/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs;

import com.intellij.dvcs.push.PushSupport;
import com.intellij.dvcs.repo.AbstractRepositoryManager;
import com.intellij.dvcs.repo.RepoStateException;
import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.repo.RepositoryManager;
import com.intellij.ide.file.BatchFileChangeListener;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.update.RefreshVFsSynchronously;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.impl.status.StatusBarUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.vcs.log.TimedVcsCommit;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcsUtil.VcsImplUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.intellij.images.editor.ImageFileEditor;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DvcsUtil {
    private static final Logger LOG = Logger.getInstance(DvcsUtil.class);
    private static final Logger LOGGER = Logger.getInstance(DvcsUtil.class);
    private static final int IO_RETRIES = 3;
    private static final int SHORT_HASH_LENGTH = 8;
    private static final int LONG_HASH_LENGTH = 40;
    public static final Comparator<VirtualFile> VIRTUAL_FILE_PRESENTATION_COMPARATOR = (o1, o2) -> {
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        return o1.getPresentableUrl().compareTo(o2.getPresentableUrl());
    };
    public static final Comparator<Repository> REPOSITORY_COMPARATOR = Comparator.comparing(Repository::getPresentableUrl);

    @NotNull
    public static List<VirtualFile> sortVirtualFilesByPresentation(@NotNull Collection<VirtualFile> virtualFiles) {
        if (virtualFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFiles", "com/intellij/dvcs/DvcsUtil", "sortVirtualFilesByPresentation"));
        }
        List list2 = ContainerUtil.sorted(virtualFiles, VIRTUAL_FILE_PRESENTATION_COMPARATOR);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/DvcsUtil", "sortVirtualFilesByPresentation"));
        }
        return list2;
    }

    @NotNull
    public static List<VirtualFile> findVirtualFilesWithRefresh(@NotNull List<File> files) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/dvcs/DvcsUtil", "findVirtualFilesWithRefresh"));
        }
        RefreshVFsSynchronously.refreshFiles(files);
        List list2 = ContainerUtil.mapNotNull(files, file2 -> VfsUtil.findFileByIoFile((File)file2, (boolean)false));
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/DvcsUtil", "findVirtualFilesWithRefresh"));
        }
        return list2;
    }

    @Deprecated
    @NotNull
    public static String getShortRepositoryName(@NotNull Project project2, @NotNull VirtualFile root) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/dvcs/DvcsUtil", "getShortRepositoryName"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/dvcs/DvcsUtil", "getShortRepositoryName"));
        }
        String string = VcsImplUtil.getShortVcsRootName(project2, root);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/DvcsUtil", "getShortRepositoryName"));
        }
        return string;
    }

    @NotNull
    public static String getShortRepositoryName(@NotNull Repository repository) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "com/intellij/dvcs/DvcsUtil", "getShortRepositoryName"));
        }
        String string = VcsImplUtil.getShortVcsRootName(repository.getProject(), repository.getRoot());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/DvcsUtil", "getShortRepositoryName"));
        }
        return string;
    }

    @NotNull
    public static String getShortNames(@NotNull Collection<? extends Repository> repositories) {
        if (repositories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositories", "com/intellij/dvcs/DvcsUtil", "getShortNames"));
        }
        String string = StringUtil.join(repositories, repository -> DvcsUtil.getShortRepositoryName(repository), (String)", ");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/DvcsUtil", "getShortNames"));
        }
        return string;
    }

    @NotNull
    public static String fileOrFolder(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/dvcs/DvcsUtil", "fileOrFolder"));
        }
        if (file2.isDirectory()) {
            if ("folder" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/DvcsUtil", "fileOrFolder"));
            }
            return "folder";
        }
        if ("file" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/DvcsUtil", "fileOrFolder"));
        }
        return "file";
    }

    public static boolean anyRepositoryIsFresh(Collection<? extends Repository> repositories) {
        for (Repository repository : repositories) {
            if (!repository.isFresh()) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static String joinMessagesOrNull(@NotNull Collection<String> messages) {
        if (messages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messages", "com/intellij/dvcs/DvcsUtil", "joinMessagesOrNull"));
        }
        String joined = StringUtil.join(messages, (String)"\n");
        return StringUtil.isEmptyOrSpaces((String)joined) ? null : joined;
    }

    @Nullable
    public static VirtualFile getSelectedFile(@NotNull Project project2) {
        Editor editor;
        FileEditorManager manager;
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/dvcs/DvcsUtil", "getSelectedFile"));
        }
        StatusBar statusBar = WindowManager.getInstance().getStatusBar(project2);
        FileEditor fileEditor = StatusBarUtil.getCurrentFileEditor(project2, statusBar);
        VirtualFile result2 = null;
        if (fileEditor != null) {
            if (fileEditor instanceof TextEditor) {
                Document document = ((TextEditor)fileEditor).getEditor().getDocument();
                result2 = FileDocumentManager.getInstance().getFile(document);
            } else if (fileEditor instanceof ImageFileEditor) {
                result2 = ((ImageFileEditor)fileEditor).getImageEditor().getFile();
            }
        }
        if (result2 == null && (manager = FileEditorManager.getInstance((Project)project2)) != null && (editor = manager.getSelectedTextEditor()) != null) {
            result2 = FileDocumentManager.getInstance().getFile(editor.getDocument());
        }
        return result2;
    }

    @NotNull
    public static String getShortHash(@NotNull String hash) {
        if (hash == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hash", "com/intellij/dvcs/DvcsUtil", "getShortHash"));
        }
        if (hash.length() < 8) {
            LOG.debug("Unexpectedly short hash: [" + hash + "]");
        }
        if (hash.length() > 40) {
            LOG.debug("Unexpectedly long hash: [" + hash + "]");
        }
        String string = hash.substring(0, Math.min(8, hash.length()));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/DvcsUtil", "getShortHash"));
        }
        return string;
    }

    @NotNull
    public static String getDateString(@NotNull TimedVcsCommit commit) {
        if (commit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commit", "com/intellij/dvcs/DvcsUtil", "getDateString"));
        }
        String string = DateFormatUtil.formatPrettyDateTime((long)commit.getTimestamp()) + " ";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/DvcsUtil", "getDateString"));
        }
        return string;
    }

    @NotNull
    public static AccessToken workingTreeChangeStarted(final @NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/dvcs/DvcsUtil", "workingTreeChangeStarted"));
        }
        ((BatchFileChangeListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(BatchFileChangeListener.TOPIC)).batchChangeStarted(project2);
        AccessToken accessToken = new AccessToken(){

            public void finish() {
                ((BatchFileChangeListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(BatchFileChangeListener.TOPIC)).batchChangeCompleted(project2);
            }
        };
        if (accessToken == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/DvcsUtil", "workingTreeChangeStarted"));
        }
        return accessToken;
    }

    @Deprecated
    public static void workingTreeChangeFinished(@NotNull Project project2, @NotNull AccessToken token) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/dvcs/DvcsUtil", "workingTreeChangeFinished"));
        }
        if (token == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "token", "com/intellij/dvcs/DvcsUtil", "workingTreeChangeFinished"));
        }
        token.finish();
    }

    public static void assertFileExists(File file2, String message2) throws IllegalStateException {
        if (!file2.exists()) {
            throw new IllegalStateException(message2);
        }
    }

    @NotNull
    public static String tryLoadFile(@NotNull File file2) throws RepoStateException {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/dvcs/DvcsUtil", "tryLoadFile"));
        }
        String string = DvcsUtil.tryLoadFile(file2, null);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/DvcsUtil", "tryLoadFile"));
        }
        return string;
    }

    @NotNull
    public static String tryLoadFile(@NotNull File file2, @Nullable String encoding) throws RepoStateException {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/dvcs/DvcsUtil", "tryLoadFile"));
        }
        String string = DvcsUtil.tryOrThrow(() -> {
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/dvcs/DvcsUtil", "lambda$tryLoadFile$3"));
            }
            return StringUtil.convertLineSeparators((String)FileUtil.loadFile((File)file2, (String)encoding)).trim();
        }, file2);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/DvcsUtil", "tryLoadFile"));
        }
        return string;
    }

    @Nullable
    @Contract(value="_ , !null -> !null")
    public static String tryLoadFileOrReturn(@NotNull File file2, @Nullable String defaultValue) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/dvcs/DvcsUtil", "tryLoadFileOrReturn"));
        }
        return DvcsUtil.tryLoadFileOrReturn(file2, defaultValue, null);
    }

    @Nullable
    @Contract(value="_ , !null, _ -> !null")
    public static String tryLoadFileOrReturn(@NotNull File file2, @Nullable String defaultValue, @Nullable String encoding) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/dvcs/DvcsUtil", "tryLoadFileOrReturn"));
        }
        try {
            return DvcsUtil.tryLoadFile(file2, encoding);
        }
        catch (RepoStateException e) {
            LOG.error((Throwable)e);
            return defaultValue;
        }
    }

    private static <T> T tryOrThrow(Callable<T> actionToTry, File fileToLoad) throws RepoStateException {
        IOException cause = null;
        for (int i2 = 0; i2 < 3; ++i2) {
            try {
                return actionToTry.call();
            }
            catch (IOException e) {
                LOG.info("IOException while loading " + fileToLoad, (Throwable)e);
                cause = e;
                continue;
            }
            catch (Exception e) {
                throw new RepoStateException("Couldn't load file " + fileToLoad, e);
            }
        }
        throw new RepoStateException("Couldn't load file " + fileToLoad, cause);
    }

    public static void visitVcsDirVfs(@NotNull VirtualFile vcsDir, @NotNull Collection<String> subDirs) {
        if (vcsDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcsDir", "com/intellij/dvcs/DvcsUtil", "visitVcsDirVfs"));
        }
        if (subDirs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subDirs", "com/intellij/dvcs/DvcsUtil", "visitVcsDirVfs"));
        }
        vcsDir.getChildren();
        for (String subdir : subDirs) {
            VirtualFile dir = vcsDir.findFileByRelativePath(subdir);
            DvcsUtil.ensureAllChildrenInVfs(dir);
        }
    }

    public static void ensureAllChildrenInVfs(@Nullable VirtualFile dir) {
        if (dir != null) {
            VfsUtilCore.processFilesRecursively((VirtualFile)dir, (Processor)Processor.TRUE);
        }
    }

    public static void addMappingIfSubRoot(@NotNull Project project2, @NotNull String newRepositoryPath, @NotNull String vcsName) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/dvcs/DvcsUtil", "addMappingIfSubRoot"));
        }
        if (newRepositoryPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newRepositoryPath", "com/intellij/dvcs/DvcsUtil", "addMappingIfSubRoot"));
        }
        if (vcsName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcsName", "com/intellij/dvcs/DvcsUtil", "addMappingIfSubRoot"));
        }
        if (project2.getBasePath() != null && FileUtil.isAncestor((String)project2.getBasePath(), (String)newRepositoryPath, (boolean)true)) {
            ProjectLevelVcsManager manager = ProjectLevelVcsManager.getInstance((Project)project2);
            manager.setDirectoryMappings(VcsUtil.addMapping((List)manager.getDirectoryMappings(), (String)newRepositoryPath, (String)vcsName));
        }
    }

    @Nullable
    public static <T extends Repository> T guessRepositoryForFile(@NotNull Project project2, @NotNull RepositoryManager<T> manager, @Nullable VirtualFile file2, @Nullable String defaultRootPathValue) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/dvcs/DvcsUtil", "guessRepositoryForFile"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/dvcs/DvcsUtil", "guessRepositoryForFile"));
        }
        Repository repository = manager.getRepositoryForRoot(DvcsUtil.guessVcsRoot(project2, file2));
        return (T)(repository != null ? repository : manager.getRepositoryForRoot(DvcsUtil.guessRootForVcs(project2, manager.getVcs(), defaultRootPathValue)));
    }

    @Nullable
    public static <T extends Repository> T guessCurrentRepositoryQuick(@NotNull Project project2, @NotNull AbstractRepositoryManager<T> manager, @Nullable String defaultRootPathValue) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/dvcs/DvcsUtil", "guessCurrentRepositoryQuick"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/dvcs/DvcsUtil", "guessCurrentRepositoryQuick"));
        }
        T repository = manager.getRepositoryForRootQuick(DvcsUtil.guessVcsRoot(project2, DvcsUtil.getSelectedFile(project2)));
        return repository != null ? repository : manager.getRepositoryForRootQuick(DvcsUtil.guessRootForVcs(project2, manager.getVcs(), defaultRootPathValue));
    }

    @Nullable
    private static VirtualFile guessRootForVcs(@NotNull Project project2, @Nullable AbstractVcs vcs, @Nullable String defaultRootPathValue) {
        VirtualFile recentRoot;
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/dvcs/DvcsUtil", "guessRootForVcs"));
        }
        if (project2.isDisposed()) {
            return null;
        }
        LOG.debug("Guessing vcs root...");
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)project2);
        if (vcs == null) {
            LOG.debug("Vcs not found.");
            return null;
        }
        String vcsName = vcs.getDisplayName();
        VirtualFile[] vcsRoots = vcsManager.getRootsUnderVcs(vcs);
        if (vcsRoots.length == 0) {
            LOG.debug("No " + vcsName + " roots in the project.");
            return null;
        }
        if (vcsRoots.length == 1) {
            VirtualFile onlyRoot = vcsRoots[0];
            LOG.debug("Only one " + vcsName + " root in the project, returning: " + onlyRoot);
            return onlyRoot;
        }
        if (defaultRootPathValue != null && (recentRoot = VcsUtil.getVirtualFile((String)defaultRootPathValue)) != null) {
            LOG.debug("Returning the recent root: " + recentRoot);
            return recentRoot;
        }
        VirtualFile projectBaseDir = project2.getBaseDir();
        if (projectBaseDir == null) {
            VirtualFile firstRoot = vcsRoots[0];
            LOG.debug("Project base dir is null, returning the first root: " + firstRoot);
            return firstRoot;
        }
        for (VirtualFile root : vcsRoots) {
            if (!root.equals(projectBaseDir) && !VfsUtilCore.isAncestor((VirtualFile)root, (VirtualFile)projectBaseDir, (boolean)true)) continue;
            LOG.debug("The best candidate: " + root);
            return root;
        }
        VirtualFile rootCandidate = vcsRoots[0];
        LOG.debug("Returning the best candidate: " + rootCandidate);
        return rootCandidate;
    }

    public static <T extends Repository> List<T> sortRepositories(@NotNull Collection<T> repositories) {
        if (repositories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositories", "com/intellij/dvcs/DvcsUtil", "sortRepositories"));
        }
        List validRepositories = ContainerUtil.filter(repositories, t -> t.getRoot().isValid());
        Collections.sort(validRepositories, REPOSITORY_COMPARATOR);
        return validRepositories;
    }

    @Nullable
    private static VirtualFile getVcsRootForLibraryFile(@NotNull Project project2, @NotNull VirtualFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/dvcs/DvcsUtil", "getVcsRootForLibraryFile"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/dvcs/DvcsUtil", "getVcsRootForLibraryFile"));
        }
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)project2);
        VirtualFile root = vcsManager.getVcsRootFor(VfsUtilCore.getVirtualFileForJar((VirtualFile)file2));
        if (root != null) {
            LOGGER.debug("Found root for zip/jar file: " + root);
            return root;
        }
        List entries = ProjectRootManager.getInstance((Project)project2).getFileIndex().getOrderEntriesForFile(file2);
        HashSet<VirtualFile> libraryRoots = new HashSet<VirtualFile>();
        for (OrderEntry entry : entries) {
            VirtualFile moduleRoot;
            if (!(entry instanceof LibraryOrderEntry) && !(entry instanceof JdkOrderEntry) || (moduleRoot = vcsManager.getVcsRootFor(entry.getOwnerModule().getModuleFile())) == null) continue;
            libraryRoots.add(moduleRoot);
        }
        if (libraryRoots.size() == 0) {
            LOGGER.debug("No library roots");
            return null;
        }
        Iterator libIterator = libraryRoots.iterator();
        VirtualFile topLibraryRoot = (VirtualFile)libIterator.next();
        while (libIterator.hasNext()) {
            VirtualFile libRoot = (VirtualFile)libIterator.next();
            if (!VfsUtilCore.isAncestor((VirtualFile)libRoot, (VirtualFile)topLibraryRoot, (boolean)true)) continue;
            topLibraryRoot = libRoot;
        }
        LOGGER.debug("Several library roots, returning " + topLibraryRoot);
        return topLibraryRoot;
    }

    @Nullable
    public static VirtualFile guessVcsRoot(@NotNull Project project2, @Nullable VirtualFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/dvcs/DvcsUtil", "guessVcsRoot"));
        }
        VirtualFile root = null;
        if (file2 != null && (root = ProjectLevelVcsManager.getInstance((Project)project2).getVcsRootFor(file2)) == null) {
            LOGGER.debug("Cannot get root by file. Trying with get by library: " + file2);
            root = DvcsUtil.getVcsRootForLibraryFile(project2, file2);
        }
        return root;
    }

    @NotNull
    public static <R extends Repository> Map<R, List<VcsFullCommitDetails>> groupCommitsByRoots(@NotNull RepositoryManager<R> repoManager, @NotNull List<? extends VcsFullCommitDetails> commits) {
        if (repoManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repoManager", "com/intellij/dvcs/DvcsUtil", "groupCommitsByRoots"));
        }
        if (commits == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commits", "com/intellij/dvcs/DvcsUtil", "groupCommitsByRoots"));
        }
        HashMap groupedCommits = ContainerUtil.newHashMap();
        for (VcsFullCommitDetails vcsFullCommitDetails : commits) {
            Repository repository = repoManager.getRepositoryForRoot(vcsFullCommitDetails.getRoot());
            if (repository == null) {
                LOGGER.info("No repository found for commit " + vcsFullCommitDetails);
                continue;
            }
            List commitsInRoot = (List)groupedCommits.get(repository);
            if (commitsInRoot == null) {
                commitsInRoot = ContainerUtil.newArrayList();
                groupedCommits.put(repository, commitsInRoot);
            }
            commitsInRoot.add(vcsFullCommitDetails);
        }
        HashMap hashMap = groupedCommits;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/DvcsUtil", "groupCommitsByRoots"));
        }
        return hashMap;
    }

    @Nullable
    public static PushSupport getPushSupport(@NotNull AbstractVcs vcs) {
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "com/intellij/dvcs/DvcsUtil", "getPushSupport"));
        }
        return (PushSupport)ContainerUtil.find((Object[])Extensions.getExtensions((ExtensionPointName)PushSupport.PUSH_SUPPORT_EP, (AreaInstance)vcs.getProject()), support -> {
            if (vcs == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "com/intellij/dvcs/DvcsUtil", "lambda$getPushSupport$5"));
            }
            return support.getVcs().equals((Object)vcs);
        });
    }

    @NotNull
    public static String joinShortNames(@NotNull Collection<? extends Repository> repositories) {
        if (repositories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositories", "com/intellij/dvcs/DvcsUtil", "joinShortNames"));
        }
        String string = DvcsUtil.joinShortNames(repositories, -1);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/DvcsUtil", "joinShortNames"));
        }
        return string;
    }

    @NotNull
    public static String joinShortNames(@NotNull Collection<? extends Repository> repositories, int limit) {
        if (repositories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositories", "com/intellij/dvcs/DvcsUtil", "joinShortNames"));
        }
        String string = DvcsUtil.joinWithAnd(ContainerUtil.map(repositories, repository -> DvcsUtil.getShortRepositoryName(repository)), limit);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/DvcsUtil", "joinShortNames"));
        }
        return string;
    }

    @NotNull
    public static String joinWithAnd(@NotNull List<String> strings, int limit) {
        if (strings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strings", "com/intellij/dvcs/DvcsUtil", "joinWithAnd"));
        }
        int size = strings.size();
        if (size == 0) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/DvcsUtil", "joinWithAnd"));
            }
            return "";
        }
        if (size == 1) {
            String string = strings.get(0);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/DvcsUtil", "joinWithAnd"));
            }
            return string;
        }
        if (size == 2) {
            String string = strings.get(0) + " and " + strings.get(1);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/DvcsUtil", "joinWithAnd"));
            }
            return string;
        }
        boolean isLimited = limit >= 2 && limit < size;
        int listCount = (isLimited ? limit : size) - 1;
        StringBuilder sb = new StringBuilder();
        for (int i2 = 0; i2 < listCount; ++i2) {
            if (i2 != 0) {
                sb.append(", ");
            }
            sb.append(strings.get(i2));
        }
        if (isLimited) {
            sb.append(" and ").append(size - limit + 1).append(" others");
        } else {
            sb.append(" and ").append(strings.get(size - 1));
        }
        String string = sb.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/DvcsUtil", "joinWithAnd"));
        }
        return string;
    }
}

