/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.cherrypick;

import com.google.common.collect.Lists;
import com.intellij.dvcs.cherrypick.VcsCherryPicker;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerEx;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsLog;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsCherryPickManager {
    private static final Logger LOG = Logger.getInstance(VcsCherryPickManager.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final ProjectLevelVcsManager myProjectLevelVcsManager;
    @NotNull
    private final Set<CommitId> myIdsInProgress;

    public VcsCherryPickManager(@NotNull Project project2, @NotNull ProjectLevelVcsManager projectLevelVcsManager) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/dvcs/cherrypick/VcsCherryPickManager", "<init>"));
        }
        if (projectLevelVcsManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectLevelVcsManager", "com/intellij/dvcs/cherrypick/VcsCherryPickManager", "<init>"));
        }
        this.myIdsInProgress = ContainerUtil.newConcurrentSet();
        this.myProject = project2;
        this.myProjectLevelVcsManager = projectLevelVcsManager;
    }

    public void cherryPick(@NotNull VcsLog log) {
        if (log == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "log", "com/intellij/dvcs/cherrypick/VcsCherryPickManager", "cherryPick"));
        }
        log.requestSelectedDetails(details -> ProgressManager.getInstance().run((Task)new CherryPickingTask(this.myProject, ContainerUtil.reverse((List)details))));
    }

    public boolean isCherryPickAlreadyStartedFor(@NotNull List<CommitId> commits) {
        if (commits == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commits", "com/intellij/dvcs/cherrypick/VcsCherryPickManager", "isCherryPickAlreadyStartedFor"));
        }
        for (CommitId commit : commits) {
            if (!this.myIdsInProgress.contains(commit)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private VcsCherryPicker getCherryPickerForCommit(@NotNull VcsFullCommitDetails commitDetails) {
        if (commitDetails == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitDetails", "com/intellij/dvcs/cherrypick/VcsCherryPickManager", "getCherryPickerForCommit"));
        }
        AbstractVcs vcs = this.myProjectLevelVcsManager.getVcsFor(commitDetails.getRoot());
        if (vcs == null) {
            return null;
        }
        VcsKey key2 = vcs.getKeyInstanceMethod();
        return this.getCherryPickerFor(key2);
    }

    @Nullable
    public VcsCherryPicker getCherryPickerFor(@NotNull VcsKey key2) {
        if (key2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/dvcs/cherrypick/VcsCherryPickManager", "getCherryPickerFor"));
        }
        return (VcsCherryPicker)ContainerUtil.find((Object[])Extensions.getExtensions((ExtensionPointName)VcsCherryPicker.EXTENSION_POINT_NAME, (AreaInstance)this.myProject), picker -> {
            if (key2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/dvcs/cherrypick/VcsCherryPickManager", "lambda$getCherryPickerFor$1"));
            }
            return picker.getSupportedVcs().equals((Object)key2);
        });
    }

    public static VcsCherryPickManager getInstance(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/dvcs/cherrypick/VcsCherryPickManager", "getInstance"));
        }
        return (VcsCherryPickManager)ServiceManager.getService((Project)project2, VcsCherryPickManager.class);
    }

    private class CherryPickingTask
    extends Task.Backgroundable {
        @NotNull
        private final List<VcsFullCommitDetails> myAllDetailsInReverseOrder;
        @NotNull
        private final ChangeListManagerEx myChangeListManager;

        public CherryPickingTask(@NotNull Project project2, List<VcsFullCommitDetails> detailsInReverseOrder) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/dvcs/cherrypick/VcsCherryPickManager$CherryPickingTask", "<init>"));
            }
            if (detailsInReverseOrder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "detailsInReverseOrder", "com/intellij/dvcs/cherrypick/VcsCherryPickManager$CherryPickingTask", "<init>"));
            }
            super(project2, "Cherry-Picking");
            this.myAllDetailsInReverseOrder = detailsInReverseOrder;
            this.myChangeListManager = (ChangeListManagerEx)ChangeListManager.getInstance((Project)this.myProject);
            this.myChangeListManager.blockModalNotifications();
        }

        @Nullable
        private VcsCherryPicker getCherryPickerOrReportError(@NotNull VcsFullCommitDetails details) {
            if (details == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "details", "com/intellij/dvcs/cherrypick/VcsCherryPickManager$CherryPickingTask", "getCherryPickerOrReportError"));
            }
            CommitId commitId = new CommitId((Hash)details.getId(), details.getRoot());
            if (VcsCherryPickManager.this.myIdsInProgress.contains(commitId)) {
                this.showError("Cherry pick process is already started for commit " + commitId.getHash().toShortString() + " from root " + commitId.getRoot().getName());
                return null;
            }
            VcsCherryPickManager.this.myIdsInProgress.add(commitId);
            VcsCherryPicker cherryPicker = VcsCherryPickManager.this.getCherryPickerForCommit(details);
            if (cherryPicker == null) {
                this.showError("Cherry pick is not supported for commit " + ((Hash)details.getId()).toShortString() + " from root " + details.getRoot().getName());
                return null;
            }
            return cherryPicker;
        }

        public void showError(@NotNull String message2) {
            if (message2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/dvcs/cherrypick/VcsCherryPickManager$CherryPickingTask", "showError"));
            }
            VcsNotifier.getInstance(this.myProject).notifyWeakError(message2);
            LOG.warn(message2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/dvcs/cherrypick/VcsCherryPickManager$CherryPickingTask", "run"));
            }
            try {
                boolean isOk = true;
                MultiMap<VcsCherryPicker, VcsFullCommitDetails> groupedCommits = this.createArrayMultiMap();
                for (VcsFullCommitDetails details : this.myAllDetailsInReverseOrder) {
                    VcsCherryPicker cherryPicker = this.getCherryPickerOrReportError(details);
                    if (cherryPicker == null) {
                        isOk = false;
                        break;
                    }
                    groupedCommits.putValue((Object)cherryPicker, (Object)details);
                }
                if (isOk) {
                    for (Map.Entry entry : groupedCommits.entrySet()) {
                        ((VcsCherryPicker)entry.getKey()).cherryPick((List)Lists.newArrayList((Iterable)((Iterable)entry.getValue())));
                    }
                }
            }
            finally {
                ApplicationManager.getApplication().invokeLater(() -> {
                    this.myChangeListManager.unblockModalNotifications();
                    for (VcsFullCommitDetails details : this.myAllDetailsInReverseOrder) {
                        VcsCherryPickManager.this.myIdsInProgress.remove(new CommitId((Hash)details.getId(), details.getRoot()));
                    }
                });
            }
        }

        @NotNull
        public MultiMap<VcsCherryPicker, VcsFullCommitDetails> createArrayMultiMap() {
            MultiMap<VcsCherryPicker, VcsFullCommitDetails> multiMap = new MultiMap<VcsCherryPicker, VcsFullCommitDetails>(){

                @NotNull
                protected Collection<VcsFullCommitDetails> createCollection() {
                    ArrayList<VcsFullCommitDetails> arrayList = new ArrayList<VcsFullCommitDetails>();
                    if (arrayList == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/cherrypick/VcsCherryPickManager$CherryPickingTask$1", "createCollection"));
                    }
                    return arrayList;
                }
            };
            if (multiMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/cherrypick/VcsCherryPickManager$CherryPickingTask", "createArrayMultiMap"));
            }
            return multiMap;
        }
    }
}

