/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.push;

import com.intellij.CommonBundle;
import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.push.CommitLoader;
import com.intellij.dvcs.push.OutgoingCommitsProvider;
import com.intellij.dvcs.push.OutgoingResult;
import com.intellij.dvcs.push.PrePushHandler;
import com.intellij.dvcs.push.PushInfo;
import com.intellij.dvcs.push.PushSettings;
import com.intellij.dvcs.push.PushSource;
import com.intellij.dvcs.push.PushSpec;
import com.intellij.dvcs.push.PushSupport;
import com.intellij.dvcs.push.PushTarget;
import com.intellij.dvcs.push.PushTargetPanel;
import com.intellij.dvcs.push.Pusher;
import com.intellij.dvcs.push.RepositoryNodeListener;
import com.intellij.dvcs.push.VcsError;
import com.intellij.dvcs.push.VcsPushOptionValue;
import com.intellij.dvcs.push.VcsPushOptionsPanel;
import com.intellij.dvcs.push.ui.CheckBoxModel;
import com.intellij.dvcs.push.ui.CommitNode;
import com.intellij.dvcs.push.ui.PushLog;
import com.intellij.dvcs.push.ui.RepositoryNode;
import com.intellij.dvcs.push.ui.RepositoryWithBranchPanel;
import com.intellij.dvcs.push.ui.SingleRepositoryNode;
import com.intellij.dvcs.push.ui.TextWithLinkNode;
import com.intellij.dvcs.push.ui.VcsLinkListener;
import com.intellij.dvcs.push.ui.VcsLinkedTextComponent;
import com.intellij.dvcs.push.ui.VcsPushDialog;
import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.repo.VcsRepositoryManager;
import com.intellij.dvcs.ui.DvcsBundle;
import com.intellij.ide.util.DelegatingProgressIndicator;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.CheckboxTree;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PushController
implements Disposable {
    @NotNull
    private final Project myProject;
    @NotNull
    private final List<? extends Repository> myPreselectedRepositories;
    @NotNull
    private final VcsRepositoryManager myGlobalRepositoryManager;
    @NotNull
    private final List<PushSupport<Repository, PushSource, PushTarget>> myPushSupports;
    @NotNull
    private final PushLog myPushLog;
    @NotNull
    private final VcsPushDialog myDialog;
    @NotNull
    private final PushSettings myPushSettings;
    @NotNull
    private final Set<String> myExcludedRepositoryRoots;
    @Nullable
    private final Repository myCurrentlyOpenedRepository;
    private final List<PrePushHandler> myHandlers;
    private final boolean mySingleRepoProject;
    private static final int DEFAULT_CHILDREN_PRESENTATION_NUMBER = 20;
    private final ExecutorService myExecutorService;
    private final Map<RepositoryNode, MyRepoModel<?, ?, ?>> myView2Model;

    public PushController(@NotNull Project project2, @NotNull VcsPushDialog dialog2, @NotNull List<? extends Repository> preselectedRepositories, @Nullable Repository currentRepo) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/dvcs/push/PushController", "<init>"));
        }
        if (dialog2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialog", "com/intellij/dvcs/push/PushController", "<init>"));
        }
        if (preselectedRepositories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "preselectedRepositories", "com/intellij/dvcs/push/PushController", "<init>"));
        }
        this.myHandlers = ContainerUtil.newArrayList();
        this.myExecutorService = ConcurrencyUtil.newSingleThreadExecutor((String)"DVCS Push");
        this.myView2Model = new TreeMap();
        this.myProject = project2;
        this.myPushSettings = (PushSettings)ServiceManager.getService((Project)project2, PushSettings.class);
        ContainerUtil.addAll(this.myHandlers, (Object[])PrePushHandler.EP_NAME.getExtensions((AreaInstance)project2));
        this.myGlobalRepositoryManager = VcsRepositoryManager.getInstance(project2);
        this.myExcludedRepositoryRoots = ContainerUtil.newHashSet((Iterable)this.myPushSettings.getExcludedRepoRoots());
        this.myPreselectedRepositories = preselectedRepositories;
        this.myCurrentlyOpenedRepository = currentRepo;
        this.myPushSupports = this.getAffectedSupports();
        this.mySingleRepoProject = this.isSingleRepoProject();
        this.myDialog = dialog2;
        CheckedTreeNode rootNode = new CheckedTreeNode(null);
        this.createTreeModel(rootNode);
        this.myPushLog = new PushLog(this.myProject, rootNode, this.isSyncStrategiesAllowed());
        this.myPushLog.getTree().addPropertyChangeListener("tree.edit.mode", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Boolean isEditMode = (Boolean)evt.getNewValue();
                if (isEditMode.booleanValue()) {
                    PushController.this.myDialog.disableOkActions();
                }
            }
        });
        this.startLoadingCommits();
        Disposer.register((Disposable)dialog2.getDisposable(), (Disposable)this);
    }

    private boolean isSyncStrategiesAllowed() {
        return !this.mySingleRepoProject && ContainerUtil.and(this.getAffectedSupports(), support -> support.mayChangeTargetsSync());
    }

    private boolean isSingleRepoProject() {
        return this.myGlobalRepositoryManager.getRepositories().size() == 1;
    }

    @NotNull
    private <R extends Repository, S extends PushSource, T extends PushTarget> List<PushSupport<R, S, T>> getAffectedSupports() {
        Collection<Repository> repositories = this.myGlobalRepositoryManager.getRepositories();
        Set vcss = ContainerUtil.map2Set(repositories, repository -> repository.getVcs());
        List list2 = ContainerUtil.map((Collection)vcss, vcs -> DvcsUtil.getPushSupport(vcs));
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/push/PushController", "getAffectedSupports"));
        }
        return list2;
    }

    public boolean isForcePushEnabled() {
        return ContainerUtil.exists(this.myView2Model.values(), model -> model.getSupport().isForcePushEnabled());
    }

    @Nullable
    public PushTarget getProhibitedTarget() {
        MyRepoModel model = (MyRepoModel)ContainerUtil.find(this.myView2Model.values(), model1 -> {
            Object target2 = model1.getTarget();
            return model1.isSelected() && target2 != null && !model1.getSupport().isForcePushAllowed(model1.getRepository(), target2);
        });
        return model != null ? (PushTarget)model.getTarget() : null;
    }

    private void startLoadingCommits() {
        LinkedHashMap priorityLoading = ContainerUtil.newLinkedHashMap();
        LinkedHashMap others = ContainerUtil.newLinkedHashMap();
        RepositoryNode nodeForCurrentEditor = this.findNodeByRepo(this.myCurrentlyOpenedRepository);
        for (Map.Entry<RepositoryNode, MyRepoModel<?, ?, ?>> entry : this.myView2Model.entrySet()) {
            MyRepoModel<?, ?, ?> model = entry.getValue();
            Object repository = model.getRepository();
            RepositoryNode repoNode = entry.getKey();
            if (this.preselectByUser((Repository)repository)) {
                priorityLoading.put(repoNode, model);
            } else if (model.getSupport().shouldRequestIncomingChangesForNotCheckedRepositories() && !repoNode.equals(nodeForCurrentEditor)) {
                others.put(repoNode, model);
            }
            if (!this.shouldPreSelect(model)) continue;
            model.setChecked(true);
        }
        if (nodeForCurrentEditor != null) {
            priorityLoading.put(nodeForCurrentEditor, this.myView2Model.get(nodeForCurrentEditor));
        }
        this.loadCommitsFromMap(priorityLoading);
        this.loadCommitsFromMap(others);
    }

    private boolean shouldPreSelect(@NotNull MyRepoModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/dvcs/push/PushController", "shouldPreSelect"));
        }
        Object repository = model.getRepository();
        return this.preselectByUser((Repository)repository) || this.notExcludedByUser((Repository)repository) && model.getSupport().shouldRequestIncomingChangesForNotCheckedRepositories();
    }

    private RepositoryNode findNodeByRepo(@Nullable Repository repository) {
        if (repository == null) {
            return null;
        }
        Map.Entry entry = (Map.Entry)ContainerUtil.find(this.myView2Model.entrySet(), entry1 -> {
            MyRepoModel model = (MyRepoModel)entry1.getValue();
            return model.getRepository().getRoot().equals(repository.getRoot());
        });
        return entry != null ? (RepositoryNode)entry.getKey() : null;
    }

    private void loadCommitsFromMap(@NotNull Map<RepositoryNode, MyRepoModel> items) {
        if (items == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "items", "com/intellij/dvcs/push/PushController", "loadCommitsFromMap"));
        }
        for (Map.Entry<RepositoryNode, MyRepoModel> entry : items.entrySet()) {
            RepositoryNode node = entry.getKey();
            this.loadCommits(entry.getValue(), node, true);
        }
    }

    private void createTreeModel(@NotNull CheckedTreeNode rootNode) {
        if (rootNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootNode", "com/intellij/dvcs/push/PushController", "createTreeModel"));
        }
        for (Repository repository : DvcsUtil.sortRepositories(this.myGlobalRepositoryManager.getRepositories())) {
            this.createRepoNode(repository, rootNode);
        }
    }

    @Nullable
    private <R extends Repository, S extends PushSource, T extends PushTarget> PushSupport<R, S, T> getPushSupportByRepository(@NotNull R repository) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "com/intellij/dvcs/push/PushController", "getPushSupportByRepository"));
        }
        return (PushSupport)ContainerUtil.find(this.myPushSupports, support -> {
            if (repository == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "com/intellij/dvcs/push/PushController", "lambda$getPushSupportByRepository$6"));
            }
            return support.getVcs().equals((Object)repository.getVcs());
        });
    }

    private <R extends Repository, S extends PushSource, T extends PushTarget> void createRepoNode(@NotNull R repository, @NotNull CheckedTreeNode rootNode) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "com/intellij/dvcs/push/PushController", "createRepoNode"));
        }
        if (rootNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootNode", "com/intellij/dvcs/push/PushController", "createRepoNode"));
        }
        PushSupport<R, S, T> support = this.getPushSupportByRepository(repository);
        if (support == null) {
            return;
        }
        PushTarget target2 = support.getDefaultTarget(repository);
        String repoName = this.getDisplayedRepoName(repository);
        PushSource source = support.getSource(repository);
        final MyRepoModel<R, PushSource, PushTarget> model = new MyRepoModel<R, PushSource, PushTarget>(repository, support, this.mySingleRepoProject, source, target2);
        if (target2 == null) {
            model.setError(VcsError.createEmptyTargetError((String)repoName));
        }
        PushTargetPanel pushTargetPanel = support.createTargetPanel(repository, target2);
        final RepositoryWithBranchPanel repoPanel = new RepositoryWithBranchPanel(this.myProject, repoName, source.getPresentation(), pushTargetPanel);
        CheckBoxModel checkBoxModel = model.getCheckBoxModel();
        final RepositoryNode repoNode = this.mySingleRepoProject ? new SingleRepositoryNode(repoPanel, checkBoxModel) : new RepositoryNode(repoPanel, checkBoxModel, target2 != null);
        pushTargetPanel.setFireOnChangeAction(new Runnable(){

            @Override
            public void run() {
                repoPanel.fireOnChange();
                ((DefaultTreeModel)PushController.this.myPushLog.getTree().getModel()).nodeChanged((TreeNode)((Object)repoNode));
            }
        });
        this.myView2Model.put(repoNode, model);
        repoPanel.addRepoNodeListener(new RepositoryNodeListener<T>(){

            @Override
            public void onTargetChanged(T newTarget) {
                repoNode.setChecked(true);
                PushController.this.myExcludedRepositoryRoots.remove(model.getRepository().getRoot().getPath());
                if (!newTarget.equals(model.getTarget()) || model.hasError() || !model.hasCommitInfo()) {
                    model.setTarget(newTarget);
                    model.clearErrors();
                    PushController.this.loadCommits(model, repoNode, false);
                }
            }

            @Override
            public void onSelectionChanged(boolean isSelected) {
                PushController.this.myDialog.updateOkActions();
                if (isSelected) {
                    boolean forceLoad = PushController.this.myExcludedRepositoryRoots.remove(model.getRepository().getRoot().getPath());
                    if (!(model.hasCommitInfo() || !forceLoad && model.getSupport().shouldRequestIncomingChangesForNotCheckedRepositories())) {
                        PushController.this.loadCommits(model, repoNode, false);
                    }
                } else {
                    PushController.this.myExcludedRepositoryRoots.add(model.getRepository().getRoot().getPath());
                }
            }

            @Override
            public void onTargetInEditMode(@NotNull String currentValue) {
                if (currentValue == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentValue", "com/intellij/dvcs/push/PushController$3", "onTargetInEditMode"));
                }
                PushController.this.myPushLog.fireEditorUpdated(currentValue);
            }
        });
        rootNode.add((MutableTreeNode)((Object)repoNode));
    }

    @NotNull
    private String getDisplayedRepoName(@NotNull Repository repository) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "com/intellij/dvcs/push/PushController", "getDisplayedRepoName"));
        }
        String name2 = DvcsUtil.getShortRepositoryName(repository);
        int slash = name2.lastIndexOf(File.separatorChar);
        if (slash < 0) {
            String string = name2;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/push/PushController", "getDisplayedRepoName"));
            }
            return string;
        }
        String candidate = name2.substring(slash + 1);
        String string = !this.containedInOtherNames(repository, candidate) ? candidate : name2;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/push/PushController", "getDisplayedRepoName"));
        }
        return string;
    }

    private boolean containedInOtherNames(@NotNull Repository except, String candidate) {
        if (except == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "except", "com/intellij/dvcs/push/PushController", "containedInOtherNames"));
        }
        return ContainerUtil.exists(this.myGlobalRepositoryManager.getRepositories(), repository -> {
            if (except == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "except", "com/intellij/dvcs/push/PushController", "lambda$containedInOtherNames$7"));
            }
            return !repository.equals(except) && repository.getRoot().getName().equals(candidate);
        });
    }

    public boolean isPushAllowed(boolean force) {
        CheckboxTree tree = this.myPushLog.getTree();
        return !((JTree)((Object)tree)).isEditing() && ContainerUtil.exists(this.myPushSupports, support -> this.isPushAllowed((PushSupport<?, ?, ?>)support, force));
    }

    private boolean isPushAllowed(@NotNull PushSupport<?, ?, ?> pushSupport, boolean force) {
        if (pushSupport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pushSupport", "com/intellij/dvcs/push/PushController", "isPushAllowed"));
        }
        Collection<RepositoryNode> nodes = this.getNodesForSupport(pushSupport);
        if (this.hasSomethingToPush(nodes)) {
            return true;
        }
        if (this.hasCheckedNodesWithContent(nodes, force || this.myDialog.getAdditionalOptionValue(pushSupport) != null)) {
            return !pushSupport.getRepositoryManager().isSyncEnabled() || !PushController.hasLoadingNodes(nodes);
        }
        return false;
    }

    private boolean hasSomethingToPush(Collection<RepositoryNode> nodes) {
        return ContainerUtil.exists(nodes, node -> {
            Object target2 = this.myView2Model.get(node).getTarget();
            return node.isChecked() && target2 != null && target2.hasSomethingToPush();
        });
    }

    private boolean hasCheckedNodesWithContent(@NotNull Collection<RepositoryNode> nodes, boolean withRefs) {
        if (nodes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodes", "com/intellij/dvcs/push/PushController", "hasCheckedNodesWithContent"));
        }
        return ContainerUtil.exists(nodes, node -> node.isChecked() && (withRefs || !this.myView2Model.get(node).getLoadedCommits().isEmpty()));
    }

    @NotNull
    private Collection<RepositoryNode> getNodesForSupport(PushSupport<?, ?, ?> support) {
        List list2 = ContainerUtil.mapNotNull(this.myView2Model.entrySet(), entry -> support.equals(((MyRepoModel)entry.getValue()).getSupport()) ? (RepositoryNode)entry.getKey() : null);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/push/PushController", "getNodesForSupport"));
        }
        return list2;
    }

    private static boolean hasLoadingNodes(@NotNull Collection<RepositoryNode> nodes) {
        if (nodes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodes", "com/intellij/dvcs/push/PushController", "hasLoadingNodes"));
        }
        return ContainerUtil.exists(nodes, node -> node.isLoading());
    }

    private <R extends Repository, S extends PushSource, T extends PushTarget> void loadCommits(@NotNull MyRepoModel<R, S, T> model, @NotNull RepositoryNode node, boolean initial) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/dvcs/push/PushController", "loadCommits"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/dvcs/push/PushController", "loadCommits"));
        }
        node.cancelLoading();
        T target2 = model.getTarget();
        if (target2 == null) {
            node.stopLoading();
            return;
        }
        node.setEnabled(true);
        PushSupport support = model.getSupport();
        AtomicReference result2 = new AtomicReference();
        Runnable task = () -> {
            if (model == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/dvcs/push/PushController", "lambda$loadCommits$15"));
            }
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/dvcs/push/PushController", "lambda$loadCommits$15"));
            }
            Object repository = model.getRepository();
            OutgoingResult outgoing = support.getOutgoingCommitsProvider().getOutgoingCommits(repository, new PushSpec(model.getSource(), model.getTarget()), initial);
            result2.compareAndSet(null, outgoing);
            UIUtil.invokeAndWaitIfNeeded(() -> {
                boolean shouldBeSelected;
                if (model == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/dvcs/push/PushController", "lambda$null$14"));
                }
                if (node == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/dvcs/push/PushController", "lambda$null$14"));
                }
                OutgoingResult outgoing1 = (OutgoingResult)result2.get();
                List errors = outgoing1.getErrors();
                if (!errors.isEmpty()) {
                    shouldBeSelected = false;
                    model.setLoadedCommits(ContainerUtil.emptyList());
                    this.myPushLog.setChildren((DefaultMutableTreeNode)((Object)node), ContainerUtil.map((Collection)errors, error -> {
                        if (node == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/dvcs/push/PushController", "lambda$null$13"));
                        }
                        if (model == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/dvcs/push/PushController", "lambda$null$13"));
                        }
                        VcsLinkedTextComponent errorLinkText = new VcsLinkedTextComponent(error.getText(), new VcsLinkListener((VcsError)error, node, model){
                            final /* synthetic */ VcsError val$error;
                            final /* synthetic */ RepositoryNode val$node;
                            final /* synthetic */ MyRepoModel val$model;
                            {
                                this.val$error = vcsError;
                                this.val$node = repositoryNode;
                                this.val$model = myRepoModel;
                            }

                            @Override
                            public void hyperlinkActivated(@NotNull DefaultMutableTreeNode sourceNode, @NotNull MouseEvent event) {
                                if (sourceNode == null) {
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceNode", "com/intellij/dvcs/push/PushController$4", "hyperlinkActivated"));
                                }
                                if (event == null) {
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/dvcs/push/PushController$4", "hyperlinkActivated"));
                                }
                                this.val$error.handleError(new CommitLoader(){

                                    public void reloadCommits() {
                                        val$node.setChecked(true);
                                        PushController.this.loadCommits(val$model, val$node, false);
                                    }
                                });
                            }
                        });
                        return new TextWithLinkNode(errorLinkText);
                    }));
                    if (node.isChecked()) {
                        node.setChecked(false);
                    }
                } else {
                    List commits = outgoing1.getCommits();
                    model.setLoadedCommits(commits);
                    shouldBeSelected = this.shouldSelectNodeAfterLoad(model);
                    this.myPushLog.setChildren((DefaultMutableTreeNode)((Object)node), this.getPresentationForCommits(this.myProject, model.getLoadedCommits(), model.getNumberOfShownCommits()));
                    if (!commits.isEmpty()) {
                        this.myPushLog.selectIfNothingSelected((TreeNode)((Object)node));
                    }
                }
                node.stopLoading();
                this.updateLoadingPanel();
                if (shouldBeSelected) {
                    node.setChecked(true);
                } else if (initial) {
                    node.setChecked(false);
                }
                this.myDialog.updateOkActions();
            });
        };
        node.startLoading((JTree)((Object)this.myPushLog.getTree()), this.myExecutorService.submit(task, result2), initial);
        this.updateLoadingPanel();
    }

    private void updateLoadingPanel() {
        this.myPushLog.getTree().setPaintBusy(PushController.hasLoadingNodes(this.myView2Model.keySet()));
    }

    private boolean shouldSelectNodeAfterLoad(@NotNull MyRepoModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/dvcs/push/PushController", "shouldSelectNodeAfterLoad"));
        }
        if (this.mySingleRepoProject) {
            return true;
        }
        return PushController.hasCommitsToPush(model) && model.isSelected();
    }

    private boolean notExcludedByUser(@NotNull Repository repository) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "com/intellij/dvcs/push/PushController", "notExcludedByUser"));
        }
        return !this.myExcludedRepositoryRoots.contains(repository.getRoot().getPath());
    }

    private boolean preselectByUser(@NotNull Repository repository) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "com/intellij/dvcs/push/PushController", "preselectByUser"));
        }
        return this.mySingleRepoProject || this.myPreselectedRepositories.contains(repository);
    }

    private static boolean hasCommitsToPush(@NotNull MyRepoModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/dvcs/push/PushController", "hasCommitsToPush"));
        }
        Object target2 = model.getTarget();
        assert (target2 != null);
        return !model.getLoadedCommits().isEmpty() || target2.hasSomethingToPush();
    }

    public PushLog getPushPanelLog() {
        return this.myPushLog;
    }

    @NotNull
    public PrePushHandler.Result executeHandlers(@NotNull ProgressIndicator indicator) throws ProcessCanceledException, HandlerException {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/dvcs/push/PushController", "executeHandlers"));
        }
        if (this.myHandlers.isEmpty()) {
            PrePushHandler.Result result2 = PrePushHandler.Result.OK;
            if (result2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/push/PushController", "executeHandlers"));
            }
            return result2;
        }
        List<PushInfo> pushDetails = this.preparePushDetails();
        StepsProgressIndicator stepsIndicator = new StepsProgressIndicator(indicator, this.myHandlers.size());
        stepsIndicator.setIndeterminate(false);
        stepsIndicator.setFraction(0.0);
        for (PrePushHandler handler2 : this.myHandlers) {
            PrePushHandler.Result prePushHandlerResult;
            stepsIndicator.checkCanceled();
            stepsIndicator.setText(handler2.getPresentableName());
            try {
                prePushHandlerResult = handler2.handle(pushDetails, (ProgressIndicator)stepsIndicator);
            }
            catch (ProcessCanceledException pce) {
                throw pce;
            }
            catch (Throwable e) {
                throw new HandlerException(handler2.getPresentableName(), e);
            }
            if (prePushHandlerResult != PrePushHandler.Result.OK) {
                PrePushHandler.Result result3 = prePushHandlerResult;
                if (result3 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/push/PushController", "executeHandlers"));
                }
                return result3;
            }
            stepsIndicator.setIndeterminate(false);
            stepsIndicator.nextStep();
        }
        PrePushHandler.Result result4 = PrePushHandler.Result.OK;
        if (result4 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/push/PushController", "executeHandlers"));
        }
        return result4;
    }

    public void push(final boolean force) {
        Task.Backgroundable task = new Task.Backgroundable(this.myProject, "Pushing...", true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/dvcs/push/PushController$5", "run"));
                }
                PushController.this.myPushSettings.saveExcludedRepoRoots(PushController.this.myExcludedRepositoryRoots);
                for (PushSupport support : PushController.this.myPushSupports) {
                    PushController.this.doPushSynchronously(support, force);
                }
            }
        };
        task.queue();
    }

    private <R extends Repository, S extends PushSource, T extends PushTarget> void doPushSynchronously(@NotNull PushSupport<R, S, T> support, boolean force) {
        if (support == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "support", "com/intellij/dvcs/push/PushController", "doPushSynchronously"));
        }
        VcsPushOptionValue options = this.myDialog.getAdditionalOptionValue(support);
        Pusher pusher = support.getPusher();
        Map<R, PushSpec<S, T>> specs = this.collectPushSpecsForVcs(support);
        if (!specs.isEmpty()) {
            pusher.push(specs, options, force);
        }
    }

    private static <R extends Repository, S extends PushSource, T extends PushTarget> List<? extends VcsFullCommitDetails> loadCommits(@NotNull MyRepoModel<R, S, T> model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/dvcs/push/PushController", "loadCommits"));
        }
        PushSupport<R, S, T> support = model.getSupport();
        R repository = model.getRepository();
        S source = model.getSource();
        T target2 = model.getTarget();
        if (target2 == null) {
            return ContainerUtil.emptyList();
        }
        OutgoingCommitsProvider outgoingCommitsProvider = support.getOutgoingCommitsProvider();
        return outgoingCommitsProvider.getOutgoingCommits(repository, new PushSpec(source, target2), true).getCommits();
    }

    @NotNull
    private List<PushInfo> preparePushDetails() {
        ArrayList allDetails = ContainerUtil.newArrayList();
        Collection<MyRepoModel<?, ?, ?>> repoModels = this.getSelectedRepoNode();
        for (MyRepoModel<?, ?, ?> model : repoModels) {
            Object target2 = model.getTarget();
            if (target2 == null) continue;
            PushSpec pushSpec = new PushSpec(model.getSource(), target2);
            ArrayList loadedCommits = ContainerUtil.newArrayList();
            loadedCommits.addAll(model.getLoadedCommits());
            if (loadedCommits.isEmpty()) {
                loadedCommits.addAll(PushController.loadCommits(model));
            }
            Collections.reverse(loadedCommits);
            allDetails.add(new PushInfoImpl((Repository)model.getRepository(), pushSpec, loadedCommits));
        }
        List<PushInfo> list2 = Collections.unmodifiableList(allDetails);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/push/PushController", "preparePushDetails"));
        }
        return list2;
    }

    @NotNull
    private <R extends Repository, S extends PushSource, T extends PushTarget> Map<R, PushSpec<S, T>> collectPushSpecsForVcs(@NotNull PushSupport<R, S, T> pushSupport) {
        if (pushSupport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pushSupport", "com/intellij/dvcs/push/PushController", "collectPushSpecsForVcs"));
        }
        HashMap pushSpecs = ContainerUtil.newHashMap();
        Collection<MyRepoModel<?, ?, ?>> repositoriesInformation = this.getSelectedRepoNode();
        for (MyRepoModel<?, ?, ?> repoModel : repositoriesInformation) {
            Object target2;
            if (!pushSupport.equals(repoModel.getSupport()) || (target2 = repoModel.getTarget()) == null) continue;
            pushSpecs.put(repoModel.getRepository(), new PushSpec(repoModel.getSource(), target2));
        }
        HashMap hashMap = pushSpecs;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/push/PushController", "collectPushSpecsForVcs"));
        }
        return hashMap;
    }

    private Collection<MyRepoModel<?, ?, ?>> getSelectedRepoNode() {
        if (this.mySingleRepoProject) {
            return this.myView2Model.values();
        }
        return ContainerUtil.mapNotNull(this.myView2Model.entrySet(), entry -> {
            MyRepoModel model = (MyRepoModel)entry.getValue();
            return model.isSelected() && model.getTarget() != null ? model : null;
        });
    }

    public void dispose() {
        this.myExecutorService.shutdownNow();
    }

    @NotNull
    public Project getProject() {
        Project project2 = this.myProject;
        if (project2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/push/PushController", "getProject"));
        }
        return project2;
    }

    private void addMoreCommits(RepositoryNode repositoryNode) {
        MyRepoModel<?, ?, ?> repoModel = this.myView2Model.get(repositoryNode);
        repoModel.increaseShownCommits();
        this.myPushLog.setChildren((DefaultMutableTreeNode)((Object)repositoryNode), this.getPresentationForCommits(this.myProject, repoModel.getLoadedCommits(), repoModel.getNumberOfShownCommits()));
    }

    @NotNull
    private List<DefaultMutableTreeNode> getPresentationForCommits(@NotNull Project project2, @NotNull List<? extends VcsFullCommitDetails> commits, int commitsNum) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/dvcs/push/PushController", "getPresentationForCommits"));
        }
        if (commits == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commits", "com/intellij/dvcs/push/PushController", "getPresentationForCommits"));
        }
        Function commitToNode = commit -> {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/dvcs/push/PushController", "lambda$getPresentationForCommits$17"));
            }
            return new CommitNode(project2, (VcsFullCommitDetails)commit);
        };
        ArrayList<DefaultMutableTreeNode> childrenToShown = new ArrayList<DefaultMutableTreeNode>();
        for (int i2 = 0; i2 < commits.size(); ++i2) {
            if (i2 >= commitsNum) {
                VcsLinkedTextComponent moreCommitsLink = new VcsLinkedTextComponent("<a href='loadMore'>...</a>", new VcsLinkListener(){

                    @Override
                    public void hyperlinkActivated(@NotNull DefaultMutableTreeNode sourceNode, @NotNull MouseEvent event) {
                        if (sourceNode == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceNode", "com/intellij/dvcs/push/PushController$6", "hyperlinkActivated"));
                        }
                        if (event == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/dvcs/push/PushController$6", "hyperlinkActivated"));
                        }
                        TreeNode parent = sourceNode.getParent();
                        if (parent instanceof RepositoryNode) {
                            PushController.this.addMoreCommits((RepositoryNode)((Object)parent));
                        }
                    }
                });
                childrenToShown.add(new TextWithLinkNode(moreCommitsLink));
                break;
            }
            childrenToShown.add((DefaultMutableTreeNode)commitToNode.fun((Object)commits.get(i2)));
        }
        ArrayList<DefaultMutableTreeNode> arrayList = childrenToShown;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/push/PushController", "getPresentationForCommits"));
        }
        return arrayList;
    }

    @NotNull
    public Map<PushSupport, VcsPushOptionsPanel> createAdditionalPanels() {
        LinkedHashMap result2 = ContainerUtil.newLinkedHashMap();
        for (PushSupport<Repository, PushSource, PushTarget> support : this.myPushSupports) {
            ContainerUtil.putIfNotNull(support, (Object)support.createOptionsPanel(), (Map)result2);
        }
        LinkedHashMap linkedHashMap = result2;
        if (linkedHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/push/PushController", "createAdditionalPanels"));
        }
        return linkedHashMap;
    }

    public boolean ensureForcePushIsNeeded() {
        Collection<MyRepoModel<?, ?, ?>> selectedNodes = this.getSelectedRepoNode();
        MyRepoModel selectedModel = (MyRepoModel)ContainerUtil.getFirstItem(selectedNodes);
        if (selectedModel == null) {
            return false;
        }
        PushSupport activePushSupport = selectedModel.getSupport();
        PushTarget commonTarget = PushController.getCommonTarget(selectedNodes);
        if (commonTarget != null && activePushSupport.isSilentForcePushAllowed(commonTarget)) {
            return true;
        }
        return Messages.showOkCancelDialog((Project)this.myProject, (String)XmlStringUtil.wrapInHtml((CharSequence)DvcsBundle.message("push.force.confirmation.text", commonTarget != null ? " to <b>" + commonTarget.getPresentation() + "</b>" : "")), (String)"Force Push", (String)"&Force Push", (String)CommonBundle.getCancelButtonText(), (Icon)Messages.getWarningIcon(), (DialogWrapper.DoNotAskOption)(commonTarget != null ? new MyDoNotAskOptionForPush(activePushSupport, commonTarget) : null)) == 0;
    }

    @Nullable
    private static PushTarget getCommonTarget(@NotNull Collection<MyRepoModel<?, ?, ?>> selectedNodes) {
        if (selectedNodes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedNodes", "com/intellij/dvcs/push/PushController", "getCommonTarget"));
        }
        Object commonTarget = ((MyRepoModel)ObjectUtils.assertNotNull((Object)ContainerUtil.getFirstItem(selectedNodes))).getTarget();
        return commonTarget != null && !ContainerUtil.exists(selectedNodes, model -> !commonTarget.equals(model.getTarget())) ? (PushTarget)commonTarget : null;
    }

    private static class MyDoNotAskOptionForPush
    implements DialogWrapper.DoNotAskOption {
        @NotNull
        private final PushSupport myActivePushSupport;
        @NotNull
        private final PushTarget myCommonTarget;

        public MyDoNotAskOptionForPush(@NotNull PushSupport support, @NotNull PushTarget target2) {
            if (support == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "support", "com/intellij/dvcs/push/PushController$MyDoNotAskOptionForPush", "<init>"));
            }
            if (target2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/dvcs/push/PushController$MyDoNotAskOptionForPush", "<init>"));
            }
            this.myActivePushSupport = support;
            this.myCommonTarget = target2;
        }

        public boolean isToBeShown() {
            return true;
        }

        public void setToBeShown(boolean toBeShown, int exitCode) {
            if (!toBeShown && exitCode == 0) {
                this.myActivePushSupport.saveSilentForcePushTarget(this.myCommonTarget);
            }
        }

        public boolean canBeHidden() {
            return true;
        }

        public boolean shouldSaveOptionsOnCancel() {
            return false;
        }

        @NotNull
        public String getDoNotShowMessage() {
            if ("Don't warn about this target" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/push/PushController$MyDoNotAskOptionForPush", "getDoNotShowMessage"));
            }
            return "Don't warn about this target";
        }
    }

    private static class MyRepoModel<Repo extends Repository, S extends PushSource, T extends PushTarget> {
        @NotNull
        private final Repo myRepository;
        @NotNull
        private final PushSupport<Repo, S, T> mySupport;
        @NotNull
        private final S mySource;
        @Nullable
        private T myTarget;
        @Nullable
        VcsError myTargetError;
        int myNumberOfShownCommits;
        @NotNull
        List<? extends VcsFullCommitDetails> myLoadedCommits;
        @NotNull
        private final CheckBoxModel myCheckBoxModel;

        public MyRepoModel(@NotNull Repo repository, @NotNull PushSupport<Repo, S, T> supportForRepo, boolean isSelected, @NotNull S source, @Nullable T target2) {
            if (repository == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "com/intellij/dvcs/push/PushController$MyRepoModel", "<init>"));
            }
            if (supportForRepo == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "supportForRepo", "com/intellij/dvcs/push/PushController$MyRepoModel", "<init>"));
            }
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/dvcs/push/PushController$MyRepoModel", "<init>"));
            }
            this.myLoadedCommits = Collections.emptyList();
            this.myRepository = repository;
            this.mySupport = supportForRepo;
            this.myCheckBoxModel = new CheckBoxModel(isSelected);
            this.mySource = source;
            this.myTarget = target2;
            this.myNumberOfShownCommits = 20;
        }

        @NotNull
        public Repo getRepository() {
            Repo Repo2 = this.myRepository;
            if (Repo2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/push/PushController$MyRepoModel", "getRepository"));
            }
            return Repo2;
        }

        @NotNull
        public PushSupport<Repo, S, T> getSupport() {
            PushSupport<Repo, S, T> pushSupport = this.mySupport;
            if (pushSupport == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/push/PushController$MyRepoModel", "getSupport"));
            }
            return pushSupport;
        }

        @NotNull
        public S getSource() {
            S s = this.mySource;
            if (s == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/push/PushController$MyRepoModel", "getSource"));
            }
            return s;
        }

        @Nullable
        public T getTarget() {
            return this.myTarget;
        }

        public void setTarget(@Nullable T target2) {
            this.myTarget = target2;
        }

        public boolean isSelected() {
            return this.myCheckBoxModel.isChecked();
        }

        public void setError(@Nullable VcsError error) {
            this.myTargetError = error;
        }

        public void clearErrors() {
            this.myTargetError = null;
        }

        public boolean hasError() {
            return this.myTargetError != null;
        }

        public int getNumberOfShownCommits() {
            return this.myNumberOfShownCommits;
        }

        public void increaseShownCommits() {
            this.myNumberOfShownCommits *= 2;
        }

        @NotNull
        public List<? extends VcsFullCommitDetails> getLoadedCommits() {
            List<? extends VcsFullCommitDetails> list2 = this.myLoadedCommits;
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/push/PushController$MyRepoModel", "getLoadedCommits"));
            }
            return list2;
        }

        public void setLoadedCommits(@NotNull List<? extends VcsFullCommitDetails> loadedCommits) {
            if (loadedCommits == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "loadedCommits", "com/intellij/dvcs/push/PushController$MyRepoModel", "setLoadedCommits"));
            }
            this.myLoadedCommits = loadedCommits;
        }

        public boolean hasCommitInfo() {
            return this.myTargetError != null || !this.myLoadedCommits.isEmpty();
        }

        @NotNull
        public CheckBoxModel getCheckBoxModel() {
            CheckBoxModel checkBoxModel = this.myCheckBoxModel;
            if (checkBoxModel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/push/PushController$MyRepoModel", "getCheckBoxModel"));
            }
            return checkBoxModel;
        }

        public void setChecked(boolean checked) {
            this.myCheckBoxModel.setChecked(checked);
        }
    }

    private static class PushInfoImpl
    implements PushInfo {
        private final Repository myRepository;
        private final PushSpec<PushSource, PushTarget> myPushSpec;
        private final List<VcsFullCommitDetails> myCommits;

        private PushInfoImpl(@NotNull Repository repository, @NotNull PushSpec<PushSource, PushTarget> spec, @NotNull List<VcsFullCommitDetails> commits) {
            if (repository == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "com/intellij/dvcs/push/PushController$PushInfoImpl", "<init>"));
            }
            if (spec == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "spec", "com/intellij/dvcs/push/PushController$PushInfoImpl", "<init>"));
            }
            if (commits == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commits", "com/intellij/dvcs/push/PushController$PushInfoImpl", "<init>"));
            }
            this.myRepository = repository;
            this.myPushSpec = spec;
            this.myCommits = commits;
        }

        @Override
        @NotNull
        public Repository getRepository() {
            Repository repository = this.myRepository;
            if (repository == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/push/PushController$PushInfoImpl", "getRepository"));
            }
            return repository;
        }

        @Override
        @NotNull
        public PushSpec<PushSource, PushTarget> getPushSpec() {
            PushSpec<PushSource, PushTarget> pushSpec = this.myPushSpec;
            if (pushSpec == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/push/PushController$PushInfoImpl", "getPushSpec"));
            }
            return pushSpec;
        }

        @Override
        @NotNull
        public List<VcsFullCommitDetails> getCommits() {
            List<VcsFullCommitDetails> list2 = this.myCommits;
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/push/PushController$PushInfoImpl", "getCommits"));
            }
            return list2;
        }
    }

    private static class StepsProgressIndicator
    extends DelegatingProgressIndicator {
        private final int myTotalSteps;
        private final AtomicInteger myFinishedTasks;

        public StepsProgressIndicator(@NotNull ProgressIndicator indicator, int totalSteps) {
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/dvcs/push/PushController$StepsProgressIndicator", "<init>"));
            }
            super(indicator);
            this.myFinishedTasks = new AtomicInteger();
            this.myTotalSteps = totalSteps;
        }

        public void nextStep() {
            this.myFinishedTasks.incrementAndGet();
            this.setFraction(0.0);
        }

        public void setFraction(double fraction) {
            super.setFraction(((double)this.myFinishedTasks.get() + fraction) / (double)this.myTotalSteps);
        }
    }

    public static class HandlerException
    extends RuntimeException {
        private final String myHandlerName;

        public HandlerException(@NotNull String name2, @NotNull Throwable cause) {
            if (name2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/dvcs/push/PushController$HandlerException", "<init>"));
            }
            if (cause == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cause", "com/intellij/dvcs/push/PushController$HandlerException", "<init>"));
            }
            super(cause);
            this.myHandlerName = name2;
        }

        @NotNull
        public String getHandlerName() {
            String string = this.myHandlerName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/push/PushController$HandlerException", "getHandlerName"));
            }
            return string;
        }
    }
}

