/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.push.ui;

import com.intellij.dvcs.push.PushTarget;
import com.intellij.dvcs.push.PushTargetPanel;
import com.intellij.dvcs.push.RepositoryNodeListener;
import com.intellij.dvcs.push.ui.PushTargetEditorListener;
import com.intellij.dvcs.push.ui.RepositoryNode;
import com.intellij.dvcs.push.ui.SingleRepositoryNode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.ui.popup.util.PopupUtil;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.InputVerifier;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;

public class RepositoryWithBranchPanel<T extends PushTarget>
extends NonOpaquePanel {
    private final JBCheckBox myRepositoryCheckbox;
    private final PushTargetPanel<T> myDestPushTargetPanelComponent;
    private final JBLabel myLocalBranch;
    private final JLabel myArrowLabel;
    private final JLabel myRepositoryLabel;
    private final ColoredTreeCellRenderer myTextRenderer;
    @NotNull
    private final List<RepositoryNodeListener<T>> myListeners;

    public RepositoryWithBranchPanel(final @NotNull Project project2, @NotNull String repoName, @NotNull String sourceName, @NotNull PushTargetPanel<T> destPushTargetPanelComponent) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/dvcs/push/ui/RepositoryWithBranchPanel", "<init>"));
        }
        if (repoName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repoName", "com/intellij/dvcs/push/ui/RepositoryWithBranchPanel", "<init>"));
        }
        if (sourceName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceName", "com/intellij/dvcs/push/ui/RepositoryWithBranchPanel", "<init>"));
        }
        if (destPushTargetPanelComponent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "destPushTargetPanelComponent", "com/intellij/dvcs/push/ui/RepositoryWithBranchPanel", "<init>"));
        }
        this.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.setLayout(new BorderLayout());
        this.myRepositoryCheckbox = new JBCheckBox();
        this.myRepositoryCheckbox.setFocusable(false);
        this.myRepositoryCheckbox.setOpaque(false);
        this.myRepositoryCheckbox.setBorder(null);
        this.myRepositoryCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/dvcs/push/ui/RepositoryWithBranchPanel$1", "actionPerformed"));
                }
                RepositoryWithBranchPanel.this.fireOnSelectionChange(RepositoryWithBranchPanel.this.myRepositoryCheckbox.isSelected());
            }
        });
        this.myRepositoryLabel = new JLabel(repoName);
        this.myLocalBranch = new JBLabel(sourceName);
        this.myArrowLabel = new JLabel(" " + UIUtil.rightArrow() + " ");
        this.myDestPushTargetPanelComponent = destPushTargetPanelComponent;
        this.myTextRenderer = new ColoredTreeCellRenderer(){

            public void customizeCellRenderer(@NotNull JTree tree, Object value2, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                if (tree == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/dvcs/push/ui/RepositoryWithBranchPanel$2", "customizeCellRenderer"));
                }
            }
        };
        this.myTextRenderer.setOpaque(false);
        this.layoutComponents();
        this.setInputVerifier(new InputVerifier(){

            @Override
            public boolean verify(JComponent input) {
                ValidationInfo error = RepositoryWithBranchPanel.this.myDestPushTargetPanelComponent.verify();
                if (error != null) {
                    PopupUtil.showBalloonForComponent((Component)error.component, (String)error.message, (MessageType)MessageType.WARNING, (boolean)false, (Disposable)project2);
                }
                return error == null;
            }
        });
        JCheckBox emptyBorderCheckBox = new JCheckBox();
        emptyBorderCheckBox.setBorder(null);
    }

    private void layoutComponents() {
        this.add((Component)this.myRepositoryCheckbox, "West");
        NonOpaquePanel panel2 = new NonOpaquePanel((LayoutManager)new BorderLayout());
        panel2.add((Component)this.myTextRenderer, "West");
        panel2.add((Component)this.myDestPushTargetPanelComponent, "Center");
        this.add((Component)panel2, "Center");
    }

    @NotNull
    public String getRepositoryName() {
        String string = this.myRepositoryLabel.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/push/ui/RepositoryWithBranchPanel", "getRepositoryName"));
        }
        return string;
    }

    public String getSourceName() {
        return this.myLocalBranch.getText();
    }

    public String getArrow() {
        return this.myArrowLabel.getText();
    }

    @NotNull
    public Component getTreeCellEditorComponent(JTree tree, Object value2, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Rectangle bounds = tree.getPathBounds(tree.getPathForRow(row));
        this.invalidate();
        this.myTextRenderer.getTreeCellRendererComponent(tree, value2, selected, expanded, leaf, row, hasFocus);
        if (!(value2 instanceof SingleRepositoryNode)) {
            RepositoryNode node = (RepositoryNode)value2;
            this.myRepositoryCheckbox.setSelected(node.isChecked());
            this.myRepositoryCheckbox.setVisible(true);
            this.myTextRenderer.append(this.getRepositoryName(), SimpleTextAttributes.GRAY_ATTRIBUTES);
            this.myTextRenderer.appendTextPadding(120);
        } else {
            this.myRepositoryCheckbox.setVisible(false);
            this.myTextRenderer.append(" ");
        }
        this.myTextRenderer.append(this.getSourceName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        this.myTextRenderer.append(this.getArrow(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        if (bounds != null) {
            this.setPreferredSize(new Dimension(tree.getVisibleRect().width - bounds.x, bounds.height));
        }
        if (this.myTextRenderer.getTree().hasFocus()) {
            this.myDestPushTargetPanelComponent.requestFocus(true);
        }
        this.revalidate();
        RepositoryWithBranchPanel repositoryWithBranchPanel = this;
        if (repositoryWithBranchPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/push/ui/RepositoryWithBranchPanel", "getTreeCellEditorComponent"));
        }
        return repositoryWithBranchPanel;
    }

    public void addRepoNodeListener(@NotNull RepositoryNodeListener<T> listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/dvcs/push/ui/RepositoryWithBranchPanel", "addRepoNodeListener"));
        }
        this.myListeners.add(listener2);
        this.myDestPushTargetPanelComponent.addTargetEditorListener(new PushTargetEditorListener(){

            public void onTargetInEditModeChanged(@NotNull String value2) {
                if (value2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/dvcs/push/ui/RepositoryWithBranchPanel$4", "onTargetInEditModeChanged"));
                }
                for (RepositoryNodeListener listener2 : RepositoryWithBranchPanel.this.myListeners) {
                    listener2.onTargetInEditMode(value2);
                }
            }
        });
    }

    public void fireOnChange() {
        this.myDestPushTargetPanelComponent.fireOnChange();
        PushTarget target2 = this.myDestPushTargetPanelComponent.getValue();
        if (target2 == null) {
            return;
        }
        for (RepositoryNodeListener<PushTarget> repositoryNodeListener : this.myListeners) {
            repositoryNodeListener.onTargetChanged(target2);
        }
    }

    public void fireOnSelectionChange(boolean isSelected) {
        for (RepositoryNodeListener<T> listener2 : this.myListeners) {
            listener2.onSelectionChanged(isSelected);
        }
    }

    public void fireOnCancel() {
        this.myDestPushTargetPanelComponent.fireOnCancel();
    }

    public PushTargetPanel getTargetPanel() {
        return this.myDestPushTargetPanelComponent;
    }

    public boolean isEditable() {
        return this.myDestPushTargetPanelComponent.getValue() != null;
    }
}

