/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.ui;

import com.intellij.dvcs.ui.BranchActionGroup;
import com.intellij.dvcs.ui.PopupElementWithAdditionalInfo;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.EmptyAction;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupAdapter;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.WindowStateService;
import com.intellij.openapi.vcs.ui.FlatSpeedSearchPopup;
import com.intellij.ui.ActiveComponent;
import com.intellij.ui.ErrorLabel;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.SeparatorWithText;
import com.intellij.ui.components.panels.OpaquePanel;
import com.intellij.ui.popup.KeepingPopupOpenAction;
import com.intellij.ui.popup.PopupFactoryImpl;
import com.intellij.ui.popup.WizardPopup;
import com.intellij.ui.popup.list.IconListPopupRenderer;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.ui.popup.list.ListPopupModel;
import com.intellij.ui.popup.list.PopupListElementRenderer;
import com.intellij.util.FontUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BranchActionGroupPopup
extends FlatSpeedSearchPopup {
    private static final DataKey<ListPopupModel> POPUP_MODEL = DataKey.create((String)"VcsPopupModel");
    private Project myProject;
    private MyPopupListElementRenderer myListElementRenderer;
    private boolean myShown;
    private boolean myUserSizeChanged;
    private boolean myInternalSizeChanged;
    private int myMeanRowHeight;
    @Nullable
    private final String myKey;
    @NotNull
    private Dimension myPrevSize;

    public BranchActionGroupPopup(@NotNull String title, @NotNull Project project2, @NotNull Condition<AnAction> preselectActionCondition, @NotNull ActionGroup actions, @Nullable String dimensionKey) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/dvcs/ui/BranchActionGroupPopup", "<init>"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/dvcs/ui/BranchActionGroupPopup", "<init>"));
        }
        if (preselectActionCondition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "preselectActionCondition", "com/intellij/dvcs/ui/BranchActionGroupPopup", "<init>"));
        }
        if (actions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actions", "com/intellij/dvcs/ui/BranchActionGroupPopup", "<init>"));
        }
        super(title, new DefaultActionGroup(new AnAction[]{actions, BranchActionGroupPopup.createBranchSpeedSearchActionGroup(actions)}), SimpleDataContext.getProjectContext(project2), preselectActionCondition, true);
        this.myPrevSize = JBUI.emptySize();
        this.myProject = project2;
        DataManager.registerDataProvider((JComponent)this.getList(), dataId -> POPUP_MODEL.is(dataId) ? this.getListModel() : null);
        this.installOnHoverIconsSupport(this.getListElementRenderer());
        this.myKey = dimensionKey;
        if (this.myKey != null) {
            Dimension storedSize = WindowStateService.getInstance((Project)this.myProject).getSizeFor((Object)this.myProject, this.myKey);
            if (storedSize != null) {
                this.setSize(storedSize);
            }
            this.createTitlePanelToolbar(this.myKey);
        }
        this.myMeanRowHeight = this.getList().getCellBounds((int)0, (int)0).height + UIUtil.getListCellVPadding() * 2;
    }

    void createTitlePanelToolbar(final @NotNull String dimensionKey) {
        if (dimensionKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dimensionKey", "com/intellij/dvcs/ui/BranchActionGroupPopup", "createTitlePanelToolbar"));
        }
        DumbAwareAction restoreDefaultSizeAction = new DumbAwareAction("Restore Size", "Restore default size for widget", AllIcons.Vcs.RestoreDefaultSize){

            public void actionPerformed(AnActionEvent e) {
                WindowStateService.getInstance((Project)BranchActionGroupPopup.this.myProject).putSizeFor((Object)BranchActionGroupPopup.this.myProject, dimensionKey, null);
                BranchActionGroupPopup.this.myInternalSizeChanged = true;
                BranchActionGroupPopup.this.pack(true, true);
            }

            public void update(AnActionEvent e) {
                e.getPresentation().setEnabledAndVisible(BranchActionGroupPopup.this.myUserSizeChanged || WindowStateService.getInstance((Project)BranchActionGroupPopup.this.myProject).getSizeFor((Object)BranchActionGroupPopup.this.myProject, dimensionKey) != null);
            }
        };
        ActionToolbar popupTitleToolbar = ActionManager.getInstance().createActionToolbar("BranchWidget", (ActionGroup)new DefaultActionGroup(new AnAction[]{restoreDefaultSizeAction}), true);
        final JComponent toolbarComponent = popupTitleToolbar.getComponent();
        popupTitleToolbar.setReservePlaceAutoPopupIcon(false);
        toolbarComponent.setBorder((Border)JBUI.Borders.emptyRight((int)2));
        toolbarComponent.setOpaque(false);
        this.getTitle().setButtonComponent((ActiveComponent)new ActiveComponent.Adapter(){

            public JComponent getComponent() {
                return toolbarComponent;
            }
        }, null);
    }

    private BranchActionGroupPopup(@Nullable WizardPopup aParent, @NotNull ListPopupStep aStep, @Nullable Object parentValue) {
        if (aStep == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aStep", "com/intellij/dvcs/ui/BranchActionGroupPopup", "<init>"));
        }
        super(aParent, aStep, DataContext.EMPTY_CONTEXT, parentValue);
        this.myPrevSize = JBUI.emptySize();
        this.myKey = null;
        DataManager.registerDataProvider((JComponent)this.getList(), dataId -> POPUP_MODEL.is(dataId) ? this.getListModel() : null);
        this.installOnHoverIconsSupport(this.getListElementRenderer());
    }

    private void trackDimensions(final @Nullable String dimensionKey) {
        final Window popupWindow = this.getPopupWindow();
        if (popupWindow == null) {
            return;
        }
        final ComponentAdapter windowListener = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                if (BranchActionGroupPopup.this.myShown) {
                    BranchActionGroupPopup.this.processOnSizeChanged();
                }
            }
        };
        popupWindow.addComponentListener(windowListener);
        this.addPopupListener((JBPopupListener)new JBPopupAdapter(){

            public void onClosed(LightweightWindowEvent event) {
                popupWindow.removeComponentListener(windowListener);
                if (dimensionKey != null && BranchActionGroupPopup.this.myUserSizeChanged) {
                    WindowStateService.getInstance((Project)BranchActionGroupPopup.this.myProject).putSizeFor((Object)BranchActionGroupPopup.this.myProject, dimensionKey, BranchActionGroupPopup.this.myPrevSize);
                }
            }
        });
    }

    private void processOnSizeChanged() {
        boolean sizeWasIncreased;
        Dimension newSize = (Dimension)ObjectUtils.assertNotNull((Object)this.getSize());
        int preferredHeight = this.getComponent().getPreferredSize().height;
        int realHeight = this.getComponent().getHeight();
        boolean shouldExpand = preferredHeight + this.myMeanRowHeight < realHeight;
        boolean bl = sizeWasIncreased = this.myPrevSize.height < newSize.height;
        if (!this.myInternalSizeChanged && sizeWasIncreased && shouldExpand) {
            List<MoreAction> mores = this.getMoreActions();
            for (MoreAction more : mores) {
                if (!this.getList().getScrollableTracksViewportHeight()) break;
                if (more.isExpanded()) continue;
                more.setExpanded(true);
                this.getListModel().refilter();
            }
        }
        this.myPrevSize = newSize;
        this.myUserSizeChanged = !this.myInternalSizeChanged;
        this.myInternalSizeChanged = false;
    }

    @NotNull
    private List<MoreAction> getMoreActions() {
        ArrayList result2 = ContainerUtil.newArrayList();
        ListPopupModel model = this.getListModel();
        for (int i2 = 0; i2 < model.getSize(); ++i2) {
            MoreAction moreAction = BranchActionGroupPopup.getSpecificAction(model.getElementAt(i2), MoreAction.class);
            if (moreAction == null) continue;
            result2.add(moreAction);
        }
        ArrayList arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/ui/BranchActionGroupPopup", "getMoreActions"));
        }
        return arrayList;
    }

    @NotNull
    private static ActionGroup createBranchSpeedSearchActionGroup(@NotNull ActionGroup actionGroup) {
        if (actionGroup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionGroup", "com/intellij/dvcs/ui/BranchActionGroupPopup", "createBranchSpeedSearchActionGroup"));
        }
        DefaultActionGroup defaultActionGroup = new DefaultActionGroup(null, BranchActionGroupPopup.createSpeedSearchActions(actionGroup, true), false);
        if (defaultActionGroup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/ui/BranchActionGroupPopup", "createBranchSpeedSearchActionGroup"));
        }
        return defaultActionGroup;
    }

    @Override
    protected boolean isResizable() {
        return true;
    }

    @Override
    protected void afterShow() {
        super.afterShow();
        this.myShown = true;
        Dimension size = this.getSize();
        if (size != null) {
            this.myPrevSize = size;
        }
        this.trackDimensions(this.myKey);
    }

    private static List<AnAction> createSpeedSearchActions(@NotNull ActionGroup parentActionGroup, boolean isFirstLevel) {
        if (parentActionGroup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentActionGroup", "com/intellij/dvcs/ui/BranchActionGroupPopup", "createSpeedSearchActions"));
        }
        ArrayList speedSearchActions = ContainerUtil.newArrayList();
        if (!isFirstLevel) {
            speedSearchActions.add(new Separator(parentActionGroup.getTemplatePresentation().getText()));
        }
        for (AnAction child : parentActionGroup.getChildren(null)) {
            if (!(child instanceof ActionGroup)) continue;
            ActionGroup childGroup = (ActionGroup)child;
            if (isFirstLevel) {
                speedSearchActions.addAll(BranchActionGroupPopup.createSpeedSearchActions(childGroup, false));
                continue;
            }
            if (childGroup instanceof BranchActionGroup) {
                speedSearchActions.add(BranchActionGroupPopup.createSpeedSearchActionGroupWrapper(childGroup));
                continue;
            }
            if (!(childGroup instanceof HideableActionGroup)) continue;
            speedSearchActions.add(BranchActionGroupPopup.createSpeedSearchActionGroupWrapper(((HideableActionGroup)childGroup).getDelegate()));
        }
        return speedSearchActions;
    }

    @Override
    public void handleSelect(boolean handleFinalChoices) {
        super.handleSelect(handleFinalChoices, null);
        if (BranchActionGroupPopup.getSpecificAction(this.getList().getSelectedValue(), MoreAction.class) != null) {
            this.getListModel().refilter();
        }
    }

    @Override
    public void handleSelect(boolean handleFinalChoices, InputEvent e) {
        BranchActionGroup branchActionGroup = this.getSelectedBranchGroup();
        if (branchActionGroup != null && e instanceof MouseEvent && this.myListElementRenderer.isIconAt(((MouseEvent)e).getPoint())) {
            branchActionGroup.toggle();
            this.getList().repaint();
        } else {
            super.handleSelect(handleFinalChoices, e);
        }
    }

    @Override
    protected void handleToggleAction() {
        BranchActionGroup branchActionGroup = this.getSelectedBranchGroup();
        if (branchActionGroup != null) {
            branchActionGroup.toggle();
            this.getList().repaint();
        } else {
            super.handleToggleAction();
        }
    }

    @Nullable
    private BranchActionGroup getSelectedBranchGroup() {
        return BranchActionGroupPopup.getSpecificAction(this.getList().getSelectedValue(), BranchActionGroup.class);
    }

    @Override
    protected void onSpeedSearchPatternChanged() {
        this.getList().setSelectedIndex(0);
        super.onSpeedSearchPatternChanged();
        ScrollingUtil.ensureSelectionExists((JList)this.getList());
    }

    @Override
    protected boolean shouldUseStatistics() {
        return false;
    }

    @Override
    protected boolean shouldBeShowing(@NotNull AnAction action) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/dvcs/ui/BranchActionGroupPopup", "shouldBeShowing"));
        }
        if (!super.shouldBeShowing(action)) {
            return false;
        }
        if (this.getSpeedSearch().isHoldingFilter()) {
            return !(action instanceof MoreAction);
        }
        if (action instanceof MoreHideableActionGroup) {
            return ((MoreHideableActionGroup)action).shouldBeShown();
        }
        return true;
    }

    @Override
    protected WizardPopup createPopup(WizardPopup parent, PopupStep step, Object parentValue) {
        return this.createListPopupStep(parent, step, parentValue);
    }

    private WizardPopup createListPopupStep(WizardPopup parent, PopupStep step, Object parentValue) {
        if (step instanceof ListPopupStep) {
            return new BranchActionGroupPopup(parent, (ListPopupStep)step, parentValue);
        }
        return super.createPopup(parent, step, parentValue);
    }

    private static <T> T getSpecificAction(Object value2, @NotNull Class<T> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/dvcs/ui/BranchActionGroupPopup", "getSpecificAction"));
        }
        if (value2 instanceof PopupFactoryImpl.ActionItem) {
            AnAction action = ((PopupFactoryImpl.ActionItem)value2).getAction();
            if (clazz.isInstance(action)) {
                return clazz.cast(action);
            }
            if (action instanceof EmptyAction.MyDelegatingActionGroup) {
                ActionGroup group = ((EmptyAction.MyDelegatingActionGroup)action).getDelegate();
                return clazz.isInstance(group) ? (T)clazz.cast(group) : null;
            }
        }
        return null;
    }

    @Override
    protected MyPopupListElementRenderer getListElementRenderer() {
        if (this.myListElementRenderer == null) {
            this.myListElementRenderer = new MyPopupListElementRenderer(this);
        }
        return this.myListElementRenderer;
    }

    public static void wrapWithMoreActionIfNeeded(@NotNull Project project2, @NotNull DefaultActionGroup parentGroup, @NotNull List<? extends ActionGroup> actionList, int maxIndex, @Nullable String settingName) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/dvcs/ui/BranchActionGroupPopup", "wrapWithMoreActionIfNeeded"));
        }
        if (parentGroup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentGroup", "com/intellij/dvcs/ui/BranchActionGroupPopup", "wrapWithMoreActionIfNeeded"));
        }
        if (actionList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionList", "com/intellij/dvcs/ui/BranchActionGroupPopup", "wrapWithMoreActionIfNeeded"));
        }
        BranchActionGroupPopup.wrapWithMoreActionIfNeeded(project2, parentGroup, actionList, maxIndex, settingName, false);
    }

    public static void wrapWithMoreActionIfNeeded(@NotNull Project project2, @NotNull DefaultActionGroup parentGroup, @NotNull List<? extends ActionGroup> actionList, int maxIndex, @Nullable String settingName, boolean defaultExpandValue) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/dvcs/ui/BranchActionGroupPopup", "wrapWithMoreActionIfNeeded"));
        }
        if (parentGroup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentGroup", "com/intellij/dvcs/ui/BranchActionGroupPopup", "wrapWithMoreActionIfNeeded"));
        }
        if (actionList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionList", "com/intellij/dvcs/ui/BranchActionGroupPopup", "wrapWithMoreActionIfNeeded"));
        }
        if (actionList.size() > maxIndex) {
            boolean hasFavorites = actionList.stream().anyMatch(action -> action instanceof BranchActionGroup && ((BranchActionGroup)((Object)action)).isFavorite());
            MoreAction moreAction = new MoreAction(project2, actionList.size() - maxIndex, settingName, defaultExpandValue, hasFavorites);
            for (int i2 = 0; i2 < actionList.size(); ++i2) {
                parentGroup.add((AnAction)(i2 < maxIndex ? (AnAction)actionList.get(i2) : new HideableActionGroup(actionList.get(i2), moreAction)));
            }
            parentGroup.add((AnAction)moreAction);
        } else {
            parentGroup.addAll(actionList);
        }
    }

    private static class HideableActionGroup
    extends EmptyAction.MyDelegatingActionGroup
    implements MoreHideableActionGroup {
        @NotNull
        private final MoreAction myMoreAction;

        private HideableActionGroup(@NotNull ActionGroup actionGroup, @NotNull MoreAction moreAction) {
            if (actionGroup == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionGroup", "com/intellij/dvcs/ui/BranchActionGroupPopup$HideableActionGroup", "<init>"));
            }
            if (moreAction == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moreAction", "com/intellij/dvcs/ui/BranchActionGroupPopup$HideableActionGroup", "<init>"));
            }
            super(actionGroup);
            this.myMoreAction = moreAction;
        }

        @Override
        public boolean shouldBeShown() {
            return this.myMoreAction.isExpanded();
        }
    }

    static interface MoreHideableActionGroup {
        public boolean shouldBeShown();
    }

    private static class MoreAction
    extends DumbAwareAction
    implements KeepingPopupOpenAction {
        @NotNull
        private final Project myProject;
        @Nullable
        private final String mySettingName;
        private final boolean myDefaultExpandValue;
        private boolean myIsExpanded;
        @NotNull
        private final String myToCollapseText;
        @NotNull
        private final String myToExpandText;

        public MoreAction(@NotNull Project project2, int numberOfHiddenNodes, @Nullable String settingName, boolean defaultExpandValue, boolean hasFavorites) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/dvcs/ui/BranchActionGroupPopup$MoreAction", "<init>"));
            }
            this.myProject = project2;
            this.mySettingName = settingName;
            this.myDefaultExpandValue = defaultExpandValue;
            assert (numberOfHiddenNodes > 0);
            this.myToExpandText = "Show " + numberOfHiddenNodes + " More...";
            this.myToCollapseText = "Show " + (hasFavorites ? "Only Favorites" : "Less");
            this.setExpanded(settingName != null ? PropertiesComponent.getInstance((Project)project2).getBoolean(settingName, defaultExpandValue) : defaultExpandValue);
        }

        public void actionPerformed(AnActionEvent e) {
            DataProvider dataProvider;
            this.setExpanded(!this.myIsExpanded);
            InputEvent event = e.getInputEvent();
            if (event != null && event.getSource() instanceof JComponent && (dataProvider = DataManager.getDataProvider((JComponent)((JComponent)event.getSource()))) != null) {
                ((ListPopupModel)ObjectUtils.assertNotNull((Object)POPUP_MODEL.getData(dataProvider))).refilter();
            }
        }

        public boolean isExpanded() {
            return this.myIsExpanded;
        }

        public void setExpanded(boolean isExpanded) {
            this.myIsExpanded = isExpanded;
            this.saveState();
            this.updateActionText();
        }

        private void updateActionText() {
            this.getTemplatePresentation().setText(this.myIsExpanded ? this.myToCollapseText : this.myToExpandText);
        }

        public void saveState() {
            if (this.mySettingName != null) {
                PropertiesComponent.getInstance((Project)this.myProject).setValue(this.mySettingName, this.myIsExpanded, this.myDefaultExpandValue);
            }
        }
    }

    private static class MyTextSeparator
    extends SeparatorWithText {
        public MyTextSeparator() {
            this.setTextForeground((Color)JBColor.BLACK);
            this.setCaptionCentered(false);
            UIUtil.addInsets((JComponent)((Object)this), (int)4, (int)UIUtil.getListCellHPadding(), (int)0, (int)0);
        }

        protected void paintLine(Graphics g, int x, int y, int width) {
        }
    }

    private class MyPopupListElementRenderer
    extends PopupListElementRenderer<Object>
    implements IconListPopupRenderer {
        private ErrorLabel myPrefixLabel;
        private ErrorLabel myInfoLabel;
        private IconComponent myIconLabel;

        public MyPopupListElementRenderer(ListPopupImpl aPopup) {
            super(aPopup);
        }

        protected SeparatorWithText createSeparator() {
            return new MyTextSeparator();
        }

        @Override
        public boolean isIconAt(@NotNull Point point) {
            if (point == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "point", "com/intellij/dvcs/ui/BranchActionGroupPopup$MyPopupListElementRenderer", "isIconAt"));
            }
            JList list2 = BranchActionGroupPopup.this.getList();
            int index = BranchActionGroupPopup.this.getList().locationToIndex(point);
            Rectangle bounds = BranchActionGroupPopup.this.getList().getCellBounds(index, index);
            Component renderer = this.getListCellRendererComponent(list2, list2.getSelectedValue(), index, true, true);
            renderer.setBounds(bounds);
            renderer.doLayout();
            point.translate(-bounds.x, -bounds.y);
            return SwingUtilities.getDeepestComponentAt(renderer, point.x, point.y) instanceof IconComponent;
        }

        @Override
        protected void customizeComponent(JList list2, Object value2, boolean isSelected) {
            MoreAction more = (MoreAction)BranchActionGroupPopup.getSpecificAction(value2, MoreAction.class);
            if (more != null) {
                this.myTextLabel.setForeground((Color)JBColor.gray);
            }
            super.customizeComponent(list2, value2, isSelected);
            this.myTextLabel.setIcon(null);
            this.myTextLabel.setDisabledIcon(null);
            if (value2 instanceof PopupFactoryImpl.ActionItem) {
                ((PopupFactoryImpl.ActionItem)value2).setIconHovered(isSelected);
            }
            this.myIconLabel.setIcon(this.myDescriptor.getIconFor(value2));
            PopupElementWithAdditionalInfo additionalInfoAction = (PopupElementWithAdditionalInfo)BranchActionGroupPopup.getSpecificAction(value2, PopupElementWithAdditionalInfo.class);
            this.updateInfoComponent(this.myPrefixLabel, additionalInfoAction != null ? additionalInfoAction.getPrefixInfo() : null, isSelected);
            this.updateInfoComponent(this.myInfoLabel, additionalInfoAction != null ? additionalInfoAction.getInfoText() : null, isSelected);
        }

        private void updateInfoComponent(@NotNull ErrorLabel infoLabel, @Nullable String infoText, boolean isSelected) {
            if (infoLabel == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "infoLabel", "com/intellij/dvcs/ui/BranchActionGroupPopup$MyPopupListElementRenderer", "updateInfoComponent"));
            }
            if (infoText != null) {
                infoLabel.setVisible(true);
                infoLabel.setText(infoText);
                if (isSelected) {
                    this.setSelected((JComponent)infoLabel);
                } else {
                    infoLabel.setBackground(this.getBackground());
                    infoLabel.setForeground((Color)JBColor.GRAY);
                }
            } else {
                infoLabel.setVisible(false);
            }
        }

        @Override
        protected JComponent createItemComponent() {
            this.myPrefixLabel = new ErrorLabel();
            this.myPrefixLabel.setOpaque(true);
            this.myPrefixLabel.setBorder((Border)JBUI.Borders.empty((int)1, (int)1, (int)1, (int)10));
            Font minusOneFont = FontUtil.minusOne((Font)this.myPrefixLabel.getFont());
            this.myPrefixLabel.setFont(minusOneFont);
            this.myTextLabel = new ErrorLabel();
            this.myTextLabel.setOpaque(true);
            this.myTextLabel.setBorder(JBUI.Borders.empty((int)1));
            this.myInfoLabel = new ErrorLabel();
            this.myInfoLabel.setOpaque(true);
            this.myInfoLabel.setBorder((Border)JBUI.Borders.empty((int)1, (int)10, (int)1, (int)1));
            this.myInfoLabel.setFont(minusOneFont);
            OpaquePanel compoundPanel = new OpaquePanel((LayoutManager)new BorderLayout(), (Color)JBColor.WHITE);
            this.myIconLabel = new IconComponent();
            this.myInfoLabel.setHorizontalAlignment(4);
            OpaquePanel compoundTextPanel = new OpaquePanel((LayoutManager)new BorderLayout(), compoundPanel.getBackground());
            OpaquePanel textPanel = new OpaquePanel((LayoutManager)new BorderLayout(), compoundPanel.getBackground());
            compoundPanel.add((Component)this.myIconLabel, "West");
            textPanel.add((Component)this.myTextLabel, "West");
            textPanel.add((Component)this.myInfoLabel, "Center");
            compoundTextPanel.add((Component)this.myPrefixLabel, "West");
            compoundTextPanel.add((Component)textPanel, "Center");
            compoundPanel.add((Component)compoundTextPanel, "Center");
            return this.layoutComponent((JComponent)compoundPanel);
        }

        private class IconComponent
        extends JLabel {
            private IconComponent() {
            }
        }
    }
}

