/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.ui;

import com.intellij.dvcs.ui.BranchActionGroup;
import com.intellij.util.containers.ContainerUtil;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class BranchActionUtil {
    public static final Comparator<BranchActionGroup> FAVORITE_BRANCH_COMPARATOR = Comparator.comparing(branch -> branch.isFavorite() ? -1 : 0);

    public static int getNumOfFavorites(@NotNull List<? extends BranchActionGroup> branchActions) {
        if (branchActions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branchActions", "com/intellij/dvcs/ui/BranchActionUtil", "getNumOfFavorites"));
        }
        return ContainerUtil.count(branchActions, BranchActionGroup::isFavorite);
    }

    public static int getNumOfTopShownBranches(@NotNull List<? extends BranchActionGroup> branchActions) {
        if (branchActions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branchActions", "com/intellij/dvcs/ui/BranchActionUtil", "getNumOfTopShownBranches"));
        }
        int numOfFavorites = BranchActionUtil.getNumOfFavorites(branchActions);
        if (branchActions.size() > 8) {
            if (numOfFavorites > 0) {
                return numOfFavorites;
            }
            return 5;
        }
        return 8;
    }
}

