/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.ui;

import com.intellij.dvcs.repo.AbstractRepositoryManager;
import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsLog;
import com.intellij.vcs.log.VcsLogDataKeys;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.impl.VcsLogUtil;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class VcsLogAction<Repo extends Repository>
extends DumbAwareAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/dvcs/ui/VcsLogAction", "actionPerformed"));
        }
        Project project2 = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        VcsLog log = (VcsLog)e.getRequiredData(VcsLogDataKeys.VCS_LOG);
        log.requestSelectedDetails(details -> {
            MultiMap grouped = this.groupCommits(project2, (Collection)details, VcsShortCommitDetails::getRoot);
            if (grouped == null) {
                return;
            }
            this.actionPerformed(project2, grouped);
        });
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/dvcs/ui/VcsLogAction", "update"));
        }
        Project project2 = e.getProject();
        VcsLog log = (VcsLog)e.getData(VcsLogDataKeys.VCS_LOG);
        if (project2 == null || log == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        MultiMap<Repo, Hash> grouped = this.groupFirstPackOfCommits(project2, log);
        if (grouped == null) {
            e.getPresentation().setEnabledAndVisible(false);
        } else {
            e.getPresentation().setVisible(this.isVisible(project2, grouped));
            e.getPresentation().setEnabled(!grouped.isEmpty() && this.isEnabled(grouped));
        }
    }

    protected abstract void actionPerformed(@NotNull Project var1, @NotNull MultiMap<Repo, VcsFullCommitDetails> var2);

    protected abstract boolean isEnabled(@NotNull MultiMap<Repo, Hash> var1);

    protected boolean isVisible(@NotNull Project project2, @NotNull MultiMap<Repo, Hash> grouped) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/dvcs/ui/VcsLogAction", "isVisible"));
        }
        if (grouped == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grouped", "com/intellij/dvcs/ui/VcsLogAction", "isVisible"));
        }
        AbstractRepositoryManager manager = this.getRepositoryManager(project2);
        return grouped.keySet().stream().allMatch(repo -> !manager.isExternal((Repository)repo));
    }

    @NotNull
    protected abstract AbstractRepositoryManager<Repo> getRepositoryManager(@NotNull Project var1);

    @Nullable
    protected abstract Repo getRepositoryForRoot(@NotNull Project var1, @NotNull VirtualFile var2);

    @Nullable
    private MultiMap<Repo, Hash> groupFirstPackOfCommits(@NotNull Project project2, @NotNull VcsLog log) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/dvcs/ui/VcsLogAction", "groupFirstPackOfCommits"));
        }
        if (log == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "log", "com/intellij/dvcs/ui/VcsLogAction", "groupFirstPackOfCommits"));
        }
        MultiMap commitIds = this.groupCommits(project2, VcsLogUtil.collectFirstPack(log.getSelectedCommits(), 1000), CommitId::getRoot);
        if (commitIds == null) {
            return null;
        }
        MultiMap hashes = MultiMap.create();
        for (Map.Entry entry : commitIds.entrySet()) {
            hashes.putValues(entry.getKey(), (Collection)ContainerUtil.map((Collection)((Collection)entry.getValue()), CommitId::getHash));
        }
        return hashes;
    }

    @Nullable
    private <T> MultiMap<Repo, T> groupCommits(@NotNull Project project2, @NotNull Collection<T> commits, @NotNull Function<T, VirtualFile> rootGetter) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/dvcs/ui/VcsLogAction", "groupCommits"));
        }
        if (commits == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commits", "com/intellij/dvcs/ui/VcsLogAction", "groupCommits"));
        }
        if (rootGetter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootGetter", "com/intellij/dvcs/ui/VcsLogAction", "groupCommits"));
        }
        MultiMap map2 = MultiMap.create();
        for (T commit : commits) {
            Repo root = this.getRepositoryForRoot(project2, (VirtualFile)rootGetter.fun(commit));
            if (root == null) {
                return null;
            }
            map2.putValue(root, commit);
        }
        return map2;
    }
}

