/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.embedding;

import com.intellij.embedding.MasqueradingLexer;
import com.intellij.embedding.TemplateMasqueradingLexer;
import com.intellij.lang.ASTNode;
import com.intellij.lang.LighterLazyParseableNode;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.impl.DelegateMarker;
import com.intellij.lang.impl.PsiBuilderAdapter;
import com.intellij.lang.impl.PsiBuilderImpl;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MasqueradingPsiBuilderAdapter
extends PsiBuilderAdapter {
    private static final Logger LOG = Logger.getInstance(MasqueradingPsiBuilderAdapter.class);
    private List<MyShiftedToken> myShrunkSequence;
    private CharSequence myShrunkCharSequence;
    private int myLexPosition;
    private final PsiBuilderImpl myBuilderDelegate;
    private final MasqueradingLexer myLexer;

    public MasqueradingPsiBuilderAdapter(@NotNull Project project2, @NotNull ParserDefinition parserDefinition, @NotNull MasqueradingLexer lexer, @NotNull ASTNode chameleon, @NotNull CharSequence text2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/embedding/MasqueradingPsiBuilderAdapter", "<init>"));
        }
        if (parserDefinition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parserDefinition", "com/intellij/embedding/MasqueradingPsiBuilderAdapter", "<init>"));
        }
        if (lexer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lexer", "com/intellij/embedding/MasqueradingPsiBuilderAdapter", "<init>"));
        }
        if (chameleon == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chameleon", "com/intellij/embedding/MasqueradingPsiBuilderAdapter", "<init>"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/embedding/MasqueradingPsiBuilderAdapter", "<init>"));
        }
        this(new PsiBuilderImpl(project2, parserDefinition, (Lexer)lexer, chameleon, text2));
    }

    public MasqueradingPsiBuilderAdapter(@NotNull Project project2, @NotNull ParserDefinition parserDefinition, @NotNull MasqueradingLexer lexer, @NotNull LighterLazyParseableNode chameleon, @NotNull CharSequence text2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/embedding/MasqueradingPsiBuilderAdapter", "<init>"));
        }
        if (parserDefinition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parserDefinition", "com/intellij/embedding/MasqueradingPsiBuilderAdapter", "<init>"));
        }
        if (lexer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lexer", "com/intellij/embedding/MasqueradingPsiBuilderAdapter", "<init>"));
        }
        if (chameleon == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chameleon", "com/intellij/embedding/MasqueradingPsiBuilderAdapter", "<init>"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/embedding/MasqueradingPsiBuilderAdapter", "<init>"));
        }
        this(new PsiBuilderImpl(project2, parserDefinition, (Lexer)lexer, chameleon, text2));
    }

    private MasqueradingPsiBuilderAdapter(PsiBuilderImpl builder) {
        super(builder);
        LOG.assertTrue(this.myDelegate instanceof PsiBuilderImpl);
        this.myBuilderDelegate = (PsiBuilderImpl)this.myDelegate;
        LOG.assertTrue(this.myBuilderDelegate.getLexer() instanceof MasqueradingLexer);
        this.myLexer = (MasqueradingLexer)this.myBuilderDelegate.getLexer();
        this.initShrunkSequence();
    }

    @Override
    public CharSequence getOriginalText() {
        return this.myShrunkCharSequence;
    }

    @Override
    public void advanceLexer() {
        ++this.myLexPosition;
        this.skipWhitespace();
        this.synchronizePositions(false);
    }

    private void synchronizePositions(boolean exact) {
        int delegatePosition;
        PsiBuilder delegate = this.getDelegate();
        if (this.myLexPosition >= this.myShrunkSequence.size() || delegate.eof()) {
            this.myLexPosition = this.myShrunkSequence.size();
            while (!delegate.eof()) {
                delegate.advanceLexer();
            }
            return;
        }
        if (delegate.getCurrentOffset() > this.myShrunkSequence.get((int)this.myLexPosition).realStart) {
            LOG.error("delegate is ahead of my builder!", new Attachment[]{new Attachment("offset = " + delegate.getCurrentOffset(), this.getOriginalText().toString()), new Attachment("myShrunkSequence", this.myShrunkSequence.toString())});
            return;
        }
        int keepUpPosition = this.getKeepUpPosition(exact);
        while (!delegate.eof() && (delegatePosition = delegate.getCurrentOffset()) < keepUpPosition) {
            delegate.advanceLexer();
        }
    }

    private int getKeepUpPosition(boolean exact) {
        int lexPosition;
        if (exact) {
            return this.myShrunkSequence.get((int)this.myLexPosition).realStart;
        }
        for (lexPosition = this.myLexPosition; lexPosition > 0 && (this.myShrunkSequence.get((int)(lexPosition - 1)).shrunkStart == this.myShrunkSequence.get((int)lexPosition).shrunkStart || this.isWhiteSpaceOnPos(lexPosition - 1)); --lexPosition) {
        }
        if (lexPosition == 0) {
            return this.myShrunkSequence.get((int)lexPosition).realStart;
        }
        return this.myShrunkSequence.get((int)(lexPosition - 1)).realStart + 1;
    }

    @Override
    public IElementType lookAhead(int steps) {
        if (this.eof()) {
            return null;
        }
        int cur = this.myLexPosition;
        while (steps > 0) {
            ++cur;
            while (cur < this.myShrunkSequence.size() && this.isWhiteSpaceOnPos(cur)) {
                ++cur;
            }
            --steps;
        }
        return cur < this.myShrunkSequence.size() ? this.myShrunkSequence.get((int)cur).elementType : null;
    }

    @Override
    public IElementType rawLookup(int steps) {
        int cur = this.myLexPosition + steps;
        return cur >= 0 && cur < this.myShrunkSequence.size() ? this.myShrunkSequence.get((int)cur).elementType : null;
    }

    @Override
    public int rawTokenTypeStart(int steps) {
        int cur = this.myLexPosition + steps;
        if (cur < 0) {
            return -1;
        }
        if (cur >= this.myShrunkSequence.size()) {
            return this.getOriginalText().length();
        }
        return this.myShrunkSequence.get((int)cur).shrunkStart;
    }

    @Override
    public int rawTokenIndex() {
        return this.myLexPosition;
    }

    @Override
    public int getCurrentOffset() {
        return this.myLexPosition < this.myShrunkSequence.size() ? this.myShrunkSequence.get((int)this.myLexPosition).shrunkStart : this.myShrunkCharSequence.length();
    }

    @Override
    @Nullable
    public IElementType getTokenType() {
        if (this.eof()) {
            return null;
        }
        this.skipWhitespace();
        return this.myLexPosition < this.myShrunkSequence.size() ? this.myShrunkSequence.get((int)this.myLexPosition).elementType : null;
    }

    @Override
    @Nullable
    public String getTokenText() {
        if (this.eof()) {
            return null;
        }
        this.skipWhitespace();
        if (this.myLexPosition >= this.myShrunkSequence.size()) {
            return null;
        }
        MyShiftedToken token = this.myShrunkSequence.get(this.myLexPosition);
        return this.myShrunkCharSequence.subSequence(token.shrunkStart, token.shrunkEnd).toString();
    }

    @Override
    public boolean eof() {
        boolean isEof;
        boolean bl = isEof = this.myLexPosition >= this.myShrunkSequence.size();
        if (!isEof) {
            return false;
        }
        this.synchronizePositions(true);
        return true;
    }

    @Override
    @NotNull
    public PsiBuilder.Marker mark() {
        PsiBuilder.Marker originalPositionMarker = null;
        if (this.myLexPosition != 0) {
            originalPositionMarker = super.mark();
            this.synchronizePositions(true);
        }
        PsiBuilder.Marker mark = super.mark();
        if (this.myLexPosition == 0 && this.myDelegate.getTokenType() == TemplateMasqueradingLexer.MINUS_TYPE) {
            this.myDelegate.advanceLexer();
        }
        MyMarker myMarker = new MyMarker(mark, originalPositionMarker, this.myLexPosition);
        if (myMarker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/embedding/MasqueradingPsiBuilderAdapter", "mark"));
        }
        return myMarker;
    }

    private void skipWhitespace() {
        while (this.myLexPosition < this.myShrunkSequence.size() && this.isWhiteSpaceOnPos(this.myLexPosition)) {
            ++this.myLexPosition;
        }
    }

    private boolean isWhiteSpaceOnPos(int pos) {
        return this.myBuilderDelegate.whitespaceOrComment(this.myShrunkSequence.get((int)pos).elementType);
    }

    protected void initShrunkSequence() {
        this.initTokenListAndCharSequence(this.myLexer);
        this.myLexPosition = 0;
    }

    private void initTokenListAndCharSequence(MasqueradingLexer lexer) {
        lexer.start(this.getDelegate().getOriginalText());
        this.myShrunkSequence = new ArrayList<MyShiftedToken>();
        StringBuilder charSequenceBuilder = new StringBuilder();
        int realPos = 0;
        int shrunkPos = 0;
        while (lexer.getTokenType() != null) {
            IElementType masqueTokenType = lexer.getMasqueTokenType();
            String masqueTokenText = lexer.getMasqueTokenText();
            int realLength = lexer.getTokenEnd() - lexer.getTokenStart();
            if (masqueTokenType != null) {
                assert (masqueTokenText != null);
                int masqueLength = masqueTokenText.length();
                this.myShrunkSequence.add(new MyShiftedToken(masqueTokenType, realPos, realPos + realLength, shrunkPos, shrunkPos + masqueLength));
                charSequenceBuilder.append(masqueTokenText);
                shrunkPos += masqueLength;
            }
            realPos += realLength;
            lexer.advance();
        }
        this.myShrunkCharSequence = charSequenceBuilder.toString();
    }

    private void logPos() {
        StringBuilder sb = new StringBuilder();
        sb.append("\nmyLexPosition=" + this.myLexPosition + "/" + this.myShrunkSequence.size());
        if (this.myLexPosition < this.myShrunkSequence.size()) {
            MyShiftedToken token = this.myShrunkSequence.get(this.myLexPosition);
            sb.append("\nshrunk:" + token.shrunkStart + "," + token.shrunkEnd);
            sb.append("\nreal:" + token.realStart + "," + token.realEnd);
            sb.append("\nTT:" + this.getTokenText());
        }
        sb.append("\ndelegate:");
        sb.append("eof=" + this.myDelegate.eof());
        if (!this.myDelegate.eof()) {
            sb.append("\nposition:" + this.myDelegate.getCurrentOffset() + "," + (this.myDelegate.getCurrentOffset() + this.myDelegate.getTokenText().length()));
            sb.append("\nTT:" + this.myDelegate.getTokenText());
        }
        LOG.info(sb.toString());
    }

    private class MyMarker
    extends DelegateMarker {
        private final int myBuilderPosition;
        private final PsiBuilder.Marker myOriginalPositionMarker;

        public MyMarker(PsiBuilder.Marker delegate, PsiBuilder.Marker originalPositionMarker, int builderPosition) {
            super(delegate);
            this.myBuilderPosition = builderPosition;
            this.myOriginalPositionMarker = originalPositionMarker;
        }

        @Override
        public void rollbackTo() {
            if (this.myOriginalPositionMarker != null) {
                this.myOriginalPositionMarker.rollbackTo();
            } else {
                super.rollbackTo();
            }
            MasqueradingPsiBuilderAdapter.this.myLexPosition = this.myBuilderPosition;
        }

        @Override
        public void doneBefore(@NotNull IElementType type2, @NotNull PsiBuilder.Marker before) {
            if (type2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/embedding/MasqueradingPsiBuilderAdapter$MyMarker", "doneBefore"));
            }
            if (before == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "before", "com/intellij/embedding/MasqueradingPsiBuilderAdapter$MyMarker", "doneBefore"));
            }
            if (this.myOriginalPositionMarker != null) {
                this.myOriginalPositionMarker.drop();
            }
            super.doneBefore(type2, this.getDelegateOrThis(before));
        }

        @Override
        public void doneBefore(@NotNull IElementType type2, @NotNull PsiBuilder.Marker before, String errorMessage) {
            if (type2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/embedding/MasqueradingPsiBuilderAdapter$MyMarker", "doneBefore"));
            }
            if (before == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "before", "com/intellij/embedding/MasqueradingPsiBuilderAdapter$MyMarker", "doneBefore"));
            }
            if (this.myOriginalPositionMarker != null) {
                this.myOriginalPositionMarker.drop();
            }
            super.doneBefore(type2, this.getDelegateOrThis(before), errorMessage);
        }

        @Override
        public void drop() {
            if (this.myOriginalPositionMarker != null) {
                this.myOriginalPositionMarker.drop();
            }
            super.drop();
        }

        @Override
        public void done(@NotNull IElementType type2) {
            if (type2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/embedding/MasqueradingPsiBuilderAdapter$MyMarker", "done"));
            }
            if (this.myOriginalPositionMarker != null) {
                this.myOriginalPositionMarker.drop();
            }
            super.done(type2);
        }

        @Override
        public void collapse(@NotNull IElementType type2) {
            if (type2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/embedding/MasqueradingPsiBuilderAdapter$MyMarker", "collapse"));
            }
            if (this.myOriginalPositionMarker != null) {
                this.myOriginalPositionMarker.drop();
            }
            super.collapse(type2);
        }

        @Override
        public void error(String message2) {
            if (this.myOriginalPositionMarker != null) {
                this.myOriginalPositionMarker.drop();
            }
            super.error(message2);
        }

        @NotNull
        private PsiBuilder.Marker getDelegateOrThis(@NotNull PsiBuilder.Marker marker) {
            if (marker == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "marker", "com/intellij/embedding/MasqueradingPsiBuilderAdapter$MyMarker", "getDelegateOrThis"));
            }
            if (marker instanceof DelegateMarker) {
                PsiBuilder.Marker marker2 = ((DelegateMarker)marker).getDelegate();
                if (marker2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/embedding/MasqueradingPsiBuilderAdapter$MyMarker", "getDelegateOrThis"));
                }
                return marker2;
            }
            PsiBuilder.Marker marker3 = marker;
            if (marker3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/embedding/MasqueradingPsiBuilderAdapter$MyMarker", "getDelegateOrThis"));
            }
            return marker3;
        }
    }

    private static class MyShiftedToken {
        public final IElementType elementType;
        public final int realStart;
        public final int realEnd;
        public final int shrunkStart;
        public final int shrunkEnd;

        public MyShiftedToken(IElementType elementType, int realStart, int realEnd, int shrunkStart, int shrunkEnd) {
            this.elementType = elementType;
            this.realStart = realStart;
            this.realEnd = realEnd;
            this.shrunkStart = shrunkStart;
            this.shrunkEnd = shrunkEnd;
        }

        public String toString() {
            return "MSTk: [" + this.realStart + ", " + this.realEnd + "] -> [" + this.shrunkStart + ", " + this.shrunkEnd + "]: " + this.elementType.toString();
        }
    }
}

