/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.execution.ExecutionManager;
import com.intellij.execution.ExecutionMode;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.ide.errorTreeView.NewErrorTreeViewPanel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.pom.NonNavigatable;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.components.JBList;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.MessageView;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.NotNullFunction;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ErrorTreeView;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExecutionHelper {
    private static final Logger LOG = Logger.getInstance((String)ExecutionHelper.class.getName());

    private ExecutionHelper() {
    }

    public static void showErrors(@NotNull Project myProject, @NotNull List<? extends Exception> errors, @NotNull String tabDisplayName, @Nullable VirtualFile file2) {
        if (myProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "myProject", "com/intellij/execution/ExecutionHelper", "showErrors"));
        }
        if (errors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errors", "com/intellij/execution/ExecutionHelper", "showErrors"));
        }
        if (tabDisplayName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tabDisplayName", "com/intellij/execution/ExecutionHelper", "showErrors"));
        }
        ExecutionHelper.showExceptions(myProject, errors, Collections.emptyList(), tabDisplayName, file2);
    }

    public static void showExceptions(@NotNull Project myProject, @NotNull List<? extends Exception> errors, @NotNull List<? extends Exception> warnings, @NotNull String tabDisplayName, @Nullable VirtualFile file2) {
        if (myProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "myProject", "com/intellij/execution/ExecutionHelper", "showExceptions"));
        }
        if (errors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errors", "com/intellij/execution/ExecutionHelper", "showExceptions"));
        }
        if (warnings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "warnings", "com/intellij/execution/ExecutionHelper", "showExceptions"));
        }
        if (tabDisplayName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tabDisplayName", "com/intellij/execution/ExecutionHelper", "showExceptions"));
        }
        if (ApplicationManager.getApplication().isUnitTestMode() && !errors.isEmpty()) {
            throw new RuntimeException(errors.get(0));
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            if (myProject == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "myProject", "com/intellij/execution/ExecutionHelper", "lambda$showExceptions$0"));
            }
            if (errors == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errors", "com/intellij/execution/ExecutionHelper", "lambda$showExceptions$0"));
            }
            if (warnings == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "warnings", "com/intellij/execution/ExecutionHelper", "lambda$showExceptions$0"));
            }
            if (tabDisplayName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tabDisplayName", "com/intellij/execution/ExecutionHelper", "lambda$showExceptions$0"));
            }
            if (myProject.isDisposed()) {
                return;
            }
            if (errors.isEmpty() && warnings.isEmpty()) {
                ExecutionHelper.removeContents(null, myProject, tabDisplayName);
                return;
            }
            ErrorViewPanel errorTreeView = new ErrorViewPanel(myProject);
            try {
                ExecutionHelper.openMessagesView(errorTreeView, myProject, tabDisplayName);
            }
            catch (NullPointerException e) {
                StringBuilder builder = new StringBuilder();
                builder.append("Exceptions occurred:");
                for (Exception exception : errors) {
                    builder.append("\n");
                    builder.append(exception.getMessage());
                }
                builder.append("Warnings occurred:");
                for (Exception exception : warnings) {
                    builder.append("\n");
                    builder.append(exception.getMessage());
                }
                Messages.showErrorDialog((String)builder.toString(), (String)"Execution Error");
                return;
            }
            ExecutionHelper.addMessages(4, errors, errorTreeView, file2, "Unknown Error");
            ExecutionHelper.addMessages(5, warnings, errorTreeView, file2, "Unknown Warning");
            ToolWindowManager.getInstance((Project)myProject).getToolWindow(ToolWindowId.MESSAGES_WINDOW).activate(null);
        });
    }

    private static void addMessages(int messageCategory, @NotNull List<? extends Exception> exceptions, @NotNull ErrorViewPanel errorTreeView, @Nullable VirtualFile file2, @NotNull String defaultMessage) {
        if (exceptions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exceptions", "com/intellij/execution/ExecutionHelper", "addMessages"));
        }
        if (errorTreeView == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorTreeView", "com/intellij/execution/ExecutionHelper", "addMessages"));
        }
        if (defaultMessage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultMessage", "com/intellij/execution/ExecutionHelper", "addMessages"));
        }
        for (Exception exception : exceptions) {
            String[] messages;
            String message2 = exception.getMessage();
            String[] stringArray = messages = StringUtil.isNotEmpty((String)message2) ? StringUtil.splitByLines((String)message2) : ArrayUtil.EMPTY_STRING_ARRAY;
            if (messages.length == 0) {
                messages = new String[]{defaultMessage};
            }
            errorTreeView.addMessage(messageCategory, messages, file2, -1, -1, null);
        }
    }

    public static void showOutput(@NotNull Project myProject, @NotNull ProcessOutput output, @NotNull String tabDisplayName, @Nullable VirtualFile file2, boolean activateWindow) {
        if (myProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "myProject", "com/intellij/execution/ExecutionHelper", "showOutput"));
        }
        if (output == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "output", "com/intellij/execution/ExecutionHelper", "showOutput"));
        }
        if (tabDisplayName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tabDisplayName", "com/intellij/execution/ExecutionHelper", "showOutput"));
        }
        String stdout = output.getStdout();
        String stderr = output.getStderr();
        if (ApplicationManager.getApplication().isUnitTestMode() && !stdout.isEmpty() && !stderr.isEmpty()) {
            throw new RuntimeException("STDOUT:\n" + stdout + "\nSTDERR:\n" + stderr);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            String[] stderrLines;
            String[] stdoutLines;
            if (myProject == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "myProject", "com/intellij/execution/ExecutionHelper", "lambda$showOutput$1"));
            }
            if (tabDisplayName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tabDisplayName", "com/intellij/execution/ExecutionHelper", "lambda$showOutput$1"));
            }
            if (output == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "output", "com/intellij/execution/ExecutionHelper", "lambda$showOutput$1"));
            }
            if (myProject.isDisposed()) {
                return;
            }
            String stdOutTitle = "[Stdout]:";
            String stderrTitle = "[Stderr]:";
            ErrorViewPanel errorTreeView = new ErrorViewPanel(myProject);
            try {
                ExecutionHelper.openMessagesView(errorTreeView, myProject, tabDisplayName);
            }
            catch (NullPointerException e) {
                Messages.showErrorDialog((String)("[Stdout]:\n" + (stdout != null ? stdout : "<empty>") + "\n" + "[Stderr]:" + "\n" + (stderr != null ? stderr : "<empty>")), (String)"Process Output");
                return;
            }
            if (!StringUtil.isEmpty((String)stdout) && (stdoutLines = StringUtil.splitByLines((String)stdout)).length > 0) {
                if (StringUtil.isEmpty((String)stderr)) {
                    errorTreeView.addMessage(1, stdoutLines, file2, -1, -1, null);
                } else if (file2 == null) {
                    errorTreeView.addMessage(1, stdoutLines, "[Stdout]:", NonNavigatable.INSTANCE, null, null, null);
                } else {
                    errorTreeView.addMessage(1, new String[]{"[Stdout]:"}, file2, -1, -1, null);
                    errorTreeView.addMessage(1, new String[]{""}, file2, -1, -1, null);
                    errorTreeView.addMessage(1, stdoutLines, file2, -1, -1, null);
                }
            }
            if (!StringUtil.isEmpty((String)stderr) && (stderrLines = StringUtil.splitByLines((String)stderr)).length > 0) {
                if (file2 == null) {
                    errorTreeView.addMessage(1, stderrLines, "[Stderr]:", NonNavigatable.INSTANCE, null, null, null);
                } else {
                    errorTreeView.addMessage(1, new String[]{"[Stderr]:"}, file2, -1, -1, null);
                    errorTreeView.addMessage(1, ArrayUtil.EMPTY_STRING_ARRAY, file2, -1, -1, null);
                    errorTreeView.addMessage(1, stderrLines, file2, -1, -1, null);
                }
            }
            errorTreeView.addMessage(1, new String[]{"Process finished with exit code " + output.getExitCode()}, null, -1, -1, null);
            if (activateWindow) {
                ToolWindowManager.getInstance((Project)myProject).getToolWindow(ToolWindowId.MESSAGES_WINDOW).activate(null);
            }
        });
    }

    private static void openMessagesView(@NotNull ErrorViewPanel errorTreeView, @NotNull Project myProject, @NotNull String tabDisplayName) {
        if (errorTreeView == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorTreeView", "com/intellij/execution/ExecutionHelper", "openMessagesView"));
        }
        if (myProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "myProject", "com/intellij/execution/ExecutionHelper", "openMessagesView"));
        }
        if (tabDisplayName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tabDisplayName", "com/intellij/execution/ExecutionHelper", "openMessagesView"));
        }
        CommandProcessor commandProcessor = CommandProcessor.getInstance();
        commandProcessor.executeCommand(myProject, () -> {
            if (myProject == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "myProject", "com/intellij/execution/ExecutionHelper", "lambda$openMessagesView$2"));
            }
            if (errorTreeView == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorTreeView", "com/intellij/execution/ExecutionHelper", "lambda$openMessagesView$2"));
            }
            if (tabDisplayName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tabDisplayName", "com/intellij/execution/ExecutionHelper", "lambda$openMessagesView$2"));
            }
            MessageView messageView = (MessageView)ServiceManager.getService((Project)myProject, MessageView.class);
            Content content = ContentFactory.SERVICE.getInstance().createContent((JComponent)errorTreeView, tabDisplayName, true);
            messageView.getContentManager().addContent(content);
            Disposer.register((Disposable)content, (Disposable)errorTreeView);
            messageView.getContentManager().setSelectedContent(content);
            ExecutionHelper.removeContents(content, myProject, tabDisplayName);
        }, "Open message view", null);
    }

    private static void removeContents(@Nullable Content notToRemove, @NotNull Project myProject, @NotNull String tabDisplayName) {
        Content[] contents;
        if (myProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "myProject", "com/intellij/execution/ExecutionHelper", "removeContents"));
        }
        if (tabDisplayName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tabDisplayName", "com/intellij/execution/ExecutionHelper", "removeContents"));
        }
        MessageView messageView = (MessageView)ServiceManager.getService((Project)myProject, MessageView.class);
        for (Content content : contents = messageView.getContentManager().getContents()) {
            ErrorTreeView listErrorView;
            LOG.assertTrue(content != null);
            if (content.isPinned() || !tabDisplayName.equals(content.getDisplayName()) || content == notToRemove || (listErrorView = (ErrorTreeView)content.getComponent()) == null || !messageView.getContentManager().removeContent(content, true)) continue;
            content.release();
        }
    }

    public static Collection<RunContentDescriptor> findRunningConsoleByTitle(Project project2, @NotNull NotNullFunction<String, Boolean> titleMatcher) {
        if (titleMatcher == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "titleMatcher", "com/intellij/execution/ExecutionHelper", "findRunningConsoleByTitle"));
        }
        return ExecutionHelper.findRunningConsole(project2, (NotNullFunction<RunContentDescriptor, Boolean>)((NotNullFunction)selectedContent -> {
            if (titleMatcher == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "titleMatcher", "com/intellij/execution/ExecutionHelper", "lambda$findRunningConsoleByTitle$3"));
            }
            return (Boolean)titleMatcher.fun((Object)selectedContent.getDisplayName());
        }));
    }

    public static Collection<RunContentDescriptor> findRunningConsole(@NotNull Project project2, @NotNull NotNullFunction<RunContentDescriptor, Boolean> descriptorMatcher) {
        ToolWindow toolWindow;
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/ExecutionHelper", "findRunningConsole"));
        }
        if (descriptorMatcher == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptorMatcher", "com/intellij/execution/ExecutionHelper", "findRunningConsole"));
        }
        RunContentManager contentManager = ExecutionManager.getInstance((Project)project2).getContentManager();
        RunContentDescriptor selectedContent = contentManager.getSelectedContent();
        if (selectedContent != null && (toolWindow = contentManager.getToolWindowByDescriptor(selectedContent)) != null && toolWindow.isVisible() && ((Boolean)descriptorMatcher.fun((Object)selectedContent)).booleanValue()) {
            return Collections.singletonList(selectedContent);
        }
        ArrayList result2 = ContainerUtil.newArrayList();
        for (RunContentDescriptor runContentDescriptor : contentManager.getAllDescriptors()) {
            if (!((Boolean)descriptorMatcher.fun((Object)runContentDescriptor)).booleanValue()) continue;
            result2.add(runContentDescriptor);
        }
        return result2;
    }

    public static List<RunContentDescriptor> collectConsolesByDisplayName(@NotNull Project project2, @NotNull NotNullFunction<String, Boolean> titleMatcher) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/ExecutionHelper", "collectConsolesByDisplayName"));
        }
        if (titleMatcher == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "titleMatcher", "com/intellij/execution/ExecutionHelper", "collectConsolesByDisplayName"));
        }
        SmartList result2 = new SmartList();
        for (RunContentDescriptor runContentDescriptor : ExecutionManager.getInstance((Project)project2).getContentManager().getAllDescriptors()) {
            if (!((Boolean)titleMatcher.fun((Object)runContentDescriptor.getDisplayName())).booleanValue()) continue;
            result2.add(runContentDescriptor);
        }
        return result2;
    }

    public static void selectContentDescriptor(@NotNull DataContext dataContext, @NotNull Project project2, @NotNull Collection<RunContentDescriptor> consoles2, String selectDialogTitle, Consumer<RunContentDescriptor> descriptorConsumer) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/execution/ExecutionHelper", "selectContentDescriptor"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/ExecutionHelper", "selectContentDescriptor"));
        }
        if (consoles2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consoles", "com/intellij/execution/ExecutionHelper", "selectContentDescriptor"));
        }
        if (consoles2.size() == 1) {
            RunContentDescriptor descriptor = consoles2.iterator().next();
            descriptorConsumer.consume((Object)descriptor);
            ExecutionHelper.descriptorToFront(project2, descriptor);
        } else if (consoles2.size() > 1) {
            JBList list2 = new JBList(consoles2);
            final Icon icon = DefaultRunExecutor.getRunExecutorInstance().getIcon();
            list2.setCellRenderer(new ListCellRendererWrapper<RunContentDescriptor>(){

                public void customize(JList list2, RunContentDescriptor value2, int index, boolean selected, boolean hasFocus) {
                    this.setText(value2.getDisplayName());
                    this.setIcon(icon);
                }
            });
            PopupChooserBuilder builder = new PopupChooserBuilder((JList)list2);
            builder.setTitle(selectDialogTitle);
            builder.setItemChoosenCallback(() -> ExecutionHelper.lambda$selectContentDescriptor$4((JList)list2, descriptorConsumer, project2)).createPopup().showInBestPositionFor(dataContext);
        }
    }

    private static void descriptorToFront(@NotNull Project project2, @NotNull RunContentDescriptor descriptor) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/ExecutionHelper", "descriptorToFront"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/execution/ExecutionHelper", "descriptorToFront"));
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/ExecutionHelper", "lambda$descriptorToFront$5"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/execution/ExecutionHelper", "lambda$descriptorToFront$5"));
            }
            RunContentManager manager = ExecutionManager.getInstance((Project)project2).getContentManager();
            ToolWindow toolWindow = manager.getToolWindowByDescriptor(descriptor);
            if (toolWindow != null) {
                toolWindow.show(null);
                manager.selectRunContent(descriptor);
            }
        }, project2.getDisposed());
    }

    public static void executeExternalProcess(@Nullable Project myProject, @NotNull ProcessHandler processHandler2, @NotNull ExecutionMode mode, @NotNull GeneralCommandLine cmdline) {
        if (processHandler2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processHandler", "com/intellij/execution/ExecutionHelper", "executeExternalProcess"));
        }
        if (mode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "com/intellij/execution/ExecutionHelper", "executeExternalProcess"));
        }
        if (cmdline == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cmdline", "com/intellij/execution/ExecutionHelper", "executeExternalProcess"));
        }
        ExecutionHelper.executeExternalProcess(myProject, processHandler2, mode, cmdline.getCommandLineString());
    }

    private static void executeExternalProcess(@Nullable Project myProject, @NotNull ProcessHandler processHandler2, @NotNull ExecutionMode mode, @NotNull String presentableCmdline) {
        String title;
        if (processHandler2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processHandler", "com/intellij/execution/ExecutionHelper", "executeExternalProcess"));
        }
        if (mode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "com/intellij/execution/ExecutionHelper", "executeExternalProcess"));
        }
        if (presentableCmdline == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentableCmdline", "com/intellij/execution/ExecutionHelper", "executeExternalProcess"));
        }
        String string = title = mode.getTitle() != null ? mode.getTitle() : "Please wait...";
        final Runnable process2 = mode.cancelable() ? ExecutionHelper.createCancelableExecutionProcess(processHandler2, mode.shouldCancelFun()) : (mode.getTimeout() <= 0 ? () -> {
            if (processHandler2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processHandler", "com/intellij/execution/ExecutionHelper", "lambda$executeExternalProcess$6"));
            }
            processHandler2.waitFor();
        } : ExecutionHelper.createTimeLimitedExecutionProcess(processHandler2, mode, presentableCmdline));
        if (mode.withModalProgress()) {
            ProgressManager.getInstance().runProcessWithProgressSynchronously(process2, title, mode.cancelable(), myProject, mode.getProgressParentComponent());
        } else if (mode.inBackGround()) {
            Task.Backgroundable task = new Task.Backgroundable(myProject, title, mode.cancelable()){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/execution/ExecutionHelper$2", "run"));
                    }
                    process2.run();
                }
            };
            ProgressManager.getInstance().run((Task)task);
        } else {
            String title2 = mode.getTitle2();
            ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
            if (indicator != null && title2 != null) {
                indicator.setText2(title2);
            }
            process2.run();
        }
    }

    private static Runnable createCancelableExecutionProcess(final ProcessHandler processHandler2, final Function<Object, Boolean> cancelableFun) {
        return new Runnable(){
            private ProgressIndicator myProgressIndicator;
            private final Semaphore mySemaphore = new Semaphore();
            private final Runnable myWaitThread = () -> {
                try {
                    processHandler2.waitFor();
                }
                finally {
                    this.mySemaphore.up();
                }
            };
            private final Runnable myCancelListener = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    while (true) {
                        if (myProgressIndicator != null && (myProgressIndicator.isCanceled() || !myProgressIndicator.isRunning()) || cancelableFun != null && ((Boolean)cancelableFun.fun(null)).booleanValue() || processHandler2.isProcessTerminated()) {
                            if (processHandler2.isProcessTerminated()) break;
                            try {
                                processHandler2.destroyProcess();
                                break;
                            }
                            finally {
                                mySemaphore.up();
                            }
                        }
                        try {
                            1 var1_1 = this;
                            synchronized (var1_1) {
                                this.wait(1000L);
                                continue;
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            continue;
                        }
                        break;
                    }
                }
            };

            @Override
            public void run() {
                this.myProgressIndicator = ProgressManager.getInstance().getProgressIndicator();
                if (this.myProgressIndicator != null && StringUtil.isEmpty((String)this.myProgressIndicator.getText())) {
                    this.myProgressIndicator.setText("Please wait...");
                }
                LOG.assertTrue(this.myProgressIndicator != null || cancelableFun != null, (Object)"Cancelable process must have an opportunity to be canceled!");
                this.mySemaphore.down();
                ApplicationManager.getApplication().executeOnPooledThread(this.myWaitThread);
                ApplicationManager.getApplication().executeOnPooledThread(this.myCancelListener);
                this.mySemaphore.waitFor();
            }
        };
    }

    private static Runnable createTimeLimitedExecutionProcess(final ProcessHandler processHandler2, final ExecutionMode mode, final @NotNull String presentableCmdline) {
        if (presentableCmdline == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentableCmdline", "com/intellij/execution/ExecutionHelper", "createTimeLimitedExecutionProcess"));
        }
        return new Runnable(){
            private final Semaphore mySemaphore = new Semaphore();
            private final Runnable myProcessThread = () -> {
                if (presentableCmdline == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentableCmdline", "com/intellij/execution/ExecutionHelper$4", "lambda$$0"));
                }
                try {
                    boolean finished2 = processHandler2.waitFor((long)(1000 * mode.getTimeout()));
                    if (!finished2) {
                        mode.getTimeoutCallback().consume((Object)mode, (Object)presentableCmdline);
                        processHandler2.destroyProcess();
                    }
                }
                finally {
                    this.mySemaphore.up();
                }
            };

            @Override
            public void run() {
                this.mySemaphore.down();
                ApplicationManager.getApplication().executeOnPooledThread(this.myProcessThread);
                this.mySemaphore.waitFor();
            }
        };
    }

    private static /* synthetic */ void lambda$selectContentDescriptor$4(JList list2, Consumer descriptorConsumer, @NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/ExecutionHelper", "lambda$selectContentDescriptor$4"));
        }
        Object selectedValue = list2.getSelectedValue();
        if (selectedValue instanceof RunContentDescriptor) {
            RunContentDescriptor descriptor = (RunContentDescriptor)selectedValue;
            descriptorConsumer.consume((Object)descriptor);
            ExecutionHelper.descriptorToFront(project2, descriptor);
        }
    }

    public static class ErrorViewPanel
    extends NewErrorTreeViewPanel {
        public ErrorViewPanel(Project project2) {
            super(project2, "reference.toolWindows.messages");
        }

        @Override
        protected boolean canHideWarnings() {
            return false;
        }
    }
}

