/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.execution.DefaultExecutionTarget;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.ExecutionTargetListener;
import com.intellij.execution.ExecutionTargetManager;
import com.intellij.execution.ExecutionTargetProvider;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunManagerListener;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="ExecutionTargetManager", storages={@Storage(value="$WORKSPACE_FILE$")})
public class ExecutionTargetManagerImpl
extends ExecutionTargetManager
implements PersistentStateComponent<Element> {
    @NotNull
    private final Project myProject;
    @NotNull
    private final Object myActiveTargetLock;
    @Nullable
    private ExecutionTarget myActiveTarget;
    @Nullable
    private String mySavedActiveTargetId;

    public ExecutionTargetManagerImpl(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/ExecutionTargetManagerImpl", "<init>"));
        }
        this.myActiveTargetLock = new Object();
        this.myProject = project2;
        project2.getMessageBus().connect().subscribe(RunManagerListener.TOPIC, (Object)new RunManagerListener(){

            @Override
            public void runConfigurationChanged(@NotNull RunnerAndConfigurationSettings settings) {
                if (settings == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/execution/ExecutionTargetManagerImpl$1", "runConfigurationChanged"));
                }
                if (settings == RunManager.getInstance((Project)ExecutionTargetManagerImpl.this.myProject).getSelectedConfiguration()) {
                    ExecutionTargetManagerImpl.this.updateActiveTarget(settings);
                }
            }

            @Override
            public void runConfigurationSelected() {
                ExecutionTargetManagerImpl.this.updateActiveTarget();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element getState() {
        Element state = new Element("state");
        Object object = this.myActiveTargetLock;
        synchronized (object) {
            String id;
            String string = id = this.myActiveTarget == null ? this.mySavedActiveTargetId : this.myActiveTarget.getId();
            if (id != null && !id.equals(DefaultExecutionTarget.INSTANCE.getId())) {
                state.setAttribute("SELECTED_TARGET", id);
            }
        }
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadState(Element state) {
        Object object = this.myActiveTargetLock;
        synchronized (object) {
            if (this.myActiveTarget == null && this.mySavedActiveTargetId == null) {
                this.mySavedActiveTargetId = state.getAttributeValue("SELECTED_TARGET");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public ExecutionTarget getActiveTarget() {
        Object object = this.myActiveTargetLock;
        // MONITORENTER : object
        if (this.myActiveTarget == null) {
            this.updateActiveTarget();
        }
        ExecutionTarget executionTarget = this.myActiveTarget;
        // MONITOREXIT : object
        if (executionTarget != null) return executionTarget;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/ExecutionTargetManagerImpl", "getActiveTarget"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setActiveTarget(@NotNull ExecutionTarget target2) {
        if (target2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/execution/ExecutionTargetManagerImpl", "setActiveTarget"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        Object object = this.myActiveTargetLock;
        synchronized (object) {
            this.updateActiveTarget(RunManager.getInstance((Project)this.myProject).getSelectedConfiguration(), target2);
        }
    }

    private void updateActiveTarget() {
        this.updateActiveTarget(RunManager.getInstance((Project)this.myProject).getSelectedConfiguration());
    }

    private void updateActiveTarget(@Nullable RunnerAndConfigurationSettings settings) {
        this.updateActiveTarget(settings, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateActiveTarget(@Nullable RunnerAndConfigurationSettings settings, @Nullable ExecutionTarget toSelect2) {
        ExecutionTarget toNotify;
        List<ExecutionTarget> suitable = settings == null ? Collections.singletonList(DefaultExecutionTarget.INSTANCE) : this.getTargetsFor(settings);
        Object object = this.myActiveTargetLock;
        synchronized (object) {
            if (toSelect2 == null) {
                toSelect2 = this.myActiveTarget;
            }
            int index = -1;
            if (toSelect2 != null) {
                index = suitable.indexOf(toSelect2);
            } else if (this.mySavedActiveTargetId != null) {
                int size = suitable.size();
                for (int i2 = 0; i2 < size; ++i2) {
                    if (!suitable.get(i2).getId().equals(this.mySavedActiveTargetId)) continue;
                    index = i2;
                    break;
                }
            }
            toNotify = this.doSetActiveTarget(index >= 0 ? suitable.get(index) : ExecutionTargetManagerImpl.getDefaultTarget(suitable));
        }
        if (toNotify != null) {
            ((ExecutionTargetListener)this.myProject.getMessageBus().syncPublisher(TOPIC)).activeTargetChanged(toNotify);
        }
    }

    private static ExecutionTarget getDefaultTarget(List<ExecutionTarget> suitable) {
        ExecutionTarget result2 = (ExecutionTarget)ContainerUtil.find(suitable, ExecutionTarget::isReady);
        return result2 != null ? result2 : DefaultExecutionTarget.INSTANCE;
    }

    @Nullable
    private ExecutionTarget doSetActiveTarget(@NotNull ExecutionTarget newTarget) {
        if (newTarget == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newTarget", "com/intellij/execution/ExecutionTargetManagerImpl", "doSetActiveTarget"));
        }
        this.mySavedActiveTargetId = null;
        ExecutionTarget prev = this.myActiveTarget;
        this.myActiveTarget = newTarget;
        if (prev != null && !prev.equals((Object)this.myActiveTarget)) {
            return this.myActiveTarget;
        }
        return null;
    }

    @NotNull
    public List<ExecutionTarget> getTargetsFor(@Nullable RunnerAndConfigurationSettings settings) {
        if (settings == null) {
            List<ExecutionTarget> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/ExecutionTargetManagerImpl", "getTargetsFor"));
            }
            return list2;
        }
        ArrayList<ExecutionTarget> result2 = new ArrayList<ExecutionTarget>();
        for (ExecutionTargetProvider eachTargetProvider : (ExecutionTargetProvider[])Extensions.getExtensions((ExtensionPointName)ExecutionTargetProvider.EXTENSION_NAME)) {
            for (ExecutionTarget eachTarget : eachTargetProvider.getTargets(this.myProject, settings)) {
                if (!ExecutionTargetManagerImpl.canRun((RunnerAndConfigurationSettings)settings, (ExecutionTarget)eachTarget)) continue;
                result2.add(eachTarget);
            }
        }
        List<ExecutionTarget> list3 = Collections.unmodifiableList(result2);
        if (list3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/ExecutionTargetManagerImpl", "getTargetsFor"));
        }
        return list3;
    }

    public void update() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.updateActiveTarget();
    }
}

