/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.execution.ExecutionBundle;
import com.intellij.ide.structureView.impl.StructureNodeRenderer;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.SortedListModel;
import com.intellij.ui.TreeUIHelper;
import com.intellij.ui.components.JBList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.Comparator;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodListDlg
extends DialogWrapper {
    private final PsiClass myClass;
    private static final Comparator<PsiMethod> METHOD_NAME_COMPARATOR = (psiMethod, psiMethod1) -> psiMethod.getName().compareToIgnoreCase(psiMethod1.getName());
    private final SortedListModel<PsiMethod> myListModel = new SortedListModel(METHOD_NAME_COMPARATOR);
    private final JList myList = new JBList(this.myListModel);
    private final JPanel myWholePanel = new JPanel(new BorderLayout());

    public MethodListDlg(PsiClass psiClass, Condition<PsiMethod> filter, JComponent parent) {
        super((Component)parent, false);
        this.myClass = psiClass;
        this.createList(psiClass.getAllMethods(), filter);
        this.myWholePanel.add(ScrollPaneFactory.createScrollPane((Component)this.myList));
        this.myList.setCellRenderer(new ColoredListCellRenderer(){

            protected void customizeCellRenderer(@NotNull JList list2, Object value2, int index, boolean selected, boolean hasFocus) {
                if (list2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/execution/MethodListDlg$1", "customizeCellRenderer"));
                }
                PsiMethod psiMethod = (PsiMethod)value2;
                this.append(PsiFormatUtil.formatMethod((PsiMethod)psiMethod, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)1, (int)0), StructureNodeRenderer.applyDeprecation(psiMethod, SimpleTextAttributes.REGULAR_ATTRIBUTES));
                PsiClass containingClass = psiMethod.getContainingClass();
                if (!MethodListDlg.this.myClass.equals(containingClass)) {
                    this.append(" (" + containingClass.getQualifiedName() + ")", StructureNodeRenderer.applyDeprecation(containingClass, SimpleTextAttributes.GRAY_ATTRIBUTES));
                }
            }
        });
        this.myList.setSelectionMode(0);
        new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent e) {
                MethodListDlg.this.close(0);
                return true;
            }
        }.installOn((Component)this.myList);
        ScrollingUtil.ensureSelectionExists((JList)this.myList);
        TreeUIHelper.getInstance().installListSpeedSearch(this.myList);
        this.setTitle(ExecutionBundle.message((String)"choose.test.method.dialog.title", (Object[])new Object[0]));
        this.init();
    }

    private void createList(PsiMethod[] allMethods, Condition<PsiMethod> filter) {
        for (int i2 = 0; i2 < allMethods.length; ++i2) {
            PsiMethod method = allMethods[i2];
            if (!filter.value((Object)method)) continue;
            this.myListModel.add((Object)method);
        }
    }

    protected JComponent createCenterPanel() {
        return this.myWholePanel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myList;
    }

    public PsiMethod getSelected() {
        return (PsiMethod)this.myList.getSelectedValue();
    }
}

