/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.execution.BeforeRunTask;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunManagerConfig;
import com.intellij.execution.RunManagerListener;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.impl.RunnerAndConfigurationSettingsImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RunManagerEx
extends RunManager {
    @NotNull
    public static RunManagerEx getInstanceEx(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/RunManagerEx", "getInstanceEx"));
        }
        RunManagerEx runManagerEx = (RunManagerEx)RunManager.getInstance((Project)project2);
        if (runManagerEx == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/RunManagerEx", "getInstanceEx"));
        }
        return runManagerEx;
    }

    @Deprecated
    public final void setActiveConfiguration(@Nullable RunnerAndConfigurationSettings configuration) {
        this.setSelectedConfiguration(configuration);
    }

    @NotNull
    public abstract RunManagerConfig getConfig();

    @Deprecated
    public final void addConfiguration(RunnerAndConfigurationSettings settings, boolean isShared, List<BeforeRunTask> tasks, boolean addTemplateTasksIfAbsent) {
        ((RunnerAndConfigurationSettingsImpl)settings).setShared(isShared);
        this.addConfiguration(settings, tasks, addTemplateTasksIfAbsent);
    }

    @Deprecated
    public void addConfiguration(@NotNull RunnerAndConfigurationSettings settings, @NotNull List<BeforeRunTask> tasks, boolean addTemplateTasksIfAbsent) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/execution/RunManagerEx", "addConfiguration"));
        }
        if (tasks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tasks", "com/intellij/execution/RunManagerEx", "addConfiguration"));
        }
        this.setBeforeRunTasks(settings.getConfiguration(), tasks, addTemplateTasksIfAbsent);
        this.addConfiguration(settings);
    }

    @Deprecated
    public final boolean isConfigurationShared(@NotNull RunnerAndConfigurationSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/execution/RunManagerEx", "isConfigurationShared"));
        }
        return settings.isShared();
    }

    @NotNull
    public abstract List<BeforeRunTask> getBeforeRunTasks(@NotNull RunConfiguration var1);

    public void setBeforeRunTasks(@NotNull RunConfiguration configuration, @NotNull List<BeforeRunTask> tasks) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/execution/RunManagerEx", "setBeforeRunTasks"));
        }
        if (tasks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tasks", "com/intellij/execution/RunManagerEx", "setBeforeRunTasks"));
        }
        this.setBeforeRunTasks(configuration, tasks, false);
    }

    public abstract void setBeforeRunTasks(@NotNull RunConfiguration var1, @NotNull List<BeforeRunTask> var2, boolean var3);

    @NotNull
    public abstract <T extends BeforeRunTask> List<T> getBeforeRunTasks(@NotNull RunConfiguration var1, Key<T> var2);

    @NotNull
    public abstract <T extends BeforeRunTask> List<T> getBeforeRunTasks(Key<T> var1);

    public Icon getConfigurationIcon(@NotNull RunnerAndConfigurationSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/execution/RunManagerEx", "getConfigurationIcon"));
        }
        return this.getConfigurationIcon(settings, false);
    }

    public abstract Icon getConfigurationIcon(@NotNull RunnerAndConfigurationSettings var1, boolean var2);

    @Deprecated
    @NotNull
    public final Collection<RunnerAndConfigurationSettings> getSortedConfigurations() {
        List list2 = this.getAllSettings();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/RunManagerEx", "getSortedConfigurations"));
        }
        return list2;
    }

    @Deprecated
    public void addRunManagerListener(@NotNull RunManagerListener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/execution/RunManagerEx", "addRunManagerListener"));
        }
    }

    @NotNull
    public abstract Map<String, List<RunnerAndConfigurationSettings>> getStructure(@NotNull ConfigurationType var1);

    @SafeVarargs
    public static void disableTasks(Project project2, RunConfiguration settings, Key<? extends BeforeRunTask> ... keys) {
        if (keys == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keys", "com/intellij/execution/RunManagerEx", "disableTasks"));
        }
        for (Key<? extends BeforeRunTask> key2 : keys) {
            List<? extends BeforeRunTask> tasks = RunManagerEx.getInstanceEx(project2).getBeforeRunTasks(settings, key2);
            for (BeforeRunTask beforeRunTask : tasks) {
                beforeRunTask.setEnabled(false);
            }
        }
    }

    @SafeVarargs
    public static int getTasksCount(Project project2, RunConfiguration settings, Key<? extends BeforeRunTask> ... keys) {
        if (keys == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keys", "com/intellij/execution/RunManagerEx", "getTasksCount"));
        }
        return Arrays.stream(keys).mapToInt(key2 -> RunManagerEx.getInstanceEx(project2).getBeforeRunTasks(settings, (Key)key2).size()).sum();
    }
}

