/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.actions;

import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.ExecutionTargetManager;
import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.Location;
import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunManagerEx;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.RunnerRegistry;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.actions.ExecutorProvider;
import com.intellij.execution.actions.PreferredProducerFind;
import com.intellij.execution.actions.RunConfigurationsComboBoxAction;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.impl.EditConfigurationsDialog;
import com.intellij.execution.impl.RunDialog;
import com.intellij.execution.impl.RunnerAndConfigurationSettingsImpl;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.ui.popup.WizardPopup;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.ui.popup.list.PopupListElementRenderer;
import com.intellij.ui.speedSearch.SpeedSearch;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChooseRunConfigurationPopup
implements ExecutorProvider {
    private final Project myProject;
    @NotNull
    private final String myAddKey;
    @NotNull
    private final Executor myDefaultExecutor;
    @Nullable
    private final Executor myAlternativeExecutor;
    private Executor myCurrentExecutor;
    private boolean myEditConfiguration;
    private final RunListPopup myPopup;

    public ChooseRunConfigurationPopup(@NotNull Project project2, @NotNull String addKey, @NotNull Executor defaultExecutor, @Nullable Executor alternativeExecutor) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/actions/ChooseRunConfigurationPopup", "<init>"));
        }
        if (addKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "addKey", "com/intellij/execution/actions/ChooseRunConfigurationPopup", "<init>"));
        }
        if (defaultExecutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultExecutor", "com/intellij/execution/actions/ChooseRunConfigurationPopup", "<init>"));
        }
        this.myProject = project2;
        this.myAddKey = addKey;
        this.myDefaultExecutor = defaultExecutor;
        this.myAlternativeExecutor = alternativeExecutor;
        this.myPopup = new RunListPopup((ListPopupStep)new ConfigurationListPopupStep(this, this.myProject, this, this.myDefaultExecutor.getActionName()));
    }

    public void show() {
        String adText = this.getAdText(this.myAlternativeExecutor);
        if (adText != null) {
            this.myPopup.setAdText(adText);
        }
        this.myPopup.showCenteredInCurrentWindow(this.myProject);
    }

    protected static boolean canRun(@NotNull Executor executor, RunnerAndConfigurationSettings settings) {
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/intellij/execution/actions/ChooseRunConfigurationPopup", "canRun"));
        }
        return ProgramRunnerUtil.getRunner(executor.getId(), settings) != null;
    }

    @Nullable
    protected String getAdText(Executor alternateExecutor) {
        PropertiesComponent properties = PropertiesComponent.getInstance();
        if (alternateExecutor != null && !properties.isTrueValue(this.myAddKey)) {
            return String.format("Hold %s to %s", KeymapUtil.getKeystrokeText((KeyStroke)KeyStroke.getKeyStroke("SHIFT")), alternateExecutor.getActionName());
        }
        if (!properties.isTrueValue("run.configuration.edit.ad")) {
            return String.format("Press %s to Edit", KeymapUtil.getKeystrokeText((KeyStroke)KeyStroke.getKeyStroke("F4")));
        }
        if (!properties.isTrueValue("run.configuration.delete.ad")) {
            return String.format("Press %s to Delete configuration", KeymapUtil.getKeystrokeText((KeyStroke)KeyStroke.getKeyStroke("DELETE")));
        }
        return null;
    }

    private void registerActions(final RunListPopup popup) {
        popup.registerAction("alternateExecutor", KeyStroke.getKeyStroke("shift pressed SHIFT"), new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChooseRunConfigurationPopup.this.myCurrentExecutor = ChooseRunConfigurationPopup.this.myAlternativeExecutor;
                ChooseRunConfigurationPopup.this.updatePresentation();
            }
        });
        popup.registerAction("restoreDefaultExecutor", KeyStroke.getKeyStroke("released SHIFT"), new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChooseRunConfigurationPopup.this.myCurrentExecutor = ChooseRunConfigurationPopup.this.myDefaultExecutor;
                ChooseRunConfigurationPopup.this.updatePresentation();
            }
        });
        popup.registerAction("invokeAction", KeyStroke.getKeyStroke("shift ENTER"), new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                popup.handleSelect(true);
            }
        });
        popup.registerAction("editConfiguration", KeyStroke.getKeyStroke("F4"), new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChooseRunConfigurationPopup.this.myEditConfiguration = true;
                popup.handleSelect(true);
            }
        });
        popup.registerAction("deleteConfiguration", KeyStroke.getKeyStroke("DELETE"), new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                popup.removeSelected();
            }
        });
        popup.registerAction("deleteConfiguration_bksp", KeyStroke.getKeyStroke("BACK_SPACE"), new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SpeedSearch speedSearch = popup.getSpeedSearch();
                if (speedSearch.isHoldingFilter()) {
                    speedSearch.backspace();
                    speedSearch.update();
                } else {
                    popup.removeSelected();
                }
            }
        });
        for (int i2 = 0; i2 < 10; ++i2) {
            this.addNumberAction(popup, i2);
        }
    }

    private void addNumberAction(RunListPopup popup, int number) {
        Action action = ChooseRunConfigurationPopup.createNumberAction(number, popup, this.myDefaultExecutor);
        Action action_ = ChooseRunConfigurationPopup.createNumberAction(number, popup, this.myAlternativeExecutor);
        popup.registerAction(number + "Action", KeyStroke.getKeyStroke(String.valueOf(number)), action);
        popup.registerAction(number + "Action_", KeyStroke.getKeyStroke("shift pressed " + number), action_);
        popup.registerAction(number + "Action1", KeyStroke.getKeyStroke("NUMPAD" + number), action);
        popup.registerAction(number + "Action_1", KeyStroke.getKeyStroke("shift pressed NUMPAD" + number), action_);
    }

    private void updatePresentation() {
        this.myPopup.setCaption(this.getExecutor().getActionName());
    }

    static void execute(ItemWrapper itemWrapper, Executor executor) {
        if (executor == null) {
            return;
        }
        DataContext dataContext = DataManager.getInstance().getDataContext();
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project2 != null) {
            itemWrapper.perform(project2, executor, dataContext);
        }
    }

    void editConfiguration(@NotNull Project project2, @NotNull RunnerAndConfigurationSettings configuration) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/actions/ChooseRunConfigurationPopup", "editConfiguration"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/execution/actions/ChooseRunConfigurationPopup", "editConfiguration"));
        }
        Executor executor = this.getExecutor();
        PropertiesComponent.getInstance().setValue("run.configuration.edit.ad", Boolean.toString(true));
        if (RunDialog.editConfiguration(project2, configuration, "Edit configuration settings", executor)) {
            RunManager.getInstance((Project)project2).setSelectedConfiguration(configuration);
            ExecutionUtil.runConfiguration((RunnerAndConfigurationSettings)configuration, (Executor)executor);
        }
    }

    private static void deleteConfiguration(Project project2, @NotNull RunnerAndConfigurationSettings configurationSettings) {
        if (configurationSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurationSettings", "com/intellij/execution/actions/ChooseRunConfigurationPopup", "deleteConfiguration"));
        }
        RunManager.getInstance((Project)project2).removeConfiguration(configurationSettings);
    }

    @Override
    @NotNull
    public Executor getExecutor() {
        Executor executor = this.myCurrentExecutor == null ? this.myDefaultExecutor : this.myCurrentExecutor;
        if (executor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/actions/ChooseRunConfigurationPopup", "getExecutor"));
        }
        return executor;
    }

    private static Action createNumberAction(int number, ListPopupImpl listPopup, Executor executor) {
        return new MyAbstractAction(listPopup, number, executor);
    }

    public static ItemWrapper[] createSettingsList(@NotNull Project project2, @NotNull ExecutorProvider executorProvider, boolean createEditAction) {
        RunnerAndConfigurationSettings selectedConfiguration;
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/actions/ChooseRunConfigurationPopup", "createSettingsList"));
        }
        if (executorProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executorProvider", "com/intellij/execution/actions/ChooseRunConfigurationPopup", "createSettingsList"));
        }
        ArrayList<ItemWrapper> result2 = new ArrayList<ItemWrapper>();
        if (createEditAction) {
            ItemWrapper<Void> edit2 = new ItemWrapper<Void>(null){

                @Override
                public Icon getIcon() {
                    return AllIcons.Actions.EditSource;
                }

                @Override
                public String getText() {
                    return UIUtil.removeMnemonic((String)ActionsBundle.message((String)"action.editRunConfigurations.text", (Object[])new Object[0]));
                }

                @Override
                public void perform(@NotNull Project project2, final @NotNull Executor executor, @NotNull DataContext context) {
                    if (project2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/actions/ChooseRunConfigurationPopup$7", "perform"));
                    }
                    if (executor == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/intellij/execution/actions/ChooseRunConfigurationPopup$7", "perform"));
                    }
                    if (context == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/execution/actions/ChooseRunConfigurationPopup$7", "perform"));
                    }
                    if (new EditConfigurationsDialog(project2){

                        protected void init() {
                            this.setOKButtonText(executor.getStartActionText());
                            this.setOKButtonIcon(executor.getIcon());
                            this.myExecutor = executor;
                            super.init();
                        }
                    }.showAndGet()) {
                        ApplicationManager.getApplication().invokeLater(() -> {
                            if (project2 == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/actions/ChooseRunConfigurationPopup$7", "lambda$perform$0"));
                            }
                            if (executor == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/intellij/execution/actions/ChooseRunConfigurationPopup$7", "lambda$perform$0"));
                            }
                            RunnerAndConfigurationSettings configuration = RunManager.getInstance((Project)project2).getSelectedConfiguration();
                            if (configuration != null) {
                                ExecutionUtil.runConfiguration((RunnerAndConfigurationSettings)configuration, (Executor)executor);
                            }
                        }, project2.getDisposed());
                    }
                }

                @Override
                public boolean available(Executor executor) {
                    return true;
                }
            };
            edit2.setMnemonic(0);
            result2.add(edit2);
        }
        if ((selectedConfiguration = RunManager.getInstance((Project)project2).getSelectedConfiguration()) != null) {
            boolean isFirst = true;
            final ExecutionTarget activeTarget = ExecutionTargetManager.getActiveTarget((Project)project2);
            for (ExecutionTarget eachTarget : ExecutionTargetManager.getTargetsToChooseFor((Project)project2, (RunnerAndConfigurationSettings)selectedConfiguration)) {
                result2.add(new ItemWrapper<ExecutionTarget>(eachTarget, isFirst){
                    {
                        super(value2, addSeparatorAbove);
                        this.setChecked(((ExecutionTarget)this.getValue()).equals((Object)activeTarget));
                    }

                    @Override
                    public Icon getIcon() {
                        return ((ExecutionTarget)this.getValue()).getIcon();
                    }

                    @Override
                    public String getText() {
                        return ((ExecutionTarget)this.getValue()).getDisplayName();
                    }

                    @Override
                    public void perform(@NotNull Project project2, @NotNull Executor executor, @NotNull DataContext context) {
                        if (project2 == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/actions/ChooseRunConfigurationPopup$8", "perform"));
                        }
                        if (executor == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/intellij/execution/actions/ChooseRunConfigurationPopup$8", "perform"));
                        }
                        if (context == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/execution/actions/ChooseRunConfigurationPopup$8", "perform"));
                        }
                        ExecutionTargetManager.setActiveTarget((Project)project2, (ExecutionTarget)((ExecutionTarget)this.getValue()));
                        ExecutionUtil.runConfiguration((RunnerAndConfigurationSettings)selectedConfiguration, (Executor)executor);
                    }

                    @Override
                    public boolean available(Executor executor) {
                        return true;
                    }
                });
                isFirst = false;
            }
        }
        LinkedHashMap<RunnerAndConfigurationSettings, ItemWrapper> wrappedExisting = new LinkedHashMap<RunnerAndConfigurationSettings, ItemWrapper>();
        RunManagerEx runManager = RunManagerEx.getInstanceEx(project2);
        for (ConfigurationType type2 : runManager.getConfigurationFactoriesWithoutUnknown()) {
            Map<String, List<RunnerAndConfigurationSettings>> structure = runManager.getStructure(type2);
            for (Map.Entry<String, List<RunnerAndConfigurationSettings>> entry : structure.entrySet()) {
                if (entry.getValue().isEmpty()) continue;
                String key2 = entry.getKey();
                if (key2 != null) {
                    boolean isSelected = entry.getValue().contains(selectedConfiguration);
                    if (isSelected) assert (selectedConfiguration != null);
                    FolderWrapper folderWrapper = new FolderWrapper(project2, executorProvider, key2 + (isSelected ? "  (mnemonic is to \"" + selectedConfiguration.getName() + "\")" : ""), entry.getValue());
                    if (isSelected) {
                        folderWrapper.setMnemonic(1);
                    }
                    result2.add(folderWrapper);
                    continue;
                }
                for (RunnerAndConfigurationSettings configuration : entry.getValue()) {
                    ItemWrapper wrapped = ItemWrapper.wrap(project2, configuration);
                    if (configuration == selectedConfiguration) {
                        wrapped.setMnemonic(1);
                    }
                    wrappedExisting.put(configuration, wrapped);
                }
            }
        }
        if (!DumbService.isDumb((Project)project2)) {
            ChooseRunConfigurationPopup.populateWithDynamicRunners(result2, wrappedExisting, project2, RunManagerEx.getInstanceEx(project2), selectedConfiguration);
        }
        result2.addAll(wrappedExisting.values());
        return result2.toArray(new ItemWrapper[result2.size()]);
    }

    @NotNull
    private static List<RunnerAndConfigurationSettings> populateWithDynamicRunners(List<ItemWrapper> result2, Map<RunnerAndConfigurationSettings, ItemWrapper> existing, final Project project2, final RunManager manager, RunnerAndConfigurationSettings selectedConfiguration) {
        ArrayList<RunnerAndConfigurationSettings> contextConfigurations = new ArrayList<RunnerAndConfigurationSettings>();
        if (!EventQueue.isDispatchThread()) {
            List<RunnerAndConfigurationSettings> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/actions/ChooseRunConfigurationPopup", "populateWithDynamicRunners"));
            }
            return list2;
        }
        DataContext dataContext = DataManager.getInstance().getDataContext();
        ConfigurationContext context = ConfigurationContext.getFromContext((DataContext)dataContext);
        List producers = PreferredProducerFind.getConfigurationsFromContext((Location)context.getLocation(), (ConfigurationContext)context, (boolean)false);
        if (producers == null) {
            List<RunnerAndConfigurationSettings> list3 = Collections.emptyList();
            if (list3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/actions/ChooseRunConfigurationPopup", "populateWithDynamicRunners"));
            }
            return list3;
        }
        Collections.sort(producers, ConfigurationFromContext.NAME_COMPARATOR);
        RunnerAndConfigurationSettings[] preferred = new RunnerAndConfigurationSettings[]{null};
        int i2 = 2;
        for (ConfigurationFromContext fromContext : producers) {
            ItemWrapper wrapper;
            final RunnerAndConfigurationSettings configuration = fromContext.getConfigurationSettings();
            if (existing.keySet().contains(configuration)) {
                wrapper = existing.get(configuration);
                if (wrapper.getMnemonic() == 1) continue;
                wrapper.setMnemonic(i2);
                ++i2;
                continue;
            }
            if (selectedConfiguration != null && configuration.equals(selectedConfiguration)) continue;
            contextConfigurations.add(configuration);
            if (preferred[0] == null) {
                preferred[0] = configuration;
            }
            wrapper = new ItemWrapper(configuration){

                @Override
                public Icon getIcon() {
                    return RunManagerEx.getInstanceEx(project2).getConfigurationIcon(configuration);
                }

                @Override
                public String getText() {
                    return configuration.getName();
                }

                @Override
                public boolean available(Executor executor) {
                    return ChooseRunConfigurationPopup.canRun(executor, configuration);
                }

                @Override
                public void perform(@NotNull Project project22, @NotNull Executor executor, @NotNull DataContext context) {
                    if (project22 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/actions/ChooseRunConfigurationPopup$9", "perform"));
                    }
                    if (executor == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/intellij/execution/actions/ChooseRunConfigurationPopup$9", "perform"));
                    }
                    if (context == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/execution/actions/ChooseRunConfigurationPopup$9", "perform"));
                    }
                    manager.setTemporaryConfiguration(configuration);
                    RunManager.getInstance((Project)project22).setSelectedConfiguration(configuration);
                    ExecutionUtil.runConfiguration((RunnerAndConfigurationSettings)configuration, (Executor)executor);
                }

                @Override
                public PopupStep getNextStep(@NotNull Project project22, @NotNull ChooseRunConfigurationPopup action) {
                    if (project22 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/actions/ChooseRunConfigurationPopup$9", "getNextStep"));
                    }
                    if (action == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/execution/actions/ChooseRunConfigurationPopup$9", "getNextStep"));
                    }
                    return new ConfigurationActionsStep(project22, action, configuration, this.isDynamic());
                }

                @Override
                public boolean hasActions() {
                    return true;
                }
            };
            wrapper.setDynamic(true);
            wrapper.setMnemonic(i2);
            result2.add(wrapper);
            ++i2;
        }
        ArrayList<RunnerAndConfigurationSettings> arrayList = contextConfigurations;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/actions/ChooseRunConfigurationPopup", "populateWithDynamicRunners"));
        }
        return arrayList;
    }

    private static final class FolderStep
    extends BaseListPopupStep<ConfigurationActionsStep> {
        private final Project myProject;
        private final ChooseRunConfigurationPopup myPopup;
        private final ExecutorProvider myExecutorProvider;

        private FolderStep(Project project2, ExecutorProvider executorProvider, String folderName, List<ConfigurationActionsStep> children2, ChooseRunConfigurationPopup popup) {
            super(folderName, children2, new ArrayList());
            this.myProject = project2;
            this.myExecutorProvider = executorProvider;
            this.myPopup = popup;
        }

        public PopupStep onChosen(ConfigurationActionsStep selectedValue, boolean finalChoice) {
            if (finalChoice) {
                if (this.myPopup.myEditConfiguration) {
                    RunnerAndConfigurationSettings settings = selectedValue.getSettings();
                    return this.doFinalStep(() -> this.myPopup.editConfiguration(this.myProject, settings));
                }
                return this.doFinalStep(() -> {
                    RunnerAndConfigurationSettings settings = selectedValue.getSettings();
                    RunManager.getInstance((Project)this.myProject).setSelectedConfiguration(settings);
                    ExecutionUtil.runConfiguration((RunnerAndConfigurationSettings)settings, (Executor)this.myExecutorProvider.getExecutor());
                });
            }
            return selectedValue;
        }

        public Icon getIconFor(ConfigurationActionsStep aValue) {
            return aValue.getIcon();
        }

        @NotNull
        public String getTextFor(ConfigurationActionsStep value2) {
            String string = value2.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/actions/ChooseRunConfigurationPopup$FolderStep", "getTextFor"));
            }
            return string;
        }

        public boolean hasSubstep(ConfigurationActionsStep selectedValue) {
            return !selectedValue.getValues().isEmpty();
        }
    }

    private static class FolderWrapper
    extends ItemWrapper<String> {
        private final Project myProject;
        private final ExecutorProvider myExecutorProvider;
        private final List<RunnerAndConfigurationSettings> myConfigurations;

        private FolderWrapper(Project project2, ExecutorProvider executorProvider, @Nullable String value2, List<RunnerAndConfigurationSettings> configurations) {
            super(value2);
            this.myProject = project2;
            this.myExecutorProvider = executorProvider;
            this.myConfigurations = configurations;
        }

        @Override
        public void perform(@NotNull Project project2, @NotNull Executor executor, @NotNull DataContext context) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/actions/ChooseRunConfigurationPopup$FolderWrapper", "perform"));
            }
            if (executor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/intellij/execution/actions/ChooseRunConfigurationPopup$FolderWrapper", "perform"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/execution/actions/ChooseRunConfigurationPopup$FolderWrapper", "perform"));
            }
            RunManager runManager = RunManager.getInstance((Project)project2);
            RunnerAndConfigurationSettings selectedConfiguration = runManager.getSelectedConfiguration();
            if (this.myConfigurations.contains(selectedConfiguration)) {
                runManager.setSelectedConfiguration(selectedConfiguration);
                ExecutionUtil.runConfiguration((RunnerAndConfigurationSettings)selectedConfiguration, (Executor)this.myExecutorProvider.getExecutor());
            }
        }

        @Override
        @Nullable
        public Icon getIcon() {
            return AllIcons.Nodes.Folder;
        }

        @Override
        public String getText() {
            return (String)this.getValue();
        }

        @Override
        public boolean hasActions() {
            return true;
        }

        @Override
        public PopupStep getNextStep(Project project2, ChooseRunConfigurationPopup action) {
            ArrayList<ConfigurationActionsStep> steps = new ArrayList<ConfigurationActionsStep>();
            for (RunnerAndConfigurationSettings settings : this.myConfigurations) {
                steps.add(new ConfigurationActionsStep(project2, action, settings, false));
            }
            return new FolderStep(this.myProject, this.myExecutorProvider, null, steps, action);
        }
    }

    private class RunListPopup
    extends ListPopupImpl {
        public RunListPopup(ListPopupStep step) {
            super(step);
            ChooseRunConfigurationPopup.this.registerActions(this);
        }

        protected RunListPopup(WizardPopup aParent, ListPopupStep aStep, Object parentValue) {
            super(aParent, aStep, parentValue);
            ChooseRunConfigurationPopup.this.registerActions(this);
        }

        @Override
        protected WizardPopup createPopup(WizardPopup parent, PopupStep step, Object parentValue) {
            return new RunListPopup(parent, (ListPopupStep)step, parentValue);
        }

        @Override
        public void handleSelect(boolean handleFinalChoices, InputEvent e) {
            if (e instanceof MouseEvent && e.isShiftDown()) {
                this.handleShiftClick(handleFinalChoices, e, this);
                return;
            }
            this._handleSelect(handleFinalChoices, e);
        }

        private void _handleSelect(boolean handleFinalChoices, InputEvent e) {
            super.handleSelect(handleFinalChoices, e);
        }

        protected void handleShiftClick(boolean handleFinalChoices, InputEvent inputEvent, RunListPopup popup) {
            ChooseRunConfigurationPopup.this.myCurrentExecutor = ChooseRunConfigurationPopup.this.myAlternativeExecutor;
            popup._handleSelect(handleFinalChoices, inputEvent);
        }

        @Override
        protected ListCellRenderer getListElementRenderer() {
            boolean hasSideBar = false;
            for (Object each : this.getListStep().getValues()) {
                if (!(each instanceof Wrapper) || ((Wrapper)each).getMnemonic() == -1) continue;
                hasSideBar = true;
                break;
            }
            return new RunListElementRenderer(this, hasSideBar);
        }

        public void removeSelected() {
            int index;
            PropertiesComponent propertiesComponent = PropertiesComponent.getInstance();
            if (!propertiesComponent.isTrueValue("run.configuration.delete.ad")) {
                propertiesComponent.setValue("run.configuration.delete.ad", Boolean.toString(true));
            }
            if ((index = this.getSelectedIndex()) == -1) {
                return;
            }
            Object o = this.getListModel().get(index);
            if (o != null && o instanceof ItemWrapper && ((ItemWrapper)o).canBeDeleted()) {
                ChooseRunConfigurationPopup.deleteConfiguration(ChooseRunConfigurationPopup.this.myProject, (RunnerAndConfigurationSettings)((ItemWrapper)o).getValue());
                this.getListModel().deleteItem(o);
                List values = this.getListStep().getValues();
                values.remove(o);
                if (index < values.size()) {
                    this.onChildSelectedFor(values.get(index));
                } else if (index - 1 >= 0) {
                    this.onChildSelectedFor(values.get(index - 1));
                }
            }
        }
    }

    private static class MyAbstractAction
    extends AbstractAction
    implements DumbAware {
        private final ListPopupImpl myListPopup;
        private final int myNumber;
        private final Executor myExecutor;

        public MyAbstractAction(ListPopupImpl listPopup, int number, Executor executor) {
            this.myListPopup = listPopup;
            this.myNumber = number;
            this.myExecutor = executor;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.myListPopup.getSpeedSearch().isHoldingFilter()) {
                return;
            }
            for (Object item : this.myListPopup.getListStep().getValues()) {
                if (!(item instanceof ItemWrapper) || ((ItemWrapper)item).getMnemonic() != this.myNumber) continue;
                this.myListPopup.setFinalRunnable(() -> ChooseRunConfigurationPopup.execute((ItemWrapper)item, this.myExecutor));
                this.myListPopup.closeOk(null);
            }
        }
    }

    private static class RunListElementRenderer
    extends PopupListElementRenderer {
        private JLabel myLabel;
        private final ListPopupImpl myPopup1;
        private final boolean myHasSideBar;

        private RunListElementRenderer(ListPopupImpl popup, boolean hasSideBar) {
            super(popup);
            this.myPopup1 = popup;
            this.myHasSideBar = hasSideBar;
        }

        @Override
        protected JComponent createItemComponent() {
            if (this.myLabel == null) {
                this.myLabel = new JLabel();
                this.myLabel.setPreferredSize(new JLabel("8.").getPreferredSize());
            }
            JComponent result2 = super.createItemComponent();
            result2.add((Component)this.myLabel, "West");
            return result2;
        }

        @Override
        protected void customizeComponent(JList list2, Object value2, boolean isSelected) {
            super.customizeComponent(list2, value2, isSelected);
            this.myLabel.setVisible(this.myHasSideBar);
            ListPopupStep<Object> step = this.myPopup1.getListStep();
            boolean isSelectable = step.isSelectable(value2);
            this.myLabel.setEnabled(isSelectable);
            this.myLabel.setIcon(null);
            if (isSelected) {
                this.setSelected(this.myLabel);
            } else {
                this.setDeselected(this.myLabel);
            }
            if (value2 instanceof Wrapper) {
                Wrapper wrapper = (Wrapper)value2;
                int mnemonic = wrapper.getMnemonic();
                if (mnemonic != -1 && !this.myPopup1.getSpeedSearch().isHoldingFilter()) {
                    this.myLabel.setText(mnemonic + ".");
                    this.myLabel.setDisplayedMnemonicIndex(0);
                } else {
                    if (wrapper.isChecked()) {
                        this.myTextLabel.setIcon(isSelected ? RunConfigurationsComboBoxAction.CHECKED_SELECTED_ICON : RunConfigurationsComboBoxAction.CHECKED_ICON);
                    } else if (this.myTextLabel.getIcon() == null) {
                        this.myTextLabel.setIcon(RunConfigurationsComboBoxAction.EMPTY_ICON);
                    }
                    this.myLabel.setText("");
                }
            }
        }
    }

    private static abstract class ActionWrapper
    extends Wrapper {
        private final String myName;
        private final Icon myIcon;

        private ActionWrapper(String name2, Icon icon) {
            this(name2, icon, false);
        }

        private ActionWrapper(String name2, Icon icon, boolean addSeparatorAbove) {
            super(addSeparatorAbove);
            this.myName = name2;
            this.myIcon = icon;
        }

        public abstract void perform();

        @Override
        public String getText() {
            return this.myName;
        }

        @Override
        public Icon getIcon() {
            return this.myIcon;
        }
    }

    private static final class ConfigurationActionsStep
    extends BaseListPopupStep<ActionWrapper> {
        @NotNull
        private final RunnerAndConfigurationSettings mySettings;
        @NotNull
        private final Project myProject;

        private ConfigurationActionsStep(@NotNull Project project2, ChooseRunConfigurationPopup action, @NotNull RunnerAndConfigurationSettings settings, boolean dynamic) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/actions/ChooseRunConfigurationPopup$ConfigurationActionsStep", "<init>"));
            }
            if (settings == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/execution/actions/ChooseRunConfigurationPopup$ConfigurationActionsStep", "<init>"));
            }
            super(null, (Object[])ConfigurationActionsStep.buildActions(project2, action, settings, dynamic));
            this.myProject = project2;
            this.mySettings = settings;
        }

        @NotNull
        public RunnerAndConfigurationSettings getSettings() {
            RunnerAndConfigurationSettings runnerAndConfigurationSettings = this.mySettings;
            if (runnerAndConfigurationSettings == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/actions/ChooseRunConfigurationPopup$ConfigurationActionsStep", "getSettings"));
            }
            return runnerAndConfigurationSettings;
        }

        public String getName() {
            return this.mySettings.getName();
        }

        public Icon getIcon() {
            return RunManagerEx.getInstanceEx(this.myProject).getConfigurationIcon(this.mySettings);
        }

        public ListSeparator getSeparatorAbove(ActionWrapper value2) {
            return value2.addSeparatorAbove() ? new ListSeparator() : null;
        }

        private static ActionWrapper[] buildActions(final @NotNull Project project2, final ChooseRunConfigurationPopup action, final @NotNull RunnerAndConfigurationSettings settings, final boolean dynamic) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/actions/ChooseRunConfigurationPopup$ConfigurationActionsStep", "buildActions"));
            }
            if (settings == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/execution/actions/ChooseRunConfigurationPopup$ConfigurationActionsStep", "buildActions"));
            }
            ArrayList<ActionWrapper> result2 = new ArrayList<ActionWrapper>();
            final ExecutionTarget active = ExecutionTargetManager.getActiveTarget((Project)project2);
            for (final ExecutionTarget eachTarget : ExecutionTargetManager.getTargetsToChooseFor((Project)project2, (RunnerAndConfigurationSettings)settings)) {
                result2.add(new ActionWrapper(eachTarget.getDisplayName(), eachTarget.getIcon()){
                    {
                        super(name2, icon);
                        this.setChecked(eachTarget.equals((Object)active));
                    }

                    @Override
                    public void perform() {
                        RunManager manager = RunManager.getInstance((Project)project2);
                        if (dynamic) {
                            manager.setTemporaryConfiguration(settings);
                        }
                        manager.setSelectedConfiguration(settings);
                        ExecutionTargetManager.setActiveTarget((Project)project2, (ExecutionTarget)eachTarget);
                        ExecutionUtil.runConfiguration((RunnerAndConfigurationSettings)settings, (Executor)action.getExecutor());
                    }
                });
            }
            boolean isFirst = true;
            for (final Executor executor : ExecutorRegistry.getInstance().getRegisteredExecutors()) {
                ProgramRunner runner = RunnerRegistry.getInstance().getRunner(executor.getId(), (RunProfile)settings.getConfiguration());
                if (runner == null) continue;
                result2.add(new ActionWrapper(executor.getActionName(), executor.getIcon(), isFirst){

                    @Override
                    public void perform() {
                        RunManager manager = RunManager.getInstance((Project)project2);
                        if (dynamic) {
                            manager.setTemporaryConfiguration(settings);
                        }
                        manager.setSelectedConfiguration(settings);
                        ExecutionUtil.runConfiguration((RunnerAndConfigurationSettings)settings, (Executor)executor);
                    }
                });
                isFirst = false;
            }
            result2.add(new ActionWrapper("Edit...", AllIcons.Actions.EditSource, true){

                @Override
                public void perform() {
                    if (dynamic) {
                        RunManager.getInstance((Project)project2).setTemporaryConfiguration(settings);
                    }
                    action.editConfiguration(project2, settings);
                }
            });
            if (settings.isTemporary() || dynamic) {
                result2.add(new ActionWrapper("Save configuration", AllIcons.Actions.Menu_saveall){

                    @Override
                    public void perform() {
                        RunManager manager = RunManager.getInstance((Project)project2);
                        if (dynamic) {
                            manager.setTemporaryConfiguration(settings);
                        }
                        manager.makeStable(settings);
                    }
                });
            }
            return result2.toArray(new ActionWrapper[result2.size()]);
        }

        public PopupStep onChosen(ActionWrapper selectedValue, boolean finalChoice) {
            return this.doFinalStep(() -> selectedValue.perform());
        }

        public Icon getIconFor(ActionWrapper aValue) {
            return aValue.getIcon();
        }

        @NotNull
        public String getTextFor(ActionWrapper value2) {
            String string = value2.getText();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/actions/ChooseRunConfigurationPopup$ConfigurationActionsStep", "getTextFor"));
            }
            return string;
        }
    }

    private static final class ConfigurationListPopupStep
    extends BaseListPopupStep<ItemWrapper> {
        private final Project myProject;
        private final ChooseRunConfigurationPopup myAction;
        private int myDefaultConfiguration;

        private ConfigurationListPopupStep(@NotNull ChooseRunConfigurationPopup action, @NotNull Project project2, @NotNull ExecutorProvider executorProvider, @NotNull String title) {
            if (action == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/execution/actions/ChooseRunConfigurationPopup$ConfigurationListPopupStep", "<init>"));
            }
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/actions/ChooseRunConfigurationPopup$ConfigurationListPopupStep", "<init>"));
            }
            if (executorProvider == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executorProvider", "com/intellij/execution/actions/ChooseRunConfigurationPopup$ConfigurationListPopupStep", "<init>"));
            }
            if (title == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/execution/actions/ChooseRunConfigurationPopup$ConfigurationListPopupStep", "<init>"));
            }
            super(title, (Object[])ChooseRunConfigurationPopup.createSettingsList(project2, executorProvider, true));
            this.myDefaultConfiguration = -1;
            this.myProject = project2;
            this.myAction = action;
            if (-1 == this.getDefaultOptionIndex()) {
                this.myDefaultConfiguration = this.getDynamicIndex();
            }
        }

        private int getDynamicIndex() {
            int i2 = 0;
            for (ItemWrapper wrapper : this.getValues()) {
                if (wrapper.isDynamic()) {
                    return i2;
                }
                ++i2;
            }
            return -1;
        }

        public boolean isAutoSelectionEnabled() {
            return false;
        }

        public ListSeparator getSeparatorAbove(ItemWrapper value2) {
            if (value2.addSeparatorAbove()) {
                return new ListSeparator();
            }
            List configurations = this.getValues();
            int index = configurations.indexOf(value2);
            if (index > 0 && index <= configurations.size() - 1) {
                ConfigurationType aboveType;
                ItemWrapper aboveConfiguration = (ItemWrapper)configurations.get(index - 1);
                if (aboveConfiguration != null && aboveConfiguration.isDynamic() != value2.isDynamic()) {
                    return new ListSeparator();
                }
                ConfigurationType currentType = value2.getType();
                ConfigurationType configurationType = aboveType = aboveConfiguration == null ? null : aboveConfiguration.getType();
                if (aboveType != currentType && currentType != null) {
                    return new ListSeparator();
                }
            }
            return null;
        }

        public boolean isSpeedSearchEnabled() {
            return true;
        }

        public int getDefaultOptionIndex() {
            RunnerAndConfigurationSettings currentConfiguration = RunManager.getInstance((Project)this.myProject).getSelectedConfiguration();
            if (currentConfiguration == null && this.myDefaultConfiguration != -1) {
                return this.myDefaultConfiguration;
            }
            return currentConfiguration instanceof RunnerAndConfigurationSettingsImpl ? this.getValues().indexOf(ItemWrapper.wrap(this.myProject, currentConfiguration)) : -1;
        }

        public PopupStep onChosen(ItemWrapper wrapper, boolean finalChoice) {
            Object o;
            if (this.myAction.myEditConfiguration && (o = wrapper.getValue()) instanceof RunnerAndConfigurationSettingsImpl) {
                return this.doFinalStep(() -> this.myAction.editConfiguration(this.myProject, (RunnerAndConfigurationSettings)o));
            }
            if (finalChoice && wrapper.available(this.myAction.getExecutor())) {
                return this.doFinalStep(() -> {
                    if (this.myAction.getExecutor() == this.myAction.myAlternativeExecutor) {
                        PropertiesComponent.getInstance().setValue(this.myAction.myAddKey, Boolean.toString(true));
                    }
                    wrapper.perform(this.myProject, this.myAction.getExecutor(), DataManager.getInstance().getDataContext());
                });
            }
            return wrapper.getNextStep(this.myProject, this.myAction);
        }

        public boolean hasSubstep(ItemWrapper selectedValue) {
            return selectedValue.hasActions();
        }

        @NotNull
        public String getTextFor(ItemWrapper value2) {
            String string = value2.getText();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/actions/ChooseRunConfigurationPopup$ConfigurationListPopupStep", "getTextFor"));
            }
            return string;
        }

        public Icon getIconFor(ItemWrapper value2) {
            return value2.getIcon();
        }
    }

    public static abstract class ItemWrapper<T>
    extends Wrapper {
        private final T myValue;
        private boolean myDynamic;

        protected ItemWrapper(@Nullable T value2) {
            this(value2, false);
        }

        protected ItemWrapper(@Nullable T value2, boolean addSeparatorAbove) {
            super(addSeparatorAbove);
            this.myValue = value2;
        }

        public T getValue() {
            return this.myValue;
        }

        public boolean isDynamic() {
            return this.myDynamic;
        }

        public void setDynamic(boolean b) {
            this.myDynamic = b;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ItemWrapper)) {
                return false;
            }
            ItemWrapper that = (ItemWrapper)o;
            return !(this.myValue != null ? !this.myValue.equals(that.myValue) : that.myValue != null);
        }

        public int hashCode() {
            return this.myValue != null ? this.myValue.hashCode() : 0;
        }

        public abstract void perform(@NotNull Project var1, @NotNull Executor var2, @NotNull DataContext var3);

        @Nullable
        public ConfigurationType getType() {
            return null;
        }

        public boolean available(Executor executor) {
            return false;
        }

        public boolean hasActions() {
            return false;
        }

        public PopupStep getNextStep(Project project2, ChooseRunConfigurationPopup action) {
            return PopupStep.FINAL_CHOICE;
        }

        public static ItemWrapper wrap(@NotNull Project project2, @NotNull RunnerAndConfigurationSettings settings, boolean dynamic) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/actions/ChooseRunConfigurationPopup$ItemWrapper", "wrap"));
            }
            if (settings == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/execution/actions/ChooseRunConfigurationPopup$ItemWrapper", "wrap"));
            }
            ItemWrapper result2 = ItemWrapper.wrap(project2, settings);
            result2.setDynamic(dynamic);
            return result2;
        }

        public static ItemWrapper wrap(final @NotNull Project project2, @NotNull RunnerAndConfigurationSettings settings) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/actions/ChooseRunConfigurationPopup$ItemWrapper", "wrap"));
            }
            if (settings == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/execution/actions/ChooseRunConfigurationPopup$ItemWrapper", "wrap"));
            }
            return new ItemWrapper<RunnerAndConfigurationSettings>(settings){

                @Override
                public void perform(@NotNull Project project22, @NotNull Executor executor, @NotNull DataContext context) {
                    if (project22 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/actions/ChooseRunConfigurationPopup$ItemWrapper$1", "perform"));
                    }
                    if (executor == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/intellij/execution/actions/ChooseRunConfigurationPopup$ItemWrapper$1", "perform"));
                    }
                    if (context == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/execution/actions/ChooseRunConfigurationPopup$ItemWrapper$1", "perform"));
                    }
                    RunnerAndConfigurationSettings config = (RunnerAndConfigurationSettings)this.getValue();
                    RunManager.getInstance((Project)project22).setSelectedConfiguration(config);
                    ExecutionUtil.runConfiguration((RunnerAndConfigurationSettings)config, (Executor)executor);
                }

                @Override
                public ConfigurationType getType() {
                    return ((RunnerAndConfigurationSettings)this.getValue()).getType();
                }

                @Override
                public Icon getIcon() {
                    return RunManagerEx.getInstanceEx(project2).getConfigurationIcon((RunnerAndConfigurationSettings)this.getValue(), true);
                }

                @Override
                public String getText() {
                    return ((RunnerAndConfigurationSettings)this.getValue()).getName();
                }

                @Override
                public boolean hasActions() {
                    return true;
                }

                @Override
                public boolean available(Executor executor) {
                    return ProgramRunnerUtil.getRunner(executor.getId(), (RunnerAndConfigurationSettings)this.getValue()) != null;
                }

                @Override
                public PopupStep getNextStep(@NotNull Project project22, @NotNull ChooseRunConfigurationPopup action) {
                    if (project22 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/actions/ChooseRunConfigurationPopup$ItemWrapper$1", "getNextStep"));
                    }
                    if (action == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/execution/actions/ChooseRunConfigurationPopup$ItemWrapper$1", "getNextStep"));
                    }
                    return new ConfigurationActionsStep(project22, action, (RunnerAndConfigurationSettings)this.getValue(), this.isDynamic());
                }
            };
        }

        @Override
        public boolean canBeDeleted() {
            return !this.isDynamic() && this.getValue() instanceof RunnerAndConfigurationSettings;
        }
    }

    private static abstract class Wrapper {
        private int myMnemonic = -1;
        private final boolean myAddSeparatorAbove;
        private boolean myChecked;

        protected Wrapper(boolean addSeparatorAbove) {
            this.myAddSeparatorAbove = addSeparatorAbove;
        }

        public int getMnemonic() {
            return this.myMnemonic;
        }

        public boolean isChecked() {
            return this.myChecked;
        }

        public void setChecked(boolean checked) {
            this.myChecked = checked;
        }

        public void setMnemonic(int mnemonic) {
            this.myMnemonic = mnemonic;
        }

        public boolean addSeparatorAbove() {
            return this.myAddSeparatorAbove;
        }

        @Nullable
        public abstract Icon getIcon();

        public abstract String getText();

        public boolean canBeDeleted() {
            return false;
        }

        public String toString() {
            return "Wrapper[" + this.getText() + "]";
        }
    }
}

