/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.actions;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.KillableProcess;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.impl.ExecutionManagerImpl;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupAdapter;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.ui.popup.ListItemDescriptorAdapter;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.reference.SoftReference;
import com.intellij.ui.components.JBList;
import com.intellij.ui.popup.list.GroupedItemsListRenderer;
import com.intellij.util.IconUtil;
import java.awt.Component;
import java.awt.event.InputEvent;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StopAction
extends DumbAwareAction
implements AnAction.TransparentUpdate {
    private WeakReference<JBPopup> myActivePopupRef = null;

    private static boolean isPlaceGlobal(AnActionEvent e) {
        return ActionPlaces.isMainMenuOrActionSearch((String)e.getPlace()) || "MainToolbar".equals(e.getPlace()) || "NavBarToolbar".equals(e.getPlace());
    }

    public void update(AnActionEvent e) {
        boolean enable = false;
        Icon icon = this.getTemplatePresentation().getIcon();
        String description = this.getTemplatePresentation().getDescription();
        Presentation presentation = e.getPresentation();
        if (StopAction.isPlaceGlobal(e)) {
            List<RunContentDescriptor> stoppableDescriptors = StopAction.getActiveStoppableDescriptors(e.getDataContext());
            int stopCount = stoppableDescriptors.size();
            boolean bl = enable = stopCount >= 1;
            if (stopCount > 1) {
                presentation.setText(this.getTemplatePresentation().getText() + "...");
                icon = IconUtil.addText((Icon)icon, (String)String.valueOf(stopCount));
            } else if (stopCount == 1) {
                presentation.setText(ExecutionBundle.message((String)"stop.configuration.action.name", (Object[])new Object[]{StringUtil.escapeMnemonics((String)stoppableDescriptors.get(0).getDisplayName())}));
            }
        } else {
            RunProfile runProfile;
            ProcessHandler processHandler2;
            RunContentDescriptor contentDescriptor = (RunContentDescriptor)e.getData(LangDataKeys.RUN_CONTENT_DESCRIPTOR);
            ProcessHandler processHandler3 = processHandler2 = contentDescriptor == null ? null : contentDescriptor.getProcessHandler();
            if (processHandler2 != null && !processHandler2.isProcessTerminated()) {
                if (!processHandler2.isProcessTerminating()) {
                    enable = true;
                } else if (processHandler2 instanceof KillableProcess && ((KillableProcess)processHandler2).canKillProcess()) {
                    enable = true;
                    icon = AllIcons.Debugger.KillProcess;
                    description = "Kill process";
                }
            }
            if ((runProfile = (RunProfile)e.getData(LangDataKeys.RUN_PROFILE)) == null && contentDescriptor == null) {
                presentation.setText(this.getTemplatePresentation().getText());
            } else {
                presentation.setText(ExecutionBundle.message((String)"stop.configuration.action.name", (Object[])new Object[]{StringUtil.escapeMnemonics((String)(runProfile == null ? contentDescriptor.getDisplayName() : runProfile.getName()))}));
            }
        }
        presentation.setEnabled(enable);
        presentation.setIcon(icon);
        presentation.setDescription(description);
    }

    public void actionPerformed(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        Project project2 = e.getProject();
        List<RunContentDescriptor> stoppableDescriptors = StopAction.getActiveStoppableDescriptors(dataContext);
        int stopCount = stoppableDescriptors.size();
        if (StopAction.isPlaceGlobal(e)) {
            Component component;
            JBPopup activePopup;
            if (stopCount == 1) {
                ExecutionManagerImpl.stopProcess(stoppableDescriptors.get(0));
                return;
            }
            final Pair<List<HandlerItem>, HandlerItem> handlerItems = StopAction.getItemsList(stoppableDescriptors, StopAction.getRecentlyStartedContentDescriptor(dataContext));
            if (handlerItems == null || ((List)handlerItems.first).isEmpty()) {
                return;
            }
            JBList list2 = new JBList((Collection)handlerItems.first);
            if (handlerItems.second != null) {
                list2.setSelectedValue(handlerItems.second, true);
            }
            HandlerItem stopAllItem = new HandlerItem(ExecutionBundle.message((String)"stop.all", (Object[])new Object[]{KeymapUtil.getFirstKeyboardShortcutText((String)"Stop")}), AllIcons.Actions.Suspend, true){

                @Override
                void stop() {
                    for (HandlerItem item : (List)handlerItems.first) {
                        item.stop();
                    }
                }
            };
            if (stopCount > 1) {
                ((DefaultListModel)list2.getModel()).addElement(stopAllItem);
            }
            if ((activePopup = (JBPopup)SoftReference.dereference(this.myActivePopupRef)) != null) {
                stopAllItem.stop();
                activePopup.cancel();
                return;
            }
            list2.setCellRenderer(new GroupedItemsListRenderer(new ListItemDescriptorAdapter<HandlerItem>(){

                @Nullable
                public String getTextFor(HandlerItem item) {
                    return item.displayName;
                }

                @Nullable
                public Icon getIconFor(HandlerItem item) {
                    return item.icon;
                }

                public boolean hasSeparatorAboveOf(HandlerItem item) {
                    return item.hasSeparator;
                }
            }));
            JBPopup popup = JBPopupFactory.getInstance().createListPopupBuilder((JList)list2).setMovable(true).setTitle(((List)handlerItems.first).size() == 1 ? "Confirm process stop" : "Stop process").setFilteringEnabled(o -> ((HandlerItem)o).displayName).setItemChoosenCallback(() -> {
                List valuesList = list2.getSelectedValuesList();
                for (Object o : valuesList) {
                    if (!(o instanceof HandlerItem)) continue;
                    ((HandlerItem)o).stop();
                }
            }).addListener((JBPopupListener)new JBPopupAdapter(){

                public void onClosed(LightweightWindowEvent event) {
                    StopAction.this.myActivePopupRef = null;
                }
            }).setRequestFocus(true).createPopup();
            this.myActivePopupRef = new WeakReference<JBPopup>(popup);
            InputEvent inputEvent = e.getInputEvent();
            Component component2 = component = inputEvent != null ? inputEvent.getComponent() : null;
            if (component != null && ("MainToolbar".equals(e.getPlace()) || "NavBarToolbar".equals(e.getPlace()))) {
                popup.showUnderneathOf(component);
            } else if (project2 == null) {
                popup.showInBestPositionFor(dataContext);
            } else {
                popup.showCenteredInCurrentWindow(project2);
            }
        } else {
            ExecutionManagerImpl.stopProcess(StopAction.getRecentlyStartedContentDescriptor(dataContext));
        }
    }

    @Nullable
    private static Pair<List<HandlerItem>, HandlerItem> getItemsList(List<RunContentDescriptor> descriptors, RunContentDescriptor toSelect2) {
        if (descriptors.isEmpty()) {
            return null;
        }
        ArrayList<4> items = new ArrayList<4>(descriptors.size());
        HandlerItem selected = null;
        for (final RunContentDescriptor descriptor : descriptors) {
            ProcessHandler handler2 = descriptor.getProcessHandler();
            if (handler2 == null) continue;
            HandlerItem item = new HandlerItem(descriptor.getDisplayName(), descriptor.getIcon(), false){

                @Override
                void stop() {
                    ExecutionManagerImpl.stopProcess(descriptor);
                }
            };
            items.add(item);
            if (descriptor != toSelect2) continue;
            selected = item;
        }
        return Pair.create(items, selected);
    }

    @Nullable
    static RunContentDescriptor getRecentlyStartedContentDescriptor(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/execution/actions/StopAction", "getRecentlyStartedContentDescriptor"));
        }
        RunContentDescriptor contentDescriptor = (RunContentDescriptor)LangDataKeys.RUN_CONTENT_DESCRIPTOR.getData(dataContext);
        if (contentDescriptor != null) {
            return contentDescriptor;
        }
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        return project2 == null ? null : ExecutionManager.getInstance((Project)project2).getContentManager().getSelectedContent();
    }

    @NotNull
    private static List<RunContentDescriptor> getActiveStoppableDescriptors(DataContext dataContext) {
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project2 == null) {
            List<RunContentDescriptor> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/actions/StopAction", "getActiveStoppableDescriptors"));
            }
            return list2;
        }
        List runningProcesses = ExecutionManager.getInstance((Project)project2).getContentManager().getAllDescriptors();
        if (runningProcesses.isEmpty()) {
            List<RunContentDescriptor> list3 = Collections.emptyList();
            if (list3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/actions/StopAction", "getActiveStoppableDescriptors"));
            }
            return list3;
        }
        ArrayList<RunContentDescriptor> activeDescriptors = new ArrayList<RunContentDescriptor>();
        for (RunContentDescriptor descriptor : runningProcesses) {
            if (!StopAction.canBeStopped(descriptor)) continue;
            activeDescriptors.add(descriptor);
        }
        ArrayList<RunContentDescriptor> arrayList = activeDescriptors;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/actions/StopAction", "getActiveStoppableDescriptors"));
        }
        return arrayList;
    }

    private static boolean canBeStopped(@Nullable RunContentDescriptor descriptor) {
        ProcessHandler processHandler2 = descriptor != null ? descriptor.getProcessHandler() : null;
        return processHandler2 != null && !processHandler2.isProcessTerminated() && (!processHandler2.isProcessTerminating() || processHandler2 instanceof KillableProcess && ((KillableProcess)processHandler2).canKillProcess());
    }

    static abstract class HandlerItem {
        final String displayName;
        final Icon icon;
        final boolean hasSeparator;

        HandlerItem(String displayName, Icon icon, boolean hasSeparator) {
            this.displayName = displayName;
            this.icon = icon;
            this.hasSeparator = hasSeparator;
        }

        public String toString() {
            return this.displayName;
        }

        abstract void stop();
    }
}

