/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.application;

import com.intellij.codeInsight.daemon.impl.analysis.JavaModuleGraphUtil;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.diagnostic.logging.LogConfigurationPanel;
import com.intellij.execution.CommonJavaRunConfigurationParameters;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.ExternalizablePath;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.JavaRunConfigurationExtensionManager;
import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.RunConfigurationExtension;
import com.intellij.execution.SingleClassConfiguration;
import com.intellij.execution.application.ApplicationConfigurable;
import com.intellij.execution.application.ApplicationConfigurationType;
import com.intellij.execution.application.BaseJavaApplicationCommandLineState;
import com.intellij.execution.configuration.EnvironmentVariablesComponent;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RefactoringListenerProvider;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunConfigurationModule;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.junit.RefactoringListeners;
import com.intellij.execution.process.KillableProcessHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.util.JavaParametersUtil;
import com.intellij.execution.util.ProgramParametersUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.options.SettingsEditorGroup;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.ex.JavaSdkUtil;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.util.PsiMethodUtil;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.util.PathsList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApplicationConfiguration
extends ModuleBasedConfiguration<JavaRunConfigurationModule>
implements CommonJavaRunConfigurationParameters,
SingleClassConfiguration,
RefactoringListenerProvider {
    public String MAIN_CLASS_NAME;
    public String VM_PARAMETERS;
    public String PROGRAM_PARAMETERS;
    public String WORKING_DIRECTORY;
    public boolean ALTERNATIVE_JRE_PATH_ENABLED;
    public String ALTERNATIVE_JRE_PATH;
    public boolean ENABLE_SWING_INSPECTOR;
    public String ENV_VARIABLES;
    private final Map<String, String> myEnvs = new LinkedHashMap<String, String>();
    public boolean PASS_PARENT_ENVS = true;

    public ApplicationConfiguration(String name2, Project project2, ApplicationConfigurationType applicationConfigurationType) {
        this(name2, project2, applicationConfigurationType.getConfigurationFactories()[0]);
    }

    protected ApplicationConfiguration(String name2, Project project2, ConfigurationFactory factory) {
        super(name2, (RunConfigurationModule)new JavaRunConfigurationModule(project2, true), factory);
    }

    @Override
    public void setMainClass(PsiClass psiClass) {
        Module originalModule = ((JavaRunConfigurationModule)this.getConfigurationModule()).getModule();
        this.setMainClassName(JavaExecutionUtil.getRuntimeQualifiedName((PsiClass)psiClass));
        this.setModule(JavaExecutionUtil.findModule((PsiClass)psiClass));
        this.restoreOriginalModule(originalModule);
    }

    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) throws ExecutionException {
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/intellij/execution/application/ApplicationConfiguration", "getState"));
        }
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/intellij/execution/application/ApplicationConfiguration", "getState"));
        }
        JavaApplicationCommandLineState<ApplicationConfiguration> state = new JavaApplicationCommandLineState<ApplicationConfiguration>(this, env);
        JavaRunConfigurationModule module2 = (JavaRunConfigurationModule)this.getConfigurationModule();
        state.setConsoleBuilder(TextConsoleBuilderFactory.getInstance().createBuilder(this.getProject(), module2.getSearchScope()));
        return state;
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        SettingsEditorGroup group = new SettingsEditorGroup();
        group.addEditor(ExecutionBundle.message((String)"run.configuration.configuration.tab.title", (Object[])new Object[0]), (SettingsEditor)new ApplicationConfigurable(this.getProject()));
        JavaRunConfigurationExtensionManager.getInstance().appendEditors((RunConfigurationBase)this, group);
        group.addEditor(ExecutionBundle.message((String)"logs.tab.title", (Object[])new Object[0]), new LogConfigurationPanel());
        SettingsEditorGroup settingsEditorGroup = group;
        if (settingsEditorGroup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/application/ApplicationConfiguration", "getConfigurationEditor"));
        }
        return settingsEditorGroup;
    }

    public RefactoringElementListener getRefactoringElementListener(PsiElement element) {
        RefactoringElementListener listener2 = RefactoringListeners.getClassOrPackageListener(element, new RefactoringListeners.SingleClassConfigurationAccessor(this));
        return RunConfigurationExtension.wrapRefactoringElementListener(element, (RunConfigurationBase)this, listener2);
    }

    @Override
    @Nullable
    public PsiClass getMainClass() {
        return ((JavaRunConfigurationModule)this.getConfigurationModule()).findClass(this.MAIN_CLASS_NAME);
    }

    @Nullable
    public String suggestedName() {
        if (this.MAIN_CLASS_NAME == null) {
            return null;
        }
        return JavaExecutionUtil.getPresentableClassName((String)this.MAIN_CLASS_NAME);
    }

    public String getActionName() {
        if (this.MAIN_CLASS_NAME == null || this.MAIN_CLASS_NAME.length() == 0) {
            return null;
        }
        return ProgramRunnerUtil.shortenName(JavaExecutionUtil.getShortClassName((String)this.MAIN_CLASS_NAME), 6) + ".main()";
    }

    @Override
    public void setMainClassName(String qualifiedName) {
        this.MAIN_CLASS_NAME = qualifiedName;
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        JavaParametersUtil.checkAlternativeJRE(this);
        JavaRunConfigurationModule configurationModule = (JavaRunConfigurationModule)this.getConfigurationModule();
        PsiClass psiClass = configurationModule.checkModuleAndClassName(this.MAIN_CLASS_NAME, ExecutionBundle.message((String)"no.main.class.specified.error.text", (Object[])new Object[0]));
        if (!PsiMethodUtil.hasMainMethod((PsiClass)psiClass)) {
            throw new RuntimeConfigurationWarning(ExecutionBundle.message((String)"main.method.not.found.in.class.error.message", (Object[])new Object[]{this.MAIN_CLASS_NAME}));
        }
        ProgramParametersUtil.checkWorkingDirectoryExist(this, this.getProject(), configurationModule.getModule());
        JavaRunConfigurationExtensionManager.checkConfigurationIsValid((RunConfigurationBase)this);
    }

    @Override
    public void setVMParameters(String value2) {
        this.VM_PARAMETERS = value2;
    }

    @Override
    public String getVMParameters() {
        return this.VM_PARAMETERS;
    }

    @Override
    public void setProgramParameters(String value2) {
        this.PROGRAM_PARAMETERS = value2;
    }

    @Override
    public String getProgramParameters() {
        return this.PROGRAM_PARAMETERS;
    }

    @Override
    public void setWorkingDirectory(String value2) {
        this.WORKING_DIRECTORY = ExternalizablePath.urlValue(value2);
    }

    @Override
    public String getWorkingDirectory() {
        return ExternalizablePath.localPathValue(this.WORKING_DIRECTORY);
    }

    @Override
    public void setPassParentEnvs(boolean passParentEnvs) {
        this.PASS_PARENT_ENVS = passParentEnvs;
    }

    @Override
    @NotNull
    public Map<String, String> getEnvs() {
        Map<String, String> map2 = this.myEnvs;
        if (map2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/application/ApplicationConfiguration", "getEnvs"));
        }
        return map2;
    }

    @Override
    public void setEnvs(@NotNull Map<String, String> envs) {
        if (envs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "envs", "com/intellij/execution/application/ApplicationConfiguration", "setEnvs"));
        }
        this.myEnvs.clear();
        this.myEnvs.putAll(envs);
    }

    @Override
    public boolean isPassParentEnvs() {
        return this.PASS_PARENT_ENVS;
    }

    @Override
    @Nullable
    public String getRunClass() {
        return this.MAIN_CLASS_NAME;
    }

    @Override
    @Nullable
    public String getPackage() {
        return null;
    }

    @Override
    public boolean isAlternativeJrePathEnabled() {
        return this.ALTERNATIVE_JRE_PATH_ENABLED;
    }

    @Override
    public void setAlternativeJrePathEnabled(boolean enabled) {
        this.ALTERNATIVE_JRE_PATH_ENABLED = enabled;
    }

    @Override
    @Nullable
    public String getAlternativeJrePath() {
        return this.ALTERNATIVE_JRE_PATH;
    }

    @Override
    public void setAlternativeJrePath(String path) {
        this.ALTERNATIVE_JRE_PATH = path;
    }

    public Collection<Module> getValidModules() {
        return JavaRunConfigurationModule.getModulesForClass((Project)this.getProject(), (String)this.MAIN_CLASS_NAME);
    }

    public void readExternal(Element element) {
        super.readExternal(element);
        JavaRunConfigurationExtensionManager.getInstance().readExternal((RunConfigurationBase)this, element);
        DefaultJDOMExternalizer.readExternal((Object)this, (Element)element);
        this.readModule(element);
        EnvironmentVariablesComponent.readExternal(element, this.getEnvs());
    }

    public void writeExternal(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/execution/application/ApplicationConfiguration", "writeExternal"));
        }
        super.writeExternal(element);
        JavaRunConfigurationExtensionManager.getInstance().writeExternal((RunConfigurationBase)this, element);
        DefaultJDOMExternalizer.writeExternal((Object)this, (Element)element);
        this.writeModule(element);
        Map<String, String> envs = this.getEnvs();
        EnvironmentVariablesComponent.writeExternal(element, envs);
    }

    public static class JavaApplicationCommandLineState<T extends ApplicationConfiguration>
    extends BaseJavaApplicationCommandLineState<T> {
        public JavaApplicationCommandLineState(@NotNull T configuration, ExecutionEnvironment environment) {
            if (configuration == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/execution/application/ApplicationConfiguration$JavaApplicationCommandLineState", "<init>"));
            }
            super(environment, configuration);
        }

        protected JavaParameters createJavaParameters() throws ExecutionException {
            String jreHome;
            JavaParameters params = new JavaParameters();
            params.setUseClasspathJar(true);
            JavaRunConfigurationModule module2 = (JavaRunConfigurationModule)((ApplicationConfiguration)this.myConfiguration).getConfigurationModule();
            String string = jreHome = ((ApplicationConfiguration)this.myConfiguration).ALTERNATIVE_JRE_PATH_ENABLED ? ((ApplicationConfiguration)this.myConfiguration).ALTERNATIVE_JRE_PATH : null;
            if (module2.getModule() != null) {
                DumbService.getInstance((Project)module2.getProject()).runWithAlternativeResolveEnabled(() -> {
                    int classPathType = JavaParametersUtil.getClasspathType((RunConfigurationModule)module2, ((ApplicationConfiguration)this.myConfiguration).MAIN_CLASS_NAME, false);
                    JavaParametersUtil.configureModule((RunConfigurationModule)module2, params, classPathType, jreHome);
                });
            } else {
                JavaParametersUtil.configureProject(module2.getProject(), params, 7, jreHome);
            }
            params.setMainClass(((ApplicationConfiguration)this.myConfiguration).MAIN_CLASS_NAME);
            this.setupJavaParameters(params);
            JavaApplicationCommandLineState.setupModulePath(params, module2);
            return params;
        }

        @Override
        @NotNull
        protected OSProcessHandler startProcess() throws ExecutionException {
            OSProcessHandler processHandler2 = super.startProcess();
            if (processHandler2 instanceof KillableProcessHandler && DebuggerSettings.getInstance().KILL_PROCESS_IMMEDIATELY) {
                ((KillableProcessHandler)processHandler2).setShouldKillProcessSoftly(false);
            }
            OSProcessHandler oSProcessHandler = processHandler2;
            if (oSProcessHandler == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/application/ApplicationConfiguration$JavaApplicationCommandLineState", "startProcess"));
            }
            return oSProcessHandler;
        }

        private static void setupModulePath(JavaParameters params, JavaRunConfigurationModule module2) {
            PsiJavaModule mainModule;
            if (JavaSdkUtil.isJdkAtLeast(params.getJdk(), JavaSdkVersion.JDK_1_9) && (mainModule = (PsiJavaModule)DumbService.getInstance((Project)module2.getProject()).computeWithAlternativeResolveEnabled(() -> JavaModuleGraphUtil.findDescriptorByElement((PsiElement)module2.findClass(params.getMainClass())))) != null) {
                params.setModuleName(mainModule.getName());
                PathsList classPath = params.getClassPath();
                PathsList modulePath = params.getModulePath();
                modulePath.addAll(classPath.getPathList());
                classPath.clear();
            }
        }
    }
}

