/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.dashboard;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.StopAction;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.dashboard.DashboardNode;
import com.intellij.execution.dashboard.DashboardRunConfigurationNode;
import com.intellij.execution.dashboard.RunDashboardContributor;
import com.intellij.execution.dashboard.RunDashboardManager;
import com.intellij.execution.dashboard.TreeContent;
import com.intellij.execution.dashboard.tree.DashboardGrouper;
import com.intellij.execution.dashboard.tree.RunDashboardTreeStructure;
import com.intellij.execution.runners.FakeRerunAction;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManagerImpl;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.execution.ui.layout.impl.RunnerLayoutUiImpl;
import com.intellij.icons.AllIcons;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.DefaultTreeExpander;
import com.intellij.ide.TreeExpander;
import com.intellij.ide.impl.DataManagerImpl;
import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.IndexComparator;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.NodeRenderer;
import com.intellij.ide.util.treeView.TreeVisitor;
import com.intellij.ide.util.treeView.smartTree.ActionPresentation;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.components.JBPanelWithEmptyText;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerAdapter;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunDashboardContent
extends JPanel
implements TreeContent,
Disposable {
    public static final DataKey<RunDashboardContent> KEY = DataKey.create((String)"runDashboardContent");
    @NonNls
    private static final String PLACE_TOOLBAR = "RunDashboardContent#Toolbar";
    @NonNls
    private static final String RUN_DASHBOARD_CONTENT_TOOLBAR = "RunDashboardContentToolbar";
    @NonNls
    private static final String RUN_DASHBOARD_TREE_TOOLBAR = "RunDashboardTreeToolbar";
    @NonNls
    private static final String RUN_DASHBOARD_POPUP = "RunDashboardPopup";
    private static final String MESSAGE_CARD = "message";
    private static final String CONTENT_CARD = "content";
    private final JPanel myTreePanel;
    private final Tree myTree;
    private final CardLayout myDetailsPanelLayout;
    private final JPanel myDetailsPanel;
    private final JBPanelWithEmptyText myMessagePanel;
    private final JComponent myToolbar;
    private final DefaultTreeModel myTreeModel;
    private AbstractTreeBuilder myBuilder;
    private AbstractTreeNode<?> myLastSelection;
    private final Set<Object> myCollapsedTreeNodeValues;
    private final List<DashboardGrouper> myGroupers;
    @NotNull
    private final ContentManager myContentManager;
    @NotNull
    private final ContentManagerListener myContentManagerListener;
    @NotNull
    private final Project myProject;
    private final DefaultActionGroup myContentActionGroup;
    private final DefaultActionGroup myDashboardContentActions;
    private final Map<Content, List<AnAction>> myContentActions;

    public RunDashboardContent(@NotNull Project project2, @NotNull ContentManager contentManager, @NotNull List<DashboardGrouper> groupers) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/dashboard/RunDashboardContent", "<init>"));
        }
        if (contentManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentManager", "com/intellij/execution/dashboard/RunDashboardContent", "<init>"));
        }
        if (groupers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupers", "com/intellij/execution/dashboard/RunDashboardContent", "<init>"));
        }
        super(new BorderLayout());
        this.myCollapsedTreeNodeValues = new HashSet<Object>();
        this.myContentActionGroup = new DefaultActionGroup();
        this.myDashboardContentActions = new DefaultActionGroup();
        this.myContentActions = new WeakHashMap<Content, List<AnAction>>();
        this.myProject = project2;
        this.myGroupers = groupers;
        this.myTreeModel = new DefaultTreeModel(new DefaultMutableTreeNode());
        this.myTree = new Tree((TreeModel)this.myTreeModel);
        this.myTree.setRootVisible(false);
        this.myTree.setShowsRootHandles(true);
        this.myTree.setCellRenderer((TreeCellRenderer)new NodeRenderer());
        this.myTree.setLineStyleAngled();
        this.myToolbar = this.createToolbar();
        this.add((Component)this.myToolbar, "West");
        OnePixelSplitter splitter = new OnePixelSplitter(false, 0.3f);
        this.myTreePanel = new JPanel(new BorderLayout());
        this.myTreePanel.add((Component)ScrollPaneFactory.createScrollPane((Component)this.myTree, (int)1), "Center");
        splitter.setFirstComponent((JComponent)this.myTreePanel);
        this.myDetailsPanelLayout = new CardLayout();
        this.myDetailsPanel = new JPanel(this.myDetailsPanelLayout);
        this.myMessagePanel = new JBPanelWithEmptyText().withEmptyText(ExecutionBundle.message((String)"run.dashboard.empty.selection.message", (Object[])new Object[0]));
        this.myDetailsPanel.add(MESSAGE_CARD, (Component)this.myMessagePanel);
        splitter.setSecondComponent((JComponent)this.myDetailsPanel);
        this.add((Component)splitter, "Center");
        this.myContentManager = contentManager;
        this.myContentManagerListener = new ContentManagerAdapter(){

            public void contentAdded(ContentManagerEvent event) {
                Content content = event.getContent();
                RunContentDescriptor descriptor = RunContentManagerImpl.getRunContentDescriptorByContent(content);
                if (descriptor == null) {
                    return;
                }
                RunnerLayoutUi layoutUi = descriptor.getRunnerLayoutUi();
                if (!(layoutUi instanceof RunnerLayoutUiImpl)) {
                    return;
                }
                RunnerLayoutUiImpl layoutUiImpl = (RunnerLayoutUiImpl)layoutUi;
                layoutUiImpl.setLeftToolbarVisible(false);
                List<AnAction> leftToolbarActions = layoutUiImpl.getActions();
                RunDashboardContent.this.myContentActions.put(content, leftToolbarActions);
                RunDashboardContent.this.updateContentToolbar(content);
            }

            public void contentRemoved(ContentManagerEvent event) {
                Content content = event.getContent();
                RunDashboardContent.this.myContentActions.remove(content);
                RunDashboardContent.this.updateContentToolbar(content);
            }

            public void selectionChanged(final ContentManagerEvent event) {
                if (ContentManagerEvent.ContentOperation.add != event.getOperation()) {
                    return;
                }
                this.contentAdded(event);
                RunDashboardContent.this.myBuilder.queueUpdate().doWhenDone(() -> RunDashboardContent.this.myBuilder.accept(DashboardNode.class, (TreeVisitor)new TreeVisitor<DashboardNode>(){

                    public boolean visit(@NotNull DashboardNode node) {
                        if (node == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/execution/dashboard/RunDashboardContent$1$1", "visit"));
                        }
                        if (node.getContent() == event.getContent()) {
                            RunDashboardContent.this.myBuilder.select((Object)node);
                        }
                        return false;
                    }
                }));
                RunDashboardContent.this.showContentPanel();
            }
        };
        this.myContentManager.addContentManagerListener(this.myContentManagerListener);
        this.myDetailsPanel.add(CONTENT_CARD, this.myContentManager.getComponent());
        this.setupBuilder();
        this.myTree.addTreeSelectionListener(e -> this.onSelectionChanged());
        this.myTree.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeExpanded(TreeExpansionEvent event) {
                Object value2 = this.getNodeValue(event);
                if (value2 != null) {
                    RunDashboardContent.this.myCollapsedTreeNodeValues.remove(value2);
                }
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
                Object value2 = this.getNodeValue(event);
                if (value2 != null) {
                    RunDashboardContent.this.myCollapsedTreeNodeValues.add(value2);
                }
            }

            private Object getNodeValue(TreeExpansionEvent event) {
                DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)ObjectUtils.tryCast((Object)event.getPath().getLastPathComponent(), DefaultMutableTreeNode.class);
                if (treeNode == null) {
                    return null;
                }
                AbstractTreeNode nodeDescriptor = (AbstractTreeNode)ObjectUtils.tryCast((Object)treeNode.getUserObject(), AbstractTreeNode.class);
                if (nodeDescriptor == null) {
                    return null;
                }
                return nodeDescriptor.getValue();
            }
        });
        this.putClientProperty("DataProvider", new DataProvider(){

            @Nullable
            public Object getData(@NonNls String dataId) {
                DataProvider dataProvider;
                if (KEY.getName().equals(dataId)) {
                    return RunDashboardContent.this;
                }
                Content content = RunDashboardContent.this.myContentManager.getSelectedContent();
                if (content != null && content.getComponent() != null && (dataProvider = DataManagerImpl.getDataProviderEx(content.getComponent())) != null) {
                    return dataProvider.getData(dataId);
                }
                return null;
            }
        });
        new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent event) {
                DashboardRunConfigurationNode node;
                RunnerAndConfigurationSettings settings;
                RunDashboardContributor contributor;
                if (RunDashboardContent.this.myLastSelection instanceof DashboardRunConfigurationNode && RunDashboardContent.this.myLastSelection.getChildren().isEmpty() && (contributor = RunDashboardContributor.getContributor((ConfigurationType)(settings = (node = (DashboardRunConfigurationNode)RunDashboardContent.this.myLastSelection).getConfigurationSettings()).getType())) != null) {
                    return contributor.handleDoubleClick(settings.getConfiguration());
                }
                return false;
            }
        }.installOn((Component)this.myTree);
        DefaultActionGroup popupActionGroup = new DefaultActionGroup();
        popupActionGroup.add(ActionManager.getInstance().getAction(RUN_DASHBOARD_CONTENT_TOOLBAR));
        popupActionGroup.addSeparator();
        popupActionGroup.add(ActionManager.getInstance().getAction(RUN_DASHBOARD_TREE_TOOLBAR));
        popupActionGroup.add(ActionManager.getInstance().getAction(RUN_DASHBOARD_POPUP));
        PopupHandler.installPopupHandler((JComponent)this.myTree, (ActionGroup)popupActionGroup, (String)RUN_DASHBOARD_POPUP, (ActionManager)ActionManager.getInstance());
        new TreeSpeedSearch(this.myTree, TreeSpeedSearch.NODE_DESCRIPTOR_TOSTRING, true);
        this.setTreeVisible(RunDashboardManager.getInstance((Project)this.myProject).isShowConfigurations());
    }

    private void setTreeVisible(boolean visible) {
        this.myTreePanel.setVisible(visible);
        this.myToolbar.setBorder(visible ? null : BorderFactory.createMatteBorder(0, 0, 0, 1, UIUtil.CONTRAST_BORDER_COLOR));
    }

    private void updateContentToolbar(Content content) {
        List<AnAction> actions = this.myContentActions.get(content);
        this.myContentActionGroup.removeAll();
        this.myContentActionGroup.addAll((ActionGroup)this.myDashboardContentActions);
        this.myContentActionGroup.addSeparator();
        if (actions != null) {
            this.myContentActionGroup.addAll((Collection)actions.stream().filter(action -> !(action instanceof StopAction) && !(action instanceof FakeRerunAction)).collect(Collectors.toList()));
        }
    }

    private void onSelectionChanged() {
        Set nodes = this.myBuilder.getSelectedElements(AbstractTreeNode.class);
        if (nodes.size() != 1) {
            this.showMessagePanel(ExecutionBundle.message((String)"run.dashboard.empty.selection.message", (Object[])new Object[0]));
            this.myLastSelection = null;
            this.updateContentToolbar(null);
            return;
        }
        AbstractTreeNode node = (AbstractTreeNode)nodes.iterator().next();
        if (Comparing.equal((Object)node, this.myLastSelection)) {
            return;
        }
        this.myLastSelection = node;
        if (node instanceof DashboardNode) {
            Content content = ((DashboardNode)node).getContent();
            if (content != null && content.getManager() != this.myContentManager) {
                content = null;
            }
            this.updateContentToolbar(content);
            if (content != null) {
                if (content != this.myContentManager.getSelectedContent()) {
                    this.myContentManager.removeContentManagerListener(this.myContentManagerListener);
                    this.myContentManager.setSelectedContent(content);
                    this.myContentManager.addContentManagerListener(this.myContentManagerListener);
                }
                this.showContentPanel();
                return;
            }
            if (node instanceof DashboardRunConfigurationNode) {
                this.showMessagePanel(ExecutionBundle.message((String)"run.dashboard.not.started.configuration.message", (Object[])new Object[0]));
                return;
            }
        }
        this.showMessagePanel(ExecutionBundle.message((String)"run.dashboard.empty.selection.message", (Object[])new Object[0]));
    }

    private void showMessagePanel(String text2) {
        Content selectedContent = this.myContentManager.getSelectedContent();
        if (selectedContent != null) {
            this.myContentManager.removeContentManagerListener(this.myContentManagerListener);
            this.myContentManager.removeFromSelection(selectedContent);
            this.myContentManager.addContentManagerListener(this.myContentManagerListener);
        }
        this.myMessagePanel.getEmptyText().setText(text2);
        this.myDetailsPanelLayout.show(this.myDetailsPanel, MESSAGE_CARD);
    }

    private void showContentPanel() {
        this.myDetailsPanelLayout.show(this.myDetailsPanel, CONTENT_CARD);
    }

    private void setupBuilder() {
        RunDashboardTreeStructure structure = new RunDashboardTreeStructure(this.myProject, this.myGroupers);
        this.myBuilder = new AbstractTreeBuilder((JTree)this.myTree, this.myTreeModel, structure, (Comparator)IndexComparator.INSTANCE){

            protected boolean isAutoExpandNode(NodeDescriptor nodeDescriptor) {
                return super.isAutoExpandNode(nodeDescriptor) || !RunDashboardContent.this.myCollapsedTreeNodeValues.contains(((AbstractTreeNode)nodeDescriptor).getValue());
            }
        };
        this.myBuilder.initRootNode();
        Disposer.register((Disposable)this, (Disposable)this.myBuilder);
    }

    private JComponent createToolbar() {
        JPanel toolBarPanel = new JPanel(new BorderLayout());
        this.myDashboardContentActions.add(ActionManager.getInstance().getAction(RUN_DASHBOARD_CONTENT_TOOLBAR));
        this.myContentActionGroup.add((AnAction)this.myDashboardContentActions);
        ActionToolbar contentActionsToolBar = ActionManager.getInstance().createActionToolbar(PLACE_TOOLBAR, (ActionGroup)this.myContentActionGroup, false);
        toolBarPanel.add((Component)contentActionsToolBar.getComponent(), "Center");
        contentActionsToolBar.setTargetComponent((JComponent)this);
        DefaultActionGroup treeGroup = new DefaultActionGroup();
        treeGroup.addAction((AnAction)new ShowConfigurationsAction());
        treeGroup.addAction((AnAction)new PreviousConfigurationAction());
        treeGroup.addAction((AnAction)new NextConfigurationAction());
        treeGroup.addSeparator();
        DefaultTreeExpander treeExpander = new DefaultTreeExpander((JTree)this.myTree);
        AnAction expandAllAction = CommonActionsManager.getInstance().createExpandAllAction((TreeExpander)treeExpander, (JComponent)this);
        treeGroup.add(expandAllAction);
        AnAction collapseAllAction = CommonActionsManager.getInstance().createCollapseAllAction((TreeExpander)treeExpander, (JComponent)this);
        treeGroup.add(collapseAllAction);
        treeGroup.addSeparator();
        this.myGroupers.stream().filter(grouper -> !grouper.getRule().isAlwaysEnabled()).forEach(grouper -> treeGroup.add((AnAction)new GroupAction((DashboardGrouper)grouper)));
        treeGroup.addSeparator();
        AnAction treeActions = ActionManager.getInstance().getAction(RUN_DASHBOARD_TREE_TOOLBAR);
        treeActions.registerCustomShortcutSet((JComponent)this, null);
        treeGroup.add(treeActions);
        ActionToolbar treeActionsToolBar = ActionManager.getInstance().createActionToolbar(PLACE_TOOLBAR, (ActionGroup)treeGroup, false);
        toolBarPanel.add((Component)treeActionsToolBar.getComponent(), "East");
        treeActionsToolBar.setTargetComponent((JComponent)this);
        return toolBarPanel;
    }

    public void dispose() {
    }

    public void updateContent(boolean withStructure) {
        AppUIUtil.invokeLaterIfProjectAlive(this.myProject, () -> {
            boolean showConfigurations = RunDashboardManager.getInstance((Project)this.myProject).isShowConfigurations();
            if (this.myTreePanel.isVisible() ^ showConfigurations) {
                this.setTreeVisible(showConfigurations);
                this.revalidate();
                this.repaint();
            }
            this.myBuilder.queueUpdate(withStructure).doWhenDone(() -> {
                if (!withStructure) {
                    return;
                }
                final HashSet nodes = new HashSet();
                this.myBuilder.accept(AbstractTreeNode.class, (TreeVisitor)new TreeVisitor<AbstractTreeNode>(){

                    public boolean visit(@NotNull AbstractTreeNode node) {
                        if (node == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/execution/dashboard/RunDashboardContent$6", "visit"));
                        }
                        nodes.add(node.getValue());
                        return false;
                    }
                });
                this.myCollapsedTreeNodeValues.retainAll(nodes);
            });
        });
    }

    @NotNull
    public AbstractTreeBuilder getBuilder() {
        AbstractTreeBuilder abstractTreeBuilder = this.myBuilder;
        if (abstractTreeBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/dashboard/RunDashboardContent", "getBuilder"));
        }
        return abstractTreeBuilder;
    }

    private class NextConfigurationAction
    extends AnAction
    implements DumbAware {
        NextConfigurationAction() {
            super(ExecutionBundle.message((String)"run.dashboard.next.configuration.action.name", (Object[])new Object[0]), null, AllIcons.Actions.NextOccurence);
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setEnabled(RunDashboardContent.this.myContentManager.getContentCount() > 1);
        }

        public void actionPerformed(AnActionEvent e) {
            RunDashboardContent.this.myContentManager.selectNextContent();
        }
    }

    private class PreviousConfigurationAction
    extends AnAction
    implements DumbAware {
        PreviousConfigurationAction() {
            super(ExecutionBundle.message((String)"run.dashboard.previous.configuration.action.name", (Object[])new Object[0]), null, AllIcons.Actions.PreviousOccurence);
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setEnabled(RunDashboardContent.this.myContentManager.getContentCount() > 1);
        }

        public void actionPerformed(AnActionEvent e) {
            RunDashboardContent.this.myContentManager.selectPreviousContent();
        }
    }

    private class ShowConfigurationsAction
    extends ToggleAction
    implements DumbAware {
        ShowConfigurationsAction() {
            super(ExecutionBundle.message((String)"run.dashboard.show.configurations.action.name", (Object[])new Object[0]), null, AllIcons.Actions.ShowAsTree);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/execution/dashboard/RunDashboardContent$ShowConfigurationsAction", "update"));
            }
            super.update(e);
            boolean enabled = true;
            if (this.isSelected(e)) {
                Content content;
                enabled = RunDashboardContent.this.myLastSelection instanceof DashboardNode ? (content = ((DashboardNode)RunDashboardContent.this.myLastSelection).getContent()) != null && content.getManager() == RunDashboardContent.this.myContentManager : false;
            }
            e.getPresentation().setEnabled(enabled);
        }

        public boolean isSelected(AnActionEvent e) {
            Project project2 = e.getProject();
            if (project2 == null) {
                return true;
            }
            return RunDashboardManager.getInstance((Project)project2).isShowConfigurations();
        }

        public void setSelected(AnActionEvent e, boolean state) {
            Project project2 = e.getProject();
            if (project2 == null) {
                return;
            }
            RunDashboardManager.getInstance((Project)project2).setShowConfigurations(state);
            RunDashboardContent.this.updateContent(false);
        }
    }

    private class GroupAction
    extends ToggleAction
    implements DumbAware {
        private final DashboardGrouper myGrouper;

        GroupAction(DashboardGrouper grouper) {
            this.myGrouper = grouper;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/execution/dashboard/RunDashboardContent$GroupAction", "update"));
            }
            super.update(e);
            Presentation presentation = e.getPresentation();
            presentation.setEnabled(RunDashboardContent.this.myTreePanel.isVisible());
            ActionPresentation actionPresentation = this.myGrouper.getRule().getPresentation();
            presentation.setText(actionPresentation.getText());
            presentation.setDescription(actionPresentation.getDescription());
            if (RunDashboardContent.PLACE_TOOLBAR.equals(e.getPlace())) {
                presentation.setIcon(actionPresentation.getIcon());
            }
        }

        public boolean isSelected(AnActionEvent e) {
            return this.myGrouper.isEnabled();
        }

        public void setSelected(AnActionEvent e, boolean state) {
            this.myGrouper.setEnabled(state);
            RunDashboardContent.this.updateContent(true);
        }
    }
}

