/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.filters;

import com.intellij.execution.filters.AbstractFileHyperlinkFilter;
import com.intellij.execution.filters.FileHyperlinkRawData;
import com.intellij.execution.filters.PatternBasedFileHyperlinkRawDataFinder;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PatternBasedFileHyperlinkFilter
extends AbstractFileHyperlinkFilter
implements DumbAware {
    private final PatternBasedFileHyperlinkRawDataFinder myFinder;

    public PatternBasedFileHyperlinkFilter(@NotNull Project project2, @Nullable String baseDir, @NotNull PatternBasedFileHyperlinkRawDataFinder finder) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/filters/PatternBasedFileHyperlinkFilter", "<init>"));
        }
        if (finder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "finder", "com/intellij/execution/filters/PatternBasedFileHyperlinkFilter", "<init>"));
        }
        super(project2, baseDir);
        this.myFinder = finder;
    }

    @Override
    @NotNull
    public List<FileHyperlinkRawData> parse(@NotNull String line) {
        if (line == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/intellij/execution/filters/PatternBasedFileHyperlinkFilter", "parse"));
        }
        List<FileHyperlinkRawData> list2 = this.myFinder.find(line);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/filters/PatternBasedFileHyperlinkFilter", "parse"));
        }
        return list2;
    }
}

