/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.filters;

import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.SmartList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class TextConsoleBuilderImpl
extends TextConsoleBuilder {
    private final Project myProject;
    private final GlobalSearchScope myScope;
    private final List<Filter> myFilters;
    private boolean myViewer;
    private boolean myUsePredefinedMessageFilter;

    public TextConsoleBuilderImpl(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/filters/TextConsoleBuilderImpl", "<init>"));
        }
        this(project2, GlobalSearchScope.allScope((Project)project2));
    }

    public TextConsoleBuilderImpl(@NotNull Project project2, @NotNull GlobalSearchScope scope) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/filters/TextConsoleBuilderImpl", "<init>"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/execution/filters/TextConsoleBuilderImpl", "<init>"));
        }
        this.myFilters = new SmartList();
        this.myUsePredefinedMessageFilter = true;
        this.myProject = project2;
        this.myScope = scope;
    }

    public ConsoleView getConsole() {
        ConsoleView consoleView = this.createConsole();
        for (Filter filter : this.myFilters) {
            consoleView.addMessageFilter(filter);
        }
        return consoleView;
    }

    @NotNull
    protected ConsoleView createConsole() {
        ConsoleViewImpl consoleViewImpl = new ConsoleViewImpl(this.myProject, this.myScope, this.myViewer, this.myUsePredefinedMessageFilter);
        if (consoleViewImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/filters/TextConsoleBuilderImpl", "createConsole"));
        }
        return consoleViewImpl;
    }

    public void addFilter(@NotNull Filter filter) {
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/execution/filters/TextConsoleBuilderImpl", "addFilter"));
        }
        this.myFilters.add(filter);
    }

    public TextConsoleBuilder filters(@NotNull List<Filter> filters) {
        if (filters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filters", "com/intellij/execution/filters/TextConsoleBuilderImpl", "filters"));
        }
        this.myFilters.addAll(filters);
        return this;
    }

    public void setViewer(boolean isViewer) {
        this.myViewer = isViewer;
    }

    @NotNull
    protected Project getProject() {
        Project project2 = this.myProject;
        if (project2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/filters/TextConsoleBuilderImpl", "getProject"));
        }
        return project2;
    }

    protected GlobalSearchScope getScope() {
        return this.myScope;
    }

    @NotNull
    protected List<Filter> getFilters() {
        List<Filter> list2 = this.myFilters;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/filters/TextConsoleBuilderImpl", "getFilters"));
        }
        return list2;
    }

    protected boolean isViewer() {
        return this.myViewer;
    }

    public void setUsePredefinedMessageFilter(boolean usePredefinedMessageFilter) {
        this.myUsePredefinedMessageFilter = usePredefinedMessageFilter;
    }

    public boolean isUsePredefinedMessageFilter() {
        return this.myUsePredefinedMessageFilter;
    }
}

