/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.filters.impl;

import com.intellij.execution.filters.FileHyperlinkInfo;
import com.intellij.execution.filters.HyperlinkInfoBase;
import com.intellij.execution.filters.OpenFileHyperlinkInfo;
import com.intellij.ide.util.gotoByName.GotoFileCellRenderer;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class MultipleFilesHyperlinkInfo
extends HyperlinkInfoBase
implements FileHyperlinkInfo {
    private final List<VirtualFile> myVirtualFiles;
    private final int myLineNumber;
    private final Project myProject;

    public MultipleFilesHyperlinkInfo(@NotNull List<VirtualFile> virtualFiles, int lineNumber, @NotNull Project project2) {
        if (virtualFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFiles", "com/intellij/execution/filters/impl/MultipleFilesHyperlinkInfo", "<init>"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/filters/impl/MultipleFilesHyperlinkInfo", "<init>"));
        }
        this.myVirtualFiles = virtualFiles;
        this.myLineNumber = lineNumber;
        this.myProject = project2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void navigate(@NotNull Project project2, @Nullable RelativePoint hyperlinkLocationPoint) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/filters/impl/MultipleFilesHyperlinkInfo", "navigate"));
        }
        ArrayList<PsiFile> currentFiles = new ArrayList<PsiFile>();
        AccessToken accessToken = ReadAction.start();
        try {
            for (VirtualFile file2 : this.myVirtualFiles) {
                PsiFile psiFile;
                if (!file2.isValid() || (psiFile = PsiManager.getInstance((Project)project2).findFile(file2)) == null) continue;
                PsiElement navigationElement = psiFile.getNavigationElement();
                if (navigationElement instanceof PsiFile) {
                    currentFiles.add((PsiFile)navigationElement);
                    continue;
                }
                currentFiles.add(psiFile);
            }
        }
        finally {
            accessToken.finish();
        }
        if (currentFiles.isEmpty()) {
            return;
        }
        if (currentFiles.size() == 1) {
            new OpenFileHyperlinkInfo(this.myProject, ((PsiFile)currentFiles.get(0)).getVirtualFile(), this.myLineNumber).navigate(project2);
        } else {
            JBList list2 = new JBList(currentFiles);
            int width = WindowManager.getInstance().getFrame((Project)project2).getSize().width;
            list2.setCellRenderer((ListCellRenderer)new GotoFileCellRenderer(width));
            JBPopup popup = JBPopupFactory.getInstance().createListPopupBuilder((JList)list2).setTitle("Choose Target File").setItemChoosenCallback(() -> {
                if (project2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/filters/impl/MultipleFilesHyperlinkInfo", "lambda$navigate$0"));
                }
                VirtualFile file2 = ((PsiFile)list2.getSelectedValue()).getVirtualFile();
                new OpenFileHyperlinkInfo(this.myProject, file2, this.myLineNumber).navigate(project2);
            }).createPopup();
            if (hyperlinkLocationPoint != null) {
                popup.show(hyperlinkLocationPoint);
            } else {
                popup.showInFocusCenter();
            }
        }
    }

    @Nullable
    public OpenFileDescriptor getDescriptor() {
        VirtualFile file2 = this.getPreferredFile();
        return file2 != null ? new OpenFileDescriptor(this.myProject, file2, this.myLineNumber, 0) : null;
    }

    @Nullable
    private VirtualFile getPreferredFile() {
        return (VirtualFile)ContainerUtil.getFirstItem(this.myVirtualFiles);
    }
}

