/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.ProjectTopics;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleServiceManager;
import com.intellij.openapi.project.ModuleListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="ModuleRunConfigurationManager")
public final class ModuleRunConfigurationManager
implements PersistentStateComponent<Element> {
    @NonNls
    @NotNull
    private static final String STORE_LOCAL_REGISTRY_OPTION = "ruby.store.local.run.conf.in.modules";
    private static final String SHARED = "shared";
    private static final String LOCAL = "local";
    private static final Logger LOG = Logger.getInstance(ModuleRunConfigurationManager.class);
    @NotNull
    private final Module myModule;
    @NotNull
    private final Condition<RunnerAndConfigurationSettings> myModuleConfigCondition;

    public ModuleRunConfigurationManager(@NotNull Module module2) {
        if (module2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/execution/impl/ModuleRunConfigurationManager", "<init>"));
        }
        this.myModuleConfigCondition = settings -> settings != null && this.usesMyModule(settings.getConfiguration());
        this.myModule = module2;
        this.myModule.getMessageBus().connect().subscribe(ProjectTopics.MODULES, (Object)new ModuleListener(){

            public void beforeModuleRemoved(@NotNull Project project2, @NotNull Module module2) {
                if (project2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/impl/ModuleRunConfigurationManager$1", "beforeModuleRemoved"));
                }
                if (module2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/execution/impl/ModuleRunConfigurationManager$1", "beforeModuleRemoved"));
                }
                if (ModuleRunConfigurationManager.this.myModule.equals(module2)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("time to remove something from project (" + project2 + ")");
                    }
                    ModuleRunConfigurationManager.this.getRunManager().removeConfigurations(ModuleRunConfigurationManager.this.getModuleRunConfigurationSettings());
                }
            }
        });
    }

    @Nullable
    public Element getState() {
        try {
            Element element = new Element("state").addContent(this.writeExternal(new Element(SHARED), true));
            if (Registry.is((String)STORE_LOCAL_REGISTRY_OPTION)) {
                element.addContent(this.writeExternal(new Element(LOCAL), false));
            }
            return element;
        }
        catch (WriteExternalException e1) {
            LOG.error((Throwable)e1);
            return null;
        }
    }

    public void loadState(Element state) {
        try {
            this.readExternal(state);
        }
        catch (InvalidDataException e) {
            LOG.error((Throwable)e);
        }
    }

    @NotNull
    private Collection<? extends RunnerAndConfigurationSettings> getModuleRunConfigurationSettings() {
        List list2 = ContainerUtil.filter(this.getRunManager().getAllSettings(), this.myModuleConfigCondition);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/impl/ModuleRunConfigurationManager", "getModuleRunConfigurationSettings"));
        }
        return list2;
    }

    @NotNull
    private RunManagerImpl getRunManager() {
        RunManagerImpl runManagerImpl = (RunManagerImpl)RunManager.getInstance((Project)this.myModule.getProject());
        if (runManagerImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/impl/ModuleRunConfigurationManager", "getRunManager"));
        }
        return runManagerImpl;
    }

    private boolean usesMyModule(RunConfiguration config) {
        return config instanceof ModuleBasedConfiguration && this.myModule.equals(((ModuleBasedConfiguration)config).getConfigurationModule().getModule());
    }

    public Element writeExternal(@NotNull Element element, boolean isShared) throws WriteExternalException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/execution/impl/ModuleRunConfigurationManager", "writeExternal"));
        }
        LOG.debug("writeExternal(" + this.myModule + "); shared: " + isShared);
        this.getRunManager().writeConfigurations(element, this.getModuleRunConfigurationSettings().stream().filter(settings -> settings.isShared() == isShared).collect(Collectors.toList()));
        return element;
    }

    public void readExternal(@NotNull Element element) {
        Element localElement;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/execution/impl/ModuleRunConfigurationManager", "readExternal"));
        }
        Element sharedElement = element.getChild(SHARED);
        if (sharedElement != null) {
            this.doReadExternal(sharedElement, true);
        }
        if ((localElement = element.getChild(LOCAL)) != null) {
            this.doReadExternal(localElement, false);
        }
    }

    private void doReadExternal(@NotNull Element element, boolean isShared) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/execution/impl/ModuleRunConfigurationManager", "doReadExternal"));
        }
        LOG.debug("readExternal(" + this.myModule + ");  shared: " + isShared);
        RunManagerImpl runManager = this.getRunManager();
        for (Element child : element.getChildren("configuration")) {
            runManager.loadConfiguration(child, isShared);
        }
        runManager.requestSort();
    }

    static class ModuleRunConfigurationManagerStartupActivity
    implements StartupActivity {
        ModuleRunConfigurationManagerStartupActivity() {
        }

        public void runActivity(@NotNull Project project2) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/impl/ModuleRunConfigurationManager$ModuleRunConfigurationManagerStartupActivity", "runActivity"));
            }
            if (!project2.isDefault()) {
                for (Module module2 : ModuleManager.getInstance((Project)project2).getModules()) {
                    if (module2.isDisposed()) continue;
                    ModuleServiceManager.getService((Module)module2, ModuleRunConfigurationManager.class);
                }
            }
        }
    }
}

