/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.lineMarker;

import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.BaseRunConfigurationAction;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.actions.ConfigurationFromContextImpl;
import com.intellij.execution.actions.RunConfigurationProducer;
import com.intellij.execution.configurations.LocatableConfiguration;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.impl.RunnerAndConfigurationSettingsImpl;
import com.intellij.execution.lineMarker.ExecutorActionKt;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\b\u0018\u0000  2\u00020\u0001:\u0001 B\u001f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u000eH\u0016J\u0013\u0010\u0012\u001a\u00020\u000e2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0096\u0002J\u001a\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u001d\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00030\u00192\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016\u00a2\u0006\u0002\u0010\u001aJ\b\u0010\u001b\u001a\u00020\u0007H\u0016J\b\u0010\u001c\u001a\u00020\u000eH\u0016J\b\u0010\u001d\u001a\u00020\u000eH\u0016J\b\u0010\u001e\u001a\u00020\u000eH\u0016J\u0010\u0010\u001f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/intellij/execution/lineMarker/ExecutorAction;", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "origin", "Lcom/intellij/openapi/actionSystem/AnAction;", "executor", "Lcom/intellij/execution/Executor;", "order", "", "(Lcom/intellij/openapi/actionSystem/AnAction;Lcom/intellij/execution/Executor;I)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "canBePerformed", "", "context", "Lcom/intellij/openapi/actionSystem/DataContext;", "disableIfNoVisibleChildren", "equals", "other", "", "getActionName", "", "dataContext", "getChildren", "", "(Lcom/intellij/openapi/actionSystem/AnActionEvent;)[Lcom/intellij/openapi/actionSystem/AnAction;", "hashCode", "hideIfNoVisibleChildren", "isDumbAware", "isPopup", "update", "Companion", "lang-impl"})
public final class ExecutorAction
extends ActionGroup {
    private final AnAction origin;
    private final Executor executor;
    private final int order;
    public static final Companion Companion = new Companion(null);

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        DataContext dataContext = e.getDataContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)dataContext, (String)"e.dataContext");
        String name2 = this.getActionName(dataContext, this.executor);
        e.getPresentation().setEnabledAndVisible(name2 != null);
        this.origin.update(e);
        e.getPresentation().setText(name2);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        this.origin.actionPerformed(e);
    }

    public boolean canBePerformed(@NotNull DataContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return !(this.origin instanceof ActionGroup) || ((ActionGroup)this.origin).canBePerformed(context);
    }

    @NotNull
    public AnAction[] getChildren(@Nullable AnActionEvent e) {
        AnAction[] anActionArray;
        AnAction anAction = this.origin;
        if (!(anAction instanceof ActionGroup)) {
            anAction = null;
        }
        if ((anActionArray = (AnAction[])anAction) == null || (anActionArray = anActionArray.getChildren(e)) == null) {
            anActionArray = AnAction.EMPTY_ARRAY;
            Intrinsics.checkExpressionValueIsNotNull((Object)AnAction.EMPTY_ARRAY, (String)"AnAction.EMPTY_ARRAY");
        }
        return anActionArray;
    }

    public boolean isDumbAware() {
        return this.origin.isDumbAware();
    }

    public boolean isPopup() {
        return !(this.origin instanceof ActionGroup) || ((ActionGroup)this.origin).isPopup();
    }

    public boolean hideIfNoVisibleChildren() {
        return this.origin instanceof ActionGroup && ((ActionGroup)this.origin).hideIfNoVisibleChildren();
    }

    public boolean disableIfNoVisibleChildren() {
        return !(this.origin instanceof ActionGroup) || ((ActionGroup)this.origin).disableIfNoVisibleChildren();
    }

    private final String getActionName(DataContext dataContext, Executor executor) {
        List list2 = ExecutorAction.Companion.getConfigurations(dataContext);
        if (list2.isEmpty()) {
            return null;
        }
        ConfigurationFromContext configurationFromContext = (ConfigurationFromContext)CollectionsKt.getOrNull((List)list2, (int)(this.order < list2.size() ? this.order : 0));
        Object object = configurationFromContext != null ? configurationFromContext.getConfiguration() : null;
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.execution.configurations.LocatableConfiguration");
        }
        LocatableConfiguration configuration = (LocatableConfiguration)object;
        return executor.getStartActionText(BaseRunConfigurationAction.suggestRunActionName(configuration));
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (Intrinsics.areEqual(object != null ? object.getClass() : null, ((Object)((Object)this)).getClass()) ^ true) {
            return false;
        }
        Object object2 = other;
        if (object2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.execution.lineMarker.ExecutorAction");
        }
        ExecutorAction cfr_ignored_0 = (ExecutorAction)((Object)object2);
        if (Intrinsics.areEqual((Object)this.origin, (Object)((ExecutorAction)((Object)other)).origin) ^ true) {
            return false;
        }
        if (Intrinsics.areEqual((Object)this.executor, (Object)((ExecutorAction)((Object)other)).executor) ^ true) {
            return false;
        }
        return this.order == ((ExecutorAction)((Object)other)).order;
    }

    public int hashCode() {
        int result2 = this.origin.hashCode();
        result2 = 31 * result2 + this.executor.hashCode();
        result2 = 31 * result2 + this.order;
        return result2;
    }

    private ExecutorAction(AnAction origin, Executor executor, int order) {
        this.origin = origin;
        this.executor = executor;
        this.order = order;
        this.copyFrom(this.origin);
    }

    public /* synthetic */ ExecutorAction(@NotNull AnAction origin, @NotNull Executor executor, int order, DefaultConstructorMarker $constructor_marker) {
        this(origin, executor, order);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final AnAction[] getActions(int order) {
        return Companion.getActions(order);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final AnAction[] getActions() {
        return com.intellij.execution.lineMarker.ExecutorAction$Companion.getActions$default(Companion, 0, 1, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final List<AnAction> getActionList(int order) {
        return Companion.getActionList(order);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final List<AnAction> getActionList() {
        return com.intellij.execution.lineMarker.ExecutorAction$Companion.getActionList$default(Companion, 0, 1, null);
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0018\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u00042\b\b\u0002\u0010\n\u001a\u00020\u000bH\u0007J\u001d\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\r2\b\b\u0002\u0010\n\u001a\u00020\u000bH\u0007\u00a2\u0006\u0002\u0010\u000eJ\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\u0010"}, d2={"Lcom/intellij/execution/lineMarker/ExecutorAction$Companion;", "", "()V", "computeConfigurations", "", "Lcom/intellij/execution/actions/ConfigurationFromContext;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "getActionList", "Lcom/intellij/openapi/actionSystem/AnAction;", "order", "", "getActions", "", "(I)[Lcom/intellij/openapi/actionSystem/AnAction;", "getConfigurations", "lang-impl"})
    public static final class Companion {
        @JvmStatic
        @JvmOverloads
        @NotNull
        public final AnAction[] getActions(int order) {
            Collection $receiver$iv;
            Collection collection = $receiver$iv = (Collection)this.getActionList(order);
            if (collection == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
            }
            Collection thisCollection$iv = collection;
            AnAction[] anActionArray = thisCollection$iv.toArray(new AnAction[thisCollection$iv.size()]);
            if (anActionArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            return anActionArray;
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public static /* bridge */ /* synthetic */ AnAction[] getActions$default(Companion companion, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = 0;
            }
            return companion.getActions(n);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final AnAction[] getActions() {
            return com.intellij.execution.lineMarker.ExecutorAction$Companion.getActions$default(this, 0, 1, null);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @JvmOverloads
        @NotNull
        public final List<AnAction> getActionList(int order) {
            List list2;
            ActionManager actionManager = ActionManager.getInstance();
            Object[] $receiver$iv = ExecutorRegistry.getInstance().getRegisteredExecutors();
            int size$iv = $receiver$iv.length;
            switch (size$iv) {
                case 1: {
                    void it;
                    SmartList smartList;
                    Executor executor = (Executor)$receiver$iv[0];
                    SmartList smartList2 = smartList;
                    SmartList smartList3 = smartList;
                    AnAction anAction = actionManager.getAction(it.getContextActionId());
                    Intrinsics.checkExpressionValueIsNotNull((Object)anAction, (String)"actionManager.getAction(it.contextActionId)");
                    void v2 = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"it");
                    ExecutorAction executorAction = new ExecutorAction(anAction, (Executor)v2, order, null);
                    smartList2((Object)executorAction);
                    list2 = (List)smartList3;
                    break;
                }
                case 0: {
                    list2 = (List)new SmartList();
                    break;
                }
                default: {
                    void $receiver$iv$iv;
                    Object[] objectArray = $receiver$iv;
                    Collection destination$iv$iv = new ArrayList(size$iv);
                    for (int j = 0; j < ((void)$receiver$iv$iv).length; ++j) {
                        void item$iv$iv = $receiver$iv$iv[j];
                        Executor it = (Executor)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        AnAction anAction = actionManager.getAction(it.getContextActionId());
                        Intrinsics.checkExpressionValueIsNotNull((Object)anAction, (String)"actionManager.getAction(it.contextActionId)");
                        Executor executor = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)executor, (String)"it");
                        ExecutorAction executorAction = new ExecutorAction(anAction, executor, order, null);
                        collection.add(executorAction);
                    }
                    list2 = (List)destination$iv$iv;
                }
            }
            return list2;
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public static /* bridge */ /* synthetic */ List getActionList$default(Companion companion, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = 0;
            }
            return companion.getActionList(n);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final List<AnAction> getActionList() {
            return com.intellij.execution.lineMarker.ExecutorAction$Companion.getActionList$default(this, 0, 1, null);
        }

        private final List<ConfigurationFromContext> getConfigurations(DataContext dataContext) {
            List<ConfigurationFromContext> result2 = (List<ConfigurationFromContext>)DataManager.getInstance().loadFromDataContext(dataContext, ExecutorActionKt.access$getCONFIGURATION_CACHE$p());
            if (result2 == null) {
                result2 = this.computeConfigurations(dataContext);
                DataManager.getInstance().saveInDataContext(dataContext, ExecutorActionKt.access$getCONFIGURATION_CACHE$p(), result2);
            }
            return result2;
        }

        /*
         * WARNING - void declaration
         */
        private final List<ConfigurationFromContext> computeConfigurations(DataContext dataContext) {
            List list2;
            ConfigurationContext context = ConfigurationContext.getFromContext((DataContext)dataContext);
            if (context.getLocation() == null) {
                return CollectionsKt.emptyList();
            }
            Collection $receiver$iv = RunConfigurationProducer.getProducers((Project)context.getProject());
            int size$iv = $receiver$iv.size();
            if (size$iv == 1) {
                ConfigurationFromContextImpl configurationFromContextImpl;
                RunConfigurationProducer it = (RunConfigurationProducer)CollectionsKt.first((Iterable)$receiver$iv);
                Logger $receiver$iv2 = ExecutorActionKt.access$getLOG$p();
                try {
                    RunConfiguration runConfiguration = it.createLightConfiguration(context);
                    if (runConfiguration == null) {
                        configurationFromContextImpl = null;
                    } else {
                        RunConfiguration configuration = runConfiguration;
                        Project project2 = context.getProject();
                        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"context.project");
                        RunnerAndConfigurationSettingsImpl settings = new RunnerAndConfigurationSettingsImpl(RunManagerImpl.Companion.getInstanceImpl(project2), configuration, false, false, null, 24, null);
                        configurationFromContextImpl = new ConfigurationFromContextImpl(it, (RunnerAndConfigurationSettings)settings, context.getPsiLocation());
                    }
                }
                catch (ProcessCanceledException e$iv) {
                    configurationFromContextImpl = null;
                }
                catch (Throwable e$iv) {
                    $receiver$iv2.error(e$iv);
                    configurationFromContextImpl = null;
                }
                if (configurationFromContextImpl != null) {
                    ConfigurationFromContextImpl configurationFromContextImpl2;
                    ConfigurationFromContextImpl it$iv = configurationFromContextImpl2 = configurationFromContextImpl;
                    list2 = (List)new SmartList(it$iv);
                } else {
                    list2 = (List)new SmartList();
                }
            } else {
                void $receiver$iv$iv;
                Iterable iterable = $receiver$iv;
                Collection destination$iv$iv = new ArrayList(size$iv);
                void $receiver$iv$iv$iv = $receiver$iv$iv;
                Iterator iterator = $receiver$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    ConfigurationFromContextImpl configurationFromContextImpl;
                    ConfigurationFromContextImpl configurationFromContextImpl3;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    RunConfigurationProducer it = (RunConfigurationProducer)element$iv$iv;
                    Logger $receiver$iv3 = ExecutorActionKt.access$getLOG$p();
                    try {
                        if (it.createLightConfiguration(context) == null) {
                            configurationFromContextImpl3 = null;
                        } else {
                            RunConfiguration configuration;
                            Project project3 = context.getProject();
                            Intrinsics.checkExpressionValueIsNotNull((Object)project3, (String)"context.project");
                            RunnerAndConfigurationSettingsImpl settings = new RunnerAndConfigurationSettingsImpl(RunManagerImpl.Companion.getInstanceImpl(project3), configuration, false, false, null, 24, null);
                            configurationFromContextImpl3 = new ConfigurationFromContextImpl(it, (RunnerAndConfigurationSettings)settings, context.getPsiLocation());
                        }
                    }
                    catch (ProcessCanceledException e$iv) {
                        configurationFromContextImpl3 = null;
                    }
                    catch (Throwable e$iv) {
                        $receiver$iv3.error(e$iv);
                        configurationFromContextImpl3 = null;
                    }
                    if (configurationFromContextImpl3 == null) continue;
                    ConfigurationFromContextImpl it$iv$iv = configurationFromContextImpl = configurationFromContextImpl3;
                    destination$iv$iv.add(it$iv$iv);
                }
                list2 = (List)destination$iv$iv;
            }
            return list2;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

