/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework;

import com.intellij.concurrency.SensitiveProgressWrapper;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SearchForTestsTask
extends Task.Backgroundable {
    private static final Logger LOG = Logger.getInstance(SearchForTestsTask.class);
    protected Socket mySocket;
    private ServerSocket myServerSocket;
    private ProgressIndicator myProcessIndicator;

    public SearchForTestsTask(@Nullable Project project2, ServerSocket socket) {
        super(project2, ExecutionBundle.message((String)"searching.test.progress.title", (Object[])new Object[0]), true);
        this.myServerSocket = socket;
    }

    protected abstract void search() throws ExecutionException;

    protected abstract void onFound() throws ExecutionException;

    public void ensureFinished() {
        if (this.myProcessIndicator != null && !this.myProcessIndicator.isCanceled()) {
            this.finish();
        }
    }

    public void startSearch() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            try {
                this.search();
            }
            catch (Throwable e) {
                LOG.error(e);
            }
            try {
                this.onFound();
            }
            catch (ExecutionException e) {
                LOG.error((Throwable)e);
            }
        } else {
            this.myProcessIndicator = new BackgroundableProcessIndicator(this);
            ProgressManager.getInstance().runProcessWithProgressAsynchronously((Task.Backgroundable)this, this.myProcessIndicator);
        }
    }

    public void attachTaskToProcess(final OSProcessHandler handler2) {
        handler2.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void processTerminated(ProcessEvent event) {
                handler2.removeProcessListener((ProcessListener)this);
                SearchForTestsTask.this.ensureFinished();
            }

            public void startNotified(ProcessEvent event) {
                SearchForTestsTask.this.startSearch();
            }
        });
    }

    public void run(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/execution/testframework/SearchForTestsTask", "run"));
        }
        try {
            this.mySocket = this.myServerSocket.accept();
            ExecutionException[] ex = new ExecutionException[1];
            Runnable runnable2 = () -> {
                try {
                    this.search();
                }
                catch (ExecutionException e) {
                    ex[0] = e;
                }
            };
            while (!this.runSmartModeReadActionWithWritePriority(runnable2, new SensitiveProgressWrapper(indicator))) {
            }
            if (ex[0] != null) {
                this.logCantRunException(ex[0]);
            }
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
        }
        catch (Throwable e) {
            LOG.error(e);
        }
    }

    private boolean runSmartModeReadActionWithWritePriority(@NotNull Runnable runnable2, ProgressIndicator indicator) {
        if (runnable2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/execution/testframework/SearchForTestsTask", "runSmartModeReadActionWithWritePriority"));
        }
        DumbService dumbService = DumbService.getInstance((Project)this.myProject);
        indicator.checkCanceled();
        dumbService.waitForSmartMode();
        AtomicBoolean dumb = new AtomicBoolean();
        boolean success = ProgressIndicatorUtils.runInReadActionWithWriteActionPriority(() -> {
            if (runnable2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/execution/testframework/SearchForTestsTask", "lambda$runSmartModeReadActionWithWritePriority$1"));
            }
            if (this.myProject.isDisposed()) {
                return;
            }
            if (dumbService.isDumb()) {
                dumb.set(true);
                return;
            }
            runnable2.run();
        }, indicator);
        if (dumb.get()) {
            return false;
        }
        if (!success) {
            ProgressIndicatorUtils.yieldToPendingWriteActions();
        }
        return success;
    }

    protected void logCantRunException(ExecutionException e) throws ExecutionException {
        throw e;
    }

    public void onCancel() {
        this.finish();
    }

    public void onSuccess() {
        DumbService.getInstance((Project)this.getProject()).runWhenSmart(() -> {
            try {
                this.onFound();
            }
            catch (ExecutionException e) {
                LOG.error((Throwable)e);
            }
            this.finish();
        });
    }

    public void finish() {
        FilterOutputStream os = null;
        try {
            if (this.mySocket == null || this.mySocket.isClosed()) {
                return;
            }
            os = new DataOutputStream(this.mySocket.getOutputStream());
            ((DataOutputStream)os).writeBoolean(true);
        }
        catch (Throwable e) {
            LOG.info(e);
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (Throwable e) {
                LOG.info(e);
            }
            try {
                if (!this.myServerSocket.isClosed()) {
                    this.myServerSocket.close();
                }
            }
            catch (Throwable e) {
                LOG.info(e);
            }
        }
    }
}

