/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.actions;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.RunnerRegistry;
import com.intellij.execution.configurations.ConfigurationInfoProvider;
import com.intellij.execution.configurations.ConfigurationPerRunnerSettings;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.LogFileOptions;
import com.intellij.execution.configurations.ModuleRunProfile;
import com.intellij.execution.configurations.PredefinedLogFile;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.WrappingRunConfiguration;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.Filter;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.TestFrameworkRunningModel;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentContainer;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.components.JBList;
import com.intellij.util.config.AbstractProperty;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AbstractRerunFailedTestsAction
extends AnAction
implements AnAction.TransparentUpdate {
    private static final Logger LOG = Logger.getInstance(AbstractRerunFailedTestsAction.class);
    private TestFrameworkRunningModel myModel;
    private Getter<TestFrameworkRunningModel> myModelProvider;
    protected TestConsoleProperties myConsoleProperties;

    protected AbstractRerunFailedTestsAction(@NotNull ComponentContainer componentContainer) {
        if (componentContainer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentContainer", "com/intellij/execution/testframework/actions/AbstractRerunFailedTestsAction", "<init>"));
        }
        this.copyFrom(ActionManager.getInstance().getAction("RerunFailedTests"));
        this.registerCustomShortcutSet(this.getShortcutSet(), componentContainer.getComponent());
    }

    public void init(TestConsoleProperties consoleProperties) {
        this.myConsoleProperties = consoleProperties;
    }

    public void setModel(TestFrameworkRunningModel model) {
        this.myModel = model;
    }

    public void setModelProvider(Getter<TestFrameworkRunningModel> modelProvider) {
        this.myModelProvider = modelProvider;
    }

    public final void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/execution/testframework/actions/AbstractRerunFailedTestsAction", "update"));
        }
        e.getPresentation().setEnabled(this.isActive(e));
    }

    private boolean isActive(AnActionEvent e) {
        Project project2 = e.getProject();
        if (project2 == null) {
            return false;
        }
        TestFrameworkRunningModel model = this.getModel();
        if (model == null || model.getRoot() == null) {
            return false;
        }
        Filter<?> filter = this.getFailuresFilter();
        for (AbstractTestProxy abstractTestProxy : model.getRoot().getAllTests()) {
            if (!filter.shouldAccept(abstractTestProxy)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    protected List<AbstractTestProxy> getFailedTests(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/testframework/actions/AbstractRerunFailedTestsAction", "getFailedTests"));
        }
        TestFrameworkRunningModel model = this.getModel();
        if (model == null) {
            List<AbstractTestProxy> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/testframework/actions/AbstractRerunFailedTestsAction", "getFailedTests"));
            }
            return list2;
        }
        List<AbstractTestProxy> list3 = this.getFilter(project2, model.getProperties().getScope()).select(model.getRoot().getAllTests());
        if (list3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/testframework/actions/AbstractRerunFailedTestsAction", "getFailedTests"));
        }
        return list3;
    }

    @NotNull
    protected Filter getFilter(@NotNull Project project2, @NotNull GlobalSearchScope searchScope) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/testframework/actions/AbstractRerunFailedTestsAction", "getFilter"));
        }
        if (searchScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "com/intellij/execution/testframework/actions/AbstractRerunFailedTestsAction", "getFilter"));
        }
        Filter<?> filter = this.getFailuresFilter();
        if (filter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/testframework/actions/AbstractRerunFailedTestsAction", "getFilter"));
        }
        return filter;
    }

    protected Filter<?> getFailuresFilter() {
        return AbstractRerunFailedTestsAction.getFailuresFilter(this.myConsoleProperties);
    }

    public static Filter<?> getFailuresFilter(TestConsoleProperties consoleProperties) {
        if (TestConsoleProperties.INCLUDE_NON_STARTED_IN_RERUN_FAILED.value((AbstractProperty.AbstractPropertyContainer)consoleProperties)) {
            return Filter.NOT_PASSED.or(Filter.FAILED_OR_INTERRUPTED).and(Filter.IGNORED.not());
        }
        return Filter.FAILED_OR_INTERRUPTED.and(Filter.IGNORED.not());
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/execution/testframework/actions/AbstractRerunFailedTestsAction", "actionPerformed"));
        }
        ExecutionEnvironment environment = (ExecutionEnvironment)e.getData(LangDataKeys.EXECUTION_ENVIRONMENT);
        if (environment == null) {
            return;
        }
        this.execute(e, environment);
    }

    void execute(@NotNull AnActionEvent e, @NotNull ExecutionEnvironment environment) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/execution/testframework/actions/AbstractRerunFailedTestsAction", "execute"));
        }
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "com/intellij/execution/testframework/actions/AbstractRerunFailedTestsAction", "execute"));
        }
        MyRunProfile profile2 = this.getRunProfile(environment);
        if (profile2 == null) {
            return;
        }
        ExecutionEnvironmentBuilder environmentBuilder = new ExecutionEnvironmentBuilder(environment).runProfile((RunProfile)profile2);
        InputEvent event = e.getInputEvent();
        if (!(event instanceof MouseEvent) || !event.isShiftDown()) {
            AbstractRerunFailedTestsAction.performAction(environmentBuilder);
            return;
        }
        LinkedHashMap<Executor, ProgramRunner> availableRunners = new LinkedHashMap<Executor, ProgramRunner>();
        for (Executor ex : new Executor[]{DefaultRunExecutor.getRunExecutorInstance(), DefaultDebugExecutor.getDebugExecutorInstance()}) {
            ProgramRunner runner = RunnerRegistry.getInstance().getRunner(ex.getId(), (RunProfile)profile2);
            if (runner == null) continue;
            availableRunners.put(ex, runner);
        }
        if (availableRunners.isEmpty()) {
            LOG.error(environment.getExecutor().getActionName() + " is not available now");
        } else if (availableRunners.size() == 1) {
            AbstractRerunFailedTestsAction.performAction(environmentBuilder.runner((ProgramRunner)availableRunners.get(environment.getExecutor())));
        } else {
            JBList list2 = new JBList(availableRunners.keySet());
            list2.setSelectionMode(0);
            list2.setSelectedValue((Object)environment.getExecutor(), true);
            list2.setCellRenderer((ListCellRenderer)new DefaultListCellRenderer(){

                @Override
                @NotNull
                public Component getListCellRendererComponent(@NotNull JList list2, Object value2, int index, boolean isSelected, boolean cellHasFocus) {
                    if (list2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/execution/testframework/actions/AbstractRerunFailedTestsAction$1", "getListCellRendererComponent"));
                    }
                    Component component = super.getListCellRendererComponent((JList<?>)list2, value2, index, isSelected, cellHasFocus);
                    if (value2 instanceof Executor) {
                        this.setText(UIUtil.removeMnemonic((String)((Executor)value2).getStartActionText()));
                        this.setIcon(((Executor)value2).getIcon());
                    }
                    Component component2 = component;
                    if (component2 == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/testframework/actions/AbstractRerunFailedTestsAction$1", "getListCellRendererComponent"));
                    }
                    return component2;
                }
            });
            JBPopupFactory.getInstance().createListPopupBuilder((JList)list2).setTitle("Restart Failed Tests").setMovable(false).setResizable(false).setRequestFocus(true).setItemChoosenCallback(() -> {
                Object value2 = list2.getSelectedValue();
                if (value2 instanceof Executor) {
                    AbstractRerunFailedTestsAction.performAction(environmentBuilder.runner((ProgramRunner)availableRunners.get(value2)).executor((Executor)value2));
                }
            }).createPopup().showUnderneathOf(event.getComponent());
        }
    }

    private static void performAction(@NotNull ExecutionEnvironmentBuilder builder) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/execution/testframework/actions/AbstractRerunFailedTestsAction", "performAction"));
        }
        ExecutionEnvironment environment = builder.build();
        try {
            environment.getRunner().execute(environment);
        }
        catch (ExecutionException e) {
            LOG.error((Throwable)e);
        }
        finally {
            ((MyRunProfile)environment.getRunProfile()).clear();
        }
    }

    @Deprecated
    public MyRunProfile getRunProfile() {
        return null;
    }

    @Nullable
    protected MyRunProfile getRunProfile(@NotNull ExecutionEnvironment environment) {
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "com/intellij/execution/testframework/actions/AbstractRerunFailedTestsAction", "getRunProfile"));
        }
        return this.getRunProfile();
    }

    @Nullable
    public TestFrameworkRunningModel getModel() {
        if (this.myModel != null) {
            return this.myModel;
        }
        if (this.myModelProvider != null) {
            return (TestFrameworkRunningModel)this.myModelProvider.get();
        }
        return null;
    }

    public boolean isDumbAware() {
        return Registry.is((String)"dumb.aware.run.configurations");
    }

    protected static abstract class MyRunProfile
    extends RunConfigurationBase
    implements ModuleRunProfile,
    WrappingRunConfiguration<RunConfigurationBase> {
        private final RunConfigurationBase myConfiguration;

        @Deprecated
        public RunConfigurationBase getConfiguration() {
            return this.getPeer();
        }

        public RunConfigurationBase getPeer() {
            return this.myConfiguration;
        }

        public MyRunProfile(RunConfigurationBase configuration) {
            super(configuration.getProject(), configuration.getFactory(), ActionsBundle.message((String)"action.RerunFailedTests.text", (Object[])new Object[0]));
            this.myConfiguration = configuration;
        }

        public void clear() {
        }

        public void readExternal(Element element) throws InvalidDataException {
            this.myConfiguration.readExternal(element);
        }

        public void writeExternal(Element element) throws WriteExternalException {
            this.myConfiguration.writeExternal(element);
        }

        @NotNull
        public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
            SettingsEditor settingsEditor = this.myConfiguration.getConfigurationEditor();
            if (settingsEditor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/testframework/actions/AbstractRerunFailedTestsAction$MyRunProfile", "getConfigurationEditor"));
            }
            return settingsEditor;
        }

        @NotNull
        public ConfigurationType getType() {
            ConfigurationType configurationType = this.myConfiguration.getType();
            if (configurationType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/testframework/actions/AbstractRerunFailedTestsAction$MyRunProfile", "getType"));
            }
            return configurationType;
        }

        public ConfigurationPerRunnerSettings createRunnerSettings(ConfigurationInfoProvider provider) {
            return this.myConfiguration.createRunnerSettings(provider);
        }

        public SettingsEditor<ConfigurationPerRunnerSettings> getRunnerSettingsEditor(ProgramRunner runner) {
            return this.myConfiguration.getRunnerSettingsEditor(runner);
        }

        public RunConfiguration clone() {
            return this.myConfiguration.clone();
        }

        public int getUniqueID() {
            return this.myConfiguration.getUniqueID();
        }

        public LogFileOptions getOptionsForPredefinedLogFile(PredefinedLogFile predefinedLogFile) {
            return this.myConfiguration.getOptionsForPredefinedLogFile(predefinedLogFile);
        }

        @NotNull
        public List<PredefinedLogFile> getPredefinedLogFiles() {
            List list2 = this.myConfiguration.getPredefinedLogFiles();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/testframework/actions/AbstractRerunFailedTestsAction$MyRunProfile", "getPredefinedLogFiles"));
            }
            return list2;
        }

        @NotNull
        public ArrayList<LogFileOptions> getAllLogFiles() {
            ArrayList arrayList = this.myConfiguration.getAllLogFiles();
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/testframework/actions/AbstractRerunFailedTestsAction$MyRunProfile", "getAllLogFiles"));
            }
            return arrayList;
        }

        @NotNull
        public List<LogFileOptions> getLogFiles() {
            List list2 = this.myConfiguration.getLogFiles();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/testframework/actions/AbstractRerunFailedTestsAction$MyRunProfile", "getLogFiles"));
            }
            return list2;
        }
    }
}

