/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm;

import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.testframework.sm.TestsLocationProviderUtil;
import com.intellij.execution.testframework.sm.runner.SMTestLocator;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileUrlProvider
implements SMTestLocator,
DumbAware {
    public static final FileUrlProvider INSTANCE = new FileUrlProvider();

    @Override
    @NotNull
    public List<Location> getLocation(@NotNull String protocol, @NotNull String path, @NotNull Project project2, @NotNull GlobalSearchScope scope) {
        int columnNumber;
        int lineNumber;
        String filePath;
        if (protocol == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "protocol", "com/intellij/execution/testframework/sm/FileUrlProvider", "getLocation"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/execution/testframework/sm/FileUrlProvider", "getLocation"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/testframework/sm/FileUrlProvider", "getLocation"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/execution/testframework/sm/FileUrlProvider", "getLocation"));
        }
        if (!"file".equals(protocol)) {
            List<Location> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/testframework/sm/FileUrlProvider", "getLocation"));
            }
            return list2;
        }
        int lastColonIndex = path.lastIndexOf(58);
        if (lastColonIndex > 3) {
            int lastValue = StringUtil.parseInt((String)path.substring(lastColonIndex + 1), (int)-1);
            int penultimateColonIndex = path.lastIndexOf(58, lastColonIndex - 1);
            if (penultimateColonIndex > 3) {
                int penultimateValue = StringUtil.parseInt((String)path.substring(penultimateColonIndex + 1, lastColonIndex), (int)-1);
                filePath = path.substring(0, penultimateColonIndex);
                lineNumber = penultimateValue;
                columnNumber = lineNumber <= 0 ? -1 : lastValue;
            } else {
                filePath = path.substring(0, lastColonIndex);
                lineNumber = lastValue;
                columnNumber = -1;
            }
        } else {
            filePath = path;
            lineNumber = -1;
            columnNumber = -1;
        }
        String systemIndependentPath = FileUtil.toSystemIndependentName((String)filePath);
        List<VirtualFile> virtualFiles = TestsLocationProviderUtil.findSuitableFilesFor(systemIndependentPath, project2);
        if (virtualFiles.isEmpty()) {
            List<Location> list3 = Collections.emptyList();
            if (list3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/testframework/sm/FileUrlProvider", "getLocation"));
            }
            return list3;
        }
        ArrayList<Location> locations = new ArrayList<Location>(2);
        for (VirtualFile file2 : virtualFiles) {
            locations.add(FileUrlProvider.createLocationFor(project2, file2, lineNumber, columnNumber));
        }
        ArrayList<Location> arrayList = locations;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/testframework/sm/FileUrlProvider", "getLocation"));
        }
        return arrayList;
    }

    @Nullable
    public static Location createLocationFor(@NotNull Project project2, @NotNull VirtualFile virtualFile, int lineNum) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/testframework/sm/FileUrlProvider", "createLocationFor"));
        }
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/execution/testframework/sm/FileUrlProvider", "createLocationFor"));
        }
        return FileUrlProvider.createLocationFor(project2, virtualFile, lineNum, -1);
    }

    @Nullable
    public static Location createLocationFor(@NotNull Project project2, @NotNull VirtualFile virtualFile, int lineNum, int columnNum) {
        int length;
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/testframework/sm/FileUrlProvider", "createLocationFor"));
        }
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/execution/testframework/sm/FileUrlProvider", "createLocationFor"));
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project2).findFile(virtualFile);
        if (psiFile == null) {
            return null;
        }
        if (lineNum <= 0) {
            return PsiLocation.fromPsiElement((PsiElement)psiFile);
        }
        Document doc = PsiDocumentManager.getInstance((Project)project2).getDocument(psiFile);
        if (doc == null) {
            return null;
        }
        if (lineNum > doc.getLineCount()) {
            return PsiLocation.fromPsiElement((PsiElement)psiFile);
        }
        int lineStartOffset = doc.getLineStartOffset(lineNum - 1);
        int endOffset = doc.getLineEndOffset(lineNum - 1);
        PsiElement elementAtLine = null;
        for (int offset = Math.min(lineStartOffset + Math.max(columnNum - 1, 0), endOffset); offset <= endOffset && (elementAtLine = psiFile.findElementAt(offset)) instanceof PsiWhiteSpace; offset += (length = elementAtLine.getTextLength()) > 1 ? length - 1 : 1) {
        }
        return PsiLocation.fromPsiElement((Project)project2, (PsiElement)(elementAtLine != null ? elementAtLine : psiFile));
    }
}

