/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Location;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.sm.FileUrlProvider;
import com.intellij.execution.testframework.sm.SMCustomMessagesParsing;
import com.intellij.execution.testframework.sm.runner.GeneralIdBasedToSMTRunnerEventsConvertor;
import com.intellij.execution.testframework.sm.runner.GeneralTestEventsProcessor;
import com.intellij.execution.testframework.sm.runner.GeneralToSMTRunnerEventsConvertor;
import com.intellij.execution.testframework.sm.runner.OutputToGeneralTestEventsConverter;
import com.intellij.execution.testframework.sm.runner.SMTRunnerConsoleProperties;
import com.intellij.execution.testframework.sm.runner.SMTestLocator;
import com.intellij.execution.testframework.sm.runner.TestProxyFilterProvider;
import com.intellij.execution.testframework.sm.runner.TestProxyPrinterProvider;
import com.intellij.execution.testframework.sm.runner.ui.AttachToProcessListener;
import com.intellij.execution.testframework.sm.runner.ui.SMTRunnerConsoleView;
import com.intellij.execution.testframework.sm.runner.ui.SMTRunnerUIActionsHandler;
import com.intellij.execution.testframework.sm.runner.ui.SMTestRunnerResultsForm;
import com.intellij.execution.testframework.ui.BaseTestsOutputConsoleView;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.testIntegration.TestLocationProvider;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SMTestRunnerConnectionUtil {
    private static final String TEST_RUNNER_DEBUG_MODE_PROPERTY = "idea.smrunner.debug";

    private SMTestRunnerConnectionUtil() {
    }

    @NotNull
    public static BaseTestsOutputConsoleView createAndAttachConsole(@NotNull String testFrameworkName, @NotNull ProcessHandler processHandler2, @NotNull TestConsoleProperties consoleProperties) throws ExecutionException {
        if (testFrameworkName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testFrameworkName", "com/intellij/execution/testframework/sm/SMTestRunnerConnectionUtil", "createAndAttachConsole"));
        }
        if (processHandler2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processHandler", "com/intellij/execution/testframework/sm/SMTestRunnerConnectionUtil", "createAndAttachConsole"));
        }
        if (consoleProperties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consoleProperties", "com/intellij/execution/testframework/sm/SMTestRunnerConnectionUtil", "createAndAttachConsole"));
        }
        BaseTestsOutputConsoleView console = SMTestRunnerConnectionUtil.createConsole(testFrameworkName, consoleProperties);
        console.attachToProcess(processHandler2);
        BaseTestsOutputConsoleView baseTestsOutputConsoleView = console;
        if (baseTestsOutputConsoleView == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/testframework/sm/SMTestRunnerConnectionUtil", "createAndAttachConsole"));
        }
        return baseTestsOutputConsoleView;
    }

    @NotNull
    public static BaseTestsOutputConsoleView createConsole(@NotNull String testFrameworkName, @NotNull TestConsoleProperties consoleProperties) {
        if (testFrameworkName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testFrameworkName", "com/intellij/execution/testframework/sm/SMTestRunnerConnectionUtil", "createConsole"));
        }
        if (consoleProperties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consoleProperties", "com/intellij/execution/testframework/sm/SMTestRunnerConnectionUtil", "createConsole"));
        }
        String splitterPropertyName = SMTestRunnerConnectionUtil.getSplitterPropertyName(testFrameworkName);
        SMTRunnerConsoleView consoleView = new SMTRunnerConsoleView(consoleProperties, splitterPropertyName);
        SMTestRunnerConnectionUtil.initConsoleView(consoleView, testFrameworkName);
        SMTRunnerConsoleView sMTRunnerConsoleView = consoleView;
        if (sMTRunnerConsoleView == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/testframework/sm/SMTestRunnerConnectionUtil", "createConsole"));
        }
        return sMTRunnerConsoleView;
    }

    @NotNull
    public static String getSplitterPropertyName(@NotNull String testFrameworkName) {
        if (testFrameworkName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testFrameworkName", "com/intellij/execution/testframework/sm/SMTestRunnerConnectionUtil", "getSplitterPropertyName"));
        }
        String string = testFrameworkName + ".Splitter.Proportion";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/testframework/sm/SMTestRunnerConnectionUtil", "getSplitterPropertyName"));
        }
        return string;
    }

    public static void initConsoleView(final @NotNull SMTRunnerConsoleView consoleView, final @NotNull String testFrameworkName) {
        if (consoleView == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consoleView", "com/intellij/execution/testframework/sm/SMTestRunnerConnectionUtil", "initConsoleView"));
        }
        if (testFrameworkName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testFrameworkName", "com/intellij/execution/testframework/sm/SMTestRunnerConnectionUtil", "initConsoleView"));
        }
        consoleView.addAttachToProcessListener(new AttachToProcessListener(){

            @Override
            public void onAttachToProcess(@NotNull ProcessHandler processHandler2) {
                SMTestLocator customLocator;
                TestProxyFilterProvider filterProvider;
                if (processHandler2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processHandler", "com/intellij/execution/testframework/sm/SMTestRunnerConnectionUtil$1", "onAttachToProcess"));
                }
                TestConsoleProperties properties = consoleView.getProperties();
                TestProxyPrinterProvider printerProvider = null;
                if (properties instanceof SMTRunnerConsoleProperties && (filterProvider = ((SMTRunnerConsoleProperties)properties).getFilterProvider()) != null) {
                    printerProvider = new TestProxyPrinterProvider(consoleView, filterProvider);
                }
                SMTestLocator testLocator = FileUrlProvider.INSTANCE;
                if (properties instanceof SMTRunnerConsoleProperties && (customLocator = ((SMTRunnerConsoleProperties)properties).getTestLocator()) != null) {
                    testLocator = new CombinedTestLocator(customLocator);
                }
                boolean idBasedTestTree = false;
                if (properties instanceof SMTRunnerConsoleProperties) {
                    idBasedTestTree = ((SMTRunnerConsoleProperties)properties).isIdBasedTestTree();
                }
                SMTestRunnerResultsForm resultsForm = consoleView.getResultsViewer();
                SMTestRunnerConnectionUtil.attachEventsProcessors(properties, resultsForm, processHandler2, testFrameworkName, testLocator, idBasedTestTree, printerProvider);
            }
        });
        consoleView.setHelpId("reference.runToolWindow.testResultsTab");
        consoleView.initUI();
    }

    public static boolean isInDebugMode() {
        return Boolean.valueOf(System.getProperty(TEST_RUNNER_DEBUG_MODE_PROPERTY));
    }

    private static void attachEventsProcessors(TestConsoleProperties consoleProperties, SMTestRunnerResultsForm resultsViewer, ProcessHandler processHandler2, String testFrameworkName, @Nullable SMTestLocator locator, boolean idBasedTestTree, @Nullable TestProxyPrinterProvider printerProvider) {
        final OutputToGeneralTestEventsConverter outputConsumer = consoleProperties instanceof SMCustomMessagesParsing ? ((SMCustomMessagesParsing)((Object)consoleProperties)).createTestEventsConverter(testFrameworkName, consoleProperties) : new OutputToGeneralTestEventsConverter(testFrameworkName, consoleProperties);
        final GeneralTestEventsProcessor eventsProcessor = idBasedTestTree ? new GeneralIdBasedToSMTRunnerEventsConvertor(consoleProperties.getProject(), resultsViewer.getTestsRootNode(), testFrameworkName) : new GeneralToSMTRunnerEventsConvertor(consoleProperties.getProject(), resultsViewer.getTestsRootNode(), testFrameworkName);
        if (locator != null) {
            eventsProcessor.setLocator(locator);
        }
        if (printerProvider != null) {
            eventsProcessor.setPrinterProvider(printerProvider);
        }
        SMTRunnerUIActionsHandler uiActionsHandler = new SMTRunnerUIActionsHandler(consoleProperties);
        outputConsumer.setProcessor(eventsProcessor);
        eventsProcessor.addEventsListener(resultsViewer);
        resultsViewer.addEventsListener(uiActionsHandler);
        processHandler2.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void processTerminated(ProcessEvent event) {
                outputConsumer.flushBufferBeforeTerminating();
                eventsProcessor.onFinishTesting();
                Disposer.dispose((Disposable)eventsProcessor);
                Disposer.dispose((Disposable)outputConsumer);
            }

            public void startNotified(ProcessEvent event) {
                eventsProcessor.onStartTesting();
                outputConsumer.onStartTesting();
            }

            public void onTextAvailable(ProcessEvent event, Key outputType) {
                outputConsumer.process(event.getText(), outputType);
            }
        });
    }

    public static BaseTestsOutputConsoleView createConsoleWithCustomLocator(@NotNull String testFrameworkName, @NotNull TestConsoleProperties consoleProperties, ExecutionEnvironment environment, @Nullable TestLocationProvider locator) {
        if (testFrameworkName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testFrameworkName", "com/intellij/execution/testframework/sm/SMTestRunnerConnectionUtil", "createConsoleWithCustomLocator"));
        }
        if (consoleProperties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consoleProperties", "com/intellij/execution/testframework/sm/SMTestRunnerConnectionUtil", "createConsoleWithCustomLocator"));
        }
        return SMTestRunnerConnectionUtil.createConsoleWithCustomLocator(testFrameworkName, consoleProperties, environment, locator, false, null);
    }

    public static SMTRunnerConsoleView createConsoleWithCustomLocator(@NotNull String testFrameworkName, @NotNull TestConsoleProperties consoleProperties, ExecutionEnvironment environment, @Nullable TestLocationProvider locator, boolean idBasedTreeConstruction, @Nullable TestProxyFilterProvider filterProvider) {
        if (testFrameworkName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testFrameworkName", "com/intellij/execution/testframework/sm/SMTestRunnerConnectionUtil", "createConsoleWithCustomLocator"));
        }
        if (consoleProperties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consoleProperties", "com/intellij/execution/testframework/sm/SMTestRunnerConnectionUtil", "createConsoleWithCustomLocator"));
        }
        String splitterPropertyName = SMTestRunnerConnectionUtil.getSplitterPropertyName(testFrameworkName);
        SMTRunnerConsoleView consoleView = new SMTRunnerConsoleView(consoleProperties, splitterPropertyName);
        SMTestRunnerConnectionUtil.initConsoleView(consoleView, testFrameworkName, locator, idBasedTreeConstruction, filterProvider);
        return consoleView;
    }

    public static void initConsoleView(final @NotNull SMTRunnerConsoleView consoleView, final @NotNull String testFrameworkName, final @Nullable TestLocationProvider locator, final boolean idBasedTreeConstruction, final @Nullable TestProxyFilterProvider filterProvider) {
        if (consoleView == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consoleView", "com/intellij/execution/testframework/sm/SMTestRunnerConnectionUtil", "initConsoleView"));
        }
        if (testFrameworkName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testFrameworkName", "com/intellij/execution/testframework/sm/SMTestRunnerConnectionUtil", "initConsoleView"));
        }
        consoleView.addAttachToProcessListener(new AttachToProcessListener(){

            @Override
            public void onAttachToProcess(@NotNull ProcessHandler processHandler2) {
                if (processHandler2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processHandler", "com/intellij/execution/testframework/sm/SMTestRunnerConnectionUtil$3", "onAttachToProcess"));
                }
                TestConsoleProperties properties = consoleView.getProperties();
                CompositeTestLocationProvider testLocator = new CompositeTestLocationProvider(locator);
                TestProxyPrinterProvider printerProvider = null;
                if (filterProvider != null) {
                    printerProvider = new TestProxyPrinterProvider(consoleView, filterProvider);
                }
                SMTestRunnerResultsForm resultsForm = consoleView.getResultsViewer();
                SMTestRunnerConnectionUtil.attachEventsProcessors(properties, resultsForm, processHandler2, testFrameworkName, testLocator, idBasedTreeConstruction, printerProvider);
            }
        });
        consoleView.setHelpId("reference.runToolWindow.testResultsTab");
        consoleView.initUI();
    }

    private static class CompositeTestLocationProvider
    implements SMTestLocator {
        private final TestLocationProvider myPrimaryLocator;
        private final TestLocationProvider[] myLocators;

        private CompositeTestLocationProvider(@Nullable TestLocationProvider primaryLocator) {
            this.myPrimaryLocator = primaryLocator;
            this.myLocators = (TestLocationProvider[])Extensions.getExtensions(TestLocationProvider.EP_NAME);
        }

        @Override
        @NotNull
        public List<Location> getLocation(@NotNull String protocol, @NotNull String path, @NotNull Project project2, @NotNull GlobalSearchScope scope) {
            List<Location> locations;
            if (protocol == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "protocol", "com/intellij/execution/testframework/sm/SMTestRunnerConnectionUtil$CompositeTestLocationProvider", "getLocation"));
            }
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/execution/testframework/sm/SMTestRunnerConnectionUtil$CompositeTestLocationProvider", "getLocation"));
            }
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/testframework/sm/SMTestRunnerConnectionUtil$CompositeTestLocationProvider", "getLocation"));
            }
            if (scope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/execution/testframework/sm/SMTestRunnerConnectionUtil$CompositeTestLocationProvider", "getLocation"));
            }
            boolean isDumbMode = DumbService.isDumb((Project)project2);
            if (!(this.myPrimaryLocator == null || isDumbMode && !(this.myPrimaryLocator instanceof DumbAware) || (locations = this.myPrimaryLocator.getLocation(protocol, path, project2)).isEmpty())) {
                List<Location> list2 = locations;
                if (list2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/testframework/sm/SMTestRunnerConnectionUtil$CompositeTestLocationProvider", "getLocation"));
                }
                return list2;
            }
            if ("file".equals(protocol) && !(locations = FileUrlProvider.INSTANCE.getLocation(protocol, path, project2, scope)).isEmpty()) {
                List<Location> list3 = locations;
                if (list3 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/testframework/sm/SMTestRunnerConnectionUtil$CompositeTestLocationProvider", "getLocation"));
                }
                return list3;
            }
            for (TestLocationProvider provider : this.myLocators) {
                List<Location> locations2;
                if (isDumbMode && !(provider instanceof DumbAware) || (locations2 = provider.getLocation(protocol, path, project2)).isEmpty()) continue;
                List<Location> list4 = locations2;
                if (list4 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/testframework/sm/SMTestRunnerConnectionUtil$CompositeTestLocationProvider", "getLocation"));
                }
                return list4;
            }
            List<Location> list5 = Collections.emptyList();
            if (list5 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/testframework/sm/SMTestRunnerConnectionUtil$CompositeTestLocationProvider", "getLocation"));
            }
            return list5;
        }
    }

    private static class CombinedTestLocator
    implements SMTestLocator,
    DumbAware {
        private final SMTestLocator myLocator;

        public CombinedTestLocator(SMTestLocator locator) {
            this.myLocator = locator;
        }

        @Override
        @NotNull
        public List<Location> getLocation(@NotNull String protocol, @NotNull String path, @NotNull Project project2, @NotNull GlobalSearchScope scope) {
            if (protocol == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "protocol", "com/intellij/execution/testframework/sm/SMTestRunnerConnectionUtil$CombinedTestLocator", "getLocation"));
            }
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/execution/testframework/sm/SMTestRunnerConnectionUtil$CombinedTestLocator", "getLocation"));
            }
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/testframework/sm/SMTestRunnerConnectionUtil$CombinedTestLocator", "getLocation"));
            }
            if (scope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/execution/testframework/sm/SMTestRunnerConnectionUtil$CombinedTestLocator", "getLocation"));
            }
            if ("file".equals(protocol)) {
                List<Location> list2 = FileUrlProvider.INSTANCE.getLocation(protocol, path, project2, scope);
                if (list2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/testframework/sm/SMTestRunnerConnectionUtil$CombinedTestLocator", "getLocation"));
                }
                return list2;
            }
            if (!DumbService.isDumb((Project)project2) || DumbService.isDumbAware((Object)this.myLocator) || Registry.is((String)"dumb.aware.run.configurations")) {
                List<Location> list3 = this.myLocator.getLocation(protocol, path, project2, scope);
                if (list3 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/testframework/sm/SMTestRunnerConnectionUtil$CombinedTestLocator", "getLocation"));
                }
                return list3;
            }
            List<Location> list4 = Collections.emptyList();
            if (list4 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/testframework/sm/SMTestRunnerConnectionUtil$CombinedTestLocator", "getLocation"));
            }
            return list4;
        }
    }
}

