/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm;

import jetbrains.buildServer.messages.serviceMessages.MapSerializerUtil;
import org.jetbrains.annotations.NotNull;

public class ServiceMessageBuilder {
    private final StringBuilder myText = new StringBuilder("##teamcity[");

    public ServiceMessageBuilder(String command) {
        this.myText.append(command);
    }

    public ServiceMessageBuilder addAttribute(String name2, String value2) {
        this.myText.append(' ').append(name2).append("='").append(ServiceMessageBuilder.replaceEscapeSymbols(value2)).append('\'');
        return this;
    }

    public String toString() {
        return this.myText.toString() + ']';
    }

    private static String replaceEscapeSymbols(String text2) {
        return MapSerializerUtil.escapeStr((String)text2, (MapSerializerUtil.EscapeInfoProvider)MapSerializerUtil.STD_ESCAPER);
    }

    public static ServiceMessageBuilder testSuiteStarted(@NotNull String name2) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/execution/testframework/sm/ServiceMessageBuilder", "testSuiteStarted"));
        }
        return new ServiceMessageBuilder("testSuiteStarted").addAttribute("name", name2);
    }

    public static ServiceMessageBuilder testSuiteFinished(@NotNull String name2) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/execution/testframework/sm/ServiceMessageBuilder", "testSuiteFinished"));
        }
        return new ServiceMessageBuilder("testSuiteFinished").addAttribute("name", name2);
    }

    public static ServiceMessageBuilder testStarted(@NotNull String name2) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/execution/testframework/sm/ServiceMessageBuilder", "testStarted"));
        }
        return new ServiceMessageBuilder("testStarted").addAttribute("name", name2);
    }

    public static ServiceMessageBuilder testFinished(@NotNull String name2) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/execution/testframework/sm/ServiceMessageBuilder", "testFinished"));
        }
        return new ServiceMessageBuilder("testFinished").addAttribute("name", name2);
    }

    public static ServiceMessageBuilder testStdOut(@NotNull String name2) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/execution/testframework/sm/ServiceMessageBuilder", "testStdOut"));
        }
        return new ServiceMessageBuilder("testStdOut").addAttribute("name", name2);
    }

    public static ServiceMessageBuilder testStdErr(@NotNull String name2) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/execution/testframework/sm/ServiceMessageBuilder", "testStdErr"));
        }
        return new ServiceMessageBuilder("testStdErr").addAttribute("name", name2);
    }

    public static ServiceMessageBuilder testFailed(@NotNull String name2) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/execution/testframework/sm/ServiceMessageBuilder", "testFailed"));
        }
        return new ServiceMessageBuilder("testFailed").addAttribute("name", name2);
    }

    public static ServiceMessageBuilder testIgnored(@NotNull String name2) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/execution/testframework/sm/ServiceMessageBuilder", "testIgnored"));
        }
        return new ServiceMessageBuilder("testIgnored").addAttribute("name", name2);
    }
}

