/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm.runner;

import com.intellij.execution.filters.Filter;
import com.intellij.execution.testframework.Printer;
import com.intellij.execution.testframework.sm.runner.TestProxyFilterProvider;
import com.intellij.execution.testframework.ui.BaseTestsOutputConsoleView;
import com.intellij.execution.testframework.ui.TestsOutputConsolePrinter;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TestProxyPrinterProvider {
    private final TestProxyFilterProvider myFilterProvider;
    private BaseTestsOutputConsoleView myTestOutputConsoleView;

    public TestProxyPrinterProvider(@NotNull BaseTestsOutputConsoleView testsOutputConsoleView, @NotNull TestProxyFilterProvider filterProvider) {
        if (testsOutputConsoleView == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testsOutputConsoleView", "com/intellij/execution/testframework/sm/runner/TestProxyPrinterProvider", "<init>"));
        }
        if (filterProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filterProvider", "com/intellij/execution/testframework/sm/runner/TestProxyPrinterProvider", "<init>"));
        }
        this.myTestOutputConsoleView = testsOutputConsoleView;
        this.myFilterProvider = filterProvider;
    }

    @Nullable
    public Printer getPrinterByType(@NotNull String nodeType, @NotNull String nodeName, @Nullable String nodeArguments) {
        if (nodeType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeType", "com/intellij/execution/testframework/sm/runner/TestProxyPrinterProvider", "getPrinterByType"));
        }
        if (nodeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeName", "com/intellij/execution/testframework/sm/runner/TestProxyPrinterProvider", "getPrinterByType"));
        }
        Filter filter = this.myFilterProvider.getFilter(nodeType, nodeName, nodeArguments);
        if (filter != null && !Disposer.isDisposed((Disposable)this.myTestOutputConsoleView)) {
            return new HyperlinkPrinter(this.myTestOutputConsoleView, HyperlinkPrinter.ERROR_CONTENT_TYPE, filter);
        }
        return null;
    }

    private static class HyperlinkPrinter
    extends TestsOutputConsolePrinter {
        public static final Condition<ConsoleViewContentType> ERROR_CONTENT_TYPE = contentType -> ConsoleViewContentType.ERROR_OUTPUT == contentType;
        private static final String NL = "\n";
        private final Condition<ConsoleViewContentType> myContentTypeCondition;
        private final Filter myFilter;

        public HyperlinkPrinter(@NotNull BaseTestsOutputConsoleView testsOutputConsoleView, @NotNull Condition<ConsoleViewContentType> contentTypeCondition, @NotNull Filter filter) {
            if (testsOutputConsoleView == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testsOutputConsoleView", "com/intellij/execution/testframework/sm/runner/TestProxyPrinterProvider$HyperlinkPrinter", "<init>"));
            }
            if (contentTypeCondition == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentTypeCondition", "com/intellij/execution/testframework/sm/runner/TestProxyPrinterProvider$HyperlinkPrinter", "<init>"));
            }
            if (filter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/execution/testframework/sm/runner/TestProxyPrinterProvider$HyperlinkPrinter", "<init>"));
            }
            super(testsOutputConsoleView, testsOutputConsoleView.getProperties(), null);
            this.myContentTypeCondition = contentTypeCondition;
            this.myFilter = filter;
        }

        @Override
        public void print(String text2, ConsoleViewContentType contentType) {
            if (contentType == null || !this.myContentTypeCondition.value((Object)contentType)) {
                this.defaultPrint(text2, contentType);
                return;
            }
            text2 = StringUtil.replace((String)text2, (String)"\r\n", (String)NL, (boolean)false);
            StringTokenizer tokenizer = new StringTokenizer(text2, NL, true);
            while (tokenizer.hasMoreTokens()) {
                String line = tokenizer.nextToken();
                if (NL.equals(line)) {
                    this.defaultPrint(line, contentType);
                    continue;
                }
                this.printLine(line, contentType);
            }
        }

        private void defaultPrint(String text2, ConsoleViewContentType contentType) {
            super.print(text2, contentType);
        }

        private void printLine(@NotNull String line, @NotNull ConsoleViewContentType contentType) {
            Filter.Result result2;
            if (line == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/intellij/execution/testframework/sm/runner/TestProxyPrinterProvider$HyperlinkPrinter", "printLine"));
            }
            if (contentType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentType", "com/intellij/execution/testframework/sm/runner/TestProxyPrinterProvider$HyperlinkPrinter", "printLine"));
            }
            try {
                result2 = this.myFilter.applyFilter(line, line.length());
            }
            catch (Throwable t) {
                throw new RuntimeException("Error while applying " + this.myFilter + " to '" + line + "'", t);
            }
            if (result2 != null) {
                List<Filter.ResultItem> items = HyperlinkPrinter.sort(result2.getResultItems());
                int lastOffset = 0;
                for (Filter.ResultItem item : items) {
                    this.defaultPrint(line.substring(lastOffset, item.getHighlightStartOffset()), contentType);
                    String linkText = line.substring(item.getHighlightStartOffset(), item.getHighlightEndOffset());
                    this.printHyperlink(linkText, item.getHyperlinkInfo());
                    lastOffset = item.getHighlightEndOffset();
                }
                this.defaultPrint(line.substring(lastOffset), contentType);
            } else {
                this.defaultPrint(line, contentType);
            }
        }

        @NotNull
        private static List<Filter.ResultItem> sort(@NotNull List<Filter.ResultItem> items) {
            if (items == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "items", "com/intellij/execution/testframework/sm/runner/TestProxyPrinterProvider$HyperlinkPrinter", "sort"));
            }
            if (items.size() <= 1) {
                List<Filter.ResultItem> list2 = items;
                if (list2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/testframework/sm/runner/TestProxyPrinterProvider$HyperlinkPrinter", "sort"));
                }
                return list2;
            }
            ArrayList<Filter.ResultItem> copy = new ArrayList<Filter.ResultItem>(items);
            Collections.sort(copy, Comparator.comparingInt(Filter.ResultItem::getHighlightStartOffset));
            ArrayList<Filter.ResultItem> arrayList = copy;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/testframework/sm/runner/TestProxyPrinterProvider$HyperlinkPrinter", "sort"));
            }
            return arrayList;
        }
    }
}

