/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm.runner.history;

import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.sm.runner.GeneralTestEventsProcessor;
import com.intellij.execution.testframework.sm.runner.OutputToGeneralTestEventsConverter;
import com.intellij.execution.testframework.sm.runner.history.ImportTestOutputExtension;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.CharsetToolkit;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.function.Supplier;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.jetbrains.annotations.NotNull;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ImportedToGeneralTestEventsConverter
extends OutputToGeneralTestEventsConverter {
    @NotNull
    private final TestConsoleProperties myConsoleProperties;
    @NotNull
    private final File myFile;
    @NotNull
    private final ProcessHandler myHandler;

    public ImportedToGeneralTestEventsConverter(@NotNull String testFrameworkName, @NotNull TestConsoleProperties consoleProperties, @NotNull File file2, @NotNull ProcessHandler handler2) {
        if (testFrameworkName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testFrameworkName", "com/intellij/execution/testframework/sm/runner/history/ImportedToGeneralTestEventsConverter", "<init>"));
        }
        if (consoleProperties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consoleProperties", "com/intellij/execution/testframework/sm/runner/history/ImportedToGeneralTestEventsConverter", "<init>"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/execution/testframework/sm/runner/history/ImportedToGeneralTestEventsConverter", "<init>"));
        }
        if (handler2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/execution/testframework/sm/runner/history/ImportedToGeneralTestEventsConverter", "<init>"));
        }
        super(testFrameworkName, consoleProperties);
        this.myConsoleProperties = consoleProperties;
        this.myFile = file2;
        this.myHandler = handler2;
    }

    @Override
    public void onStartTesting() {
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            this.parseTestResults();
            this.myHandler.detachProcess();
        });
    }

    private void parseTestResults() {
        try {
            ImportedToGeneralTestEventsConverter.parseTestResults(() -> {
                try {
                    return new InputStreamReader((InputStream)new FileInputStream(this.myFile), CharsetToolkit.UTF8_CHARSET);
                }
                catch (FileNotFoundException e) {
                    return null;
                }
            }, this.getProcessor());
        }
        catch (IOException e) {
            String message2 = e.getMessage();
            ApplicationManager.getApplication().invokeLater(() -> Messages.showErrorDialog((Project)this.myConsoleProperties.getProject(), (String)message2, (String)("Failed to Parse " + this.myFile.getName())));
        }
    }

    public static void parseTestResults(Supplier<Reader> readerSupplier, GeneralTestEventsProcessor processor2) throws IOException {
        ImportedToGeneralTestEventsConverter.parseTestResults(readerSupplier.get(), ImportTestOutputExtension.findHandler(readerSupplier, processor2));
    }

    public static void parseTestResults(Reader reader, DefaultHandler contentHandler) throws IOException {
        try {
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            parser.parse(new InputSource(reader), contentHandler);
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new IOException(e);
        }
        finally {
            reader.close();
        }
    }
}

