/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm.runner.history.actions;

import com.intellij.execution.TestStateStorage;
import com.intellij.execution.testframework.sm.TestHistoryConfiguration;
import com.intellij.execution.testframework.sm.runner.SMTRunnerConsoleProperties;
import com.intellij.execution.testframework.sm.runner.history.actions.AbstractImportTestsAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.text.DateFormatUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImportTestsFromHistoryAction
extends AbstractImportTestsAction {
    private String myFileName;

    public ImportTestsFromHistoryAction(@Nullable SMTRunnerConsoleProperties properties, Project project2, String name2) {
        super(properties, ImportTestsFromHistoryAction.getPresentableText(project2, name2), ImportTestsFromHistoryAction.getPresentableText(project2, name2), ImportTestsFromHistoryAction.getIcon(project2, name2));
        this.myFileName = name2;
    }

    private static Icon getIcon(Project project2, String name2) {
        return TestHistoryConfiguration.getInstance(project2).getIcon(name2);
    }

    private static String getPresentableText(Project project2, String name2) {
        String nameWithoutExtension = FileUtil.getNameWithoutExtension((String)name2);
        int lastIndexOf = nameWithoutExtension.lastIndexOf(" - ");
        if (lastIndexOf > 0) {
            String date = nameWithoutExtension.substring(lastIndexOf + 3);
            try {
                Date creationDate = new SimpleDateFormat("yyyy.MM.dd 'at' HH'h' mm'm' ss's'").parse(date);
                String configurationName = TestHistoryConfiguration.getInstance(project2).getConfigurationName(name2);
                return (configurationName != null ? configurationName : nameWithoutExtension.substring(0, lastIndexOf)) + " (" + DateFormatUtil.formatDateTime((Date)creationDate) + ")";
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return nameWithoutExtension;
    }

    @Override
    @Nullable
    public VirtualFile getFile(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/testframework/sm/runner/history/actions/ImportTestsFromHistoryAction", "getFile"));
        }
        return LocalFileSystem.getInstance().findFileByPath(TestStateStorage.getTestHistoryRoot(project2).getPath() + "/" + this.myFileName);
    }
}

