/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.ui;

import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.TestTreeView;
import com.intellij.execution.testframework.ToolbarPanel;
import com.intellij.execution.testframework.ui.SameHeightPanel;
import com.intellij.execution.testframework.ui.TestStatusLine;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SideBorder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TestResultsPanel
extends JPanel
implements Disposable,
DataProvider {
    private JScrollPane myLeftPane;
    protected final JComponent myConsole;
    protected ToolbarPanel myToolbarPanel;
    private final String mySplitterProportionProperty;
    private final float mySplitterDefaultProportion;
    protected final AnAction[] myConsoleActions;
    protected final TestConsoleProperties myProperties;
    protected TestStatusLine myStatusLine;
    private JBSplitter mySplitter;

    protected TestResultsPanel(@NotNull JComponent console, AnAction[] consoleActions, TestConsoleProperties properties, @NotNull String splitterProportionProperty, float splitterDefaultProportion) {
        if (console == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "console", "com/intellij/execution/testframework/ui/TestResultsPanel", "<init>"));
        }
        if (splitterProportionProperty == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "splitterProportionProperty", "com/intellij/execution/testframework/ui/TestResultsPanel", "<init>"));
        }
        super(new BorderLayout(0, 1));
        this.myConsole = console;
        this.myConsoleActions = consoleActions;
        this.myProperties = properties;
        this.mySplitterProportionProperty = splitterProportionProperty;
        this.mySplitterDefaultProportion = splitterDefaultProportion;
        ToolWindowManagerListener listener2 = new ToolWindowManagerListener(){

            @Override
            public void toolWindowRegistered(@NotNull String id) {
                if (id == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/execution/testframework/ui/TestResultsPanel$1", "toolWindowRegistered"));
                }
            }

            @Override
            public void stateChanged() {
                boolean splitVertically = TestResultsPanel.this.splitVertically();
                TestResultsPanel.this.myStatusLine.setPreferredSize(splitVertically);
                TestResultsPanel.this.mySplitter.setOrientation(splitVertically);
                TestResultsPanel.this.revalidate();
                TestResultsPanel.this.repaint();
            }
        };
        ToolWindowManagerEx.getInstanceEx(properties.getProject()).addToolWindowManagerListener(listener2, this);
    }

    public void initUI() {
        this.myLeftPane = ScrollPaneFactory.createScrollPane();
        this.myLeftPane.putClientProperty(UIUtil.KEEP_BORDER_SIDES, 2);
        this.myStatusLine = this.createStatusLine();
        JComponent testTreeView = this.createTestTreeView();
        this.myToolbarPanel = this.createToolbarPanel();
        Disposer.register((Disposable)this, (Disposable)this.myToolbarPanel);
        boolean splitVertically = this.splitVertically();
        this.myStatusLine.setPreferredSize(splitVertically);
        this.mySplitter = TestResultsPanel.createSplitter(this.mySplitterProportionProperty, this.mySplitterDefaultProportion, splitVertically);
        if (this.mySplitter instanceof OnePixelSplitter) {
            ((OnePixelSplitter)this.mySplitter).setBlindZone(() -> JBUI.insetsTop((int)this.myToolbarPanel.getHeight()));
        }
        Disposer.register((Disposable)this, (Disposable)new Disposable(){

            public void dispose() {
                TestResultsPanel.this.remove((Component)TestResultsPanel.this.mySplitter);
                TestResultsPanel.this.mySplitter.dispose();
            }
        });
        this.add((Component)this.mySplitter, "Center");
        JPanel leftPanel = new JPanel(new BorderLayout());
        leftPanel.add((Component)this.myLeftPane, "Center");
        leftPanel.add((Component)this.myToolbarPanel, "North");
        this.mySplitter.setFirstComponent((JComponent)leftPanel);
        this.myStatusLine.setMinimumSize(new Dimension(0, this.myStatusLine.getMinimumSize().height));
        this.myStatusLine.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        JPanel rightPanel = new JPanel(new BorderLayout());
        rightPanel.add((Component)SameHeightPanel.wrap(this.myStatusLine, this.myToolbarPanel), "North");
        rightPanel.add((Component)TestResultsPanel.createOutputTab(this.myConsole, this.myConsoleActions), "Center");
        this.mySplitter.setSecondComponent((JComponent)rightPanel);
        testTreeView.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 0));
        this.setLeftComponent(testTreeView);
    }

    private boolean splitVertically() {
        String windowId = this.myProperties.getExecutor().getToolWindowId();
        ToolWindow toolWindow = ToolWindowManager.getInstance((Project)this.myProperties.getProject()).getToolWindow(windowId);
        boolean splitVertically = false;
        if (toolWindow != null) {
            ToolWindowAnchor anchor = toolWindow.getAnchor();
            splitVertically = anchor == ToolWindowAnchor.LEFT || anchor == ToolWindowAnchor.RIGHT;
        }
        return splitVertically;
    }

    protected ToolbarPanel createToolbarPanel() {
        return new ToolbarPanel(this.myProperties, this);
    }

    protected TestStatusLine createStatusLine() {
        return new TestStatusLine();
    }

    protected abstract JComponent createTestTreeView();

    @Nullable
    protected TestTreeView getTreeView() {
        return null;
    }

    @Nullable
    public Object getData(@NonNls String dataId) {
        TestTreeView view = this.getTreeView();
        if (view != null) {
            return view.getData(dataId);
        }
        return null;
    }

    private static JComponent createOutputTab(JComponent console, AnAction[] consoleActions) {
        JPanel outputTab = new JPanel(new BorderLayout());
        console.setFocusable(true);
        Color editorBackground = EditorColorsManager.getInstance().getGlobalScheme().getDefaultBackground();
        console.setBorder(new CompoundBorder(IdeBorderFactory.createBorder((int)6), (Border)new SideBorder(editorBackground, 1)));
        outputTab.add((Component)console, "Center");
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("TestRunnerResults", (ActionGroup)new DefaultActionGroup(consoleActions), false);
        outputTab.add((Component)toolbar.getComponent(), "East");
        return outputTab;
    }

    public void dispose() {
    }

    @NotNull
    protected static JBSplitter createSplitter(@NotNull String proportionProperty, float defaultProportion, boolean splitVertically) {
        if (proportionProperty == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "proportionProperty", "com/intellij/execution/testframework/ui/TestResultsPanel", "createSplitter"));
        }
        OnePixelSplitter splitter = new OnePixelSplitter(splitVertically, proportionProperty, defaultProportion);
        splitter.setHonorComponentsMinimumSize(true);
        OnePixelSplitter onePixelSplitter = splitter;
        if (onePixelSplitter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/testframework/ui/TestResultsPanel", "createSplitter"));
        }
        return onePixelSplitter;
    }

    protected void setLeftComponent(JComponent component) {
        if (component != this.myLeftPane.getViewport().getView()) {
            this.myLeftPane.setViewportView(component);
        }
    }
}

