/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui;

import com.intellij.application.options.ModuleDescriptionsComboBox;
import com.intellij.application.options.ModuleListCellRenderer;
import com.intellij.application.options.ModulesComboBox;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ModulesAlphaComparator;
import com.intellij.psi.PsiClass;
import com.intellij.ui.ComboboxSpeedSearch;
import com.intellij.ui.SortedComboBoxModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.Nullable;

public class ConfigurationModuleSelector {
    public static final String NO_MODULE_TEXT = "<no module>";
    private final Project myProject;
    private final ModuleDescriptionsComboBox myModulesDescriptionsComboBox;
    private final JComboBox<Module> myModulesList;

    public ConfigurationModuleSelector(Project project2, JComboBox<Module> modulesList) {
        this(project2, modulesList, NO_MODULE_TEXT);
    }

    public ConfigurationModuleSelector(Project project2, ModulesComboBox modulesComboBox) {
        this(project2, modulesComboBox, NO_MODULE_TEXT);
    }

    public ConfigurationModuleSelector(Project project2, ModuleDescriptionsComboBox modulesDescriptionsComboBox) {
        this(project2, modulesDescriptionsComboBox, NO_MODULE_TEXT);
    }

    public ConfigurationModuleSelector(Project project2, ModuleDescriptionsComboBox modulesDescriptionsComboBox, String emptySelectionText) {
        this.myProject = project2;
        this.myModulesDescriptionsComboBox = modulesDescriptionsComboBox;
        this.myModulesList = null;
        modulesDescriptionsComboBox.allowEmptySelection(emptySelectionText);
    }

    public ConfigurationModuleSelector(Project project2, ModulesComboBox modulesComboBox, String noModule) {
        this.myProject = project2;
        this.myModulesList = modulesComboBox;
        this.myModulesDescriptionsComboBox = null;
        modulesComboBox.allowEmptySelection(noModule);
    }

    public ConfigurationModuleSelector(Project project2, JComboBox<Module> modulesList, final String noModule) {
        this.myProject = project2;
        this.myModulesList = modulesList;
        this.myModulesDescriptionsComboBox = null;
        new ComboboxSpeedSearch(modulesList){

            @Override
            protected String getElementText(Object element) {
                if (element instanceof Module) {
                    return ((Module)element).getName();
                }
                if (element == null) {
                    return noModule;
                }
                return super.getElementText(element);
            }
        };
        this.myModulesList.setModel((ComboBoxModel<Module>)new SortedComboBoxModel((Comparator)ModulesAlphaComparator.INSTANCE));
        this.myModulesList.setRenderer((ListCellRenderer<Module>)((Object)new ModuleListCellRenderer(noModule)));
    }

    public void applyTo(ModuleBasedConfiguration configurationModule) {
        if (this.myModulesList != null) {
            configurationModule.setModule((Module)this.myModulesList.getSelectedItem());
        } else {
            configurationModule.setModuleName(this.myModulesDescriptionsComboBox.getSelectedModuleName());
        }
    }

    public void reset(ModuleBasedConfiguration configuration) {
        Module[] modules = ModuleManager.getInstance((Project)this.getProject()).getModules();
        ArrayList<Module> list2 = new ArrayList<Module>();
        for (Module module2 : modules) {
            if (!this.isModuleAccepted(module2)) continue;
            list2.add(module2);
        }
        this.setModules(list2);
        if (this.myModulesList != null) {
            this.myModulesList.setSelectedItem(configuration.getConfigurationModule().getModule());
        } else {
            this.myModulesDescriptionsComboBox.setSelectedModule(this.myProject, configuration.getConfigurationModule().getModuleName());
        }
    }

    public boolean isModuleAccepted(Module module2) {
        return ModuleTypeManager.getInstance().isClasspathProvider(ModuleType.get((Module)module2));
    }

    public Project getProject() {
        return this.myProject;
    }

    public JavaRunConfigurationModule getConfigurationModule() {
        JavaRunConfigurationModule configurationModule = new JavaRunConfigurationModule(this.getProject(), false);
        configurationModule.setModule(this.getModule());
        return configurationModule;
    }

    private void setModules(Collection<Module> modules) {
        if (this.myModulesDescriptionsComboBox != null) {
            this.myModulesDescriptionsComboBox.setModules(modules);
        } else if (this.myModulesList instanceof ModulesComboBox) {
            ((ModulesComboBox)((Object)this.myModulesList)).setModules(modules);
        } else {
            SortedComboBoxModel model = (SortedComboBoxModel)this.myModulesList.getModel();
            model.setAll(modules);
            model.add(null);
        }
    }

    public Module getModule() {
        return this.myModulesDescriptionsComboBox != null ? this.myModulesDescriptionsComboBox.getSelectedModule() : (Module)this.myModulesList.getSelectedItem();
    }

    @Nullable
    public PsiClass findClass(String className) {
        return this.getConfigurationModule().findClass(className);
    }

    public String getModuleName() {
        Module module2 = this.getModule();
        return module2 == null ? "" : module2.getName();
    }
}

