/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui;

import com.intellij.application.options.ModuleDescriptionsComboBox;
import com.intellij.application.options.ModulesComboBox;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.ui.DefaultJreSelector;
import com.intellij.execution.ui.DefaultJreSelectorKt;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.ExtensionsKt;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.EditorTextFieldWithBrowseButton;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u0000 \u000b2\u00020\u0001:\u0004\u000b\f\r\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\t\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\b\u0012\u0004\u0012\u00020\b0\nH&\u00a8\u0006\u000f"}, d2={"Lcom/intellij/execution/ui/DefaultJreSelector;", "", "()V", "addChangeListener", "", "listener", "Ljava/lang/Runnable;", "getDescriptionString", "", "getNameAndDescription", "Lcom/intellij/openapi/util/Pair;", "Companion", "ProjectSdkSelector", "SdkFromModuleDependencies", "SdkFromSourceRootDependencies", "execution-impl"})
public abstract class DefaultJreSelector {
    public static final Companion Companion = new Companion(null);

    @NotNull
    public abstract Pair<String, String> getNameAndDescription();

    public void addChangeListener(@NotNull Runnable listener2) {
        Intrinsics.checkParameterIsNotNull((Object)listener2, (String)"listener");
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String getDescriptionString() {
        void description;
        void name2;
        Pair<String, String> pair2 = this.getNameAndDescription();
        String string = ExtensionsKt.component1(pair2);
        String string2 = ExtensionsKt.component2(pair2);
        pair2 = null;
        StringBuilder stringBuilder = new StringBuilder().append(" (");
        String string3 = name2;
        if (string3 == null) {
            string3 = "<no JRE>";
        }
        return stringBuilder.append(string3).append(" - ").append((String)description).append(')').toString();
    }

    @JvmStatic
    @NotNull
    public static final DefaultJreSelector projectSdk(@NotNull Project project2) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        return Companion.projectSdk(project2);
    }

    @JvmStatic
    @NotNull
    public static final DefaultJreSelector fromModuleDependencies(@NotNull ModulesComboBox moduleComboBox, boolean productionOnly) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)moduleComboBox), (String)"moduleComboBox");
        return Companion.fromModuleDependencies(moduleComboBox, productionOnly);
    }

    @JvmStatic
    @NotNull
    public static final DefaultJreSelector fromModuleDependencies(@NotNull ModuleDescriptionsComboBox moduleComboBox, boolean productionOnly) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)moduleComboBox), (String)"moduleComboBox");
        return Companion.fromModuleDependencies(moduleComboBox, productionOnly);
    }

    @JvmStatic
    @NotNull
    public static final DefaultJreSelector fromSourceRootsDependencies(@NotNull ModulesComboBox moduleComboBox, @NotNull EditorTextFieldWithBrowseButton classSelector) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)moduleComboBox), (String)"moduleComboBox");
        Intrinsics.checkParameterIsNotNull((Object)((Object)classSelector), (String)"classSelector");
        return Companion.fromSourceRootsDependencies(moduleComboBox, classSelector);
    }

    @JvmStatic
    @NotNull
    public static final DefaultJreSelector fromSourceRootsDependencies(@NotNull ModuleDescriptionsComboBox moduleComboBox, @NotNull EditorTextFieldWithBrowseButton classSelector) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)moduleComboBox), (String)"moduleComboBox");
        Intrinsics.checkParameterIsNotNull((Object)((Object)classSelector), (String)"classSelector");
        return Companion.fromSourceRootsDependencies(moduleComboBox, classSelector);
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J$\u0010\u0007\u001a\u001e\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t0\bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lcom/intellij/execution/ui/DefaultJreSelector$ProjectSdkSelector;", "Lcom/intellij/execution/ui/DefaultJreSelector;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getNameAndDescription", "Lcom/intellij/openapi/util/Pair;", "", "kotlin.jvm.PlatformType", "execution-impl"})
    public static final class ProjectSdkSelector
    extends DefaultJreSelector {
        @NotNull
        private final Project project;

        @Override
        @NotNull
        public Pair<String, String> getNameAndDescription() {
            return Pair.create((Object)ProjectRootManager.getInstance((Project)this.project).getProjectSdkName(), (Object)"project SDK");
        }

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        public ProjectSdkSelector(@NotNull Project project2) {
            Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
            this.project = project2;
        }
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\b\u0016\u0018\u0000*\f\b\u0000\u0010\u0001*\u0006\u0012\u0002\b\u00030\u00022\u00020\u0003B1\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u0012\u0014\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0016\u0010\u0017\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0019\u0012\u0004\u0012\u00020\u00190\u0018H\u0016R\u001f\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u0010\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001a"}, d2={"Lcom/intellij/execution/ui/DefaultJreSelector$SdkFromModuleDependencies;", "T", "Lcom/intellij/openapi/ui/ComboBox;", "Lcom/intellij/execution/ui/DefaultJreSelector;", "moduleComboBox", "getSelectedModule", "Lkotlin/Function1;", "Lcom/intellij/openapi/module/Module;", "productionOnly", "Lkotlin/Function0;", "", "(Lcom/intellij/openapi/ui/ComboBox;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function0;)V", "getGetSelectedModule", "()Lkotlin/jvm/functions/Function1;", "getModuleComboBox", "()Lcom/intellij/openapi/ui/ComboBox;", "Lcom/intellij/openapi/ui/ComboBox;", "getProductionOnly", "()Lkotlin/jvm/functions/Function0;", "addChangeListener", "", "listener", "Ljava/lang/Runnable;", "getNameAndDescription", "Lcom/intellij/openapi/util/Pair;", "", "execution-impl"})
    public static class SdkFromModuleDependencies<T extends ComboBox<?>>
    extends DefaultJreSelector {
        @NotNull
        private final T moduleComboBox;
        @NotNull
        private final Function1<T, Module> getSelectedModule;
        @NotNull
        private final Function0<Boolean> productionOnly;

        @Override
        @NotNull
        public Pair<String, String> getNameAndDescription() {
            Module module2 = (Module)this.getSelectedModule.invoke(this.moduleComboBox);
            if (module2 == null) {
                Pair pair2 = Pair.create(null, (Object)"module not specified");
                Intrinsics.checkExpressionValueIsNotNull((Object)pair2, (String)"Pair.create(null, \"module not specified\")");
                return pair2;
            }
            Module module3 = module2;
            boolean productionOnly = (Boolean)this.productionOnly.invoke();
            Sdk jdkToRun = JavaParameters.getJdkToRunModule((Module)module3, (boolean)productionOnly);
            Sdk moduleJdk = ModuleRootManager.getInstance((Module)module3).getSdk();
            if (moduleJdk == null || jdkToRun == null) {
                Pair pair3 = Pair.create(null, (Object)"module not specified");
                Intrinsics.checkExpressionValueIsNotNull((Object)pair3, (String)"Pair.create(null, \"module not specified\")");
                return pair3;
            }
            if (Intrinsics.areEqual((Object)moduleJdk.getHomeDirectory(), (Object)jdkToRun.getHomeDirectory())) {
                Pair pair4 = Pair.create((Object)moduleJdk.getName(), (Object)("SDK of '" + module3.getName() + "' module"));
                Intrinsics.checkExpressionValueIsNotNull((Object)pair4, (String)"Pair.create(moduleJdk.na\u2026'${module.name}' module\")");
                return pair4;
            }
            Pair pair5 = Pair.create((Object)jdkToRun.getName(), (Object)("newest SDK from '" + module3.getName() + "' module" + (productionOnly ? "" : " test") + " dependencies"));
            Intrinsics.checkExpressionValueIsNotNull((Object)pair5, (String)"Pair.create(jdkToRun.nam\u2026e \" test\"} dependencies\")");
            return pair5;
        }

        @Override
        public void addChangeListener(@NotNull Runnable listener2) {
            Intrinsics.checkParameterIsNotNull((Object)listener2, (String)"listener");
            this.moduleComboBox.addActionListener(new ActionListener(listener2){
                final /* synthetic */ Runnable $listener;

                public final void actionPerformed(ActionEvent it) {
                    this.$listener.run();
                }
                {
                    this.$listener = runnable2;
                }
            });
        }

        @NotNull
        public final T getModuleComboBox() {
            return this.moduleComboBox;
        }

        @NotNull
        public final Function1<T, Module> getGetSelectedModule() {
            return this.getSelectedModule;
        }

        @NotNull
        public final Function0<Boolean> getProductionOnly() {
            return this.productionOnly;
        }

        public SdkFromModuleDependencies(@NotNull T moduleComboBox, @NotNull Function1<? super T, ? extends Module> getSelectedModule, @NotNull Function0<Boolean> productionOnly) {
            Intrinsics.checkParameterIsNotNull(moduleComboBox, (String)"moduleComboBox");
            Intrinsics.checkParameterIsNotNull(getSelectedModule, (String)"getSelectedModule");
            Intrinsics.checkParameterIsNotNull(productionOnly, (String)"productionOnly");
            this.moduleComboBox = moduleComboBox;
            this.getSelectedModule = getSelectedModule;
            this.productionOnly = productionOnly;
        }
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u0000*\f\b\u0000\u0010\u0001*\u0006\u0012\u0002\b\u00030\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B+\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u0012\u0014\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0011"}, d2={"Lcom/intellij/execution/ui/DefaultJreSelector$SdkFromSourceRootDependencies;", "T", "Lcom/intellij/openapi/ui/ComboBox;", "Lcom/intellij/execution/ui/DefaultJreSelector$SdkFromModuleDependencies;", "moduleComboBox", "getSelectedModule", "Lkotlin/Function1;", "Lcom/intellij/openapi/module/Module;", "classSelector", "Lcom/intellij/ui/EditorTextFieldWithBrowseButton;", "(Lcom/intellij/openapi/ui/ComboBox;Lkotlin/jvm/functions/Function1;Lcom/intellij/ui/EditorTextFieldWithBrowseButton;)V", "getClassSelector", "()Lcom/intellij/ui/EditorTextFieldWithBrowseButton;", "addChangeListener", "", "listener", "Ljava/lang/Runnable;", "execution-impl"})
    public static final class SdkFromSourceRootDependencies<T extends ComboBox<?>>
    extends SdkFromModuleDependencies<T> {
        @NotNull
        private final EditorTextFieldWithBrowseButton classSelector;

        @Override
        public void addChangeListener(@NotNull Runnable listener2) {
            Intrinsics.checkParameterIsNotNull((Object)listener2, (String)"listener");
            super.addChangeListener(listener2);
            ((EditorTextField)((Object)this.classSelector.getChildComponent())).addDocumentListener(new DocumentListener(listener2){
                final /* synthetic */ Runnable $listener;

                public void documentChanged(@Nullable DocumentEvent e) {
                    this.$listener.run();
                }
                {
                    this.$listener = $captured_local_variable$0;
                }
            });
        }

        @NotNull
        public final EditorTextFieldWithBrowseButton getClassSelector() {
            return this.classSelector;
        }

        public SdkFromSourceRootDependencies(final @NotNull T moduleComboBox, final @NotNull Function1<? super T, ? extends Module> getSelectedModule, final @NotNull EditorTextFieldWithBrowseButton classSelector) {
            Intrinsics.checkParameterIsNotNull(moduleComboBox, (String)"moduleComboBox");
            Intrinsics.checkParameterIsNotNull(getSelectedModule, (String)"getSelectedModule");
            Intrinsics.checkParameterIsNotNull((Object)((Object)classSelector), (String)"classSelector");
            super(moduleComboBox, getSelectedModule, (Function0<Boolean>)((Function0)new Function0<Boolean>(){

                public final boolean invoke() {
                    return DefaultJreSelectorKt.access$isClassInProductionSources(moduleComboBox, getSelectedModule, classSelector);
                }
            }));
            this.classSelector = classSelector;
        }
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0018\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0018\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000fH\u0007\u00a8\u0006\u0010"}, d2={"Lcom/intellij/execution/ui/DefaultJreSelector$Companion;", "", "()V", "fromModuleDependencies", "Lcom/intellij/execution/ui/DefaultJreSelector;", "moduleComboBox", "Lcom/intellij/application/options/ModuleDescriptionsComboBox;", "productionOnly", "", "Lcom/intellij/application/options/ModulesComboBox;", "fromSourceRootsDependencies", "classSelector", "Lcom/intellij/ui/EditorTextFieldWithBrowseButton;", "projectSdk", "project", "Lcom/intellij/openapi/project/Project;", "execution-impl"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final DefaultJreSelector projectSdk(@NotNull Project project2) {
            Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
            return new ProjectSdkSelector(project2);
        }

        @JvmStatic
        @NotNull
        public final DefaultJreSelector fromModuleDependencies(@NotNull ModulesComboBox moduleComboBox, boolean productionOnly) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)moduleComboBox), (String)"moduleComboBox");
            return new SdkFromModuleDependencies<ComboBox>(moduleComboBox, fromModuleDependencies.1.INSTANCE, (Function0<Boolean>)((Function0)new Function0<Boolean>(productionOnly){
                final /* synthetic */ boolean $productionOnly;

                public final boolean invoke() {
                    return this.$productionOnly;
                }
                {
                    this.$productionOnly = bl;
                    super(0);
                }
            }));
        }

        @JvmStatic
        @NotNull
        public final DefaultJreSelector fromModuleDependencies(@NotNull ModuleDescriptionsComboBox moduleComboBox, boolean productionOnly) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)moduleComboBox), (String)"moduleComboBox");
            return new SdkFromModuleDependencies<ComboBox>(moduleComboBox, fromModuleDependencies.3.INSTANCE, (Function0<Boolean>)((Function0)new Function0<Boolean>(productionOnly){
                final /* synthetic */ boolean $productionOnly;

                public final boolean invoke() {
                    return this.$productionOnly;
                }
                {
                    this.$productionOnly = bl;
                    super(0);
                }
            }));
        }

        @JvmStatic
        @NotNull
        public final DefaultJreSelector fromSourceRootsDependencies(@NotNull ModulesComboBox moduleComboBox, @NotNull EditorTextFieldWithBrowseButton classSelector) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)moduleComboBox), (String)"moduleComboBox");
            Intrinsics.checkParameterIsNotNull((Object)((Object)classSelector), (String)"classSelector");
            return new SdkFromSourceRootDependencies<ComboBox>((ComboBox)moduleComboBox, (Function1)fromSourceRootsDependencies.1.INSTANCE, classSelector);
        }

        @JvmStatic
        @NotNull
        public final DefaultJreSelector fromSourceRootsDependencies(@NotNull ModuleDescriptionsComboBox moduleComboBox, @NotNull EditorTextFieldWithBrowseButton classSelector) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)moduleComboBox), (String)"moduleComboBox");
            Intrinsics.checkParameterIsNotNull((Object)((Object)classSelector), (String)"classSelector");
            return new SdkFromSourceRootDependencies<ComboBox>((ComboBox)moduleComboBox, (Function1)fromSourceRootsDependencies.2.INSTANCE, classSelector);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

