/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui;

import com.intellij.execution.ui.JrePathEditor;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.ui.SortedComboBoxModel;
import com.intellij.ui.components.JBTextField;
import com.intellij.util.ui.StatusText;
import java.awt.Container;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import org.jetbrains.annotations.NotNull;

class JreComboboxEditor
extends BasicComboBoxEditor {
    public static final TextComponentAccessor<JComboBox> TEXT_COMPONENT_ACCESSOR = new JreComboBoxTextComponentAccessor();
    private final SortedComboBoxModel<JrePathEditor.JreComboBoxItem> myComboBoxModel;

    public JreComboboxEditor(SortedComboBoxModel<JrePathEditor.JreComboBoxItem> comboBoxModel) {
        this.myComboBoxModel = comboBoxModel;
    }

    @Override
    public void setItem(Object anObject) {
        this.editor.setText(anObject == null ? "" : ((JrePathEditor.JreComboBoxItem)anObject).getPresentableText());
    }

    @Override
    public Object getItem() {
        String text2 = this.editor.getText().trim();
        for (JrePathEditor.JreComboBoxItem item : this.myComboBoxModel.getItems()) {
            if (!item.getPresentableText().equals(text2)) continue;
            return item;
        }
        return new JrePathEditor.CustomJreItem(FileUtil.toSystemIndependentName((String)text2));
    }

    @Override
    protected JTextField createEditorComponent() {
        JBTextField field = new JBTextField();
        field.setBorder(null);
        field.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                this.update(e);
            }

            @Override
            public void focusLost(FocusEvent e) {
                this.update(e);
            }

            private void update(FocusEvent e) {
                Container c = e.getComponent().getParent();
                if (c != null) {
                    c.revalidate();
                    c.repaint();
                }
            }
        });
        return field;
    }

    public StatusText getEmptyText() {
        return this.getEditorComponent().getEmptyText();
    }

    public JBTextField getEditorComponent() {
        return (JBTextField)super.getEditorComponent();
    }

    private static class JreComboBoxTextComponentAccessor
    implements TextComponentAccessor<JComboBox> {
        private JreComboBoxTextComponentAccessor() {
        }

        public String getText(JComboBox component) {
            Object item = component.getEditor().getItem();
            return item != null ? ((JrePathEditor.JreComboBoxItem)item).getPresentableText() : "";
        }

        public void setText(JComboBox component, @NotNull String text2) {
            if (text2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/execution/ui/JreComboboxEditor$JreComboBoxTextComponentAccessor", "setText"));
            }
            component.getEditor().setItem(new JrePathEditor.CustomJreItem(FileUtil.toSystemIndependentName((String)text2)));
        }
    }
}

