/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.util;

import com.intellij.execution.CantRunException;
import com.intellij.execution.CommonJavaRunConfigurationParameters;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.RunConfigurationModule;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.execution.configurations.SimpleProgramParameters;
import com.intellij.execution.util.ProgramParametersUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.ex.PathUtilEx;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ExportableOrderEntry;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ObjectUtils;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaParametersUtil {
    private JavaParametersUtil() {
    }

    public static void configureConfiguration(SimpleJavaParameters parameters2, CommonJavaRunConfigurationParameters configuration) {
        String vmParameters;
        ProgramParametersUtil.configureConfiguration((SimpleProgramParameters)parameters2, configuration);
        Project project2 = configuration.getProject();
        Module module2 = ProgramParametersUtil.getModule(configuration);
        String alternativeJrePath = configuration.getAlternativeJrePath();
        if (alternativeJrePath != null) {
            configuration.setAlternativeJrePath(ProgramParametersUtil.expandPath(alternativeJrePath, null, project2));
        }
        if ((vmParameters = configuration.getVMParameters()) != null) {
            vmParameters = ProgramParametersUtil.expandPath(vmParameters, module2, project2);
            for (Map.Entry each : parameters2.getEnv().entrySet()) {
                vmParameters = StringUtil.replace((String)vmParameters, (String)("$" + (String)each.getKey() + "$"), (String)((String)each.getValue()), (boolean)false);
            }
        }
        parameters2.getVMParametersList().addParametersString(vmParameters);
    }

    public static int getClasspathType(RunConfigurationModule configurationModule, String mainClassName, boolean classMustHaveSource) throws CantRunException {
        Module module2 = configurationModule.getModule();
        if (module2 == null) {
            throw CantRunException.noModuleConfigured((String)configurationModule.getModuleName());
        }
        Boolean inProduction = JavaParametersUtil.isClassInProductionSources(mainClassName, module2);
        if (inProduction == null) {
            if (!classMustHaveSource) {
                return 7;
            }
            throw CantRunException.classNotFound((String)mainClassName, (Module)module2);
        }
        return inProduction != false ? 3 : 7;
    }

    @Nullable(value="null if class not found")
    public static Boolean isClassInProductionSources(@NotNull String mainClassName, @NotNull Module module2) {
        ModuleFileIndex fileIndex;
        Module classModule;
        if (mainClassName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mainClassName", "com/intellij/execution/util/JavaParametersUtil", "isClassInProductionSources"));
        }
        if (module2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/execution/util/JavaParametersUtil", "isClassInProductionSources"));
        }
        PsiClass psiClass = JavaExecutionUtil.findMainClass((Module)module2, (String)mainClassName);
        if (psiClass == null) {
            return null;
        }
        PsiFile psiFile = psiClass.getContainingFile();
        if (psiFile == null) {
            return null;
        }
        VirtualFile virtualFile = psiFile.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        Module module3 = classModule = psiClass.isValid() ? ModuleUtilCore.findModuleForPsiElement((PsiElement)psiClass) : null;
        if (classModule == null) {
            classModule = module2;
        }
        if ((fileIndex = ModuleRootManager.getInstance((Module)classModule).getFileIndex()).isInSourceContent(virtualFile)) {
            return !fileIndex.isInTestSourceContent(virtualFile);
        }
        List entriesForFile = fileIndex.getOrderEntriesForFile(virtualFile);
        for (OrderEntry entry : entriesForFile) {
            if (!(entry instanceof ExportableOrderEntry) || ((ExportableOrderEntry)entry).getScope() != DependencyScope.TEST) continue;
            return false;
        }
        return true;
    }

    public static void configureModule(RunConfigurationModule runConfigurationModule, JavaParameters parameters2, int classPathType, @Nullable String jreHome) throws CantRunException {
        Module module2 = runConfigurationModule.getModule();
        if (module2 == null) {
            throw CantRunException.noModuleConfigured((String)runConfigurationModule.getModuleName());
        }
        JavaParametersUtil.configureModule(module2, parameters2, classPathType, jreHome);
    }

    public static void configureModule(Module module2, JavaParameters parameters2, int classPathType, @Nullable String jreHome) throws CantRunException {
        parameters2.configureByModule(module2, classPathType, JavaParametersUtil.createModuleJdk(module2, (classPathType & 4) == 0, jreHome));
    }

    public static void configureProject(Project project2, JavaParameters parameters2, int classPathType, @Nullable String jreHome) throws CantRunException {
        parameters2.configureByProject(project2, classPathType, JavaParametersUtil.createProjectJdk(project2, jreHome));
    }

    public static Sdk createModuleJdk(Module module2, boolean productionOnly, @Nullable String jreHome) throws CantRunException {
        return jreHome == null ? JavaParameters.getValidJdkToRunModule((Module)module2, (boolean)productionOnly) : JavaParametersUtil.createAlternativeJdk(jreHome);
    }

    public static Sdk createProjectJdk(Project project2, @Nullable String jreHome) throws CantRunException {
        return jreHome == null ? JavaParametersUtil.createProjectJdk(project2) : JavaParametersUtil.createAlternativeJdk(jreHome);
    }

    private static Sdk createProjectJdk(Project project2) throws CantRunException {
        Sdk jdk = PathUtilEx.getAnyJdk(project2);
        if (jdk == null) {
            throw CantRunException.noJdkConfigured();
        }
        return jdk;
    }

    private static Sdk createAlternativeJdk(@NotNull String jreHome) throws CantRunException {
        if (jreHome == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jreHome", "com/intellij/execution/util/JavaParametersUtil", "createAlternativeJdk"));
        }
        Sdk configuredJdk = ProjectJdkTable.getInstance().findJdk(jreHome);
        if (configuredJdk != null) {
            return configuredJdk;
        }
        if (!JdkUtil.checkForJre((String)jreHome)) {
            throw new CantRunException(ExecutionBundle.message((String)"jre.path.is.not.valid.jre.home.error.message", (Object[])new Object[]{jreHome}));
        }
        JavaSdk javaSdk = JavaSdk.getInstance();
        return javaSdk.createJdk((String)ObjectUtils.notNull((Object)javaSdk.getVersionString(jreHome), (Object)""), jreHome);
    }

    public static void checkAlternativeJRE(@NotNull CommonJavaRunConfigurationParameters configuration) throws RuntimeConfigurationWarning {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/execution/util/JavaParametersUtil", "checkAlternativeJRE"));
        }
        if (configuration.isAlternativeJrePathEnabled()) {
            JavaParametersUtil.checkAlternativeJRE(configuration.getAlternativeJrePath());
        }
    }

    public static void checkAlternativeJRE(@Nullable String jrePath) throws RuntimeConfigurationWarning {
        if (StringUtil.isEmptyOrSpaces((String)jrePath) || ProjectJdkTable.getInstance().findJdk(jrePath) == null && !JdkUtil.checkForJre((String)jrePath)) {
            throw new RuntimeConfigurationWarning(ExecutionBundle.message((String)"jre.path.is.not.valid.jre.home.error.message", (Object[])new Object[]{jrePath}));
        }
    }
}

