/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.externalDependencies.impl;

import com.intellij.externalDependencies.DependencyOnPlugin;
import com.intellij.externalDependencies.ExternalDependenciesManager;
import com.intellij.externalDependencies.ProjectExternalDependency;
import com.intellij.externalDependencies.impl.CheckRequiredPluginsActivity;
import com.intellij.externalDependencies.impl.DependencyOnPluginState;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FilteringIterator;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import com.intellij.util.xmlb.annotations.Property;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="ExternalDependencies", storages={@Storage(value="externalDependencies.xml")})
public class ExternalDependenciesManagerImpl
extends ExternalDependenciesManager
implements PersistentStateComponent<ExternalDependenciesState> {
    private final Project myProject;
    private static final Comparator<ProjectExternalDependency> DEPENDENCY_COMPARATOR = (o1, o2) -> {
        int i2 = o1.getClass().getSimpleName().compareToIgnoreCase(o2.getClass().getSimpleName());
        if (i2 != 0) {
            return i2;
        }
        return ((Comparable)((Object)o1)).compareTo(o2);
    };
    private List<ProjectExternalDependency> myDependencies = new ArrayList<ProjectExternalDependency>();

    public ExternalDependenciesManagerImpl(Project project2) {
        this.myProject = project2;
    }

    @Override
    @NotNull
    public <T extends ProjectExternalDependency> List<T> getDependencies(@NotNull Class<T> aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/externalDependencies/impl/ExternalDependenciesManagerImpl", "getDependencies"));
        }
        List list2 = ContainerUtil.collect(this.myDependencies.iterator(), (FilteringIterator.InstanceOf)FilteringIterator.instanceOf(aClass));
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/externalDependencies/impl/ExternalDependenciesManagerImpl", "getDependencies"));
        }
        return list2;
    }

    @Override
    @NotNull
    public List<ProjectExternalDependency> getAllDependencies() {
        List<ProjectExternalDependency> list2 = Collections.unmodifiableList(this.myDependencies);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/externalDependencies/impl/ExternalDependenciesManagerImpl", "getAllDependencies"));
        }
        return list2;
    }

    @Override
    public void setAllDependencies(@NotNull List<ProjectExternalDependency> dependencies) {
        if (dependencies == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependencies", "com/intellij/externalDependencies/impl/ExternalDependenciesManagerImpl", "setAllDependencies"));
        }
        this.myDependencies.clear();
        this.myDependencies.addAll(dependencies);
        Collections.sort(this.myDependencies, DEPENDENCY_COMPARATOR);
    }

    @Nullable
    public ExternalDependenciesState getState() {
        ExternalDependenciesState state = new ExternalDependenciesState();
        for (ProjectExternalDependency dependency : this.myDependencies) {
            state.myDependencies.add(new DependencyOnPluginState((DependencyOnPlugin)dependency));
        }
        return state;
    }

    public void loadState(ExternalDependenciesState state) {
        ArrayList<ProjectExternalDependency> oldDependencies = new ArrayList<ProjectExternalDependency>(this.myDependencies);
        this.myDependencies.clear();
        for (DependencyOnPluginState dependency : state.myDependencies) {
            this.myDependencies.add(new DependencyOnPlugin(dependency.myId, dependency.myMinVersion, dependency.myMaxVersion, dependency.myChannel));
        }
        if (!oldDependencies.equals(this.myDependencies) && !this.myDependencies.isEmpty()) {
            StartupManager.getInstance((Project)this.myProject).runWhenProjectIsInitialized((Runnable)((DumbAwareRunnable)() -> CheckRequiredPluginsActivity.runCheck(this.myProject)));
        }
    }

    public static class ExternalDependenciesState {
        @Property(surroundWithTag=false)
        @AbstractCollection(surroundWithTag=false)
        public List<DependencyOnPluginState> myDependencies = new ArrayList<DependencyOnPluginState>();
    }
}

