/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet;

import com.google.common.base.Predicates;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.FacetFromExternalSourcesStorage;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetManagerListener;
import com.intellij.facet.FacetType;
import com.intellij.facet.FacetTypeId;
import com.intellij.facet.FacetTypeRegistry;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.facet.impl.FacetLoadingErrorDescription;
import com.intellij.facet.impl.FacetModelBase;
import com.intellij.facet.impl.FacetModelImpl;
import com.intellij.facet.impl.FacetUtil;
import com.intellij.facet.impl.invalid.InvalidFacet;
import com.intellij.facet.impl.invalid.InvalidFacetConfiguration;
import com.intellij.facet.impl.invalid.InvalidFacetManager;
import com.intellij.facet.impl.invalid.InvalidFacetType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleComponent;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ProjectLoadingErrorsNotifier;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.project.ProjectUtilCore;
import com.intellij.openapi.roots.ExternalProjectSystemRegistry;
import com.intellij.openapi.roots.ProjectModelExternalSource;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.UnknownFeaturesCollector;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.serialization.facet.FacetManagerState;
import org.jetbrains.jps.model.serialization.facet.FacetState;

@State(name="FacetManager")
public class FacetManagerImpl
extends FacetManager
implements ModuleComponent,
PersistentStateComponent<FacetManagerState> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.facet.FacetManagerImpl");
    @NonNls
    public static final String COMPONENT_NAME = "FacetManager";
    private final Module myModule;
    private final FacetManagerModel myModel = new FacetManagerModel();
    private boolean myInsideCommit = false;
    private final MessageBus myMessageBus;
    private boolean myModuleAdded;

    public FacetManagerImpl(Module module2, MessageBus messageBus) {
        this.myModule = module2;
        this.myMessageBus = messageBus;
    }

    @NotNull
    public ModifiableFacetModel createModifiableModel() {
        FacetModelImpl model = new FacetModelImpl(this);
        model.addFacetsFromManager();
        FacetModelImpl facetModelImpl = model;
        if (facetModelImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/facet/FacetManagerImpl", "createModifiableModel"));
        }
        return facetModelImpl;
    }

    @NotNull
    public Facet[] getAllFacets() {
        Facet[] facetArray = this.myModel.getAllFacets();
        if (facetArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/facet/FacetManagerImpl", "getAllFacets"));
        }
        return facetArray;
    }

    @Nullable
    public <F extends Facet> F getFacetByType(FacetTypeId<F> typeId) {
        return this.myModel.getFacetByType(typeId);
    }

    @Nullable
    public <F extends Facet> F findFacet(FacetTypeId<F> type2, String name2) {
        return this.myModel.findFacet(type2, name2);
    }

    @Nullable
    public <F extends Facet> F getFacetByType(@NotNull Facet underlyingFacet, FacetTypeId<F> typeId) {
        if (underlyingFacet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "underlyingFacet", "com/intellij/facet/FacetManagerImpl", "getFacetByType"));
        }
        return this.myModel.getFacetByType(underlyingFacet, typeId);
    }

    @NotNull
    public <F extends Facet> Collection<F> getFacetsByType(@NotNull Facet underlyingFacet, FacetTypeId<F> typeId) {
        if (underlyingFacet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "underlyingFacet", "com/intellij/facet/FacetManagerImpl", "getFacetsByType"));
        }
        Collection<F> collection = this.myModel.getFacetsByType(underlyingFacet, typeId);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/facet/FacetManagerImpl", "getFacetsByType"));
        }
        return collection;
    }

    @NotNull
    public <F extends Facet> Collection<F> getFacetsByType(FacetTypeId<F> typeId) {
        Collection<F> collection = this.myModel.getFacetsByType(typeId);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/facet/FacetManagerImpl", "getFacetsByType"));
        }
        return collection;
    }

    @NotNull
    public Facet[] getSortedFacets() {
        Facet[] facetArray = this.myModel.getSortedFacets();
        if (facetArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/facet/FacetManagerImpl", "getSortedFacets"));
        }
        return facetArray;
    }

    @NotNull
    public String getFacetName(@NotNull Facet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/intellij/facet/FacetManagerImpl", "getFacetName"));
        }
        String string = this.myModel.getFacetName(facet);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/facet/FacetManagerImpl", "getFacetName"));
        }
        return string;
    }

    @NotNull
    public <F extends Facet, C extends FacetConfiguration> F createFacet(@NotNull FacetType<F, C> type2, @NotNull String name2, @NotNull C configuration, @Nullable Facet underlying) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/facet/FacetManagerImpl", "createFacet"));
        }
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/facet/FacetManagerImpl", "createFacet"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/facet/FacetManagerImpl", "createFacet"));
        }
        Facet facet = type2.createFacet(this.myModule, name2, configuration, underlying);
        FacetManagerImpl.assertTrue(facet.getModule() == this.myModule, facet, "module");
        FacetManagerImpl.assertTrue(facet.getConfiguration() == configuration, facet, "configuration");
        FacetManagerImpl.assertTrue(Comparing.equal((String)facet.getName(), (String)name2), facet, "name");
        FacetManagerImpl.assertTrue(facet.getUnderlyingFacet() == underlying, facet, "underlyingFacet");
        Facet facet2 = facet;
        if (facet2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/facet/FacetManagerImpl", "createFacet"));
        }
        return (F)facet2;
    }

    @NotNull
    public <F extends Facet, C extends FacetConfiguration> F createFacet(@NotNull FacetType<F, C> type2, @NotNull String name2, @Nullable Facet underlying) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/facet/FacetManagerImpl", "createFacet"));
        }
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/facet/FacetManagerImpl", "createFacet"));
        }
        FacetConfiguration configuration = ProjectFacetManager.getInstance((Project)this.myModule.getProject()).createDefaultConfiguration(type2);
        F f = this.createFacet(type2, name2, configuration, underlying);
        if (f == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/facet/FacetManagerImpl", "createFacet"));
        }
        return f;
    }

    @NotNull
    public <F extends Facet, C extends FacetConfiguration> F addFacet(@NotNull FacetType<F, C> type2, @NotNull String name2, @Nullable Facet underlying) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/facet/FacetManagerImpl", "addFacet"));
        }
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/facet/FacetManagerImpl", "addFacet"));
        }
        ModifiableFacetModel model = this.createModifiableModel();
        F facet = this.createFacet(type2, name2, underlying);
        model.addFacet(facet);
        model.commit();
        F f = facet;
        if (f == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/facet/FacetManagerImpl", "addFacet"));
        }
        return f;
    }

    private static void assertTrue(boolean value2, Facet facet, String parameter) {
        if (!value2) {
            LOG.error("Facet type " + facet.getType().getClass().getName() + " violates the contract of FacetType.createFacet method about '" + parameter + "' parameter");
        }
    }

    private void addFacets(List<FacetState> facetStates, Facet underlyingFacet, ModifiableFacetModel model) {
        FacetTypeRegistry registry = FacetTypeRegistry.getInstance();
        for (FacetState child : facetStates) {
            FacetType actualUnderlyingType;
            String typeId = child.getFacetType();
            if (typeId == null) {
                this.addInvalidFacet(child, model, underlyingFacet, ProjectBundle.message((String)"error.message.facet.type.isn.t.specified", (Object[])new Object[0]));
                continue;
            }
            FacetType type2 = registry.findFacetType(typeId);
            if (type2 == null) {
                this.addInvalidFacet(child, model, underlyingFacet, ProjectBundle.message((String)"error.message.unknown.facet.type.0", (Object[])new Object[]{typeId}), typeId);
                continue;
            }
            ModuleType moduleType = ModuleType.get((Module)this.myModule);
            if (!type2.isSuitableModuleType(moduleType)) {
                this.addInvalidFacet(child, model, underlyingFacet, ProjectBundle.message((String)"error.message.0.facets.are.not.allowed.in.1", (Object[])new Object[]{type2.getPresentableName(), moduleType.getName()}));
                continue;
            }
            FacetType expectedUnderlyingType = null;
            FacetTypeId underlyingTypeId = type2.getUnderlyingFacetType();
            if (underlyingTypeId != null) {
                expectedUnderlyingType = registry.findFacetType(underlyingTypeId);
            }
            FacetType facetType = actualUnderlyingType = underlyingFacet != null ? underlyingFacet.getType() : null;
            if (expectedUnderlyingType != null) {
                if (!expectedUnderlyingType.equals(actualUnderlyingType)) {
                    this.addInvalidFacet(child, model, underlyingFacet, ProjectBundle.message((String)"error.message.0.facet.must.be.placed.under.1.facet", (Object[])new Object[]{type2.getPresentableName(), expectedUnderlyingType.getPresentableName()}));
                    continue;
                }
            } else if (actualUnderlyingType != null) {
                this.addInvalidFacet(child, model, underlyingFacet, ProjectBundle.message((String)"error.message.0.cannot.be.placed.under.1", (Object[])new Object[]{type2.getPresentableName(), actualUnderlyingType.getPresentableName()}));
                continue;
            }
            try {
                this.addFacet(type2, child, underlyingFacet, model);
            }
            catch (InvalidDataException e) {
                LOG.info((Throwable)e);
                this.addInvalidFacet(child, model, underlyingFacet, ProjectBundle.message((String)"error.message.cannot.load.facet.configuration.0", (Object[])new Object[]{e.getMessage()}));
            }
        }
    }

    private void addInvalidFacet(FacetState state, ModifiableFacetModel model, Facet underlyingFacet, String errorMessage) {
        this.addInvalidFacet(state, model, underlyingFacet, errorMessage, null);
    }

    private void addInvalidFacet(FacetState state, ModifiableFacetModel model, Facet underlyingFacet, String errorMessage, String typeId) {
        InvalidFacetManager invalidFacetManager = InvalidFacetManager.getInstance(this.myModule.getProject());
        InvalidFacetType type2 = InvalidFacetType.getInstance();
        InvalidFacetConfiguration configuration = new InvalidFacetConfiguration(state, errorMessage);
        InvalidFacet facet = this.createFacet(type2, StringUtil.notNullize((String)state.getName()), configuration, underlyingFacet);
        model.addFacet((Facet)facet);
        if (!invalidFacetManager.isIgnored(facet)) {
            FacetLoadingErrorDescription description = new FacetLoadingErrorDescription(facet);
            ProjectLoadingErrorsNotifier.getInstance(this.myModule.getProject()).registerError(description);
            if (typeId != null) {
                UnknownFeaturesCollector.getInstance(this.myModule.getProject()).registerUnknownFeature("com.intellij.facetType", typeId, "Facet");
            }
        }
    }

    private <F extends Facet<C>, C extends FacetConfiguration> void addFacet(FacetType<F, C> type2, FacetState state, Facet underlyingFacet, ModifiableFacetModel model) throws InvalidDataException {
        Element newConfiguration;
        Collection facetsOfThisType;
        Collection collection = facetsOfThisType = underlyingFacet == null ? model.getFacetsByType(type2.getId()) : model.getFacetsByType(underlyingFacet, type2.getId());
        if (type2.isOnlyOneFacetAllowed() && !facetsOfThisType.isEmpty() && facetsOfThisType.stream().anyMatch(f -> !f.getName().equals(state.getName()))) {
            LOG.info("'" + state.getName() + "' facet removed from module " + this.myModule.getName() + ", because only one " + type2.getPresentableName() + " facet allowed");
            return;
        }
        Object facet = null;
        if (!facetsOfThisType.isEmpty() && ProjectUtilCore.isExternalStorageEnabled((Project)this.myModule.getProject()) && (facet = (Facet)facetsOfThisType.stream().filter(f -> f.getName().equals(state.getName())).findFirst().orElse(null)) != null && (newConfiguration = state.getConfiguration()) != null) {
            FacetUtil.loadFacetConfiguration(facet.getConfiguration(), newConfiguration);
        }
        if (facet == null) {
            String externalSystemId;
            FacetConfiguration configuration = type2.createDefaultConfiguration();
            Element config = state.getConfiguration();
            FacetUtil.loadFacetConfiguration(configuration, config);
            String name2 = state.getName();
            facet = this.createFacet(type2, name2, configuration, underlyingFacet);
            if (facet instanceof JDOMExternalizable) {
                ((JDOMExternalizable)facet).readExternal(config);
            }
            if ((externalSystemId = state.getExternalSystemId()) != null) {
                facet.setExternalSource(ExternalProjectSystemRegistry.getInstance().getSourceById(externalSystemId));
            }
            model.addFacet(facet);
        }
        this.addFacets(state.getSubFacets(), (Facet)facet, model);
    }

    public void loadState(FacetManagerState state) {
        FacetModelImpl model = new FacetModelImpl(this);
        FacetManagerState importedFacetsState = FacetFromExternalSourcesStorage.getInstance(this.myModule).getLoadedState();
        this.addFacets(ContainerUtil.concat((List)state.getFacets(), (List)importedFacetsState.getFacets()), null, model);
        this.commit(model, false);
    }

    @NotNull
    public FacetManagerState getState() {
        FacetManagerState facetManagerState = this.saveState(FacetManagerImpl.getImportedFacetPredicate(this.myModule.getProject()).negate());
        if (facetManagerState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/facet/FacetManagerImpl", "getState"));
        }
        return facetManagerState;
    }

    @NotNull
    static Predicate<Facet> getImportedFacetPredicate(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/facet/FacetManagerImpl", "getImportedFacetPredicate"));
        }
        if (ProjectUtilCore.isExternalStorageEnabled((Project)project2)) {
            Predicate<Facet> predicate = facet -> facet.getExternalSource() != null;
            if (predicate == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/facet/FacetManagerImpl", "getImportedFacetPredicate"));
            }
            return predicate;
        }
        com.google.common.base.Predicate predicate = Predicates.alwaysFalse();
        if (predicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/facet/FacetManagerImpl", "getImportedFacetPredicate"));
        }
        return predicate;
    }

    @NotNull
    FacetManagerState saveState(Predicate<Facet> filter) {
        FacetManagerState managerState = new FacetManagerState();
        Facet[] facets = this.getSortedFacets();
        HashMap<Facet, List<FacetState>> states = new HashMap<Facet, List<FacetState>>();
        states.put(null, managerState.getFacets());
        for (Facet facet : facets) {
            if (!filter.test(facet)) continue;
            Facet underlyingFacet = facet.getUnderlyingFacet();
            FacetState facetState = FacetManagerImpl.createFacetState(facet, this.myModule.getProject());
            if (!(facet instanceof InvalidFacet)) {
                Element config;
                block5: {
                    try {
                        FacetConfiguration configuration = facet.getConfiguration();
                        config = FacetUtil.saveFacetConfiguration(configuration);
                        if (!(facet instanceof JDOMExternalizable)) break block5;
                        ((JDOMExternalizable)facet).writeExternal(config);
                    }
                    catch (WriteExternalException e) {
                        continue;
                    }
                }
                facetState.setConfiguration(config);
            }
            FacetManagerImpl.getOrCreateTargetFacetList(underlyingFacet, states, this.myModule.getProject()).add(facetState);
            states.put(facet, facetState.getSubFacets());
        }
        FacetManagerState facetManagerState = managerState;
        if (facetManagerState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/facet/FacetManagerImpl", "saveState"));
        }
        return facetManagerState;
    }

    private static List<FacetState> getOrCreateTargetFacetList(Facet underlyingFacet, Map<Facet, List<FacetState>> states, @NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/facet/FacetManagerImpl", "getOrCreateTargetFacetList"));
        }
        List facetStateList = states.get(underlyingFacet);
        if (facetStateList == null) {
            FacetState state = FacetManagerImpl.createFacetState(underlyingFacet, project2);
            FacetManagerImpl.getOrCreateTargetFacetList(underlyingFacet.getUnderlyingFacet(), states, project2).add(state);
            facetStateList = state.getSubFacets();
            states.put(underlyingFacet, facetStateList);
        }
        return facetStateList;
    }

    private static FacetState createFacetState(@NotNull Facet facet, @NotNull Project project2) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/intellij/facet/FacetManagerImpl", "createFacetState"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/facet/FacetManagerImpl", "createFacetState"));
        }
        if (facet instanceof InvalidFacet) {
            return ((InvalidFacetConfiguration)((InvalidFacet)facet).getConfiguration()).getFacetState();
        }
        FacetState facetState = new FacetState();
        ProjectModelExternalSource externalSource = facet.getExternalSource();
        if (externalSource != null && ProjectUtilCore.isExternalStorageEnabled((Project)project2)) {
            facetState.setExternalSystemId(externalSource.getId());
        }
        facetState.setFacetType(facet.getType().getStringId());
        facetState.setName(facet.getName());
        return facetState;
    }

    public void commit(ModifiableFacetModel model) {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        this.commit(model, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commit(ModifiableFacetModel model, boolean fireEvents) {
        LOG.assertTrue(!this.myInsideCommit, (Object)"Recursive commit");
        HashSet<Facet> toRemove2 = new HashSet<Facet>(Arrays.asList(this.getAllFacets()));
        ArrayList<Facet> toAdd = new ArrayList<Facet>();
        ArrayList<FacetRenameInfo> toRename = new ArrayList<FacetRenameInfo>();
        FacetManagerListener publisher = (FacetManagerListener)this.myMessageBus.syncPublisher(FACETS_TOPIC);
        try {
            this.myInsideCommit = true;
            for (Facet facet : model.getAllFacets()) {
                boolean isNew;
                boolean bl = isNew = !toRemove2.remove(facet);
                if (!isNew) continue;
                toAdd.add(facet);
            }
            ArrayList<Facet> newFacets = new ArrayList<Facet>();
            for (Facet facet : this.getAllFacets()) {
                if (toRemove2.contains(facet)) continue;
                newFacets.add(facet);
            }
            newFacets.addAll(toAdd);
            for (Facet facet : newFacets) {
                String newName = model.getNewName(facet);
                if (newName == null || newName.equals(facet.getName())) continue;
                toRename.add(new FacetRenameInfo(facet, facet.getName(), newName));
            }
            if (fireEvents) {
                for (Facet facet : toAdd) {
                    publisher.beforeFacetAdded(facet);
                }
                for (Facet facet : toRemove2) {
                    publisher.beforeFacetRemoved(facet);
                }
                for (FacetRenameInfo info : toRename) {
                    publisher.beforeFacetRenamed(info.myFacet);
                }
            }
            for (FacetRenameInfo info : toRename) {
                info.myFacet.setName(info.myNewName);
            }
            this.myModel.setAllFacets(newFacets.toArray(new Facet[newFacets.size()]));
        }
        finally {
            this.myInsideCommit = false;
        }
        if (this.myModuleAdded) {
            for (Facet facet : toAdd) {
                facet.initFacet();
            }
        }
        for (Facet facet : toRemove2) {
            Disposer.dispose((Disposable)facet);
        }
        if (fireEvents) {
            for (Facet facet : toAdd) {
                publisher.facetAdded(facet);
            }
            for (Facet facet : toRemove2) {
                publisher.facetRemoved(facet);
            }
            for (FacetRenameInfo info : toRename) {
                publisher.facetRenamed(info.myFacet, info.myOldName);
            }
        }
        for (Facet facet : toAdd) {
            FacetType type2;
            Module module2 = facet.getModule();
            if (!module2.equals(this.myModule)) {
                LOG.error(facet + " is created for module " + module2 + " but added to module " + this.myModule);
            }
            if (!(type2 = facet.getType()).isOnlyOneFacetAllowed()) continue;
            if (type2.getUnderlyingFacetType() == null) {
                Collection facets = this.getFacetsByType(type2.getId());
                if (facets.size() <= 1) continue;
                LOG.error("Only one '" + type2.getPresentableName() + "' facet per module allowed, but " + facets.size() + " facets found in module '" + this.myModule.getName() + "'");
                continue;
            }
            Facet underlyingFacet = facet.getUnderlyingFacet();
            LOG.assertTrue(underlyingFacet != null, (Object)("Underlying facet is not specified for '" + facet.getName() + "'"));
            Collection facets = this.getFacetsByType(underlyingFacet, type2.getId());
            if (facets.size() <= 1) continue;
            LOG.error("Only one '" + type2.getPresentableName() + "' facet per parent facet allowed, but " + facets.size() + " sub-facets found in facet " + underlyingFacet.getName());
        }
    }

    public void setExternalSource(Facet facet, ProjectModelExternalSource externalSource) {
        facet.setExternalSource(externalSource);
    }

    Set<ProjectModelExternalSource> getExternalSources() {
        return this.myModel.myExternalSources;
    }

    public void moduleAdded() {
        if (this.myModuleAdded) {
            return;
        }
        for (Facet facet : this.getAllFacets()) {
            facet.initFacet();
        }
        this.myModuleAdded = true;
    }

    @NonNls
    @NotNull
    public String getComponentName() {
        if (COMPONENT_NAME == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/facet/FacetManagerImpl", "getComponentName"));
        }
        return COMPONENT_NAME;
    }

    private static class FacetRenameInfo {
        private final Facet myFacet;
        private final String myOldName;
        private final String myNewName;

        public FacetRenameInfo(Facet facet, String oldName, String newName) {
            this.myFacet = facet;
            this.myOldName = oldName;
            this.myNewName = newName;
        }
    }

    private static class FacetManagerModel
    extends FacetModelBase {
        private Facet[] myAllFacets = Facet.EMPTY_ARRAY;
        private Set<ProjectModelExternalSource> myExternalSources = new LinkedHashSet<ProjectModelExternalSource>();

        private FacetManagerModel() {
        }

        @NotNull
        public Facet[] getAllFacets() {
            if (this.myAllFacets == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/facet/FacetManagerImpl$FacetManagerModel", "getAllFacets"));
            }
            return this.myAllFacets;
        }

        public void setAllFacets(Facet[] allFacets) {
            this.myExternalSources.clear();
            for (Facet facet : allFacets) {
                ContainerUtil.addIfNotNull(this.myExternalSources, (Object)facet.getExternalSource());
            }
            this.myAllFacets = allFacets;
            this.facetsChanged();
        }
    }
}

