/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.impl.ui.libraries;

import com.intellij.facet.impl.ui.libraries.LibraryDownloadSettings;
import com.intellij.framework.library.DownloadableLibraryFileDescription;
import com.intellij.framework.library.DownloadableLibraryType;
import com.intellij.framework.library.FrameworkLibraryVersion;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryNameAndLevelPanel;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainer;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.ui.CheckBoxList;
import com.intellij.ui.CheckBoxListListener;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.FormBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DownloadingOptionsDialog
extends DialogWrapper {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.facet.impl.ui.libraries.DownloadingOptionsDialog");
    private JPanel myPanel;
    private CheckBoxList myFilesList;
    private TextFieldWithBrowseButton myDirectoryField;
    private JCheckBox myDownloadSourcesCheckBox;
    private JCheckBox myDownloadJavadocsCheckBox;
    private JLabel myFilesToDownloadLabel;
    private JLabel myCopyDownloadedFilesToLabel;
    private JPanel myNameWrappingPanel;
    private JComboBox myVersionComboBox;
    private final LibraryNameAndLevelPanel myNameAndLevelPanel;
    private DownloadableLibraryType myLibraryType;
    private FrameworkLibraryVersion myLastSelectedVersion;

    public DownloadingOptionsDialog(@NotNull Component parent, @NotNull LibraryDownloadSettings settings, @NotNull List<? extends FrameworkLibraryVersion> versions, boolean showNameAndLevel) {
        int n;
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/facet/impl/ui/libraries/DownloadingOptionsDialog", "<init>"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/facet/impl/ui/libraries/DownloadingOptionsDialog", "<init>"));
        }
        if (versions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "versions", "com/intellij/facet/impl/ui/libraries/DownloadingOptionsDialog", "<init>"));
        }
        super(parent, true);
        this.$$$setupUI$$$();
        this.setTitle("Downloading Options");
        this.myLibraryType = settings.getLibraryType();
        LOG.assertTrue(!versions.isEmpty());
        FormBuilder builder = LibraryNameAndLevelPanel.createFormBuilder();
        this.myVersionComboBox = new ComboBox();
        for (FrameworkLibraryVersion frameworkLibraryVersion : versions) {
            this.myVersionComboBox.addItem(frameworkLibraryVersion);
        }
        this.myVersionComboBox.setRenderer(new ListCellRendererWrapper<FrameworkLibraryVersion>(){

            public void customize(JList list2, FrameworkLibraryVersion value2, int index, boolean selected, boolean hasFocus) {
                this.setText(value2.getDefaultLibraryName());
            }
        });
        this.myVersionComboBox.setSelectedItem(settings.getVersion());
        if (versions.size() > 1) {
            builder.addLabeledComponent("&Version:", (JComponent)this.myVersionComboBox);
        }
        this.myNameAndLevelPanel = showNameAndLevel ? new LibraryNameAndLevelPanel(builder, settings.getLibraryName(), settings.getLibraryLevel()) : null;
        this.myNameWrappingPanel.add(builder.getPanel());
        this.onVersionChanged(settings.getSelectedDownloads());
        this.myVersionComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DownloadingOptionsDialog.this.onVersionChanged(null);
            }
        });
        this.myFilesList.setBorder(null);
        this.myFilesToDownloadLabel.setLabelFor((Component)this.myFilesList);
        this.myDirectoryField.addBrowseFolderListener(ProjectBundle.message((String)"file.chooser.directory.for.downloaded.libraries.title", (Object[])new Object[0]), ProjectBundle.message((String)"file.chooser.directory.for.downloaded.libraries.description", (Object[])new Object[0]), null, FileChooserDescriptorFactory.createSingleFolderDescriptor());
        this.myCopyDownloadedFilesToLabel.setLabelFor((Component)this.myDirectoryField);
        this.myDirectoryField.setText(FileUtil.toSystemDependentName((String)settings.getDirectoryForDownloadedLibrariesPath()));
        boolean sourcesCheckboxVisible = false;
        boolean bl = false;
        for (FrameworkLibraryVersion frameworkLibraryVersion : versions) {
            sourcesCheckboxVisible |= DownloadingOptionsDialog.haveAdditionalDownloads(frameworkLibraryVersion.getFiles(), AdditionalDownloadType.SOURCES);
            n |= DownloadingOptionsDialog.haveAdditionalDownloads(frameworkLibraryVersion.getFiles(), AdditionalDownloadType.DOCUMENTATION);
        }
        this.myDownloadSourcesCheckBox.setVisible(sourcesCheckboxVisible);
        this.myDownloadJavadocsCheckBox.setVisible(n != 0);
        this.myFilesList.setCheckBoxListListener(new CheckBoxListListener(){

            public void checkBoxSelectionChanged(int index, boolean value2) {
                DownloadingOptionsDialog.this.updateSourcesAndJavadocCheckboxes();
            }
        });
        this.updateSourcesAndJavadocCheckboxes();
        this.myDownloadSourcesCheckBox.setSelected(settings.isDownloadSources());
        this.myDownloadJavadocsCheckBox.setSelected(settings.isDownloadJavaDocs());
        this.init();
    }

    private void updateSourcesAndJavadocCheckboxes() {
        boolean sourcesCheckboxEnabled;
        boolean javadocCheckboxEnabled;
        FrameworkLibraryVersion version = this.getSelectedVersion();
        if (version == null) {
            javadocCheckboxEnabled = false;
            sourcesCheckboxEnabled = false;
        } else {
            List<DownloadableLibraryFileDescription> descriptions = this.getSelectedDownloads(version);
            sourcesCheckboxEnabled = DownloadingOptionsDialog.haveAdditionalDownloads(descriptions, AdditionalDownloadType.SOURCES);
            javadocCheckboxEnabled = DownloadingOptionsDialog.haveAdditionalDownloads(descriptions, AdditionalDownloadType.DOCUMENTATION);
        }
        DownloadingOptionsDialog.setEnabled(this.myDownloadSourcesCheckBox, sourcesCheckboxEnabled);
        DownloadingOptionsDialog.setEnabled(this.myDownloadJavadocsCheckBox, javadocCheckboxEnabled);
    }

    private static void setEnabled(JCheckBox checkBox, boolean enabled) {
        if (!enabled) {
            checkBox.setSelected(false);
        }
        checkBox.setEnabled(enabled);
    }

    private static boolean haveAdditionalDownloads(List<? extends DownloadableLibraryFileDescription> descriptions, AdditionalDownloadType type2) {
        for (DownloadableLibraryFileDescription downloadableLibraryFileDescription : descriptions) {
            if ((type2 != AdditionalDownloadType.SOURCES || downloadableLibraryFileDescription.getSourcesDescription() == null) && (type2 != AdditionalDownloadType.DOCUMENTATION || downloadableLibraryFileDescription.getDocumentationDescription() == null)) continue;
            return true;
        }
        return false;
    }

    private void onVersionChanged(@Nullable List<? extends DownloadableLibraryFileDescription> selectedFiles) {
        FrameworkLibraryVersion version = this.getSelectedVersion();
        if (Comparing.equal((Object)this.myLastSelectedVersion, (Object)version)) {
            return;
        }
        if (version != null) {
            List downloads = version.getFiles();
            this.myFilesList.setModel((ListModel)new CollectionListModel(ContainerUtil.map2Array((Collection)downloads, JCheckBox.class, description -> {
                boolean selected = selectedFiles != null ? selectedFiles.contains(description) : !description.isOptional();
                return new JCheckBox(description.getPresentableFileName(), selected);
            })));
            if (this.myNameAndLevelPanel != null) {
                this.myNameAndLevelPanel.setDefaultName(version.getDefaultLibraryName());
            }
        }
        this.updateSourcesAndJavadocCheckboxes();
        this.myLastSelectedVersion = version;
    }

    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myFilesList;
    }

    @Nullable
    public FrameworkLibraryVersion getSelectedVersion() {
        return (FrameworkLibraryVersion)this.myVersionComboBox.getSelectedItem();
    }

    @Nullable
    public static LibraryDownloadSettings showDialog(@NotNull JComponent parent, @NotNull LibraryDownloadSettings settings, List<? extends FrameworkLibraryVersion> versions, boolean showNameAndLevel) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/facet/impl/ui/libraries/DownloadingOptionsDialog", "showDialog"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/facet/impl/ui/libraries/DownloadingOptionsDialog", "showDialog"));
        }
        DownloadingOptionsDialog dialog2 = new DownloadingOptionsDialog(parent, settings, versions, showNameAndLevel);
        if (!dialog2.showAndGet()) {
            return null;
        }
        return dialog2.createSettings();
    }

    private List<DownloadableLibraryFileDescription> getSelectedDownloads(FrameworkLibraryVersion version) {
        ArrayList<DownloadableLibraryFileDescription> selected = new ArrayList<DownloadableLibraryFileDescription>();
        List downloads = version.getFiles();
        for (int i2 = 0; i2 < downloads.size(); ++i2) {
            if (!this.myFilesList.isItemSelected(i2)) continue;
            selected.add((DownloadableLibraryFileDescription)downloads.get(i2));
        }
        return selected;
    }

    private LibraryDownloadSettings createSettings() {
        LibrariesContainer.LibraryLevel libraryLevel;
        String libraryName;
        FrameworkLibraryVersion version = this.getSelectedVersion();
        LOG.assertTrue(version != null);
        if (this.myNameAndLevelPanel != null) {
            libraryName = this.myNameAndLevelPanel.getLibraryName();
            libraryLevel = this.myNameAndLevelPanel.getLibraryLevel();
        } else {
            libraryName = version.getDefaultLibraryName();
            libraryLevel = LibrariesContainer.LibraryLevel.PROJECT;
        }
        String path = FileUtil.toSystemIndependentName((String)this.myDirectoryField.getText());
        List<DownloadableLibraryFileDescription> selected = this.getSelectedDownloads(version);
        return new LibraryDownloadSettings(version, this.myLibraryType, path, libraryName, libraryLevel, selected, this.myDownloadSourcesCheckBox.isSelected(), this.myDownloadJavadocsCheckBox.isSelected());
    }

    private /* synthetic */ void $$$setupUI$$$() {
        CheckBoxList checkBoxList;
        JPanel jPanel;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JLabel jLabel;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JLabel jLabel2;
        JPanel jPanel2;
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(7, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(6, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myFilesToDownloadLabel = jLabel2 = new JLabel();
        jLabel2.setText("Files to download:");
        jLabel2.setDisplayedMnemonic('F');
        jLabel2.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myDirectoryField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel2.add((Component)textFieldWithBrowseButton, new GridConstraints(5, 0, 1, 1, 0, 1, 6, 0, null, new Dimension(350, -1), null));
        this.myCopyDownloadedFilesToLabel = jLabel = new JLabel();
        jLabel.setText("Copy downloaded files to:");
        jLabel.setDisplayedMnemonic('T');
        jLabel.setDisplayedMnemonicIndex(22);
        jPanel2.add((Component)jLabel, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myDownloadSourcesCheckBox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setFocusable(false);
        jCheckBox2.setText("Download sources");
        jCheckBox2.setMnemonic('S');
        jCheckBox2.setDisplayedMnemonicIndex(9);
        jPanel3.add((Component)jCheckBox2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel3.add((Component)spacer2, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myDownloadJavadocsCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setFocusable(false);
        jCheckBox.setText("Download javadocs");
        jCheckBox.setMnemonic('J');
        jCheckBox.setDisplayedMnemonicIndex(9);
        jPanel3.add((Component)jCheckBox, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myNameWrappingPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel2.add((Component)jBScrollPane, new GridConstraints(2, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        this.myFilesList = checkBoxList = new CheckBoxList();
        jBScrollPane.setViewportView((Component)checkBoxList);
        jLabel2.setLabelFor((Component)jBScrollPane);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private static enum AdditionalDownloadType {
        SOURCES,
        DOCUMENTATION;

    }
}

