/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find;

import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.find.EditorSearchSession;
import com.intellij.find.FindBundle;
import com.intellij.find.FindInProjectSettings;
import com.intellij.find.FindManager;
import com.intellij.find.FindModel;
import com.intellij.find.FindResult;
import com.intellij.find.findUsages.PsiElement2UsageTargetAdapter;
import com.intellij.find.impl.FindInProjectUtil;
import com.intellij.find.replaceInProject.ReplaceInProjectManager;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.CaretState;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ReadOnlyFragmentModificationException;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ScrollingModel;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.actions.EditorActionUtil;
import com.intellij.openapi.editor.actions.IncrementalFindAction;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.ui.LightweightHint;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageInfoToUsageConverter;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageView;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.usages.impl.UsageViewImpl;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FindUtil {
    private static final Key<Direction> KEY = Key.create((String)"FindUtil.KEY");

    private FindUtil() {
    }

    @Nullable
    private static VirtualFile getVirtualFile(@NotNull Editor myEditor) {
        if (myEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "myEditor", "com/intellij/find/FindUtil", "getVirtualFile"));
        }
        Project project2 = myEditor.getProject();
        PsiFile file2 = project2 != null ? PsiDocumentManager.getInstance((Project)project2).getPsiFile(myEditor.getDocument()) : null;
        return file2 != null ? file2.getVirtualFile() : null;
    }

    public static void initStringToFindWithSelection(FindModel findModel, Editor editor) {
        String s;
        if (editor != null && (s = editor.getSelectionModel().getSelectedText()) != null && s.length() < 10000) {
            FindModel.initStringToFindNoMultiline((FindModel)findModel, (String)s);
        }
    }

    private static boolean isMultilineSelection(Editor editor) {
        String selectedText;
        SelectionModel selectionModel;
        SelectionModel selectionModel2 = selectionModel = editor != null ? editor.getSelectionModel() : null;
        return selectionModel != null && (selectedText = selectionModel.getSelectedText()) != null && selectedText.contains("\n");
    }

    private static boolean isWholeLineSelection(Editor editor) {
        SelectionModel selectionModel;
        SelectionModel selectionModel2 = selectionModel = editor != null ? editor.getSelectionModel() : null;
        if (selectionModel != null) {
            int line;
            String selectedText = selectionModel.getSelectedText();
            Document document = editor.getDocument();
            String lineText = document.getText(new TextRange(document.getLineStartOffset(line = document.getLineNumber(selectionModel.getSelectionStart())), document.getLineEndOffset(line)));
            if (lineText.trim().equals(selectedText)) {
                return true;
            }
        }
        return false;
    }

    public static void configureFindModel(boolean replace, @Nullable Editor editor, FindModel model, boolean firstSearch) {
        String selectedText;
        boolean isGlobal = true;
        String stringToFind = null;
        SelectionModel selectionModel = editor != null ? editor.getSelectionModel() : null;
        String string = selectedText = selectionModel != null ? selectionModel.getSelectedText() : null;
        if (!StringUtil.isEmpty((String)selectedText)) {
            if (replace && (FindUtil.isMultilineSelection(editor) || FindUtil.isWholeLineSelection(editor))) {
                isGlobal = false;
                stringToFind = model.getStringToFind();
            } else if (FindUtil.isMultilineSelection(editor)) {
                model.setMultiline(true);
            }
            if (stringToFind == null) {
                stringToFind = selectedText;
            }
        } else {
            stringToFind = firstSearch ? "" : model.getStringToFind();
        }
        model.setReplaceState(replace);
        model.setStringToFind(stringToFind);
        model.setGlobal(isGlobal);
        model.setPromptOnReplace(false);
    }

    public static void updateFindInFileModel(@Nullable Project project2, @NotNull FindModel with, boolean saveFindString) {
        if (with == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "with", "com/intellij/find/FindUtil", "updateFindInFileModel"));
        }
        FindModel model = FindManager.getInstance((Project)project2).getFindInFileModel();
        model.setCaseSensitive(with.isCaseSensitive());
        model.setWholeWordsOnly(with.isWholeWordsOnly());
        model.setRegularExpressions(with.isRegularExpressions());
        model.setSearchContext(with.getSearchContext());
        if (saveFindString && !with.getStringToFind().isEmpty()) {
            model.setStringToFind(with.getStringToFind());
        }
        if (with.isReplaceState()) {
            model.setPreserveCase(with.isPreserveCase());
            if (saveFindString) {
                model.setStringToReplace(with.getStringToReplace());
            }
        }
    }

    public static void useFindStringFromFindInFileModel(FindModel findModel, Editor editor) {
        EditorSearchSession editorSearchSession;
        if (editor != null && (editorSearchSession = EditorSearchSession.get(editor)) != null) {
            FindModel currentFindModel = editorSearchSession.getFindModel();
            findModel.setStringToFind(currentFindModel.getStringToFind());
            if (findModel.isReplaceState()) {
                findModel.setStringToReplace(currentFindModel.getStringToReplace());
            }
        }
    }

    public static void findWordAtCaret(Project project2, Editor editor) {
        int caretOffset = editor.getCaretModel().getOffset();
        Document document = editor.getDocument();
        CharSequence text2 = document.getCharsSequence();
        int start = 0;
        int end = document.getTextLength();
        if (!editor.getSelectionModel().hasSelection()) {
            char c;
            int i2;
            for (i2 = caretOffset - 1; i2 >= 0; --i2) {
                c = text2.charAt(i2);
                if (Character.isJavaIdentifierPart(c)) continue;
                start = i2 + 1;
                break;
            }
            for (i2 = caretOffset; i2 < document.getTextLength(); ++i2) {
                c = text2.charAt(i2);
                if (Character.isJavaIdentifierPart(c)) continue;
                end = i2;
                break;
            }
        } else {
            start = editor.getSelectionModel().getSelectionStart();
            end = editor.getSelectionModel().getSelectionEnd();
        }
        if (start >= end) {
            return;
        }
        FindManager findManager = FindManager.getInstance((Project)project2);
        FindInProjectSettings findInProjectSettings = FindInProjectSettings.getInstance(project2);
        String s = text2.subSequence(start, end).toString();
        findInProjectSettings.addStringToFind(s);
        findManager.getFindInFileModel().setStringToFind(s);
        findManager.setFindWasPerformed();
        findManager.clearFindingNextUsageInFile();
        FindModel model = new FindModel();
        model.setStringToFind(s);
        model.setCaseSensitive(true);
        model.setWholeWordsOnly(!editor.getSelectionModel().hasSelection());
        EditorSearchSession searchSession = EditorSearchSession.get(editor);
        if (searchSession != null) {
            searchSession.setTextInField(model.getStringToFind());
        }
        findManager.setFindNextModel(model);
        FindUtil.doSearch(project2, editor, caretOffset, true, model, true);
    }

    public static void find(@NotNull Project project2, @NotNull Editor editor) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/find/FindUtil", "find"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/find/FindUtil", "find"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        FindManager findManager = FindManager.getInstance((Project)project2);
        String s = editor.getSelectionModel().getSelectedText();
        FindModel model = findManager.getFindInFileModel().clone();
        if (StringUtil.isEmpty((String)s)) {
            model.setGlobal(true);
        } else if (s.indexOf(10) >= 0) {
            model.setGlobal(false);
        } else {
            model.setStringToFind(s);
            model.setGlobal(true);
        }
        model.setReplaceState(false);
        model.setFindAllEnabled(PsiDocumentManager.getInstance((Project)project2).getPsiFile(editor.getDocument()) != null);
        findManager.showFindDialog(model, () -> {
            int offset;
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/find/FindUtil", "lambda$find$0"));
            }
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/find/FindUtil", "lambda$find$0"));
            }
            if (model.isFindAll()) {
                findManager.setFindNextModel(model);
                FindUtil.findAllAndShow(project2, editor, model);
                return;
            }
            if (!model.isGlobal() && editor.getSelectionModel().hasSelection()) {
                offset = model.isForward() ? editor.getSelectionModel().getSelectionStart() : editor.getSelectionModel().getSelectionEnd();
                ScrollType scrollType = model.isForward() ? ScrollType.CENTER_DOWN : ScrollType.CENTER_UP;
                FindUtil.moveCaretAndDontChangeSelection(editor, offset, scrollType);
            }
            if (model.isGlobal()) {
                offset = model.isFromCursor() ? editor.getCaretModel().getOffset() : (model.isForward() ? 0 : editor.getDocument().getTextLength());
            } else {
                if (!editor.getSelectionModel().hasSelection()) {
                    findManager.setFindNextModel(null);
                    return;
                }
                offset = model.isForward() ? editor.getSelectionModel().getSelectionStart() : editor.getSelectionModel().getSelectionEnd();
            }
            findManager.setFindNextModel(null);
            findManager.getFindInFileModel().copyFrom(model);
            FindUtil.doSearch(project2, editor, offset, true, model, true);
        });
    }

    @Nullable
    public static List<Usage> findAll(@NotNull Project project2, @NotNull Editor editor, @NotNull FindModel findModel) {
        FindResult result2;
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/find/FindUtil", "findAll"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/find/FindUtil", "findAll"));
        }
        if (findModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "findModel", "com/intellij/find/FindUtil", "findAll"));
        }
        Document document = editor.getDocument();
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)project2).getPsiFile(document);
        if (psiFile == null) {
            return null;
        }
        CharSequence text2 = document.getCharsSequence();
        int textLength = document.getTextLength();
        ArrayList<Usage> usages = new ArrayList<Usage>();
        FindManager findManager = FindManager.getInstance((Project)project2);
        findModel.setForward(true);
        int offset = 0;
        VirtualFile virtualFile = FindUtil.getVirtualFile(editor);
        while (offset < textLength && (result2 = findManager.findString(text2, offset, findModel, virtualFile)).isStringFound()) {
            usages.add((Usage)new UsageInfo2UsageAdapter(new UsageInfo((PsiElement)psiFile, result2.getStartOffset(), result2.getEndOffset())));
            int prevOffset = offset;
            if (prevOffset != (offset = result2.getEndOffset())) continue;
            ++offset;
        }
        return usages;
    }

    public static void findAllAndShow(@NotNull Project project2, @NotNull Editor editor, @NotNull FindModel findModel) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/find/FindUtil", "findAllAndShow"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/find/FindUtil", "findAllAndShow"));
        }
        if (findModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "findModel", "com/intellij/find/FindUtil", "findAllAndShow"));
        }
        List<Usage> usages = FindUtil.findAll(project2, editor, findModel);
        if (usages == null) {
            return;
        }
        UsageTarget[] usageTargets = new UsageTarget[]{new FindInProjectUtil.StringUsageTarget(project2, findModel)};
        UsageViewPresentation usageViewPresentation = FindInProjectUtil.setupViewPresentation(false, findModel);
        UsageViewManager.getInstance((Project)project2).showUsages(usageTargets, usages.toArray(new Usage[usages.size()]), usageViewPresentation);
    }

    public static void searchBack(Project project2, FileEditor fileEditor, @Nullable DataContext dataContext) {
        if (!(fileEditor instanceof TextEditor)) {
            return;
        }
        TextEditor textEditor = (TextEditor)fileEditor;
        Editor editor = textEditor.getEditor();
        FindUtil.searchBack(project2, editor, dataContext);
    }

    public static void searchBack(Project project2, Editor editor, @Nullable DataContext context) {
        int offset;
        FindManager findManager = FindManager.getInstance((Project)project2);
        if (!findManager.findWasPerformed() && !findManager.selectNextOccurrenceWasPerformed()) {
            new IncrementalFindAction().getHandler().execute(editor, context);
            return;
        }
        FindModel model = findManager.getFindNextModel(editor);
        if (model == null) {
            model = findManager.getFindInFileModel();
        }
        model.setForward(!(model = model.clone()).isForward());
        if (!model.isGlobal() && !editor.getSelectionModel().hasSelection()) {
            model.setGlobal(true);
        }
        if (Direction.UP.equals(editor.getUserData(KEY)) && !model.isForward()) {
            offset = editor.getDocument().getTextLength();
        } else if (Direction.DOWN.equals(editor.getUserData(KEY)) && model.isForward()) {
            offset = 0;
        } else {
            editor.putUserData(KEY, null);
            offset = editor.getCaretModel().getOffset();
            if (!model.isForward() && offset > 0) {
                --offset;
            }
        }
        FindUtil.searchAgain(project2, editor, offset, model);
    }

    public static boolean searchAgain(Project project2, FileEditor fileEditor, @Nullable DataContext context) {
        if (!(fileEditor instanceof TextEditor)) {
            return false;
        }
        TextEditor textEditor = (TextEditor)fileEditor;
        Editor editor = textEditor.getEditor();
        return FindUtil.searchAgain(project2, editor, context);
    }

    private static boolean searchAgain(Project project2, Editor editor, @Nullable DataContext context) {
        int offset;
        FindManager findManager = FindManager.getInstance((Project)project2);
        if (!findManager.findWasPerformed() && !findManager.selectNextOccurrenceWasPerformed()) {
            new IncrementalFindAction().getHandler().execute(editor, context);
            return false;
        }
        FindModel model = findManager.getFindNextModel(editor);
        if (model == null) {
            model = findManager.getFindInFileModel();
        }
        model = model.clone();
        if (Direction.DOWN.equals(editor.getUserData(KEY)) && model.isForward()) {
            offset = 0;
        } else if (Direction.UP.equals(editor.getUserData(KEY)) && !model.isForward()) {
            offset = editor.getDocument().getTextLength();
        } else {
            editor.putUserData(KEY, null);
            int n = offset = model.isGlobal() && model.isForward() ? editor.getSelectionModel().getSelectionEnd() : editor.getCaretModel().getOffset();
            if (!model.isForward() && offset > 0) {
                --offset;
            }
        }
        return FindUtil.searchAgain(project2, editor, offset, model);
    }

    private static boolean searchAgain(Project project2, Editor editor, int offset, FindModel model) {
        if (!model.isGlobal() && !editor.getSelectionModel().hasSelection()) {
            model.setGlobal(true);
        }
        model.setFromCursor(false);
        if (model.isReplaceState()) {
            model.setPromptOnReplace(true);
            model.setReplaceAll(false);
            FindUtil.replace(project2, editor, offset, model);
            return true;
        }
        FindUtil.doSearch(project2, editor, offset, true, model, true);
        return false;
    }

    public static void replace(@NotNull Project project2, @NotNull Editor editor) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/find/FindUtil", "replace"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/find/FindUtil", "replace"));
        }
        FindManager findManager = FindManager.getInstance((Project)project2);
        FindModel model = findManager.getFindInFileModel().clone();
        String s = editor.getSelectionModel().getSelectedText();
        if (!StringUtil.isEmpty((String)s)) {
            if (s.indexOf(10) >= 0) {
                model.setGlobal(false);
            } else {
                model.setStringToFind(s);
                model.setGlobal(true);
            }
        } else {
            model.setGlobal(true);
        }
        model.setReplaceState(true);
        findManager.showFindDialog(model, () -> {
            int offset;
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/find/FindUtil", "lambda$replace$1"));
            }
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/find/FindUtil", "lambda$replace$1"));
            }
            if (!model.isGlobal() && editor.getSelectionModel().hasSelection()) {
                offset = model.isForward() ? editor.getSelectionModel().getSelectionStart() : editor.getSelectionModel().getSelectionEnd();
                ScrollType scrollType = model.isForward() ? ScrollType.CENTER_DOWN : ScrollType.CENTER_UP;
                FindUtil.moveCaretAndDontChangeSelection(editor, offset, scrollType);
            }
            if (model.isGlobal()) {
                if (model.isFromCursor()) {
                    offset = editor.getCaretModel().getOffset();
                    if (!model.isForward()) {
                        ++offset;
                    }
                } else {
                    offset = model.isForward() ? 0 : editor.getDocument().getTextLength();
                }
            } else {
                if (!editor.getSelectionModel().hasSelection()) {
                    findManager.setFindNextModel(null);
                    return;
                }
                int n = offset = model.isForward() ? editor.getSelectionModel().getSelectionStart() : editor.getSelectionModel().getSelectionEnd();
            }
            if (s != null && editor.getSelectionModel().hasSelection() && s.equals(model.getStringToFind())) {
                if (model.isFromCursor() && model.isForward()) {
                    offset = Math.min(editor.getSelectionModel().getSelectionStart(), offset);
                } else if (model.isFromCursor() && !model.isForward()) {
                    offset = Math.max(editor.getSelectionModel().getSelectionEnd(), offset);
                }
            }
            findManager.setFindNextModel(null);
            findManager.getFindInFileModel().copyFrom(model);
            FindUtil.replace(project2, editor, offset, model);
        });
    }

    public static boolean replace(@NotNull Project project2, @NotNull Editor editor, int offset, @NotNull FindModel model) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/find/FindUtil", "replace"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/find/FindUtil", "replace"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/find/FindUtil", "replace"));
        }
        return FindUtil.replace(project2, editor, offset, model, (range, replace) -> true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean replace(@NotNull Project project2, @NotNull Editor editor, int offset, @NotNull FindModel model, ReplaceDelegate delegate) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/find/FindUtil", "replace"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/find/FindUtil", "replace"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/find/FindUtil", "replace"));
        }
        Document document = editor.getDocument();
        if (!FileDocumentManager.getInstance().requestWriting(document, project2)) {
            return false;
        }
        document.startGuardedBlockChecking();
        boolean toPrompt = model.isPromptOnReplace();
        try {
            FindUtil.doReplace(project2, editor, model, document, offset, toPrompt, delegate);
        }
        catch (ReadOnlyFragmentModificationException e) {
            EditorActionManager.getInstance().getReadonlyFragmentModificationHandler(document).handle(e);
        }
        finally {
            document.stopGuardedBlockChecking();
        }
        return true;
    }

    private static void doReplace(@NotNull Project project2, @NotNull Editor editor, @NotNull FindModel aModel, @NotNull Document document, int caretOffset, boolean toPrompt, ReplaceDelegate delegate) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/find/FindUtil", "doReplace"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/find/FindUtil", "doReplace"));
        }
        if (aModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aModel", "com/intellij/find/FindUtil", "doReplace"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/find/FindUtil", "doReplace"));
        }
        FindManager findManager = FindManager.getInstance((Project)project2);
        FindModel model = aModel.clone();
        int occurrences = 0;
        ArrayList<Pair<TextRange, String>> rangesToChange = new ArrayList<Pair<TextRange, String>>();
        boolean replaced = false;
        boolean reallyReplaced = false;
        int offset = caretOffset;
        while (offset >= 0 && offset < editor.getDocument().getTextLength()) {
            int newOffset;
            String toReplace;
            caretOffset = offset;
            FindResult result2 = FindUtil.doSearch(project2, editor, offset, !replaced, model, toPrompt);
            if (result2 == null) break;
            int startResultOffset = result2.getStartOffset();
            model.setFromCursor(true);
            int startOffset = result2.getStartOffset();
            int endOffset = result2.getEndOffset();
            String string = document.getCharsSequence().subSequence(startOffset, endOffset).toString();
            try {
                toReplace = findManager.getStringToReplace(string, model, startOffset, document.getCharsSequence());
            }
            catch (FindManager.MalformedReplacementStringException e) {
                if (ApplicationManager.getApplication().isUnitTestMode()) break;
                Messages.showErrorDialog((Project)project2, (String)e.getMessage(), (String)FindBundle.message("find.replace.invalid.replacement.string.title", new Object[0]));
                break;
            }
            if (toPrompt) {
                int promptResult = findManager.showPromptDialog(model, FindBundle.message("find.replace.dialog.title", new Object[0]));
                if (promptResult == 2) {
                    offset = model.isForward() ? result2.getEndOffset() : startResultOffset;
                    continue;
                }
                if (promptResult == 1) break;
                if (promptResult == 3) {
                    toPrompt = false;
                }
            }
            if (delegate == null || delegate.shouldReplace((TextRange)result2, toReplace)) {
                if (toPrompt && !reallyReplaced) {
                    editor.getCaretModel().moveToOffset(0);
                    reallyReplaced = true;
                }
                TextRange textRange = FindUtil.doReplace(project2, document, model, result2, toReplace, toPrompt, rangesToChange);
                replaced = true;
                int n = newOffset = model.isForward() ? textRange.getEndOffset() : textRange.getStartOffset();
                if (textRange.isEmpty()) {
                    ++newOffset;
                }
                ++occurrences;
            } else {
                int n = newOffset = model.isForward() ? result2.getEndOffset() : result2.getStartOffset();
            }
            if (newOffset == offset) {
                newOffset += model.isForward() ? 1 : -1;
            }
            offset = newOffset;
        }
        if (replaced) {
            if (toPrompt) {
                if (caretOffset > document.getTextLength()) {
                    caretOffset = document.getTextLength();
                }
                editor.getCaretModel().moveToOffset(caretOffset);
            } else {
                CharSequence text2 = document.getCharsSequence();
                StringBuilder newText = new StringBuilder(document.getTextLength());
                Collections.sort(rangesToChange, Comparator.comparingInt(o -> ((TextRange)o.getFirst()).getStartOffset()));
                int offsetBefore = 0;
                for (Pair pair2 : rangesToChange) {
                    TextRange range = (TextRange)pair2.getFirst();
                    String replace = (String)pair2.getSecond();
                    newText.append(text2, offsetBefore, range.getStartOffset());
                    if (delegate == null || delegate.shouldReplace(range, replace)) {
                        newText.append(replace);
                    } else {
                        newText.append(text2.subSequence(range.getStartOffset(), range.getEndOffset()));
                    }
                    if ((offsetBefore = range.getEndOffset()) >= caretOffset) continue;
                    caretOffset += replace.length() - range.getLength();
                }
                newText.append(text2, offsetBefore, text2.length());
                if (caretOffset > newText.length()) {
                    caretOffset = newText.length();
                }
                int finalCaretOffset = caretOffset;
                CommandProcessor.getInstance().executeCommand(project2, () -> {
                    if (document == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/find/FindUtil", "lambda$doReplace$5"));
                    }
                    if (editor == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/find/FindUtil", "lambda$doReplace$5"));
                    }
                    ApplicationManager.getApplication().runWriteAction(() -> {
                        if (document == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/find/FindUtil", "lambda$null$4"));
                        }
                        if (editor == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/find/FindUtil", "lambda$null$4"));
                        }
                        document.setText((CharSequence)newText);
                        editor.getCaretModel().moveToOffset(finalCaretOffset);
                        if (model.isGlobal()) {
                            editor.getSelectionModel().removeSelection();
                        }
                    });
                }, null, (Object)document);
            }
        }
        ReplaceInProjectManager.reportNumberReplacedOccurrences(project2, occurrences);
    }

    private static boolean selectionMayContainRange(SelectionModel selection, TextRange range) {
        int[] starts = selection.getBlockSelectionStarts();
        int[] ends = selection.getBlockSelectionEnds();
        return starts.length != 0 && new TextRange(starts[0], ends[starts.length - 1]).contains(range);
    }

    private static boolean selectionStrictlyContainsRange(SelectionModel selection, TextRange range) {
        int[] starts = selection.getBlockSelectionStarts();
        int[] ends = selection.getBlockSelectionEnds();
        for (int i2 = 0; i2 < starts.length; ++i2) {
            if (!new TextRange(starts[i2], ends[i2]).contains(range)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private static FindResult doSearch(@NotNull Project project2, @NotNull Editor editor, int offset, boolean toWarn, @NotNull FindModel model, boolean adjustEditor) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/find/FindUtil", "doSearch"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/find/FindUtil", "doSearch"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/find/FindUtil", "doSearch"));
        }
        FindManager findManager = FindManager.getInstance((Project)project2);
        Document document = editor.getDocument();
        FindResult result2 = findManager.findString(document.getCharsSequence(), offset, model, FindUtil.getVirtualFile(editor));
        boolean isFound = result2.isStringFound();
        SelectionModel selection = editor.getSelectionModel();
        if (isFound && !model.isGlobal()) {
            if (!FindUtil.selectionMayContainRange(selection, (TextRange)result2)) {
                isFound = false;
            } else if (!FindUtil.selectionStrictlyContainsRange(selection, (TextRange)result2)) {
                int[] starts;
                for (int newOffset : starts = selection.getBlockSelectionStarts()) {
                    if (newOffset <= result2.getStartOffset()) continue;
                    return FindUtil.doSearch(project2, editor, newOffset, toWarn, model, adjustEditor);
                }
            }
        }
        if (!isFound) {
            if (toWarn) {
                FindUtil.processNotFound(editor, model.getStringToFind(), model, project2);
            }
            return null;
        }
        if (adjustEditor) {
            ScrollType scrollType;
            CaretModel caretModel = editor.getCaretModel();
            ScrollingModel scrollingModel = editor.getScrollingModel();
            int oldCaretOffset = caretModel.getOffset();
            boolean forward = oldCaretOffset < result2.getStartOffset();
            ScrollType scrollType2 = scrollType = forward ? ScrollType.CENTER_DOWN : ScrollType.CENTER_UP;
            if (model.isGlobal()) {
                int targetCaretPosition = result2.getEndOffset();
                if (selection.getSelectionEnd() - selection.getSelectionStart() == result2.getLength()) {
                    targetCaretPosition = caretModel.getOffset() - selection.getSelectionStart() + result2.getStartOffset();
                }
                if (caretModel.getCaretAt(editor.offsetToVisualPosition(targetCaretPosition)) != null) {
                    return result2;
                }
                caretModel.moveToOffset(targetCaretPosition);
                selection.removeSelection();
                scrollingModel.scrollToCaret(scrollType);
                scrollingModel.runActionOnScrollingFinished(() -> {
                    if (editor == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/find/FindUtil", "lambda$doSearch$6"));
                    }
                    scrollingModel.scrollTo(editor.offsetToLogicalPosition(result2.getStartOffset()), scrollType);
                    scrollingModel.scrollTo(editor.offsetToLogicalPosition(result2.getEndOffset()), scrollType);
                });
            } else {
                FindUtil.moveCaretAndDontChangeSelection(editor, result2.getStartOffset(), scrollType);
                FindUtil.moveCaretAndDontChangeSelection(editor, result2.getEndOffset(), scrollType);
            }
            IdeDocumentHistory.getInstance(project2).includeCurrentCommandAsNavigation();
            EditorColorsManager manager = EditorColorsManager.getInstance();
            TextAttributes selectionAttributes = manager.getGlobalScheme().getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES);
            if (!model.isGlobal()) {
                RangeHighlighterEx segmentHighlighter = (RangeHighlighterEx)editor.getMarkupModel().addRangeHighlighter(result2.getStartOffset(), result2.getEndOffset(), 6001, selectionAttributes, HighlighterTargetArea.EXACT_RANGE);
                MyListener listener2 = new MyListener(editor, segmentHighlighter);
                caretModel.addCaretListener((CaretListener)listener2);
            } else {
                selection.setSelection(result2.getStartOffset(), result2.getEndOffset());
            }
        }
        return result2;
    }

    public static void processNotFound(final Editor editor, String stringToFind, FindModel model, Project project2) {
        String message2 = FindBundle.message("find.search.string.not.found.message", stringToFind);
        short position = 2;
        if (model.isGlobal()) {
            FindModel modelForNextSearch;
            Document document;
            FindModel newModel = model.clone();
            FindManager findManager = FindManager.getInstance((Project)project2);
            FindResult result2 = findManager.findString((document = editor.getDocument()).getCharsSequence(), newModel.isForward() ? 0 : document.getTextLength(), model, FindUtil.getVirtualFile(editor));
            if (!result2.isStringFound()) {
                result2 = null;
            }
            if ((modelForNextSearch = findManager.getFindNextModel(editor)) == null) {
                modelForNextSearch = findManager.getFindInFileModel();
            }
            if (result2 != null) {
                AnAction action;
                if (newModel.isForward()) {
                    action = ActionManager.getInstance().getAction(modelForNextSearch.isForward() ? "FindNext" : "FindPrevious");
                    String shortcutsText = KeymapUtil.getFirstKeyboardShortcutText((AnAction)action);
                    message2 = !shortcutsText.isEmpty() ? FindBundle.message("find.search.again.from.top.hotkey.message", message2, shortcutsText) : FindBundle.message("find.search.again.from.top.action.message", message2);
                    editor.putUserData(KEY, (Object)Direction.DOWN);
                } else {
                    action = ActionManager.getInstance().getAction(modelForNextSearch.isForward() ? "FindPrevious" : "FindNext");
                    String shortcutsText = KeymapUtil.getFirstKeyboardShortcutText((AnAction)action);
                    message2 = !shortcutsText.isEmpty() ? FindBundle.message("find.search.again.from.bottom.hotkey.message", message2, shortcutsText) : FindBundle.message("find.search.again.from.bottom.action.message", message2);
                    editor.putUserData(KEY, (Object)Direction.UP);
                    position = 1;
                }
            }
            CaretListener listener2 = new CaretListener(){

                public void caretPositionChanged(CaretEvent e) {
                    editor.putUserData(KEY, null);
                    editor.getCaretModel().removeCaretListener((CaretListener)this);
                }
            };
            editor.getCaretModel().addCaretListener(listener2);
        }
        JComponent component = HintUtil.createInformationLabel(JDOMUtil.escapeText((String)message2, (boolean)false, (boolean)false));
        LightweightHint hint = new LightweightHint(component);
        HintManagerImpl.getInstanceImpl().showEditorHint(hint, editor, position, 42, 0, false);
    }

    public static TextRange doReplace(Project project2, Document document, @NotNull FindModel model, FindResult result2, @NotNull String stringToReplace, boolean reallyReplace, List<Pair<TextRange, String>> rangesToChange) {
        int start;
        int end;
        block10: {
            String toFind;
            block11: {
                block12: {
                    int newOffset;
                    if (model == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/find/FindUtil", "doReplace"));
                    }
                    if (stringToReplace == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stringToReplace", "com/intellij/find/FindUtil", "doReplace"));
                    }
                    int startOffset = result2.getStartOffset();
                    int endOffset = result2.getEndOffset();
                    if (reallyReplace) {
                        newOffset = FindUtil.doReplace(project2, document, startOffset, endOffset, stringToReplace);
                    } else {
                        String converted = StringUtil.convertLineSeparators((String)stringToReplace);
                        TextRange textRange = new TextRange(startOffset, endOffset);
                        rangesToChange.add((Pair<TextRange, String>)Pair.create((Object)textRange, (Object)converted));
                        newOffset = endOffset;
                    }
                    if (!model.isRegularExpressions()) break block10;
                    toFind = model.getStringToFind();
                    if (!model.isForward()) break block11;
                    if (!StringUtil.endsWithChar((CharSequence)toFind, (char)'$')) break block12;
                    int i2 = 0;
                    int length = toFind.length();
                    while (i2 + 2 <= length && toFind.charAt(length - i2 - 2) == '\\') {
                        ++i2;
                    }
                    if (i2 % 2 != 0) break block10;
                    ++end;
                    break block10;
                }
                if (!StringUtil.startsWithChar((CharSequence)toFind, (char)'^')) break block10;
                for (end = newOffset; end < document.getTextLength() && document.getCharsSequence().charAt(end) != '\n'; ++end) {
                }
                break block10;
            }
            if (StringUtil.startsWithChar((CharSequence)toFind, (char)'^')) {
                --start;
            } else if (StringUtil.endsWithChar((CharSequence)toFind, (char)'$')) {
                for (start = startOffset; start >= 0 && document.getCharsSequence().charAt(start) != '\n'; --start) {
                }
            }
        }
        return new TextRange(start, end);
    }

    private static int doReplace(Project project2, Document document, int startOffset, int endOffset, String stringToReplace) {
        String converted = StringUtil.convertLineSeparators((String)stringToReplace);
        CommandProcessor.getInstance().executeCommand(project2, () -> ApplicationManager.getApplication().runWriteAction(() -> document.replaceString(startOffset, endOffset, (CharSequence)converted)), null, null);
        return startOffset + converted.length();
    }

    private static void moveCaretAndDontChangeSelection(Editor editor, int offset, ScrollType scrollType) {
        LogicalPosition pos = editor.offsetToLogicalPosition(offset);
        editor.getCaretModel().moveToLogicalPosition(pos);
        editor.getScrollingModel().scrollToCaret(scrollType);
    }

    @Nullable
    public static UsageView showInUsageView(@Nullable PsiElement sourceElement, @NotNull PsiElement[] targets, @NotNull String title, @NotNull Project project2) {
        PsiElement[] psiElementArray;
        UsageTarget[] usageTargetArray;
        if (targets == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targets", "com/intellij/find/FindUtil", "showInUsageView"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/find/FindUtil", "showInUsageView"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/find/FindUtil", "showInUsageView"));
        }
        if (targets.length == 0) {
            return null;
        }
        UsageViewPresentation presentation = new UsageViewPresentation();
        presentation.setCodeUsagesString(title);
        presentation.setTabName(title);
        presentation.setTabText(title);
        if (sourceElement == null) {
            usageTargetArray = UsageTarget.EMPTY_ARRAY;
        } else {
            UsageTarget[] usageTargetArray2 = new UsageTarget[1];
            usageTargetArray = usageTargetArray2;
            usageTargetArray2[0] = new PsiElement2UsageTargetAdapter(sourceElement);
        }
        UsageTarget[] usageTargets = usageTargetArray;
        if (sourceElement == null) {
            psiElementArray = PsiElement.EMPTY_ARRAY;
        } else {
            PsiElement[] psiElementArray2 = new PsiElement[1];
            psiElementArray = psiElementArray2;
            psiElementArray2[0] = sourceElement;
        }
        final PsiElement[] primary = psiElementArray;
        final UsageView view = UsageViewManager.getInstance((Project)project2).showUsages(usageTargets, Usage.EMPTY_ARRAY, presentation);
        SmartPointerManager smartPointerManager = SmartPointerManager.getInstance((Project)project2);
        final List pointers = ContainerUtil.map((Object[])targets, arg_0 -> ((SmartPointerManager)smartPointerManager).createSmartPsiElementPointer(arg_0));
        targets = PsiElement.EMPTY_ARRAY;
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project2, "Updating Usage View ..."){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/find/FindUtil$2", "run"));
                }
                for (SmartPsiElementPointer pointer : pointers) {
                    if (((UsageViewImpl)view).isDisposed()) break;
                    ApplicationManager.getApplication().runReadAction(() -> {
                        PsiElement target2 = pointer.getElement();
                        if (target2 != null) {
                            view.appendUsage(UsageInfoToUsageConverter.convert((PsiElement[])primary, (UsageInfo)new UsageInfo(target2)));
                        }
                    });
                }
                UIUtil.invokeLaterIfNeeded(() -> ((UsageViewImpl)((UsageViewImpl)view)).expandAll());
            }
        });
        return view;
    }

    public static void selectSearchResultsInEditor(@NotNull Editor editor, @NotNull Iterator<FindResult> resultIterator, int caretShiftFromSelectionStart) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/find/FindUtil", "selectSearchResultsInEditor"));
        }
        if (resultIterator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resultIterator", "com/intellij/find/FindUtil", "selectSearchResultsInEditor"));
        }
        if (!editor.getCaretModel().supportsMultipleCarets()) {
            return;
        }
        ArrayList<CaretState> caretStates = new ArrayList<CaretState>();
        while (resultIterator.hasNext()) {
            FindResult findResult = resultIterator.next();
            int caretOffset = FindUtil.getCaretPosition(findResult, caretShiftFromSelectionStart);
            int selectionStartOffset = findResult.getStartOffset();
            int selectionEndOffset = findResult.getEndOffset();
            EditorActionUtil.makePositionVisible(editor, caretOffset);
            EditorActionUtil.makePositionVisible(editor, selectionStartOffset);
            EditorActionUtil.makePositionVisible(editor, selectionEndOffset);
            caretStates.add(new CaretState(editor.offsetToLogicalPosition(caretOffset), editor.offsetToLogicalPosition(selectionStartOffset), editor.offsetToLogicalPosition(selectionEndOffset)));
        }
        if (caretStates.isEmpty()) {
            return;
        }
        editor.getCaretModel().setCaretsAndSelections(caretStates);
    }

    public static boolean selectSearchResultInEditor(@NotNull Editor editor, @NotNull FindResult result2, int caretShiftFromSelectionStart) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/find/FindUtil", "selectSearchResultInEditor"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/find/FindUtil", "selectSearchResultInEditor"));
        }
        if (!editor.getCaretModel().supportsMultipleCarets()) {
            return false;
        }
        int caretOffset = FindUtil.getCaretPosition(result2, caretShiftFromSelectionStart);
        LogicalPosition caretPosition = editor.offsetToLogicalPosition(caretOffset);
        if (caretShiftFromSelectionStart == 0) {
            caretPosition = caretPosition.leanForward(true);
        }
        EditorActionUtil.makePositionVisible(editor, caretOffset);
        Caret newCaret = editor.getCaretModel().addCaret(editor.logicalToVisualPosition(caretPosition));
        if (newCaret == null) {
            return false;
        }
        int selectionStartOffset = result2.getStartOffset();
        int selectionEndOffset = result2.getEndOffset();
        EditorActionUtil.makePositionVisible(editor, selectionStartOffset);
        EditorActionUtil.makePositionVisible(editor, selectionEndOffset);
        newCaret.setSelection(selectionStartOffset, selectionEndOffset);
        return true;
    }

    private static int getCaretPosition(FindResult findResult, int caretShiftFromSelectionStart) {
        return caretShiftFromSelectionStart < 0 ? findResult.getEndOffset() : Math.min(findResult.getStartOffset() + caretShiftFromSelectionStart, findResult.getEndOffset());
    }

    @FunctionalInterface
    public static interface ReplaceDelegate {
        public boolean shouldReplace(TextRange var1, String var2);
    }

    private static class MyListener
    implements CaretListener {
        private final Editor myEditor;
        private final RangeHighlighter mySegmentHighlighter;

        private MyListener(@NotNull Editor editor, @NotNull RangeHighlighter segmentHighlighter) {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/find/FindUtil$MyListener", "<init>"));
            }
            if (segmentHighlighter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "segmentHighlighter", "com/intellij/find/FindUtil$MyListener", "<init>"));
            }
            this.myEditor = editor;
            this.mySegmentHighlighter = segmentHighlighter;
        }

        public void caretPositionChanged(CaretEvent e) {
            this.removeAll();
        }

        private void removeAll() {
            this.myEditor.getCaretModel().removeCaretListener((CaretListener)this);
            this.mySegmentHighlighter.dispose();
        }
    }

    private static enum Direction {
        UP,
        DOWN;

    }
}

