/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.actions;

import com.intellij.openapi.util.Condition;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

class PingEDT {
    private final String myName;
    private final Runnable pingAction;
    private volatile boolean stopped;
    private volatile boolean pinged;
    private final Condition<?> myShutUpCondition;
    private final int myMaxUnitOfWorkThresholdMs;
    private final AtomicBoolean invokeLaterScheduled;
    private final Runnable myUpdateRunnable;

    PingEDT(@NotNull @NonNls String name2, @NotNull Condition<?> shutUpCondition, int maxUnitOfWorkThresholdMs, @NotNull Runnable pingAction) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/find/actions/PingEDT", "<init>"));
        }
        if (shutUpCondition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shutUpCondition", "com/intellij/find/actions/PingEDT", "<init>"));
        }
        if (pingAction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pingAction", "com/intellij/find/actions/PingEDT", "<init>"));
        }
        this.invokeLaterScheduled = new AtomicBoolean();
        this.myUpdateRunnable = new Runnable(){

            @Override
            public void run() {
                boolean b = PingEDT.this.invokeLaterScheduled.compareAndSet(true, false);
                assert (b);
                if (PingEDT.this.stopped || PingEDT.this.myShutUpCondition.value(null)) {
                    PingEDT.this.stop();
                    return;
                }
                long start = System.currentTimeMillis();
                int processed2 = 0;
                while (PingEDT.this.processNext()) {
                    ++processed2;
                    long finish = System.currentTimeMillis();
                    if (PingEDT.this.myMaxUnitOfWorkThresholdMs == -1 || finish - start <= (long)PingEDT.this.myMaxUnitOfWorkThresholdMs) continue;
                    break;
                }
                if (!PingEDT.this.isEmpty()) {
                    PingEDT.this.scheduleUpdate();
                }
            }
        };
        this.myName = name2;
        this.myShutUpCondition = shutUpCondition;
        this.myMaxUnitOfWorkThresholdMs = maxUnitOfWorkThresholdMs;
        this.pingAction = pingAction;
    }

    private boolean isEmpty() {
        return !this.pinged;
    }

    private boolean processNext() {
        this.pinged = false;
        this.pingAction.run();
        return this.pinged;
    }

    public boolean ping() {
        this.pinged = true;
        return this.scheduleUpdate();
    }

    private boolean scheduleUpdate() {
        if (!this.stopped && this.invokeLaterScheduled.compareAndSet(false, true)) {
            SwingUtilities.invokeLater(this.myUpdateRunnable);
            return true;
        }
        return false;
    }

    public void stop() {
        this.stopped = true;
    }
}

