/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.impl;

import com.intellij.openapi.application.PathMacroFilter;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.impl.stores.FileStorageCoreUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.xmlb.XmlSerializerUtil;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Tag;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class FindInProjectSettingsBase
implements PersistentStateComponent<FindInProjectSettingsBase> {
    private static final int MAX_RECENT_SIZE = 30;
    @Tag(value="findStrings")
    @Property(surroundWithTag=false)
    @AbstractCollection(surroundWithTag=false, elementTag="find", elementValueAttribute="")
    public List<String> findStrings = new ArrayList<String>();
    @Tag(value="replaceStrings")
    @Property(surroundWithTag=false)
    @AbstractCollection(surroundWithTag=false, elementTag="replace", elementValueAttribute="")
    public List<String> replaceStrings = new ArrayList<String>();
    @Tag(value="dirStrings")
    @Property(surroundWithTag=false)
    @AbstractCollection(surroundWithTag=false, elementTag="dir", elementValueAttribute="")
    public List<String> dirStrings = new ArrayList<String>();

    public void loadState(FindInProjectSettingsBase state) {
        XmlSerializerUtil.copyBean((Object)state, (Object)this);
        LinkedHashSet<String> tmp = new LinkedHashSet<String>(this.findStrings);
        this.findStrings.clear();
        this.findStrings.addAll(tmp);
        tmp.clear();
        tmp.addAll(this.replaceStrings);
        this.replaceStrings.clear();
        this.replaceStrings.addAll(tmp);
        tmp.clear();
        tmp.addAll(this.dirStrings);
        this.dirStrings.clear();
        this.dirStrings.addAll(tmp);
    }

    public FindInProjectSettingsBase getState() {
        return this;
    }

    public void addDirectory(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/find/impl/FindInProjectSettingsBase", "addDirectory"));
        }
        if (s.isEmpty()) {
            return;
        }
        FindInProjectSettingsBase.addRecentStringToList(s, this.dirStrings);
    }

    @NotNull
    public List<String> getRecentDirectories() {
        ArrayList<String> arrayList = new ArrayList<String>(this.dirStrings);
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/impl/FindInProjectSettingsBase", "getRecentDirectories"));
        }
        return arrayList;
    }

    public void addStringToFind(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/find/impl/FindInProjectSettingsBase", "addStringToFind"));
        }
        if (s.indexOf(13) >= 0 || s.indexOf(10) >= 0) {
            return;
        }
        FindInProjectSettingsBase.addRecentStringToList(s, this.findStrings);
    }

    public void addStringToReplace(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/find/impl/FindInProjectSettingsBase", "addStringToReplace"));
        }
        if (s.indexOf(13) >= 0 || s.indexOf(10) >= 0) {
            return;
        }
        FindInProjectSettingsBase.addRecentStringToList(s, this.replaceStrings);
    }

    @NotNull
    public String[] getRecentFindStrings() {
        String[] stringArray = ArrayUtil.toStringArray(this.findStrings);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/impl/FindInProjectSettingsBase", "getRecentFindStrings"));
        }
        return stringArray;
    }

    @NotNull
    public String[] getRecentReplaceStrings() {
        String[] stringArray = ArrayUtil.toStringArray(this.replaceStrings);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/impl/FindInProjectSettingsBase", "getRecentReplaceStrings"));
        }
        return stringArray;
    }

    static void addRecentStringToList(@NotNull String str, @NotNull List<String> list2) {
        if (str == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "com/intellij/find/impl/FindInProjectSettingsBase", "addRecentStringToList"));
        }
        if (list2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/find/impl/FindInProjectSettingsBase", "addRecentStringToList"));
        }
        if (list2.contains(str)) {
            list2.remove(str);
        }
        list2.add(str);
        while (list2.size() > 30) {
            list2.remove(0);
        }
    }

    static class FindInProjectPathMacroFilter
    extends PathMacroFilter {
        FindInProjectPathMacroFilter() {
        }

        public boolean skipPathMacros(@NotNull Element element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/find/impl/FindInProjectSettingsBase$FindInProjectPathMacroFilter", "skipPathMacros"));
            }
            String tag = element.getName();
            if (tag.equals("findStrings") || tag.equals("replaceStrings")) {
                String component = FileStorageCoreUtil.findComponentName(element);
                return component != null && (component.equals("FindSettings") || component.equals("FindInProjectRecents"));
            }
            return false;
        }
    }
}

