/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.impl;

import com.intellij.CommonBundle;
import com.intellij.codeInsight.AutoPopupController;
import com.intellij.find.FindBundle;
import com.intellij.find.FindInProjectSettings;
import com.intellij.find.FindManager;
import com.intellij.find.FindModel;
import com.intellij.find.FindSettings;
import com.intellij.find.SearchTextArea;
import com.intellij.find.actions.ShowUsagesAction;
import com.intellij.find.editorHeaderActions.ShowMoreOptions;
import com.intellij.find.impl.FindDialog;
import com.intellij.find.impl.FindInProjectUtil;
import com.intellij.find.impl.FindManagerImpl;
import com.intellij.find.impl.FindPopupScopeUI;
import com.intellij.find.impl.FindPopupScopeUIProvider;
import com.intellij.find.impl.FindUI;
import com.intellij.find.impl.FindUIHelper;
import com.intellij.find.impl.RegExHelpPopup;
import com.intellij.icons.AllIcons;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.MnemonicHelper;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.progress.util.ReadTask;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.LoadingDecorator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.OnePixelDivider;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.ui.popup.ComponentPopupBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.DimensionService;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopeUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.StateRestoringCheckBox;
import com.intellij.ui.TextFieldWithAutoCompletion;
import com.intellij.ui.TextFieldWithAutoCompletionListProvider;
import com.intellij.ui.UIBundle;
import com.intellij.ui.WindowMoveListener;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.table.JBTable;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.FindUsagesProcessPresentation;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.usages.impl.UsagePreviewPanel;
import com.intellij.usages.rules.MergeableUsage;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FindPopupPanel
extends JBPanel
implements FindUI {
    private static final Logger LOG = Logger.getInstance(FindPopupPanel.class);
    private static final KeyStroke ENTER = KeyStroke.getKeyStroke(10, 0);
    private static final KeyStroke ENTER_WITH_MODIFIERS = KeyStroke.getKeyStroke(10, SystemInfo.isMac ? 256 : 128);
    private static final String SERVICE_KEY = "find.popup";
    private static final String SPLITTER_SERVICE_KEY = "find.popup.splitter";
    @NotNull
    private final FindUIHelper myHelper;
    @NotNull
    private final Project myProject;
    @NotNull
    private final Disposable myDisposable;
    @NotNull
    private final FindPopupScopeUI myScopeUI;
    private JComponent myCodePreviewComponent;
    private SearchTextArea mySearchTextArea;
    private SearchTextArea myReplaceTextArea;
    private ActionListener myOkActionListener;
    private AtomicBoolean myCanClose;
    private JBLabel myOKHintLabel;
    private Alarm mySearchRescheduleOnCancellationsAlarm;
    private volatile ProgressIndicatorBase myResultsPreviewSearchProgress;
    private JLabel myTitleLabel;
    private StateRestoringCheckBox myCbCaseSensitive;
    private StateRestoringCheckBox myCbPreserveCase;
    private StateRestoringCheckBox myCbWholeWordsOnly;
    private StateRestoringCheckBox myCbRegularExpressions;
    private StateRestoringCheckBox myCbFileFilter;
    private ActionToolbarImpl myScopeSelectionToolbar;
    private TextFieldWithAutoCompletion<String> myFileMaskField;
    private ArrayList<String> myFileMasks;
    private ActionButton myFilterContextButton;
    private ActionButton myTabResultsButton;
    private JButton myOKButton;
    private JTextArea mySearchComponent;
    private JTextArea myReplaceComponent;
    private String mySelectedContextName;
    private FindPopupScopeUI.ScopeType mySelectedScope;
    private JPanel myScopeDetailsPanel;
    private JBTable myResultsPreviewTable;
    private UsagePreviewPanel myUsagePreviewPanel;
    private JBPopup myBalloon;
    private LoadingDecorator myLoadingDecorator;
    private int myLoadingHash;

    FindPopupPanel(@NotNull FindUIHelper helper) {
        if (helper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "helper", "com/intellij/find/impl/FindPopupPanel", "<init>"));
        }
        this.myCanClose = new AtomicBoolean(true);
        this.myFileMasks = new ArrayList();
        this.mySelectedContextName = FindBundle.message("find.context.anywhere.scope.label", new Object[0]);
        this.myHelper = helper;
        this.myProject = this.myHelper.getProject();
        this.myDisposable = Disposer.newDisposable();
        this.myScopeUI = FindPopupScopeUIProvider.getInstance().create(this);
        Disposer.register((Disposable)this.myDisposable, (Disposable)new Disposable(){

            public void dispose() {
                FindPopupPanel.this.finishPreviousPreviewSearch();
                if (FindPopupPanel.this.mySearchRescheduleOnCancellationsAlarm != null) {
                    Disposer.dispose((Disposable)FindPopupPanel.this.mySearchRescheduleOnCancellationsAlarm);
                }
                if (FindPopupPanel.this.myUsagePreviewPanel != null) {
                    Disposer.dispose((Disposable)FindPopupPanel.this.myUsagePreviewPanel);
                }
            }
        });
        this.initComponents();
        this.initByModel();
        ApplicationManager.getApplication().invokeLater(() -> this.scheduleResultsUpdate(), ModalityState.any());
    }

    @Override
    public void showUI() {
        if (this.myBalloon != null && this.myBalloon.isVisible()) {
            return;
        }
        if (this.myBalloon != null && !this.myBalloon.isDisposed()) {
            this.myBalloon.cancel();
        }
        if (this.myBalloon == null || this.myBalloon.isDisposed()) {
            ComponentPopupBuilder builder = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)((Object)this), (JComponent)this.mySearchComponent);
            this.myBalloon = builder.setProject(this.myHelper.getProject()).setMovable(true).setResizable(true).setMayBeParent(true).setCancelOnClickOutside(true).setRequestFocus(true).setCancelCallback(() -> {
                if (!this.myCanClose.get()) {
                    return false;
                }
                if (!ApplicationManager.getApplication().isActive()) {
                    return false;
                }
                if (KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow() == null) {
                    return false;
                }
                List popups = JBPopupFactory.getInstance().getChildPopups((Component)((Object)this));
                if (!popups.isEmpty()) {
                    for (JBPopup popup : popups) {
                        popup.cancel();
                    }
                    return false;
                }
                if (this.myScopeUI.hideAllPopups()) {
                    return false;
                }
                DimensionService.getInstance().setSize(SERVICE_KEY, this.myBalloon.getSize(), this.myHelper.getProject());
                DimensionService.getInstance().setLocation(SERVICE_KEY, this.myBalloon.getLocationOnScreen(), this.myHelper.getProject());
                ((FindManagerImpl)FindManager.getInstance((Project)this.myProject)).changeGlobalSettings(this.myHelper.getModel());
                return true;
            }).createPopup();
            Disposer.register((Disposable)this.myBalloon, (Disposable)this.myDisposable);
            this.registerCloseAction(this.myBalloon);
            Window window = WindowManager.getInstance().suggestParentWindow(this.myProject);
            Component parent = UIUtil.findUltimateParent((Component)window);
            RelativePoint showPoint = null;
            Point screenPoint = DimensionService.getInstance().getLocation(SERVICE_KEY);
            if (screenPoint != null) {
                showPoint = new RelativePoint(screenPoint);
            }
            if (parent != null && showPoint == null) {
                int height;
                int n = height = UISettings.getInstance().getShowNavigationBar() ? 135 : 115;
                if (parent instanceof IdeFrameImpl && ((IdeFrameImpl)parent).isInFullScreen()) {
                    height -= 20;
                }
                showPoint = new RelativePoint(parent, new Point((parent.getSize().width - this.getPreferredSize().width) / 2, height));
            }
            this.mySearchComponent.selectAll();
            WindowMoveListener windowListener = new WindowMoveListener((Component)((Object)this));
            this.myTitleLabel.addMouseListener(windowListener);
            this.myTitleLabel.addMouseMotionListener(windowListener);
            this.myLoadingDecorator.getComponent().addMouseListener(windowListener);
            this.myLoadingDecorator.getComponent().addMouseMotionListener(windowListener);
            Dimension panelSize = this.getPreferredSize();
            Dimension prev = DimensionService.getInstance().getSize(SERVICE_KEY);
            if (!this.myCbPreserveCase.isVisible()) {
                panelSize.width += this.myCbPreserveCase.getPreferredSize().width + 8;
            }
            panelSize.height *= 2;
            if (prev != null && prev.height < panelSize.height) {
                prev.height = panelSize.height;
            }
            this.myBalloon.setMinimumSize(panelSize);
            if (prev == null) {
                panelSize.height = (int)((double)panelSize.height * 1.5);
                panelSize.width = (int)((double)panelSize.width * 1.15);
            }
            this.myBalloon.setSize(prev != null ? prev : panelSize);
            if (showPoint != null && showPoint.getComponent() != null) {
                this.myBalloon.show(showPoint);
            } else {
                this.myBalloon.showCenteredInCurrentWindow(this.myProject);
            }
        }
    }

    @Override
    @NotNull
    public Disposable getDisposable() {
        Disposable disposable = this.myDisposable;
        if (disposable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/impl/FindPopupPanel", "getDisposable"));
        }
        return disposable;
    }

    @NotNull
    public Project getProject() {
        Project project2 = this.myProject;
        if (project2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/impl/FindPopupPanel", "getProject"));
        }
        return project2;
    }

    @NotNull
    public FindUIHelper getHelper() {
        FindUIHelper findUIHelper = this.myHelper;
        if (findUIHelper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/impl/FindPopupPanel", "getHelper"));
        }
        return findUIHelper;
    }

    @NotNull
    public JBPopup getBalloon() {
        JBPopup jBPopup = this.myBalloon;
        if (jBPopup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/impl/FindPopupPanel", "getBalloon"));
        }
        return jBPopup;
    }

    @NotNull
    public AtomicBoolean getCanClose() {
        AtomicBoolean atomicBoolean = this.myCanClose;
        if (atomicBoolean == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/impl/FindPopupPanel", "getCanClose"));
        }
        return atomicBoolean;
    }

    private void initComponents() {
        KeyStroke editSourceKeyStroke;
        this.myTitleLabel = new JBLabel(FindBundle.message("find.in.path.dialog.title", new Object[0]), UIUtil.ComponentStyle.REGULAR);
        this.myTitleLabel.setFont(this.myTitleLabel.getFont().deriveFont(1));
        this.myTitleLabel.setBorder((Border)JBUI.Borders.empty((int)0, (int)0, (int)0, (int)16));
        this.myLoadingDecorator = new LoadingDecorator((JComponent)new JLabel("  ", EmptyIcon.ICON_16, 10), this.getDisposable(), 250, true, new AsyncProcessIcon("FindInPathLoading"));
        this.myLoadingDecorator.setLoadingText("");
        this.myCbCaseSensitive = FindPopupPanel.createCheckBox("find.popup.case.sensitive");
        ItemListener liveResultsPreviewUpdateListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                FindPopupPanel.this.scheduleResultsUpdate();
            }
        };
        this.myCbCaseSensitive.addItemListener(liveResultsPreviewUpdateListener);
        this.myCbPreserveCase = FindPopupPanel.createCheckBox("find.options.replace.preserve.case");
        this.myCbPreserveCase.addItemListener(liveResultsPreviewUpdateListener);
        this.myCbPreserveCase.setVisible(this.myHelper.getModel().isReplaceState());
        this.myCbWholeWordsOnly = FindPopupPanel.createCheckBox("find.popup.whole.words");
        this.myCbWholeWordsOnly.addItemListener(liveResultsPreviewUpdateListener);
        this.myCbRegularExpressions = FindPopupPanel.createCheckBox("find.popup.regex");
        this.myCbRegularExpressions.addItemListener(liveResultsPreviewUpdateListener);
        this.myCbFileFilter = FindPopupPanel.createCheckBox("find.popup.filemask");
        this.myCbFileFilter.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (FindPopupPanel.this.myCbFileFilter.isSelected()) {
                    FindPopupPanel.this.myFileMaskField.setEnabled(true);
                    if (FindPopupPanel.this.myCbFileFilter.getClientProperty("dontRequestFocus") == null) {
                        FindPopupPanel.this.myFileMaskField.selectAll();
                        IdeFocusManager.getInstance((Project)FindPopupPanel.this.myProject).requestFocus((Component)((Object)FindPopupPanel.this.myFileMaskField), true);
                    }
                } else {
                    FindPopupPanel.this.myFileMaskField.setEnabled(false);
                    if (FindPopupPanel.this.myCbFileFilter.getClientProperty("dontRequestFocus") == null) {
                        IdeFocusManager.getInstance((Project)FindPopupPanel.this.myProject).requestFocus((Component)FindPopupPanel.this.mySearchComponent, true);
                    }
                }
            }
        });
        this.myCbFileFilter.addItemListener(liveResultsPreviewUpdateListener);
        this.myFileMaskField = new TextFieldWithAutoCompletion<String>(this.myProject, (TextFieldWithAutoCompletionListProvider)new TextFieldWithAutoCompletion.StringsCompletionProvider(this.myFileMasks, null), true, null){

            @Override
            public void setEnabled(boolean enabled) {
                super.setEnabled(enabled);
                this.setBackground(enabled ? JBColor.background() : UIUtil.getComboBoxDisabledBackground());
            }

            @Override
            protected EditorEx createEditor() {
                EditorEx editor = super.createEditor();
                editor.putUserData(AutoPopupController.ALWAYS_AUTO_POPUP, Boolean.TRUE);
                editor.putUserData(AutoPopupController.NO_ADS, Boolean.TRUE);
                editor.putUserData(AutoPopupController.AUTO_POPUP_ON_FOCUS_GAINED, Boolean.TRUE);
                return editor;
            }
        };
        this.myFileMaskField.setPreferredWidth(JBUI.scale((int)100));
        this.myFileMaskField.addDocumentListener(new DocumentListener(){

            public void documentChanged(com.intellij.openapi.editor.event.DocumentEvent e) {
                FindPopupPanel.this.scheduleResultsUpdate();
            }
        });
        MyShowFilterPopupAction myShowFilterPopupAction = new MyShowFilterPopupAction();
        this.myFilterContextButton = new ActionButton(myShowFilterPopupAction, myShowFilterPopupAction.getTemplatePresentation(), "unknown", ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE){

            @Override
            public int getPopState() {
                int state = super.getPopState();
                if (state != 0) {
                    return state;
                }
                return FindPopupPanel.this.mySelectedContextName.equals(FindDialog.getPresentableName(FindModel.SearchContext.ANY)) ? 0 : -1;
            }
        };
        myShowFilterPopupAction.registerCustomShortcutSet(myShowFilterPopupAction.getShortcutSet(), (JComponent)((Object)this));
        DefaultActionGroup tabResultsContextGroup = new DefaultActionGroup();
        tabResultsContextGroup.add((AnAction)new ToggleAction(FindBundle.message("find.options.skip.results.tab.with.one.usage.checkbox", new Object[0])){

            public boolean isSelected(AnActionEvent e) {
                return FindPopupPanel.this.myHelper.isSkipResultsWithOneUsage();
            }

            public void setSelected(AnActionEvent e, boolean state) {
                FindPopupPanel.this.myHelper.setSkipResultsWithOneUsage(state);
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/find/impl/FindPopupPanel$7", "update"));
                }
                super.update(e);
                e.getPresentation().setVisible(!FindPopupPanel.this.myHelper.isReplaceState());
            }
        });
        tabResultsContextGroup.add((AnAction)new ToggleAction(FindBundle.message("find.open.in.new.tab.checkbox", new Object[0])){

            public boolean isSelected(AnActionEvent e) {
                return FindPopupPanel.this.myHelper.isUseSeparateView();
            }

            public void setSelected(AnActionEvent e, boolean state) {
                FindPopupPanel.this.myHelper.setUseSeparateView(state);
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/find/impl/FindPopupPanel$8", "update"));
                }
                super.update(e);
                e.getPresentation().setEnabled(FindPopupPanel.this.myHelper.getModel().isOpenInNewTabEnabled());
                e.getPresentation().setVisible(FindPopupPanel.this.myHelper.getModel().isOpenInNewTabVisible());
            }
        });
        tabResultsContextGroup.setPopup(true);
        Presentation tabSettingsPresentation = new Presentation();
        tabSettingsPresentation.setIcon(AllIcons.General.SecondaryGroup);
        this.myTabResultsButton = new ActionButton((AnAction)tabResultsContextGroup, tabSettingsPresentation, "unknown", ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE);
        new AnAction(){

            public void actionPerformed(AnActionEvent e) {
                FindPopupPanel.this.myTabResultsButton.click();
            }
        }.registerCustomShortcutSet((ShortcutSet)CustomShortcutSet.fromString((String[])new String[]{"alt DOWN"}), (JComponent)((Object)this));
        this.myOKButton = new JButton(FindBundle.message("find.popup.find.button", new Object[0]));
        this.myOkActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FindModel validateModel = FindPopupPanel.this.myHelper.getModel().clone();
                FindPopupPanel.this.applyTo(validateModel, false);
                ValidationInfo validationInfo = FindPopupPanel.this.getValidationInfo(validateModel);
                if (validationInfo != null) {
                    String message2 = validationInfo.message;
                    Messages.showMessageDialog((Component)((Object)FindPopupPanel.this), (String)message2, (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
                    return;
                }
                FindPopupPanel.this.myHelper.getModel().copyFrom(validateModel);
                FindPopupPanel.this.myHelper.updateFindSettings();
                FindPopupPanel.this.myHelper.doOKAction();
                Disposer.dispose((Disposable)FindPopupPanel.this.myBalloon);
            }
        };
        this.myOKButton.addActionListener(this.myOkActionListener);
        final boolean enterAsOK = Registry.is((String)"ide.find.enter.as.ok", (boolean)false);
        new AnAction(){

            public void actionPerformed(AnActionEvent e) {
                if (enterAsOK || FindPopupPanel.this.myHelper.isReplaceState()) {
                    FindPopupPanel.this.myOkActionListener.actionPerformed(null);
                } else {
                    FindPopupPanel.this.navigateToSelectedUsage();
                }
            }
        }.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(ENTER), (JComponent)((Object)this));
        new AnAction(){

            public void actionPerformed(AnActionEvent e) {
                if (FindPopupPanel.this.myHelper.isReplaceState()) {
                    return;
                }
                if (enterAsOK) {
                    FindPopupPanel.this.navigateToSelectedUsage();
                } else {
                    FindPopupPanel.this.myOkActionListener.actionPerformed(null);
                }
            }
        }.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(ENTER_WITH_MODIFIERS), (JComponent)((Object)this));
        ArrayList navigationKeyStrokes = ContainerUtil.newArrayList();
        KeyStroke viewSourceKeyStroke = KeymapUtil.getKeyStroke((ShortcutSet)CommonShortcuts.getViewSource());
        if (viewSourceKeyStroke != null && !Comparing.equal((Object)viewSourceKeyStroke, (Object)ENTER_WITH_MODIFIERS) && !Comparing.equal((Object)viewSourceKeyStroke, (Object)ENTER)) {
            navigationKeyStrokes.add(new KeyboardShortcut(viewSourceKeyStroke, null));
        }
        if ((editSourceKeyStroke = KeymapUtil.getKeyStroke((ShortcutSet)CommonShortcuts.getEditSource())) != null && !Comparing.equal((Object)editSourceKeyStroke, (Object)ENTER_WITH_MODIFIERS) && !Comparing.equal((Object)editSourceKeyStroke, (Object)ENTER)) {
            navigationKeyStrokes.add(new KeyboardShortcut(editSourceKeyStroke, null));
        }
        if (!navigationKeyStrokes.isEmpty()) {
            new AnAction(){

                public void actionPerformed(AnActionEvent e) {
                    FindPopupPanel.this.navigateToSelectedUsage();
                }
            }.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(navigationKeyStrokes.toArray(Shortcut.EMPTY_ARRAY)), (JComponent)((Object)this));
        }
        this.mySearchComponent = new JTextArea();
        this.mySearchComponent.setColumns(25);
        this.mySearchComponent.setRows(1);
        this.myReplaceComponent = new JTextArea();
        this.myReplaceComponent.setColumns(25);
        this.myReplaceComponent.setRows(1);
        this.mySearchTextArea = new SearchTextArea(this.mySearchComponent, true, true);
        this.myReplaceTextArea = new SearchTextArea(this.myReplaceComponent, false, false);
        DocumentAdapter documentAdapter = new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                FindPopupPanel.this.mySearchComponent.setRows(Math.max(1, Math.min(3, StringUtil.countChars((CharSequence)FindPopupPanel.this.mySearchComponent.getText(), (char)'\n') + 1)));
                FindPopupPanel.this.myReplaceComponent.setRows(Math.max(1, Math.min(3, StringUtil.countChars((CharSequence)FindPopupPanel.this.myReplaceComponent.getText(), (char)'\n') + 1)));
                if (FindPopupPanel.this.myBalloon == null) {
                    return;
                }
                if (e.getDocument() == FindPopupPanel.this.mySearchComponent.getDocument()) {
                    FindPopupPanel.this.scheduleResultsUpdate();
                }
            }
        };
        this.mySearchComponent.getDocument().addDocumentListener((javax.swing.event.DocumentListener)documentAdapter);
        this.myReplaceComponent.getDocument().addDocumentListener((javax.swing.event.DocumentListener)documentAdapter);
        this.mySearchTextArea.setMultilineEnabled(false);
        this.myReplaceTextArea.setMultilineEnabled(false);
        Pair<FindPopupScopeUI.ScopeType, JComponent>[] scopeComponents = this.myScopeUI.getComponents();
        LinkedList<MySelectScopeToggleAction> scopeActions = new LinkedList<MySelectScopeToggleAction>();
        this.myScopeDetailsPanel = new JPanel(new CardLayout());
        this.myScopeDetailsPanel.setBorder((Border)JBUI.Borders.emptyBottom((int)(UIUtil.isUnderDefaultMacTheme() ? 0 : 3)));
        for (Pair<FindPopupScopeUI.ScopeType, JComponent> scopeComponent : scopeComponents) {
            FindPopupScopeUI.ScopeType scopeType = (FindPopupScopeUI.ScopeType)scopeComponent.first;
            scopeActions.add(new MySelectScopeToggleAction(scopeType));
            this.myScopeDetailsPanel.add(scopeType.name, (Component)scopeComponent.second);
        }
        this.myScopeSelectionToolbar = FindPopupPanel.createToolbar(scopeActions.toArray(AnAction.EMPTY_ARRAY));
        this.myScopeSelectionToolbar.setMinimumButtonSize(ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE);
        this.mySelectedScope = (FindPopupScopeUI.ScopeType)scopeComponents[0].first;
        this.myResultsPreviewTable = new JBTable(){

            public Dimension getPreferredScrollableViewportSize() {
                return new Dimension(this.getWidth(), 1 + this.getRowHeight() * 4);
            }
        };
        this.myResultsPreviewTable.setFocusable(false);
        this.myResultsPreviewTable.getEmptyText().setShowAboveCenter(false);
        this.myResultsPreviewTable.setShowColumns(false);
        this.myResultsPreviewTable.getSelectionModel().setSelectionMode(0);
        this.myResultsPreviewTable.setShowGrid(false);
        this.myResultsPreviewTable.setIntercellSpacing((Dimension)JBUI.emptySize());
        new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent event) {
                if (event.getSource() != FindPopupPanel.this.myResultsPreviewTable) {
                    return false;
                }
                FindPopupPanel.this.navigateToSelectedUsage();
                return true;
            }
        }.installOn((Component)this.myResultsPreviewTable);
        this.myResultsPreviewTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                FindPopupPanel.this.myResultsPreviewTable.transferFocus();
            }
        });
        FindPopupPanel.applyFont(JBUI.Fonts.label(), new Component[]{this.myCbCaseSensitive, this.myCbPreserveCase, this.myCbWholeWordsOnly, this.myCbRegularExpressions, this.myResultsPreviewTable});
        ScrollingUtil.installActions((JTable)this.myResultsPreviewTable, (boolean)false, (JComponent)this.mySearchComponent);
        ScrollingUtil.installActions((JTable)this.myResultsPreviewTable, (boolean)false, (JComponent)this.myReplaceComponent);
        ScrollingUtil.installActions((JTable)this.myResultsPreviewTable, (boolean)false, this.myFileMaskField);
        ActionListener helpAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HelpManager.getInstance().invokeHelp("reference.dialogs.findinpath");
            }
        };
        this.registerKeyboardAction(helpAction, KeyStroke.getKeyStroke(112, 0), 2);
        this.registerKeyboardAction(helpAction, KeyStroke.getKeyStroke(156, 0), 2);
        this.myUsagePreviewPanel = new UsagePreviewPanel(this.myProject, new UsageViewPresentation(), Registry.is((String)"ide.find.as.popup.editable.code")){

            public Dimension getPreferredSize() {
                return new Dimension(FindPopupPanel.this.myResultsPreviewTable.getWidth(), Math.max(this.getHeight(), this.getLineHeight() * 15));
            }
        };
        Disposer.register((Disposable)this.myDisposable, (Disposable)this.myUsagePreviewPanel);
        this.myResultsPreviewTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                int index = FindPopupPanel.this.myResultsPreviewTable.getSelectedRow();
                if (index != -1) {
                    UsageInfo2UsageAdapter adapter = (UsageInfo2UsageAdapter)FindPopupPanel.this.myResultsPreviewTable.getModel().getValueAt(index, 0);
                    FindPopupPanel.this.myUsagePreviewPanel.updateLayout(adapter.isValid() ? Arrays.asList(adapter.getMergedInfos()) : null);
                    VirtualFile file2 = adapter.getFile();
                    String path = "";
                    if (file2 != null) {
                        String relativePath = VfsUtilCore.getRelativePath((VirtualFile)file2, (VirtualFile)FindPopupPanel.this.myProject.getBaseDir());
                        if (relativePath == null) {
                            relativePath = file2.getPath();
                        }
                        path = "<html><body>&nbsp;&nbsp;&nbsp;" + relativePath.replace(file2.getName(), "<b>" + file2.getName() + "</b>") + "</body></html>";
                    }
                    FindPopupPanel.this.myUsagePreviewPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)path, (boolean)false, (Insets)new JBInsets(8, 0, 0, 0)).setShowLine(false));
                } else {
                    FindPopupPanel.this.myUsagePreviewPanel.updateLayout(null);
                    FindPopupPanel.this.myUsagePreviewPanel.setBorder(IdeBorderFactory.createBorder());
                }
            }
        });
        this.mySearchRescheduleOnCancellationsAlarm = new Alarm();
        JBSplitter splitter = new JBSplitter(true, 0.33f);
        splitter.setSplitterProportionKey(SPLITTER_SERVICE_KEY);
        splitter.setDividerWidth(JBUI.scale((int)2));
        splitter.getDivider().setBackground(OnePixelDivider.BACKGROUND);
        JBScrollPane scrollPane = new JBScrollPane((Component)this.myResultsPreviewTable){

            public Dimension getMinimumSize() {
                Dimension size = super.getMinimumSize();
                size.height = ((FindPopupPanel)FindPopupPanel.this).myResultsPreviewTable.getPreferredScrollableViewportSize().height;
                return size;
            }
        };
        scrollPane.setBorder(IdeBorderFactory.createEmptyBorder());
        splitter.setFirstComponent((JComponent)scrollPane);
        JPanel bottomPanel = new JPanel((LayoutManager)new MigLayout("flowx, ins 4 4 0 4, fillx, hidemode 2, gap 0"));
        bottomPanel.add(this.myTabResultsButton);
        bottomPanel.add(Box.createHorizontalGlue(), "growx, pushx");
        this.myOKHintLabel = new JBLabel("");
        this.myOKHintLabel.setEnabled(false);
        bottomPanel.add((Component)this.myOKHintLabel, "gapright 10");
        bottomPanel.add(this.myOKButton);
        this.myCodePreviewComponent = this.myUsagePreviewPanel.createComponent();
        splitter.setSecondComponent(this.myCodePreviewComponent);
        JPanel scopesPanel = new JPanel((LayoutManager)new MigLayout("flowx, gap 26, ins 0"));
        scopesPanel.add(this.myScopeSelectionToolbar.getComponent());
        scopesPanel.add((Component)this.myScopeDetailsPanel, "growx, pushx");
        this.setLayout((LayoutManager)new MigLayout("flowx, ins 4, gap 0, fillx, hidemode 3"));
        int cbGapLeft = this.myCbCaseSensitive.getInsets().left;
        int cbGapRight = this.myCbCaseSensitive.getInsets().right;
        String cbGap = cbGapLeft + cbGapRight < 16 ? "gapright " + (16 - cbGapLeft - cbGapRight) : "";
        JPanel titlePanel = new JPanel(new BorderLayout());
        titlePanel.add((Component)this.myLoadingDecorator.getComponent(), "West");
        titlePanel.add((Component)this.myTitleLabel, "Center");
        this.add(titlePanel, "sx 2, growx, pushx, growy");
        this.add(this.myCbCaseSensitive, cbGap);
        this.add(this.myCbPreserveCase, cbGap);
        this.add(this.myCbWholeWordsOnly, cbGap);
        this.add(this.myCbRegularExpressions, "gapright 0");
        this.add((Component)RegExHelpPopup.createRegExLink("<html><body><b>?</b></body></html>", this.myCbRegularExpressions, LOG), "gapright " + (16 - cbGapLeft));
        this.add(this.myCbFileFilter);
        this.add((Component)((Object)this.myFileMaskField), "gapright 16");
        this.add(this.myFilterContextButton, "wrap");
        this.add((Component)((Object)this.mySearchTextArea), "pushx, growx, sx 10, gaptop 4, wrap");
        this.add((Component)((Object)this.myReplaceTextArea), "pushx, growx, sx 10, gaptop 4, wrap");
        this.add(scopesPanel, "sx 10, pushx, growx, ax left, wrap, gaptop 4, gapbottom 4");
        this.add((Component)splitter, "pushx, growx, growy, pushy, sx 10, wrap, pad -4 -4 4 4");
        this.add(bottomPanel, "pushx, growx, dock south, sx 10");
        MnemonicHelper.init((Component)((Object)this));
        this.setFocusCycleRoot(true);
        this.setFocusTraversalPolicy(new LayoutFocusTraversalPolicy(){

            @Override
            public Component getComponentAfter(Container container, Component c) {
                return c == FindPopupPanel.this.myResultsPreviewTable ? FindPopupPanel.this.mySearchComponent : super.getComponentAfter(container, c);
            }
        });
    }

    @NotNull
    private static StateRestoringCheckBox createCheckBox(String message2) {
        StateRestoringCheckBox checkBox = new StateRestoringCheckBox(FindBundle.message(message2, new Object[0]));
        checkBox.setFocusable(false);
        StateRestoringCheckBox stateRestoringCheckBox = checkBox;
        if (stateRestoringCheckBox == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/impl/FindPopupPanel", "createCheckBox"));
        }
        return stateRestoringCheckBox;
    }

    private void registerCloseAction(JBPopup popup) {
        AnAction escape = ActionManager.getInstance().getAction("EditorEscape");
        DumbAwareAction closeAction = new DumbAwareAction(){

            public void actionPerformed(AnActionEvent e) {
                if (FindPopupPanel.this.myBalloon != null && FindPopupPanel.this.myBalloon.isVisible()) {
                    FindPopupPanel.this.myBalloon.cancel();
                }
            }
        };
        closeAction.registerCustomShortcutSet(escape == null ? CommonShortcuts.ESCAPE : escape.getShortcutSet(), popup.getContent(), (Disposable)popup);
    }

    public void addNotify() {
        super.addNotify();
        ApplicationManager.getApplication().invokeLater(() -> ScrollingUtil.ensureSelectionExists((JTable)this.myResultsPreviewTable), ModalityState.any());
        this.myScopeSelectionToolbar.updateActionsImmediately();
    }

    @Override
    public void initByModel() {
        FindModel myModel = this.myHelper.getModel();
        this.myCbCaseSensitive.setSelected(myModel.isCaseSensitive());
        this.myCbWholeWordsOnly.setSelected(myModel.isWholeWordsOnly());
        this.myCbRegularExpressions.setSelected(myModel.isRegularExpressions());
        this.mySelectedContextName = FindDialog.getSearchContextName(myModel);
        if (myModel.isReplaceState()) {
            this.myCbPreserveCase.setSelected(myModel.isPreserveCase());
        }
        this.mySelectedScope = this.myScopeUI.initByModel(myModel);
        boolean isThereFileFilter = myModel.getFileFilter() != null && !myModel.getFileFilter().isEmpty();
        try {
            this.myCbFileFilter.putClientProperty("dontRequestFocus", Boolean.TRUE);
            this.myCbFileFilter.setSelected(isThereFileFilter);
        }
        finally {
            this.myCbFileFilter.putClientProperty("dontRequestFocus", null);
        }
        List<Object> variants = Arrays.asList(ArrayUtil.reverseArray((Object[])FindSettings.getInstance().getRecentFileMasks()));
        this.myFileMaskField.setVariants(variants);
        if (!variants.isEmpty()) {
            this.myFileMaskField.setText((String)variants.get(0));
        }
        this.myFileMaskField.setEnabled(isThereFileFilter);
        String toSearch = myModel.getStringToFind();
        FindInProjectSettings findInProjectSettings = FindInProjectSettings.getInstance(this.myProject);
        if (StringUtil.isEmpty((String)toSearch)) {
            String[] history = findInProjectSettings.getRecentFindStrings();
            toSearch = history.length > 0 ? history[history.length - 1] : "";
        }
        this.mySearchComponent.setText(toSearch);
        String toReplace = myModel.getStringToReplace();
        if (StringUtil.isEmpty((String)toReplace)) {
            String[] history = findInProjectSettings.getRecentReplaceStrings();
            toReplace = history.length > 0 ? history[history.length - 1] : "";
        }
        this.myReplaceComponent.setText(toReplace);
        this.updateControls();
        this.updateScopeDetailsPanel();
        this.updateReplaceVisibility();
    }

    private void updateControls() {
        FindModel myModel = this.myHelper.getModel();
        if (this.myCbRegularExpressions.isSelected()) {
            this.myCbWholeWordsOnly.makeUnselectable(false);
        } else {
            this.myCbWholeWordsOnly.makeSelectable();
        }
        if (myModel.isReplaceState()) {
            if (this.myCbRegularExpressions.isSelected() || this.myCbCaseSensitive.isSelected()) {
                this.myCbPreserveCase.makeUnselectable(false);
            } else {
                this.myCbPreserveCase.makeSelectable();
            }
            if (this.myCbPreserveCase.isSelected()) {
                this.myCbRegularExpressions.makeUnselectable(false);
                this.myCbCaseSensitive.makeUnselectable(false);
            } else {
                this.myCbRegularExpressions.makeSelectable();
                this.myCbCaseSensitive.makeSelectable();
            }
        }
    }

    @Override
    public void updateReplaceVisibility() {
        boolean isReplaceState = this.myHelper.isReplaceState();
        this.myTitleLabel.setText(this.myHelper.getTitle());
        this.myReplaceTextArea.setVisible(isReplaceState);
        this.myCbPreserveCase.setVisible(isReplaceState);
        if (Registry.is((String)"ide.find.enter.as.ok", (boolean)false) || isReplaceState) {
            this.myOKHintLabel.setText(KeymapUtil.getKeystrokeText((KeyStroke)ENTER));
        } else {
            this.myOKHintLabel.setText(KeymapUtil.getKeystrokeText((KeyStroke)ENTER_WITH_MODIFIERS));
        }
        this.myOKButton.setText(FindBundle.message(isReplaceState ? "find.popup.replace.button" : "find.popup.find.button", new Object[0]));
    }

    private void updateScopeDetailsPanel() {
        ((CardLayout)this.myScopeDetailsPanel.getLayout()).show(this.myScopeDetailsPanel, this.mySelectedScope.name);
        Component firstFocusableComponent = (Component)UIUtil.uiTraverser((Component)this.myScopeDetailsPanel).bfsTraversal().find(c -> c.isFocusable() && c.isEnabled() && c.isShowing() && (c instanceof JComboBox || c instanceof AbstractButton || c instanceof JTextComponent));
        this.myScopeDetailsPanel.revalidate();
        this.myScopeDetailsPanel.repaint();
        if (firstFocusableComponent != null) {
            ApplicationManager.getApplication().invokeLater(() -> IdeFocusManager.getInstance((Project)this.myProject).requestFocus(firstFocusableComponent, true));
        }
        if (firstFocusableComponent == null && !this.mySearchComponent.isFocusOwner() && !this.myReplaceComponent.isFocusOwner()) {
            ApplicationManager.getApplication().invokeLater(() -> IdeFocusManager.getInstance((Project)this.myProject).requestFocus((Component)this.mySearchComponent, true));
        }
    }

    public void scheduleResultsUpdate() {
        if (this.myBalloon == null || !this.myBalloon.isVisible()) {
            return;
        }
        if (this.mySearchRescheduleOnCancellationsAlarm == null || this.mySearchRescheduleOnCancellationsAlarm.isDisposed()) {
            return;
        }
        this.updateControls();
        this.mySearchRescheduleOnCancellationsAlarm.cancelAllRequests();
        this.mySearchRescheduleOnCancellationsAlarm.addRequest(() -> this.findSettingsChanged(), 100);
    }

    private void finishPreviousPreviewSearch() {
        if (this.myResultsPreviewSearchProgress != null && !this.myResultsPreviewSearchProgress.isCanceled()) {
            this.myResultsPreviewSearchProgress.cancel();
        }
    }

    private void findSettingsChanged() {
        ProgressIndicatorBase progressIndicatorWhenSearchStarted;
        if (this.isShowing()) {
            ScrollingUtil.ensureSelectionExists((JTable)this.myResultsPreviewTable);
        }
        final ModalityState state = ModalityState.current();
        this.finishPreviousPreviewSearch();
        this.mySearchRescheduleOnCancellationsAlarm.cancelAllRequests();
        this.applyTo(this.myHelper.getModel(), false);
        this.myHelper.updateFindSettings();
        FindModel findInProjectModel = FindManager.getInstance((Project)this.myProject).getFindInProjectModel();
        FindModel copy = new FindModel();
        copy.copyFrom(findInProjectModel);
        findInProjectModel.copyFrom(this.myHelper.getModel());
        final FindSettings findSettings = FindSettings.getInstance();
        this.myScopeUI.applyTo(findSettings, this.mySelectedScope);
        findSettings.setFileMask(this.myHelper.getModel().getFileFilter());
        ValidationInfo result2 = this.getValidationInfo(this.myHelper.getModel());
        this.myResultsPreviewSearchProgress = progressIndicatorWhenSearchStarted = new ProgressIndicatorBase(){

            @Override
            public void stop() {
                super.stop();
                FindPopupPanel.this.onStop(System.identityHashCode(this));
            }
        };
        final int hash = System.identityHashCode(this.myResultsPreviewSearchProgress);
        final DefaultTableModel model = new DefaultTableModel(){

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        model.addColumn("Usages");
        final LinkedHashSet<VirtualFile> filesToScanInitially = new LinkedHashSet<VirtualFile>();
        if (this.myHelper.myPreviousModel != null && this.myHelper.myPreviousModel.getStringToFind().length() < this.myHelper.getModel().getStringToFind().length()) {
            DefaultTableModel previousModel = (DefaultTableModel)this.myResultsPreviewTable.getModel();
            int len = previousModel.getRowCount();
            for (int i2 = 0; i2 < len; ++i2) {
                UsageInfo2UsageAdapter usage = (UsageInfo2UsageAdapter)previousModel.getValueAt(i2, 0);
                VirtualFile file2 = usage.getFile();
                if (file2 == null) continue;
                filesToScanInitially.add(file2);
            }
        }
        this.myHelper.myPreviousModel = this.myHelper.getModel().clone();
        this.myCodePreviewComponent.setVisible(false);
        this.mySearchTextArea.setInfoText(null);
        this.myResultsPreviewTable.setModel((TableModel)model);
        if (result2 != null) {
            this.myResultsPreviewTable.getEmptyText().setText(UIBundle.message((String)"message.nothingToShow", (Object[])new Object[0]) + " (" + result2.message + ")");
            this.onStop(hash);
            return;
        }
        GlobalSearchScope scope = GlobalSearchScopeUtil.toGlobalSearchScope(FindInProjectUtil.getScopeFromModel(this.myProject, this.myHelper.myPreviousModel), this.myProject);
        this.myResultsPreviewTable.getColumnModel().getColumn(0).setCellRenderer(new FindDialog.UsageTableCellRenderer(this.myCbFileFilter.isSelected(), false, scope));
        this.myResultsPreviewTable.getEmptyText().setText("Searching...");
        this.onStart(hash);
        final AtomicInteger resultsCount = new AtomicInteger();
        final AtomicInteger resultsFilesCount = new AtomicInteger();
        ProgressIndicatorUtils.scheduleWithWriteActionPriority(this.myResultsPreviewSearchProgress, new ReadTask(){

            @Override
            public ReadTask.Continuation performInReadAction(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/find/impl/FindPopupPanel$26", "performInReadAction"));
                }
                UsageViewPresentation presentation = FindInProjectUtil.setupViewPresentation(findSettings.isShowResultsInSeparateView(), FindPopupPanel.this.myHelper.getModel().clone());
                boolean showPanelIfOnlyOneUsage = !findSettings.isSkipResultsWithOneUsage();
                FindUsagesProcessPresentation processPresentation = FindInProjectUtil.setupProcessPresentation(FindPopupPanel.this.myProject, showPanelIfOnlyOneUsage, presentation);
                ThreadLocal lastUsageFileRef = new ThreadLocal();
                ThreadLocal recentUsageRef = new ThreadLocal();
                FindInProjectUtil.findUsages(FindPopupPanel.this.myHelper.getModel().clone(), FindPopupPanel.this.myProject, (Processor<UsageInfo>)((Processor)info -> {
                    boolean continueSearch;
                    Usage recent;
                    if (this.isCancelled()) {
                        FindPopupPanel.this.onStop(hash);
                        return false;
                    }
                    Usage usage = (Usage)UsageInfo2UsageAdapter.CONVERTER.fun(info);
                    usage.getPresentation().getIcon();
                    VirtualFile file2 = (VirtualFile)lastUsageFileRef.get();
                    VirtualFile usageFile = info.getVirtualFile();
                    if (file2 == null || !file2.equals(usageFile)) {
                        resultsFilesCount.incrementAndGet();
                        lastUsageFileRef.set(usageFile);
                    }
                    UsageInfo2UsageAdapter recentAdapter = (recent = (Usage)recentUsageRef.get()) != null && recent instanceof UsageInfo2UsageAdapter ? (UsageInfo2UsageAdapter)recent : null;
                    UsageInfo2UsageAdapter currentAdapter = usage instanceof UsageInfo2UsageAdapter ? (UsageInfo2UsageAdapter)usage : null;
                    boolean merged = currentAdapter != null && recentAdapter != null ? recentAdapter.merge((MergeableUsage)currentAdapter) : false;
                    if (!merged) {
                        recentUsageRef.set(usage);
                    }
                    ApplicationManager.getApplication().invokeLater(() -> {
                        if (this.isCancelled()) {
                            FindPopupPanel.this.onStop(hash);
                            return;
                        }
                        if (!merged) {
                            model.addRow(new Object[]{usage});
                        } else {
                            model.fireTableRowsUpdated(model.getRowCount() - 1, model.getRowCount() - 1);
                        }
                        FindPopupPanel.this.myCodePreviewComponent.setVisible(true);
                        if (model.getRowCount() == 1 && FindPopupPanel.this.myResultsPreviewTable.getModel() == model) {
                            FindPopupPanel.this.myResultsPreviewTable.setRowSelectionInterval(0, 0);
                        }
                        int occurrences = resultsCount.get();
                        int filesWithOccurrences = resultsFilesCount.get();
                        if (occurrences == 0) {
                            FindPopupPanel.this.myResultsPreviewTable.getEmptyText().setText(UIBundle.message((String)"message.nothingToShow", (Object[])new Object[0]));
                        }
                        FindPopupPanel.this.myCodePreviewComponent.setVisible(occurrences > 0);
                        StringBuilder stringBuilder = new StringBuilder();
                        if (occurrences > 0) {
                            boolean foundAllUsages;
                            stringBuilder.append(Math.min(ShowUsagesAction.getUsagesPageSize(), occurrences));
                            boolean bl = foundAllUsages = occurrences < ShowUsagesAction.getUsagesPageSize();
                            if (!foundAllUsages) {
                                stringBuilder.append("+");
                            }
                            stringBuilder.append(UIBundle.message((String)"message.matches", (Object[])new Object[]{occurrences}));
                            stringBuilder.append(" in ");
                            stringBuilder.append(filesWithOccurrences);
                            if (!foundAllUsages) {
                                stringBuilder.append("+");
                            }
                            stringBuilder.append(UIBundle.message((String)"message.files", (Object[])new Object[]{filesWithOccurrences}));
                        }
                        FindPopupPanel.this.mySearchTextArea.setInfoText(stringBuilder.toString());
                    }, state);
                    boolean bl = continueSearch = resultsCount.incrementAndGet() < ShowUsagesAction.getUsagesPageSize();
                    if (!continueSearch) {
                        FindPopupPanel.this.onStop(hash);
                    }
                    return continueSearch;
                }), processPresentation, filesToScanInitially);
                return new ReadTask.Continuation(() -> {
                    if (!this.isCancelled() && resultsCount.get() == 0) {
                        FindPopupPanel.this.myResultsPreviewTable.getEmptyText().setText(UIBundle.message((String)"message.nothingToShow", (Object[])new Object[0]));
                    }
                    FindPopupPanel.this.onStop(hash);
                }, state);
            }

            boolean isCancelled() {
                return progressIndicatorWhenSearchStarted != FindPopupPanel.this.myResultsPreviewSearchProgress || progressIndicatorWhenSearchStarted.isCanceled();
            }

            @Override
            public void onCanceled(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/find/impl/FindPopupPanel$26", "onCanceled"));
                }
                if (FindPopupPanel.this.isShowing() && progressIndicatorWhenSearchStarted == FindPopupPanel.this.myResultsPreviewSearchProgress) {
                    FindPopupPanel.this.scheduleResultsUpdate();
                }
            }
        });
    }

    private void onStart(int hash) {
        this.myLoadingHash = hash;
        this.myLoadingDecorator.startLoading(false);
    }

    private void onStop(int hash) {
        if (hash != this.myLoadingHash) {
            return;
        }
        UIUtil.invokeLaterIfNeeded(() -> this.myLoadingDecorator.stopLoading());
    }

    @Override
    @Nullable
    public String getFileTypeMask() {
        String mask = null;
        if (this.myCbFileFilter != null && this.myCbFileFilter.isSelected()) {
            mask = this.myFileMaskField.getText();
        }
        return mask;
    }

    @Nullable(value="null means OK")
    private ValidationInfo getValidationInfo(@NotNull FindModel model) {
        String mask;
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/find/impl/FindPopupPanel", "getValidationInfo"));
        }
        ValidationInfo scopeValidationInfo = this.myScopeUI.validate(model, this.mySelectedScope);
        if (scopeValidationInfo != null) {
            return scopeValidationInfo;
        }
        if (!this.myHelper.canSearchThisString()) {
            return new ValidationInfo(FindBundle.message("find.empty.search.text.error", new Object[0]), (JComponent)this.mySearchComponent);
        }
        if (this.myCbRegularExpressions != null && this.myCbRegularExpressions.isSelected() && this.myCbRegularExpressions.isEnabled()) {
            String toFind = this.getStringToFind();
            try {
                boolean isCaseSensitive = this.myCbCaseSensitive != null && this.myCbCaseSensitive.isSelected() && this.myCbCaseSensitive.isEnabled();
                Pattern pattern = Pattern.compile(toFind, isCaseSensitive ? 8 : 10);
                if (pattern.matcher("").matches() && !toFind.endsWith("$") && !toFind.startsWith("^")) {
                    return new ValidationInfo(FindBundle.message("find.empty.match.regular.expression.error", new Object[0]), (JComponent)this.mySearchComponent);
                }
            }
            catch (PatternSyntaxException e) {
                return new ValidationInfo(FindBundle.message("find.invalid.regular.expression.error", toFind, e.getDescription()), (JComponent)this.mySearchComponent);
            }
        }
        if ((mask = this.getFileTypeMask()) != null) {
            if (mask.isEmpty()) {
                return new ValidationInfo(FindBundle.message("find.filter.empty.file.mask.error", new Object[0]), this.myFileMaskField);
            }
            if (mask.contains(";")) {
                return new ValidationInfo("File masks should be comma-separated", this.myFileMaskField);
            }
            try {
                FindInProjectUtil.createFileMaskRegExp(mask);
            }
            catch (PatternSyntaxException ex) {
                return new ValidationInfo(FindBundle.message("find.filter.invalid.file.mask.error", mask), this.myFileMaskField);
            }
        }
        return null;
    }

    @Override
    @NotNull
    public String getStringToFind() {
        String string = this.mySearchComponent.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/impl/FindPopupPanel", "getStringToFind"));
        }
        return string;
    }

    @NotNull
    private String getStringToReplace() {
        String string = this.myReplaceComponent.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/impl/FindPopupPanel", "getStringToReplace"));
        }
        return string;
    }

    private void applyTo(@NotNull FindModel model, boolean findAll) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/find/impl/FindPopupPanel", "applyTo"));
        }
        model.setCaseSensitive(this.myCbCaseSensitive.isSelected());
        if (model.isReplaceState()) {
            model.setPreserveCase(this.myCbPreserveCase.isSelected());
        }
        model.setWholeWordsOnly(this.myCbWholeWordsOnly.isSelected());
        String selectedSearchContextInUi = this.mySelectedContextName;
        FindModel.SearchContext searchContext = FindDialog.parseSearchContext(selectedSearchContextInUi);
        model.setSearchContext(searchContext);
        model.setRegularExpressions(this.myCbRegularExpressions.isSelected());
        String stringToFind = this.getStringToFind();
        model.setStringToFind(stringToFind);
        if (model.isReplaceState()) {
            model.setPromptOnReplace(true);
            model.setReplaceAll(false);
            String stringToReplace = this.getStringToReplace();
            model.setStringToReplace(StringUtil.convertLineSeparators((String)stringToReplace));
        }
        model.setProjectScope(false);
        model.setDirectoryName(null);
        model.setModuleName(null);
        model.setCustomScopeName(null);
        model.setCustomScope(null);
        model.setCustomScope(false);
        this.myScopeUI.applyTo(model, this.mySelectedScope);
        model.setFindAll(findAll);
        String mask = this.getFileTypeMask();
        model.setFileFilter(mask);
    }

    private void navigateToSelectedUsage() {
        Usage[] usages = this.getSelectedUsages();
        if (usages != null) {
            this.applyTo(FindManager.getInstance((Project)this.myProject).getFindInProjectModel(), false);
            this.myBalloon.cancel();
            usages[0].navigate(true);
            for (int i2 = 1; i2 < usages.length; ++i2) {
                usages[i2].highlightInEditor();
            }
        }
    }

    @Nullable
    private Usage[] getSelectedUsages() {
        int[] rows = this.myResultsPreviewTable.getSelectedRows();
        SmartList usages = null;
        for (int row : rows) {
            Object valueAt = this.myResultsPreviewTable.getModel().getValueAt(row, 0);
            if (!(valueAt instanceof Usage)) continue;
            if (usages == null) {
                usages = new SmartList();
            }
            Usage at = (Usage)valueAt;
            usages.add(at);
        }
        return usages != null ? (Usage[])ContainerUtil.toArray(usages, (Object[])Usage.EMPTY_ARRAY) : null;
    }

    public static ActionToolbarImpl createToolbar(AnAction ... actions) {
        ActionToolbarImpl toolbar = (ActionToolbarImpl)ActionManager.getInstance().createActionToolbar("EditorToolbar", (ActionGroup)new DefaultActionGroup(actions), true);
        toolbar.setForceMinimumSize(true);
        toolbar.setLayoutPolicy(0);
        return toolbar;
    }

    private static void applyFont(JBFont font, Component ... components) {
        for (Component component : components) {
            component.setFont((Font)font);
        }
    }

    private class MyShowFilterPopupAction
    extends AnAction {
        private final DefaultActionGroup mySwitchContextGroup;

        public MyShowFilterPopupAction() {
            super(FindBundle.message("find.popup.show.filter.popup", new Object[0]), null, AllIcons.General.Filter);
            LayeredIcon icon = (LayeredIcon)JBUI.scale((JBUI.JBIcon)new LayeredIcon(2));
            icon.setIcon(AllIcons.General.Filter, 0);
            icon.setIcon(AllIcons.General.Dropdown, 1, 3, 0);
            this.getTemplatePresentation().setIcon((Icon)icon);
            this.setShortcutSet((ShortcutSet)new CustomShortcutSet(new Shortcut[]{ShowMoreOptions.SHORT_CUT}));
            this.mySwitchContextGroup = new DefaultActionGroup();
            this.mySwitchContextGroup.add((AnAction)new MySwitchContextToggleAction(FindModel.SearchContext.ANY));
            this.mySwitchContextGroup.add((AnAction)new MySwitchContextToggleAction(FindModel.SearchContext.IN_COMMENTS));
            this.mySwitchContextGroup.add((AnAction)new MySwitchContextToggleAction(FindModel.SearchContext.IN_STRING_LITERALS));
            this.mySwitchContextGroup.add((AnAction)new MySwitchContextToggleAction(FindModel.SearchContext.EXCEPT_COMMENTS));
            this.mySwitchContextGroup.add((AnAction)new MySwitchContextToggleAction(FindModel.SearchContext.EXCEPT_STRING_LITERALS));
            this.mySwitchContextGroup.add((AnAction)new MySwitchContextToggleAction(FindModel.SearchContext.EXCEPT_COMMENTS_AND_STRING_LITERALS));
            this.mySwitchContextGroup.setPopup(true);
        }

        public void actionPerformed(AnActionEvent e) {
            if (PlatformDataKeys.CONTEXT_COMPONENT.getData(e.getDataContext()) == null) {
                return;
            }
            ListPopup listPopup = JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)this.mySwitchContextGroup, e.getDataContext(), false, null, 10);
            listPopup.showUnderneathOf((Component)FindPopupPanel.this.myFilterContextButton);
        }
    }

    private class MySelectScopeToggleAction
    extends ToggleAction {
        private final FindPopupScopeUI.ScopeType myScope;

        public MySelectScopeToggleAction(FindPopupScopeUI.ScopeType scope) {
            super(scope.text, null, scope.icon);
            this.getTemplatePresentation().setHoveredIcon(scope.icon);
            this.getTemplatePresentation().setDisabledIcon(scope.icon);
            this.myScope = scope;
        }

        public boolean displayTextInToolbar() {
            return true;
        }

        public boolean isSelected(AnActionEvent e) {
            return FindPopupPanel.this.mySelectedScope == this.myScope;
        }

        public void setSelected(AnActionEvent e, boolean state) {
            if (state) {
                FindPopupPanel.this.mySelectedScope = this.myScope;
                FindPopupPanel.this.myScopeSelectionToolbar.updateActionsImmediately();
                FindPopupPanel.this.updateScopeDetailsPanel();
                FindPopupPanel.this.scheduleResultsUpdate();
            }
        }
    }

    private class MySwitchContextToggleAction
    extends ToggleAction {
        public MySwitchContextToggleAction(FindModel.SearchContext context) {
            super(FindDialog.getPresentableName(context));
        }

        public void beforeActionPerformedUpdate(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/find/impl/FindPopupPanel$MySwitchContextToggleAction", "beforeActionPerformedUpdate"));
            }
            super.beforeActionPerformedUpdate(e);
        }

        public boolean isSelected(AnActionEvent e) {
            return Comparing.equal((String)FindPopupPanel.this.mySelectedContextName, (String)this.getTemplatePresentation().getText());
        }

        public void setSelected(AnActionEvent e, boolean state) {
            if (state) {
                FindPopupPanel.this.mySelectedContextName = this.getTemplatePresentation().getText();
                FindPopupPanel.this.scheduleResultsUpdate();
            }
        }
    }
}

