/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.psi.util.PsiUtilBase;
import org.jetbrains.annotations.NotNull;

public class FormatConstants {
    public static final int RESERVED_LINE_WRAP_WIDTH_IN_COLUMNS = 3;

    private FormatConstants() {
    }

    public static int getReservedLineWrapWidthInColumns(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/formatting/FormatConstants", "getReservedLineWrapWidthInColumns"));
        }
        return FormatConstants.isPlainTextFile(editor) ? 0 : 3;
    }

    private static boolean isPlainTextFile(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/formatting/FormatConstants", "isPlainTextFile"));
        }
        return editor.getProject() != null && PlainTextLanguage.INSTANCE.is(PsiUtilBase.getLanguageInEditor((Editor)editor, (Project)editor.getProject()));
    }
}

