/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting;

import com.intellij.formatting.FormatRangesStorage;
import com.intellij.formatting.FormatTextRange;
import com.intellij.formatting.FormattingRangesInfo;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UnfairTextRange;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.ChangedRangesInfo;
import com.intellij.util.containers.ContainerUtil;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class FormatTextRanges
implements FormattingRangesInfo {
    private final List<TextRange> myInsertedRanges;
    private final FormatRangesStorage myStorage;

    public FormatTextRanges() {
        this.myStorage = new FormatRangesStorage();
        this.myInsertedRanges = null;
    }

    public FormatTextRanges(TextRange range, boolean processHeadingWhitespace) {
        this.myStorage = new FormatRangesStorage();
        this.myInsertedRanges = null;
        this.add(range, processHeadingWhitespace);
    }

    public FormatTextRanges(@NotNull ChangedRangesInfo changedRangesInfo) {
        if (changedRangesInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changedRangesInfo", "com/intellij/formatting/FormatTextRanges", "<init>"));
        }
        this.myStorage = new FormatRangesStorage();
        List<TextRange> optimized = FormatTextRanges.optimizedChangedRanges(changedRangesInfo.allChangedRanges);
        optimized.forEach(range -> this.add((TextRange)range, true));
        this.myInsertedRanges = changedRangesInfo.insertedRanges;
    }

    public void add(TextRange range, boolean processHeadingWhitespace) {
        this.myStorage.add(range, processHeadingWhitespace);
    }

    @Override
    public boolean isWhitespaceReadOnly(@NotNull TextRange range) {
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/formatting/FormatTextRanges", "isWhitespaceReadOnly"));
        }
        return this.myStorage.isWhiteSpaceReadOnly(range);
    }

    @Override
    public boolean isReadOnly(@NotNull TextRange range) {
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/formatting/FormatTextRanges", "isReadOnly"));
        }
        return this.myStorage.isReadOnly(range);
    }

    @Override
    public boolean isOnInsertedLine(int offset) {
        if (this.myInsertedRanges == null) {
            return false;
        }
        Optional<TextRange> enclosingRange = this.myInsertedRanges.stream().filter(range -> range.contains(offset)).findAny();
        return enclosingRange.isPresent();
    }

    public List<FormatTextRange> getRanges() {
        return this.myStorage.getRanges();
    }

    public FormatTextRanges ensureNonEmpty() {
        FormatTextRanges result2 = new FormatTextRanges();
        for (FormatTextRange range : this.myStorage.getRanges()) {
            if (range.isProcessHeadingWhitespace()) {
                result2.add(range.getNonEmptyTextRange(), true);
                continue;
            }
            result2.add(range.getTextRange(), false);
        }
        return result2;
    }

    public boolean isEmpty() {
        return this.myStorage.isEmpty();
    }

    public boolean isFullReformat(PsiFile file2) {
        List<FormatTextRange> ranges = this.myStorage.getRanges();
        return ranges.size() == 1 && file2.getTextRange().equals((Object)ranges.get(0).getTextRange());
    }

    public List<TextRange> getTextRanges() {
        return this.myStorage.getRanges().stream().map(FormatTextRange::getTextRange).collect(Collectors.toList());
    }

    public List<TextRange> getExtendedFormattingRanges() {
        return this.myStorage.getRanges().stream().map(range -> {
            TextRange textRange = range.getTextRange();
            return new UnfairTextRange(textRange.getStartOffset() - 500, textRange.getEndOffset() + 500);
        }).collect(Collectors.toList());
    }

    private static List<TextRange> optimizedChangedRanges(@NotNull List<TextRange> allChangedRanges) {
        if (allChangedRanges == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allChangedRanges", "com/intellij/formatting/FormatTextRanges", "optimizedChangedRanges"));
        }
        if (allChangedRanges.isEmpty()) {
            return allChangedRanges;
        }
        List sorted = ContainerUtil.sorted(allChangedRanges, (Comparator)Segment.BY_START_OFFSET_THEN_END_OFFSET);
        List result2 = ContainerUtil.newSmartList();
        TextRange prev = (TextRange)sorted.get(0);
        for (TextRange next : sorted) {
            if (next.getStartOffset() <= prev.getEndOffset() + 5) {
                int newEndOffset = Math.max(prev.getEndOffset(), next.getEndOffset());
                prev = new TextRange(prev.getStartOffset(), newEndOffset);
                continue;
            }
            result2.add(prev);
            prev = next;
        }
        result2.add(prev);
        return result2;
    }
}

