/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting.commandLine;

import com.intellij.formatting.FormatTextRanges;
import com.intellij.formatting.commandLine.FileSetProcessor;
import com.intellij.formatting.commandLine.MessageOutput;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.lang.LanguageFormatting;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.impl.NonProjectFileWritingAccessProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.impl.source.codeStyle.CodeFormatterFacade;
import com.intellij.util.PlatformUtils;
import java.io.File;
import java.io.IOException;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileSetFormatter
extends FileSetProcessor {
    private static final Logger LOG = Logger.getInstance(FileSetFormatter.class);
    private static final String PROJECT_DIR_PREFIX = PlatformUtils.getPlatformPrefix() + ".format.";
    private static final String PROJECT_DIR_SUFFIX = ".tmp";
    private static final String RESULT_MESSAGE_OK = "OK";
    private static final String RESULT_MESSAGE_FAILED = "Failed";
    private static final String RESULT_MESSAGE_NOT_SUPPORTED = "Skipped, not supported.";
    private static final String RESULT_MESSAGE_BINARY_FILE = "Skipped, binary file.";
    @NotNull
    private final String myProjectUID;
    @Nullable
    private Project myProject;
    private MessageOutput myMessageOutput;
    @NotNull
    private CodeStyleSettings mySettings;

    public FileSetFormatter(@NotNull MessageOutput messageOutput) {
        if (messageOutput == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messageOutput", "com/intellij/formatting/commandLine/FileSetFormatter", "<init>"));
        }
        this.myMessageOutput = messageOutput;
        this.mySettings = new CodeStyleSettings();
        this.myProjectUID = UUID.randomUUID().toString();
    }

    public void setCodeStyleSettings(@NotNull CodeStyleSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/formatting/commandLine/FileSetFormatter", "setCodeStyleSettings"));
        }
        this.mySettings = settings;
    }

    private void createProject() throws IOException {
        ProjectManagerEx projectManager = (ProjectManagerEx)ProjectManager.getInstance();
        File projectDir = this.createProjectDir();
        this.myProject = projectManager.createProject(this.myProjectUID, projectDir.getPath());
        if (this.myProject != null) {
            projectManager.openProject(this.myProject);
        }
    }

    private File createProjectDir() throws IOException {
        File tempDir = FileUtil.createTempDirectory((String)PROJECT_DIR_PREFIX, (String)(this.myProjectUID + PROJECT_DIR_SUFFIX));
        File projectDir = new File(tempDir.getPath() + File.separator + ".idea");
        if (projectDir.mkdirs()) {
            return projectDir;
        }
        throw new IOException("Cannot create a temporary project at " + projectDir);
    }

    private void closeProject() {
        if (this.myProject != null) {
            ProjectUtil.closeAndDispose(this.myProject);
        }
    }

    @Override
    public void processFiles() throws IOException {
        this.createProject();
        if (this.myProject != null) {
            super.processFiles();
            this.closeProject();
        }
    }

    @Override
    protected boolean processFile(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/formatting/commandLine/FileSetFormatter", "processFile"));
        }
        String resultMessage = RESULT_MESSAGE_OK;
        assert (this.myProject != null);
        VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)false, (boolean)false, (VirtualFile[])new VirtualFile[]{virtualFile});
        this.myMessageOutput.info("Formatting " + virtualFile.getCanonicalPath() + "...");
        if (!virtualFile.getFileType().isBinary()) {
            VirtualFile[] openFiles;
            Document document = FileDocumentManager.getInstance().getDocument(virtualFile);
            if (document != null) {
                PsiFile psiFile = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(document);
                NonProjectFileWritingAccessProvider.allowWriting(virtualFile);
                if (psiFile != null) {
                    if (FileSetFormatter.isFormattingSupported(psiFile)) {
                        this.reformatFile(this.myProject, psiFile, document);
                        FileDocumentManager.getInstance().saveDocument(document);
                    } else {
                        resultMessage = RESULT_MESSAGE_NOT_SUPPORTED;
                    }
                } else {
                    LOG.warn("Unable to get a PSI file for " + virtualFile.getPath());
                    resultMessage = RESULT_MESSAGE_FAILED;
                }
            } else {
                LOG.warn("No document available for " + virtualFile.getPath());
                resultMessage = RESULT_MESSAGE_FAILED;
            }
            FileEditorManager editorManager = FileEditorManager.getInstance((Project)this.myProject);
            for (VirtualFile openFile2 : openFiles = editorManager.getOpenFiles()) {
                editorManager.closeFile(openFile2);
            }
        } else {
            resultMessage = RESULT_MESSAGE_BINARY_FILE;
        }
        this.myMessageOutput.info(resultMessage + "\n");
        return RESULT_MESSAGE_OK.equals(resultMessage);
    }

    private void reformatFile(@NotNull Project project2, @NotNull PsiFile file2, @NotNull Document document) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/formatting/commandLine/FileSetFormatter", "reformatFile"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/formatting/commandLine/FileSetFormatter", "reformatFile"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/formatting/commandLine/FileSetFormatter", "reformatFile"));
        }
        WriteCommandAction.runWriteCommandAction((Project)project2, () -> {
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/formatting/commandLine/FileSetFormatter", "lambda$reformatFile$0"));
            }
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/formatting/commandLine/FileSetFormatter", "lambda$reformatFile$0"));
            }
            if (document == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/formatting/commandLine/FileSetFormatter", "lambda$reformatFile$0"));
            }
            CodeFormatterFacade formatterFacade = new CodeFormatterFacade(this.mySettings, file2.getLanguage());
            formatterFacade.processText(file2, new FormatTextRanges(new TextRange(0, file2.getTextLength()), true), false);
            PsiDocumentManager.getInstance((Project)project2).commitDocument(document);
        });
    }

    private static boolean isFormattingSupported(@NotNull PsiFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/formatting/commandLine/FileSetFormatter", "isFormattingSupported"));
        }
        return LanguageFormatting.INSTANCE.forContext((PsiElement)file2) != null;
    }
}

