/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting.commandLine;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public abstract class FileSetProcessor {
    private static final Logger LOG = Logger.getInstance(FileSetProcessor.class);
    private Set<File> myTopEntries = ContainerUtil.newHashSet();
    private Set<String> myFileMasks = ContainerUtil.newHashSet();
    private int myProcessedFiles;
    private boolean isRecursive;

    public void processFiles() throws IOException {
        for (File topEntry : this.myTopEntries) {
            this.processEntry(topEntry);
        }
    }

    public void setRecursive() {
        this.isRecursive = true;
    }

    public void addFileMask(@NotNull String fileMask) {
        if (fileMask == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileMask", "com/intellij/formatting/commandLine/FileSetProcessor", "addFileMask"));
        }
        String fileMaskRegexp = FileSetProcessor.fileMaskToRegexp(fileMask);
        LOG.info("File mask regexp: " + fileMaskRegexp);
        this.myFileMasks.add(fileMaskRegexp);
    }

    private static String fileMaskToRegexp(@NotNull String fileMask) {
        if (fileMask == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileMask", "com/intellij/formatting/commandLine/FileSetProcessor", "fileMaskToRegexp"));
        }
        return fileMask.replace(".", "\\.").replace("*", ".*").replace("?", ".").replace("+", "\\+");
    }

    public void addEntry(@NotNull String filePath) throws IOException {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/formatting/commandLine/FileSetProcessor", "addEntry"));
        }
        File file2 = new File(filePath);
        if (!file2.exists()) {
            throw new IOException("File " + filePath + " not found.");
        }
        this.myTopEntries.add(file2);
    }

    private void processEntry(@NotNull File entry) throws IOException {
        if (entry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entry", "com/intellij/formatting/commandLine/FileSetProcessor", "processEntry"));
        }
        if (entry.exists()) {
            if (entry.isDirectory()) {
                LOG.info("Scanning directory " + entry.getPath());
                File[] subEntries = entry.listFiles();
                if (subEntries != null) {
                    for (File subEntry : subEntries) {
                        if (subEntry.isDirectory() && !this.isRecursive) continue;
                        this.processEntry(subEntry);
                    }
                }
            } else if (this.matchesFileMask(entry.getName())) {
                VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(entry);
                if (virtualFile == null) {
                    throw new IOException("Can not find " + entry.getPath());
                }
                LOG.info("Processing " + virtualFile.getPath());
                if (this.processFile(virtualFile)) {
                    ++this.myProcessedFiles;
                }
            }
        }
    }

    private boolean matchesFileMask(@NotNull String name2) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/formatting/commandLine/FileSetProcessor", "matchesFileMask"));
        }
        if (this.myFileMasks.isEmpty()) {
            return true;
        }
        for (String fileMask : this.myFileMasks) {
            if (!name2.matches(fileMask)) continue;
            return true;
        }
        return false;
    }

    protected abstract boolean processFile(@NotNull VirtualFile var1);

    public int getProcessedFiles() {
        return this.myProcessedFiles;
    }
}

