/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.help.impl;

import com.intellij.CommonBundle;
import com.intellij.help.impl.IdeaHelpBroker;
import com.intellij.help.impl.MacHelpUtil;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.HelpSetPath;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.internal.statistic.UsageTrigger;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.reference.SoftReference;
import com.intellij.util.PlatformUtils;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.lang.ref.WeakReference;
import java.net.URL;
import javax.help.BadIDException;
import javax.help.HelpSet;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class HelpManagerImpl
extends HelpManager {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.help.impl.HelpManagerImpl");
    @NonNls
    private static final String HELP_HS = "Help.hs";
    private WeakReference<IdeaHelpBroker> myBrokerReference = null;

    public void invokeHelp(@Nullable String id) {
        HelpSet set2;
        id = StringUtil.notNullize((String)id, (String)"top");
        UsageTrigger.trigger("ide.help." + id);
        if (MacHelpUtil.isApplicable() && MacHelpUtil.invokeHelp(id)) {
            return;
        }
        IdeaHelpBroker broker = (IdeaHelpBroker)SoftReference.dereference(this.myBrokerReference);
        if (broker == null && (set2 = HelpManagerImpl.createHelpSet()) != null) {
            broker = new IdeaHelpBroker(set2);
            this.myBrokerReference = new WeakReference<IdeaHelpBroker>(broker);
        }
        if (broker == null) {
            String productCode;
            ApplicationInfoEx info = ApplicationInfoEx.getInstanceEx();
            String minorVersion = info.getMinorVersion();
            int dot = minorVersion.indexOf(46);
            if (dot != -1) {
                minorVersion = minorVersion.substring(0, dot);
            }
            String productVersion = info.getMajorVersion() + "." + minorVersion;
            String url = info.getWebHelpUrl();
            if (!url.endsWith("/")) {
                url = url + "/";
            }
            url = url + productVersion + "/?" + id;
            if (PlatformUtils.isJetBrainsProduct() && !StringUtil.isEmpty((String)(productCode = info.getBuild().getProductCode()))) {
                url = url + "&utm_source=from_product&utm_medium=help_link&utm_campaign=" + productCode + "&utm_content=" + productVersion;
            }
            BrowserUtil.browse((String)url);
            return;
        }
        Window activeWindow = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        broker.setActivationWindow(activeWindow);
        try {
            broker.setCurrentID(id);
        }
        catch (BadIDException e) {
            Messages.showErrorDialog((String)IdeBundle.message((String)"help.topic.not.found.error", (Object[])new Object[]{id}), (String)CommonBundle.getErrorTitle());
            return;
        }
        broker.setDisplayed(true);
    }

    @Nullable
    private static HelpSet createHelpSet() {
        IdeaPluginDescriptor[] pluginDescriptors;
        String applicationHelpUrl = ApplicationInfo.getInstance().getHelpURL();
        if (applicationHelpUrl == null) {
            return null;
        }
        String urlToHelp = applicationHelpUrl + "/" + HELP_HS;
        HelpSet mainHelpSet = HelpManagerImpl.loadHelpSet(urlToHelp);
        if (mainHelpSet == null) {
            return null;
        }
        for (IdeaPluginDescriptor pluginDescriptor : pluginDescriptors = PluginManagerCore.getPlugins()) {
            HelpSetPath[] sets;
            for (HelpSetPath hsPath : sets = pluginDescriptor.getHelpSets()) {
                HelpSet pluginHelpSet;
                String url = "jar:file:///" + pluginDescriptor.getPath().getAbsolutePath() + "/help/" + hsPath.getFile() + "!";
                if (!hsPath.getPath().startsWith("/")) {
                    url = url + "/";
                }
                if ((pluginHelpSet = HelpManagerImpl.loadHelpSet(url = url + hsPath.getPath())) == null) continue;
                mainHelpSet.add(pluginHelpSet);
            }
        }
        return mainHelpSet;
    }

    @Nullable
    private static HelpSet loadHelpSet(String url) {
        try {
            return new HelpSet(null, new URL(url));
        }
        catch (Exception e) {
            LOG.info("Failed to load help set from '" + url + "'", (Throwable)e);
            return null;
        }
    }
}

