/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.concurrency.JobScheduler;
import com.intellij.diagnostic.VMOptions;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.util.ExecUtil;
import com.intellij.ide.AppLifecycleListener;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.RemoteDesktopService;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.notification.NotificationsConfiguration;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Bitness;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.Version;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.JdkBundle;
import com.intellij.util.SystemProperties;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.sun.jna.Library;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.File;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;

public class SystemHealthMonitor
implements ApplicationComponent {
    private static final Logger LOG = Logger.getInstance(SystemHealthMonitor.class);
    private static final NotificationGroup GROUP = new NotificationGroup("System Health", NotificationDisplayType.STICKY_BALLOON, false);
    private static final NotificationGroup LOG_GROUP = NotificationGroup.logOnlyGroup((String)"System Health (minor)");
    private static final String SWITCH_JDK_ACTION = "SwitchBootJdk";
    private static final String LATEST_JDK_RELEASE = "1.8.0u112";
    private final PropertiesComponent myProperties;

    public SystemHealthMonitor(@NotNull PropertiesComponent properties) {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/intellij/ide/SystemHealthMonitor", "<init>"));
        }
        this.myProperties = properties;
    }

    public void initComponent() {
        this.checkRuntime();
        this.checkReservedCodeCacheSize();
        this.checkIBus();
        this.checkSignalBlocking();
        this.checkLauncherScript();
        this.checkHiDPIMode();
        SystemHealthMonitor.startDiskSpaceMonitoring();
    }

    private void checkReservedCodeCacheSize() {
        int minReservedCodeCacheSize = 240;
        int reservedCodeCacheSize = VMOptions.readOption(VMOptions.MemoryKind.CODE_CACHE, true);
        if (reservedCodeCacheSize > 0 && reservedCodeCacheSize < minReservedCodeCacheSize) {
            this.showNotification(new KeyHyperlinkAdapter("vmoptions.warn.message"), reservedCodeCacheSize, minReservedCodeCacheSize);
        }
    }

    private void checkRuntime() {
        JdkBundle bundle;
        if (StringUtil.endsWithIgnoreCase((String)System.getProperty("java.version", ""), (String)"-ea")) {
            this.showNotification(new KeyHyperlinkAdapter("unsupported.jvm.ea.message"), new Object[0]);
        }
        if ((bundle = JdkBundle.createBoot()) != null && !bundle.isBundled()) {
            Version version = bundle.getVersion();
            Integer updateNumber = bundle.getUpdateNumber();
            if (version != null && updateNumber != null && version.major == 1 && version.minor == 8 && updateNumber < 112) {
                String bundleVersion = version.toCompactString() + "u" + updateNumber;
                boolean showSwitchOption = false;
                File bundledJDKAbsoluteLocation = JdkBundle.getBundledJDKAbsoluteLocation();
                if (bundledJDKAbsoluteLocation.exists() && bundle.getBitness() == Bitness.x64) {
                    JdkBundle bundledJdk;
                    if (SystemInfo.isMacIntel64) {
                        showSwitchOption = true;
                    } else if ((SystemInfo.isWindows || SystemInfo.isLinux) && (bundledJdk = JdkBundle.createBundle(bundledJDKAbsoluteLocation, false, false)) != null && bundledJdk.getVersion() != null) {
                        showSwitchOption = true;
                    }
                }
                this.showNotification(new KeyHyperlinkAdapter(showSwitchOption ? "outdated.jvm.version.message1" : "outdated.jvm.version.message2"){

                    @Override
                    protected void hyperlinkActivated(HyperlinkEvent e) {
                        if ("switch".equals(e.getDescription())) {
                            ActionManager.getInstance().getAction(SystemHealthMonitor.SWITCH_JDK_ACTION).actionPerformed(null);
                        } else {
                            super.hyperlinkActivated(e);
                        }
                    }
                }, bundleVersion, LATEST_JDK_RELEASE);
            }
        }
    }

    private void checkIBus() {
        String fix;
        Matcher m;
        String version;
        String xim;
        if (SystemInfo.isXWindow && (xim = System.getenv("XMODIFIERS")) != null && xim.contains("im=ibus") && (version = ExecUtil.execAndReadLine((GeneralCommandLine)new GeneralCommandLine(new String[]{"ibus-daemon", "--version"}))) != null && (m = Pattern.compile("ibus-daemon - Version ([0-9.]+)").matcher(version)).find() && StringUtil.compareVersionNumbers((String)m.group(1), (String)"1.5.11") < 0 && ((fix = System.getenv("IBUS_ENABLE_SYNC_MODE")) == null || fix.isEmpty() || fix.equals("0") || fix.equalsIgnoreCase("false"))) {
            this.showNotification(new KeyHyperlinkAdapter("ibus.blocking.warn.message"), new Object[0]);
        }
    }

    private void checkSignalBlocking() {
        if (SystemInfo.isUnix) {
            try {
                LibC lib = (LibC)Native.loadLibrary((String)"c", LibC.class);
                Memory buf = new Memory(1024L);
                if (lib.sigaction(2, null, (Pointer)buf) == 0) {
                    long handler2;
                    long l = handler2 = Native.POINTER_SIZE == 8 ? buf.getLong(0L) : (long)buf.getInt(0L);
                    if (handler2 == 1L) {
                        this.showNotification(new KeyHyperlinkAdapter("ide.sigint.ignored.message"), new Object[0]);
                    }
                }
            }
            catch (Throwable t) {
                LOG.warn(t);
            }
        }
    }

    private void checkLauncherScript() {
        if (SystemInfo.isXWindow && System.getProperty("jb.restart.code") != null) {
            this.showNotification(new KeyHyperlinkAdapter("ide.launcher.script.outdated"), new Object[0]);
        }
    }

    private void checkHiDPIMode() {
        boolean defaultScreenIsHiDPI;
        boolean switchedHiDPIMode = SystemInfo.isJetBrainsJvm && "true".equalsIgnoreCase(System.getProperty("sun.java2d.uiScale.enabled")) && !UIUtil.isJreHiDPIEnabled();
        boolean bl = defaultScreenIsHiDPI = (double)JBUI.sysScale() > 1.0;
        if (SystemInfo.isWindows && (switchedHiDPIMode && defaultScreenIsHiDPI || RemoteDesktopService.isRemoteSession())) {
            this.showNotification(new KeyHyperlinkAdapter("ide.set.hidpi.mode"), new Object[0]);
        }
    }

    private void showNotification(final KeyHyperlinkAdapter adapter, Object ... params) {
        String key2 = adapter.key;
        boolean ignored = adapter.isIgnored();
        LOG.info("issue detected: " + key2 + (ignored ? " (ignored)" : ""));
        if (ignored) {
            return;
        }
        final String message2 = IdeBundle.message((String)key2, (Object[])params) + IdeBundle.message((String)"sys.health.acknowledge.link", (Object[])new Object[0]);
        final Application app = ApplicationManager.getApplication();
        app.getMessageBus().connect((Disposable)app).subscribe(AppLifecycleListener.TOPIC, (Object)new AppLifecycleListener(){

            @Override
            public void appFrameCreated(String[] commandLineArgs, @NotNull Ref<Boolean> willOpenProject) {
                if (willOpenProject == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "willOpenProject", "com/intellij/ide/SystemHealthMonitor$2", "appFrameCreated"));
                }
                app.invokeLater(() -> {
                    JRootPane component = WindowManager.getInstance().findVisibleFrame().getRootPane();
                    if (component != null) {
                        Rectangle rect = component.getVisibleRect();
                        JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(message2, MessageType.WARNING, (HyperlinkListener)((Object)adapter)).setFadeoutTime(-1L).setHideOnFrameResize(false).setHideOnLinkClick(true).setDisposable((Disposable)app).createBalloon().show(new RelativePoint((Component)component, new Point(rect.x + 30, rect.y + rect.height - 10)), Balloon.Position.above);
                    }
                    Notification notification = LOG_GROUP.createNotification("", message2, NotificationType.WARNING, (NotificationListener)new NotificationListener.Adapter(){

                        protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent e) {
                            if (notification == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/ide/SystemHealthMonitor$2$1", "hyperlinkActivated"));
                            }
                            if (e == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/SystemHealthMonitor$2$1", "hyperlinkActivated"));
                            }
                            adapter.hyperlinkActivated(e);
                        }
                    });
                    notification.setImportant(true);
                    Notifications.Bus.notify((Notification)notification);
                });
            }
        });
    }

    private static void startDiskSpaceMonitoring() {
        if (SystemProperties.getBooleanProperty((String)"idea.no.system.path.space.monitoring", (boolean)false)) {
            return;
        }
        final File file2 = new File(PathManager.getSystemPath());
        final AtomicBoolean reported = new AtomicBoolean();
        final ThreadLocal ourFreeSpaceCalculation = new ThreadLocal();
        JobScheduler.getScheduler().schedule(new Runnable(){
            private static final long LOW_DISK_SPACE_THRESHOLD = 0x3200000L;
            private static final long MAX_WRITE_SPEED_IN_BPS = 524288000L;

            @Override
            public void run() {
                if (!reported.get()) {
                    Future future2 = (Future)ourFreeSpaceCalculation.get();
                    if (future2 == null) {
                        future2 = ApplicationManager.getApplication().executeOnPooledThread(() -> {
                            long fileUsableSpace = file2.getUsableSpace();
                            while (fileUsableSpace == 0L) {
                                TimeoutUtil.sleep((long)5000L);
                                fileUsableSpace = file2.getUsableSpace();
                            }
                            return fileUsableSpace;
                        });
                        ourFreeSpaceCalculation.set(future2);
                    }
                    if (!future2.isDone() || future2.isCancelled()) {
                        this.restart(1L);
                        return;
                    }
                    try {
                        long fileUsableSpace = (Long)future2.get();
                        long timeout = Math.min(3600L, Math.max(5L, (fileUsableSpace - 0x3200000L) / 524288000L));
                        ourFreeSpaceCalculation.set(null);
                        if (fileUsableSpace < 0x3200000L) {
                            if (ReadAction.compute(() -> NotificationsConfiguration.getNotificationsConfiguration()) == null) {
                                ourFreeSpaceCalculation.set(future2);
                                this.restart(1L);
                                return;
                            }
                            reported.compareAndSet(false, true);
                            SwingUtilities.invokeLater(() -> {
                                String productName = ApplicationNamesInfo.getInstance().getFullProductName();
                                String message2 = IdeBundle.message((String)"low.disk.space.message", (Object[])new Object[]{productName});
                                if (fileUsableSpace < 102400L) {
                                    LOG.warn(message2 + " (" + fileUsableSpace + ")");
                                    Messages.showErrorDialog((String)message2, (String)"Fatal Configuration Problem");
                                    reported.compareAndSet(true, false);
                                    this.restart(timeout);
                                } else {
                                    GROUP.createNotification(message2, file2.getPath(), NotificationType.ERROR, null).whenExpired(() -> {
                                        reported.compareAndSet(true, false);
                                        this.restart(timeout);
                                    }).notify(null);
                                }
                            });
                        } else {
                            this.restart(timeout);
                        }
                    }
                    catch (Exception ex) {
                        LOG.error((Throwable)ex);
                    }
                }
            }

            private void restart(long timeout) {
                JobScheduler.getScheduler().schedule(this, timeout, TimeUnit.SECONDS);
            }
        }, 1L, TimeUnit.SECONDS);
    }

    private class KeyHyperlinkAdapter
    extends HyperlinkAdapter {
        private final String key;

        private KeyHyperlinkAdapter(String key2) {
            this.key = key2;
        }

        private boolean isIgnored() {
            return SystemHealthMonitor.this.myProperties.isValueSet("ignore." + this.key);
        }

        protected void hyperlinkActivated(HyperlinkEvent e) {
            String url = e.getDescription();
            if ("ack".equals(url)) {
                SystemHealthMonitor.this.myProperties.setValue("ignore." + this.key, "true");
            } else {
                BrowserUtil.browse((String)url);
            }
        }
    }

    private static interface LibC
    extends Library {
        public static final int SIGINT = 2;
        public static final long SIG_IGN = 1L;

        public int sigaction(int var1, Pointer var2, Pointer var3);
    }
}

