/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.actions.ShowFilePathAction;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.settingsSummary.ProblemType;
import com.intellij.util.io.ZipUtil;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.zip.ZipOutputStream;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class CollectZippedLogsAction
extends AnAction
implements DumbAware {
    private static final ExtensionPointName<ProblemType> EP_SETTINGS = ExtensionPointName.create((String)"com.intellij.settingsSummaryFactory");
    private static final String CONFIRMATION_DIALOG = "zipped.logs.action.show.confirmation.dialog";

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/CollectZippedLogsAction", "actionPerformed"));
        }
        Project project2 = e.getProject();
        boolean doNotShowDialog = PropertiesComponent.getInstance().getBoolean(CONFIRMATION_DIALOG);
        try {
            File zippedLogsFile = CollectZippedLogsAction.createZip(project2);
            if (!doNotShowDialog) {
                Messages.showIdeaMessageDialog((Project)project2, (String)"Included log and settings may contain sensitive data.", (String)"Sensitive Data", (String[])new String[]{Messages.OK_BUTTON}, (int)1, (Icon)Messages.getInformationIcon(), (DialogWrapper.DoNotAskOption)new DialogWrapper.DoNotAskOption.Adapter(){

                    public void rememberChoice(boolean selected, int exitCode) {
                        PropertiesComponent.getInstance().setValue(CollectZippedLogsAction.CONFIRMATION_DIALOG, selected);
                    }
                });
            }
            if (ShowFilePathAction.isSupported()) {
                ShowFilePathAction.openFile(zippedLogsFile);
            } else {
                Messages.showInfoMessage((String)zippedLogsFile.getAbsolutePath(), (String)"Log File");
            }
        }
        catch (IOException exception) {
            Messages.showErrorDialog((String)("Can't create zip file with logs: " + exception.getLocalizedMessage()), (String)"Can't Create File");
        }
    }

    @NotNull
    private static File createZip(Project project2) throws IOException {
        File settingsTempFile = null;
        File zippedLogsFile = FileUtil.createTempFile((String)("logs-" + CollectZippedLogsAction.getDate()), (String)".zip");
        try (ZipOutputStream zipOutputStream = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(zippedLogsFile)));){
            ZipUtil.addFileOrDirRecursively((ZipOutputStream)zipOutputStream, null, (File)new File(PathManager.getLogPath()), (String)"", null, null);
            settingsTempFile = CollectZippedLogsAction.dumpSettingsToFile(project2);
            ZipUtil.addFileToZip((ZipOutputStream)zipOutputStream, (File)settingsTempFile, (String)"settings.txt", null, null);
        }
        catch (IOException exception) {
            zippedLogsFile.delete();
            throw exception;
        }
        finally {
            if (settingsTempFile != null) {
                settingsTempFile.delete();
            }
        }
        File file2 = zippedLogsFile;
        if (file2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/CollectZippedLogsAction", "createZip"));
        }
        return file2;
    }

    @NotNull
    private static File dumpSettingsToFile(Project project2) throws IOException {
        File settingsTempFile = FileUtil.createTempFile((String)("settings" + CollectZippedLogsAction.getDate()), (String)".txt");
        for (ProblemType problemType : (ProblemType[])EP_SETTINGS.getExtensions()) {
            String settingString = problemType.collectInfo(project2);
            FileUtil.appendToFile((File)settingsTempFile, (String)(settingString + '\n'));
        }
        File file2 = settingsTempFile;
        if (file2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/CollectZippedLogsAction", "dumpSettingsToFile"));
        }
        return file2;
    }

    @NotNull
    private static String getDate() {
        String string = new SimpleDateFormat("yyyyMMdd-HHmmss").format(new Date());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/CollectZippedLogsAction", "getDate"));
        }
        return string;
    }

    public void update(AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        presentation.setText(CollectZippedLogsAction.getActionName());
    }

    @NotNull
    private static String getActionName() {
        String string = "Collect and Show Logs in " + ShowFilePathAction.getFileManagerName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/CollectZippedLogsAction", "getActionName"));
        }
        return string;
    }
}

