/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.EditorGotoLineNumberDialog;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;

public class GotoLineAction
extends AnAction
implements DumbAware {
    public GotoLineAction() {
        this.setEnabledInModalContext(true);
    }

    public void actionPerformed(AnActionEvent e) {
        Project project2 = (Project)e.getData(CommonDataKeys.PROJECT);
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR_EVEN_IF_INACTIVE);
        if (Boolean.TRUE.equals(e.getData(PlatformDataKeys.IS_MODAL_CONTEXT))) {
            EditorGotoLineNumberDialog dialog2 = new EditorGotoLineNumberDialog(project2, editor);
            dialog2.show();
        } else {
            CommandProcessor processor2 = CommandProcessor.getInstance();
            processor2.executeCommand(project2, () -> {
                EditorGotoLineNumberDialog dialog2 = new EditorGotoLineNumberDialog(project2, editor);
                dialog2.show();
                IdeDocumentHistory.getInstance(project2).includeCurrentCommandAsNavigation();
            }, IdeBundle.message((String)"command.go.to.line", (Object[])new Object[0]), null);
        }
    }

    public void update(AnActionEvent event) {
        Presentation presentation = event.getPresentation();
        Project project2 = (Project)event.getData(CommonDataKeys.PROJECT);
        if (project2 == null) {
            presentation.setEnabled(false);
            presentation.setVisible(false);
            return;
        }
        Editor editor = (Editor)event.getData(CommonDataKeys.EDITOR_EVEN_IF_INACTIVE);
        presentation.setEnabled(editor != null);
        presentation.setVisible(editor != null);
    }
}

