/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.PowerSaveMode;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PowerSaveModeNotifier
implements StartupActivity {
    private static final NotificationGroup POWER_SAVE_MODE = NotificationGroup.balloonGroup((String)"Power Save Mode");
    private static final String IGNORE_POWER_SAVE_MODE = "ignore.power.save.mode";

    public void runActivity(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/actions/PowerSaveModeNotifier", "runActivity"));
        }
        if (PowerSaveMode.isEnabled()) {
            PowerSaveModeNotifier.notifyOnPowerSaveMode(project2);
        }
    }

    static void notifyOnPowerSaveMode(@Nullable Project project2) {
        if (PropertiesComponent.getInstance().getBoolean(IGNORE_POWER_SAVE_MODE)) {
            return;
        }
        Notification notification = POWER_SAVE_MODE.createNotification("Power save mode is on", "Code insight and background tasks are disabled.", NotificationType.WARNING, null);
        notification.addAction((AnAction)new NotificationAction("Do Not Show Again"){

            public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/PowerSaveModeNotifier$1", "actionPerformed"));
                }
                if (notification == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/ide/actions/PowerSaveModeNotifier$1", "actionPerformed"));
                }
                PropertiesComponent.getInstance().setValue(PowerSaveModeNotifier.IGNORE_POWER_SAVE_MODE, true);
                notification.expire();
            }
        });
        notification.addAction((AnAction)new NotificationAction("Disable Power Save Mode"){

            public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/PowerSaveModeNotifier$2", "actionPerformed"));
                }
                if (notification == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/ide/actions/PowerSaveModeNotifier$2", "actionPerformed"));
                }
                PowerSaveMode.setEnabled((boolean)false);
                notification.expire();
            }
        });
        notification.notify(project2);
        Balloon balloon = notification.getBalloon();
        if (balloon != null) {
            MessageBus bus = project2 == null ? ApplicationManager.getApplication().getMessageBus() : project2.getMessageBus();
            MessageBusConnection connection = bus.connect();
            connection.subscribe(PowerSaveMode.TOPIC, () -> notification.expire());
            Disposer.register((Disposable)balloon, (Disposable)connection);
        }
    }
}

